/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.barcode.fa.manage.FAExBaseStatusEnum;
import com.kingdee.eas.barcode.fa.manage.RepairBillInfo;
import com.kingdee.eas.barcode.fa.manage.app.AbstractRepairBillControllerBean;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class RepairBillControllerBean
extends AbstractRepairBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.fa.manage.app.RepairBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepairBillInfo bill = (RepairBillInfo)model;
        bill.setBaseStatus(FAExBaseStatusEnum.SUBMIT);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepairBillInfo bill = (RepairBillInfo)model;
        bill.setBaseStatus(FAExBaseStatusEnum.SUBMIT);
        return super._submit(ctx, model);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectValue value = this._getValue(ctx, pk);
        this.updateStatus(ctx, value, FAExBaseStatusEnum.APPROVED);
    }

    @Override
    protected void _auditing(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectValue value = this._getValue(ctx, pk);
        this.updateStatus(ctx, value, FAExBaseStatusEnum.APPROVING, true);
    }

    @Override
    protected void _unaudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectValue value = this._getValue(ctx, pk);
        this.updateStatus(ctx, value, FAExBaseStatusEnum.UNPASS);
    }

    public void updateStatus(Context ctx, IObjectValue model, FAExBaseStatusEnum status) throws EASBizException, BOSException {
        this.updateStatus(ctx, model, status, false);
    }

    public void updateStatus(Context ctx, IObjectValue model, FAExBaseStatusEnum status, boolean nouserinfo) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            this.setStatus(ctx, conn, model, status, nouserinfo);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public void setStatus(Context ctx, Connection conn, IObjectValue model, FAExBaseStatusEnum status) throws EASBizException, BOSException {
        this.setStatus(ctx, conn, model, status, false);
    }

    public void setStatus(Context ctx, Connection conn, IObjectValue model, FAExBaseStatusEnum status, boolean nouserinfo) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        BillBaseInfo aSCMBillBaseInfo = (BillBaseInfo)model;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET ");
            if (!nouserinfo) {
                sqlBuff.append(" CFAuditTime = ?, FAuditorID = ? , ");
            }
            sqlBuff.append("  CFBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            preStmt = conn.prepareStatement(sqlBuff.toString());
            Date now = new Date();
            int index = 1;
            if (!nouserinfo) {
                preStmt.setTimestamp(index++, new Timestamp(now.getTime()));
                UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                preStmt.setString(index++, aUserInfo.getId().toString());
            }
            preStmt.setString(index++, status.getValue());
            preStmt.setString(index++, aSCMBillBaseInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm);
                SQLUtils.cleanup(preStmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup(sm);
        SQLUtils.cleanup((Statement)preStmt);
    }

    public String getMainTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(model.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }
}

