/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.barcode.pda.app.Util2;
import com.kingdee.eas.barcode.scm.BarcodeWSException;
import com.kingdee.eas.barcode.scm.LiceControlCollection;
import com.kingdee.eas.barcode.scm.LiceControlFactory;
import com.kingdee.eas.barcode.scm.LiceControlInfo;
import com.kingdee.eas.barcode.scm.app.LicenseCache;
import com.kingdee.eas.barcode.scm.util.Json;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BarcodeLicenseUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.pda.BarcodeLicenseUtils");

    public static void requestLicenseOrReleaseLicense(Context ctx, boolean flag, String sessionId) throws LicenseException, BarcodeWSException {
        ILicenseSrvAgent iILicenseSrvAgent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
        if (iILicenseSrvAgent == null) {
            // empty if block
        }
        String[] licenseNameArg = new String[]{"BARCODE_IM", "BARCODE_FA"};
        if (flag) {
            LicenseUserInfo paramLicenseUserInfo = BarcodeLicenseUtils.createLicenseUserInfo(ctx);
            boolean isLiceseError = true;
            int licenselcFlag = 0;
            String uiClssName = "com.kingdee.eas.barcode.scm.client.BarcodePDAViewConfigListUI";
            int size = licenseNameArg.length;
            for (int i = 0; i < size; ++i) {
                licenselcFlag = iILicenseSrvAgent.reqeustLicenseByModuleAndUIName(paramLicenseUserInfo, licenseNameArg[i], uiClssName);
                logger.info((Object)("liceseName\uff1a" + licenseNameArg[i] + " licenselcFlag:" + licenselcFlag));
                if (licenselcFlag == 4 || licenselcFlag == 2) continue;
                isLiceseError = false;
                break;
            }
            if (!isLiceseError) {
                return;
            }
            switch (licenselcFlag) {
                case 4: {
                    throw new BarcodeWSException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Error_License_Invalid")));
                }
                case 2: {
                    throw new BarcodeWSException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Error_License_NO_SURPLUS")));
                }
            }
        } else {
            int size = licenseNameArg.length;
            for (int i = 0; i < size; ++i) {
                iILicenseSrvAgent.releaseLicenseBySessionIDAndSubSystem(sessionId, licenseNameArg[i]);
            }
        }
    }

    private static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static void checkLicense(Context ctx, boolean flag, String session, String key) throws LicenseException {
        if (key == null) {
            return;
        }
        if (flag) {
            BarcodeLicenseUtils.checkMachineCode(ctx);
            LicenseCache.checkLicense(ctx, key);
        } else {
            LicenseCache.releaseLicense(ctx, key);
        }
    }

    public static String getLicenseApplyText(String custom, String users, String connections, String expireDate, String runtime, String serverinfo) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        if (custom == null || custom.trim().length() == 0) {
            data.put("client", "\u6df1\u5733\u5e02\u4f18\u8054\u8f6f\u4ef6\u670d\u52a1\u6709\u9650\u516c\u53f8");
        } else {
            data.put("client", custom);
        }
        data.put("project", "EAS\u6761\u7801");
        data.put("name_prefix", "com.unionware.eas.barcode");
        data.put("short_name_prefix", "unbar");
        data.put("meta_level", "70");
        data.put("env_type", "production");
        data.put("users", users);
        data.put("connections", connections);
        data.put("expire", expireDate);
        data.put("runtime", runtime);
        data.put("server", serverinfo);
        return Json.toString(data);
    }

    public static int importLicenseText(Context ctx, String license) throws Exception {
        String key;
        Map dl = BarcodeLicenseUtils.parseJson(license);
        String json = (String)dl.get("json");
        if (!Util2.isValid(json, key = (String)dl.get("key"))) {
            return -1;
        }
        Map info = (Map)Json.toObject(json);
        String runtime = info.get("runtime").toString();
        if (!runtime.equals(LiceControlFactory.getLocalInstance(ctx).getMetaRumTime())) {
            return -2;
        }
        LiceControlInfo data = null;
        LiceControlCollection coll = LiceControlFactory.getLocalInstance(ctx).getLiceControlCollection("where number='" + runtime + "'");
        if (coll.size() == 0) {
            data = new LiceControlInfo();
            data.setNumber(runtime);
            data.setData_json(license);
            LiceControlFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)data);
        } else {
            data = coll.get(0);
            data.setData_json(license);
            LiceControlFactory.getLocalInstance(ctx).save((CoreBaseInfo)data);
        }
        return 1;
    }

    private static Map parseJson(String license) {
        Map rev = (Map)Json.toObject(license);
        return rev;
    }

    public static void checkMachineCode(Context ctx) throws LicenseException {
        ILicenseSrvAgent iILicenseSrvAgent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
        LicenseBaseInfo licenseBaInfo = iILicenseSrvAgent.getLicenseBaseInfo();
        String machineCode = licenseBaInfo.getMechineCode();
        logger.info((Object)("machineCode" + machineCode));
        LicenseCache.checkBarcodeVersion(ctx, machineCode);
    }

    public static LicenseUserInfo createLicenseUserInfo(Context ctx) {
        LicenseUserInfo user = null;
        try {
            Date loginTime = new Date(System.currentTimeMillis());
            user = new LicenseUserInfo();
            if (ctx != null) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                if (userInfo != null && userInfo.getId() != null) {
                    user.setUserID(userInfo.getId().toString());
                }
                user.setUserName(ctx.getUserName());
                user.setSessionID(ctx.getContextID());
                if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    user.setUserCompany(ContextUtil.getCurrentCtrlUnit((Context)ctx).getName());
                }
                user.setUserLoginAis(ctx.getAIS());
            }
            user.setUserIP(ctx.getClientHostIP());
            user.setUserLoginTime(loginTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            user = null;
        }
        return user;
    }
}

