/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeExecutor;
import com.kingdee.eas.barcode.scm.BarcodeRuleCollection;
import com.kingdee.eas.barcode.scm.BarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.BarcodeTypeEnum;
import com.kingdee.eas.barcode.scm.BarcodeWSException;
import com.kingdee.eas.barcode.scm.IBarcodeAnalysisFacade;
import com.kingdee.eas.barcode.scm.IIndBarcodeAnalysisFacade;
import com.kingdee.eas.barcode.scm.IndBarcodeAnalysisFacadeFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeBackFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.app.BarcodeServerUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BarcodePDAScanning
implements BarcodeExecutor {
    private String getParamValue(Context ctx) throws BOSException {
        IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getLocalInstance(ctx).getIndubarodeParamsetCollection();
        String paramValue = "0";
        if (paramCol != null && paramCol.get(0) != null) {
            IndubarodeParamsetInfo indParasetInfo = paramCol.get(0);
            if (indParasetInfo.isBusinessBarcode()) {
                paramValue = "0";
            } else if (indParasetInfo.isIndBarcode()) {
                paramValue = "1";
            } else if (indParasetInfo.isPriorBusiness()) {
                paramValue = "3";
            } else if (indParasetInfo.isPriorInd()) {
                paramValue = "4";
            }
        }
        return paramValue;
    }

    public boolean executeBarcode(Context ctx, String barcode, String transTypeNumber, String srcBosType, String destBosType, String paramValue, CtrlUnitInfo ctrlUnitInfo, List<BarcodeAnalysisResult> barcodeResultList, boolean isFirstEx) throws EASBizException, BOSException {
        BarcodeAnalysisResult barcodeResult = null;
        if (this.isCountTableForDestBosType(destBosType)) {
            srcBosType = "D9D2CA5D";
        }
        boolean isPackage = false;
        StringBuffer selectSql = new StringBuffer();
        ArrayList<String> barcodeList = new ArrayList<String>();
        selectSql.append("select FPacakgeBarcode,fbarcode from T_BC_PackageBarcodeEntry entry ").append("\t\n");
        selectSql.append(" left join T_BC_PackageBarcode packageBarcode on packageBarcode.fid=entry.FParentID").append("\t\n");
        selectSql.append("where FPacakgeBarcode in('").append(barcode).append("')").append("\t\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        HashMap<String, String> packageBarcodeMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String leafBarcode = rs.getString("fbarcode");
                String FPacakgeBarcode = rs.getString("FPacakgeBarcode");
                barcodeList.add(leafBarcode);
                isPackage = true;
                if (packageBarcodeMap.containsKey(FPacakgeBarcode)) continue;
                packageBarcodeMap.put(FPacakgeBarcode, leafBarcode);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (isFirstEx) {
            for (String newbarcode : barcode.split("','")) {
                if (packageBarcodeMap.containsKey(newbarcode)) continue;
                barcodeList.add(newbarcode);
            }
        }
        int size = barcodeList.size();
        for (int i = 0; i < size; ++i) {
            String childbarcode;
            block23: {
                childbarcode = (String)barcodeList.get(i);
                if ("1".equals(paramValue) || "4".equals(paramValue)) {
                    barcodeResult = this.isCountTableForDestBosType(destBosType) ? this.processDossier(ctx, childbarcode, ctrlUnitInfo, srcBosType) : this.processDossier(ctx, childbarcode, ctrlUnitInfo, destBosType);
                    if (barcodeResult == null) {
                        if ("1".equals(paramValue)) {
                            throw new BarcodeWSException(BarcodeWSException.NOTGUIZE);
                        }
                        if ("4".equals(paramValue)) {
                            try {
                                barcodeResult = this.barcodeAnalysis(ctx, childbarcode, srcBosType, destBosType, ctrlUnitInfo.getNumber());
                            }
                            catch (Exception e) {
                                throw new BarcodeWSException(BarcodeWSException.NOTGUIZE);
                            }
                        }
                    }
                } else if ("0".equals(paramValue)) {
                    barcodeResult = this.barcodeAnalysis(ctx, childbarcode, srcBosType, destBosType, ctrlUnitInfo.getNumber());
                } else if ("3".equals(paramValue)) {
                    try {
                        barcodeResult = this.barcodeAnalysis(ctx, childbarcode, srcBosType, destBosType, ctrlUnitInfo.getNumber());
                    }
                    catch (Exception e) {
                        barcodeResult = this.isCountTableForDestBosType(destBosType) ? this.processDossier(ctx, childbarcode, ctrlUnitInfo, srcBosType) : this.processDossier(ctx, childbarcode, ctrlUnitInfo, destBosType);
                        if (barcodeResult != null) break block23;
                        throw new BarcodeWSException(BarcodeWSException.NOTGUIZE);
                    }
                }
            }
            if (barcodeResult == null) {
                throw new BarcodeWSException(BarcodeWSException.NOTGUIZE);
            }
            if (barcodeResult.isBarcodeRepeat()) {
                this.isRepeatBarcode(ctx, destBosType, childbarcode, transTypeNumber);
            }
            if (barcodeResult != null && barcodeResult.getBarcodeType().getValue() == 2) {
                if (this.isAutoExecutePackageBarcode()) {
                    this.executeBarcode(ctx, childbarcode, transTypeNumber, srcBosType, destBosType, paramValue, ctrlUnitInfo, barcodeResultList, false);
                }
                isPackage = true;
            }
            barcodeResultList.add(barcodeResult);
        }
        return isPackage;
    }

    private void isRepeatBarcode(Context ctx, String bosType, String barcode, String transferNumber) throws EASBizException, BOSException {
        if (transferNumber != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("isScan", (Object)true));
            filterInfo.getFilterItems().add(new FilterItemInfo("barcodeState", (Object)BarcodeServerUtils.getInOrOutBill(ctx, bosType, transferNumber)));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcode));
            boolean isExists = BarcodeDossierFactory.getLocalInstance(ctx).exists(filterInfo);
            if (isExists) {
                throw new BarcodeWSException(BarcodeWSException.BARCODEREPREAT, new Object[]{"\u3010" + barcode + "\u3011"});
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.number", (Object)transferNumber.toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)barcode));
            isExists = IndBarcodeBackFactory.getLocalInstance(ctx).exists(filterInfo);
            if (isExists) {
                throw new BarcodeWSException(BarcodeWSException.BARCODEREPREAT, new Object[]{"\u3010" + barcode + "\u3011"});
            }
        }
    }

    protected BarcodeAnalysisResult processDossier(Context ctx, String barcode, CtrlUnitInfo ctrlUnitInfo, String destBosType) throws BOSException, EASBizException {
        BarcodeAnalysisResult barcodeResult = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)barcode));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.displayName.*");
        sic.add("material.*");
        sic.add("barRule.*");
        sic.add("barRule.barcodeType.*");
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.entrys.name"));
        sic.add(new SelectorItemInfo("template.entrys.value"));
        sic.add(new SelectorItemInfo("template.entrys.displayName.*"));
        view.setSelector(sic);
        BarcodeDossierCollection col = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
        if (col.size() > 0) {
            BarcodeDossierInfo info = col.get(0);
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)destBosType));
            filter.getFilterItems().add(new FilterItemInfo("master.id", (Object)info.getBarRule().getId()));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
            view.setFilter(filter);
            sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("master.*");
            sic.add("master.barcodeType.*");
            sic.add("Entry.*");
            sic.add("Entry.property.*");
            view.setSelector(sic);
            IndBarcodeSetupCollection setupCol = IndBarcodeSetupFactory.getLocalInstance(ctx).getIndBarcodeSetupCollection(view);
            if (setupCol.size() > 0) {
                IndBarcodeSetupInfo setupInfo = setupCol.get(0);
                barcodeResult = IndBarcodeAnalysisFacadeFactory.getLocalInstance(ctx).barcodeAnalysis(barcode, info, setupInfo);
                barcodeResult.setSrcBillId(info.getSrcBillId());
                barcodeResult.setSrcBosType(info.getSrcBosType());
                barcodeResult.setSrcBillNumber(info.getSrcBillNumber());
            }
        }
        return barcodeResult;
    }

    protected List<BarcodeAnalysisResult> processDossier(Context ctx, String barcode, CtrlUnitInfo ctrlUnitInfo, String srcBosType, String destBosType, IIndBarcodeAnalysisFacade indBarcodeAnalysisFacade, List<BarcodeAnalysisResult> barcodeResultList) throws BOSException, EASBizException {
        long time = System.currentTimeMillis();
        if (barcodeResultList != null) {
            barcodeResultList.clear();
        }
        BarcodeAnalysisResult barcodeResult = null;
        BarcodeDossierCollection infoCol = this.getBarcodeDossierCol(ctx, barcode);
        IndBarcodeSetupInfo setupInfo = null;
        IndBarcodeSetupInfo pacakageSetupInfo = null;
        BigDecimal totalQty = BigDecimal.ZERO;
        int size = infoCol.size();
        for (int i = 0; i < size; ++i) {
            BarcodeDossierInfo info = infoCol.get(i);
            if (BarcodeTypeEnum.packageBarcode.equals((Object)info.getBarRule().getBarcodeType().getBarcodeType())) {
                if (pacakageSetupInfo == null) {
                    pacakageSetupInfo = this.getIndBarcodeSetupInfo(ctx, destBosType, info);
                }
            } else if (setupInfo == null) {
                setupInfo = this.getIndBarcodeSetupInfo(ctx, destBosType, info);
            }
            barcodeResult = indBarcodeAnalysisFacade.barcodeAnalysis(info.getNumber(), info, setupInfo == null ? pacakageSetupInfo : setupInfo);
            barcodeResultList.add(barcodeResult);
            if (!BarcodeTypeEnum.packageBarcode.equals((Object)info.getBarRule().getBarcodeType().getBarcodeType())) continue;
            this.processDossier(ctx, barcode, ctrlUnitInfo, srcBosType, destBosType, indBarcodeAnalysisFacade, barcodeResultList);
            setupInfo = null;
        }
        time = System.currentTimeMillis() - time;
        Logger.info((String)("\u89e3\u6790\u6761\u7801\u6d88\u8017\u65f6\u95f4\uff1a processDossier end:" + time));
        return barcodeResultList;
    }

    private String getResultList(Context ctx, CtrlUnitInfo ctrlUnitInfo, BarcodeAnalysisResult barcodeResult, BarcodeDossierInfo info, IndBarcodeSetupInfo setupInfo, String srcBosType, String destBosType, IIndBarcodeAnalysisFacade indBarcodeAnalysisFacade, List<BarcodeAnalysisResult> barcodeResultList, boolean isScanQty, String scanQtyStr, boolean isCard, String ruleId, Map<String, BarcodeAnalysisResult> mapReult) throws BOSException, EASBizException {
        if (barcodeResult != null && barcodeResult.getBarcodeType().getValue() == 2 && this.isAutoExecutePackageBarcode()) {
            List<String> barcodeList = barcodeResult.getChidrenBarcodes();
            int size = barcodeList.size();
            for (int i = 0; i < size; ++i) {
                String childBarcode = barcodeList.get(i);
                info = this.getBarcodeDossierInfo(ctx, childBarcode);
                if (info == null) {
                    if (ruleId == null) {
                        ruleId = this.getBarcodeRule(ctx, childBarcode, srcBosType, destBosType, ctrlUnitInfo.getNumber());
                    }
                    barcodeResult = this.barcodeAnalysis(ctx, childBarcode, srcBosType, destBosType, ctrlUnitInfo.getNumber(), ruleId);
                } else {
                    barcodeResult = indBarcodeAnalysisFacade.barcodeAnalysis(childBarcode, info, setupInfo);
                }
                barcodeResultList.add(barcodeResult);
            }
        }
        return ruleId;
    }

    public String getBarcodeRule(Context ctx, String barcode, String srcBosType, String destBosType, String CUNumber) throws EASBizException, BOSException {
        if (barcode == null || "".equals(barcode.trim())) {
            return null;
        }
        IBarcodeAnalysisFacade iBarcodeAnalysisFacade = BarcodeAnalysisFacadeFactory.getLocalInstance(ctx);
        List list = iBarcodeAnalysisFacade.findBarcodeRule(barcode, srcBosType, destBosType, CUNumber);
        this.checkBarcodeAnalysisIds(ctx, list, barcode, srcBosType, destBosType);
        String ruleId = null;
        if (list != null && list.size() > 0) {
            ruleId = (String)list.get(0);
        }
        return ruleId;
    }

    private IndBarcodeSetupInfo getIndBarcodeSetupInfo(Context ctx, String destBosType, BarcodeDossierInfo info) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)destBosType));
        filter.getFilterItems().add(new FilterItemInfo("master.id", (Object)info.getBarRule().getId()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("master.*");
        sic.add("master.barcodeType.*");
        sic.add("Entry.*");
        sic.add("Entry.property.*");
        view.setSelector(sic);
        IndBarcodeSetupCollection setupCol = IndBarcodeSetupFactory.getLocalInstance(ctx).getIndBarcodeSetupCollection(view);
        if (setupCol.size() > 0) {
            return setupCol.get(0);
        }
        return null;
    }

    private BarcodeDossierCollection getBarcodeDossierCol(Context ctx, String barcode) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)barcode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("barRule.barcodeType.barcodeType", (Object)BarcodeTypeEnum.nomarlBarcode, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.displayName.*");
        sic.add("material.*");
        sic.add("barRule.*");
        sic.add("barRule.barcodeType.*");
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.entrys.name"));
        sic.add(new SelectorItemInfo("template.entrys.value"));
        sic.add(new SelectorItemInfo("template.entrys.displayName.*"));
        view.setSelector(sic);
        BarcodeDossierCollection col = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
        if (col.size() > 0) {
            return col;
        }
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select fbarcode from T_BC_PackageBarcodeEntry entry ").append("\t\n");
        selectSql.append(" left join T_BC_PackageBarcode packageBarcode on packageBarcode.fid=entry.FParentID").append("\t\n");
        selectSql.append("where FPacakgeBarcode='").append(barcode).append("'").append("\t\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        StringBuffer barcodeStr = new StringBuffer();
        try {
            while (rs.next()) {
                String leafBarcode = rs.getString("fbarcode");
                if (barcodeStr.length() > 0) {
                    barcodeStr.append(",").append(leafBarcode);
                    continue;
                }
                barcodeStr.append(leafBarcode);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (barcodeStr.length() == 0) {
            barcodeStr.append(barcode);
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)barcodeStr.toString(), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        col = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
        return col;
    }

    private BarcodeDossierInfo getBarcodeDossierInfo(Context ctx, String barcode) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)barcode.toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.displayName.*");
        sic.add("material.*");
        sic.add("barRule.*");
        sic.add("barRule.barcodeType.*");
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.entrys.name"));
        sic.add(new SelectorItemInfo("template.entrys.value"));
        sic.add(new SelectorItemInfo("template.entrys.displayName.*"));
        view.setSelector(sic);
        BarcodeDossierCollection col = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
        if (col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    public BarcodeAnalysisResult barcodeAnalysis(Context ctx, String barcode, String srcBosType, String destBosType, String CUNumber) throws EASBizException, BOSException {
        if (barcode == null || "".equals(barcode.trim())) {
            return null;
        }
        IBarcodeAnalysisFacade iBarcodeAnalysisFacade = BarcodeAnalysisFacadeFactory.getLocalInstance(ctx);
        List list = iBarcodeAnalysisFacade.findBarcodeRule(barcode, srcBosType, destBosType, CUNumber);
        this.checkBarcodeAnalysisIds(ctx, list, barcode, srcBosType, destBosType);
        String ruleId = null;
        if (list != null && list.size() > 0) {
            ruleId = (String)list.get(0);
        }
        if (ruleId == null || "".equals(ruleId)) {
            // empty if block
        }
        BarcodeAnalysisResult barcodeAnalysisResult = iBarcodeAnalysisFacade.barcodeAnalysis(barcode, ruleId);
        return barcodeAnalysisResult;
    }

    public BarcodeAnalysisResult barcodeAnalysis(Context ctx, String barcode, String srcBosType, String destBosType, String CUNumber, String ruleId) throws EASBizException, BOSException {
        if (barcode == null || "".equals(barcode.trim())) {
            return null;
        }
        IBarcodeAnalysisFacade iBarcodeAnalysisFacade = BarcodeAnalysisFacadeFactory.getLocalInstance(ctx);
        if (ruleId == null || "".equals(ruleId)) {
            // empty if block
        }
        BarcodeAnalysisResult barcodeAnalysisResult = iBarcodeAnalysisFacade.barcodeAnalysis(barcode, ruleId);
        return barcodeAnalysisResult;
    }

    protected boolean isCountTableForDestBosType(String desBosType) {
        return "D9D2CA5D".equals(desBosType);
    }

    @Override
    public boolean isAutoExecutePackageBarcode() {
        return true;
    }

    @Override
    public void executeBarcode(String barcode) throws Exception {
    }

    public void checkBarcodeAnalysisIds(Context ctx, List list, String barcode, String srcBosType, String destBosType) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.listToSet(list), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("barcodeType.barcodeType", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("barcodeType.barcodeType", (Object)2, CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2)");
        ev.setFilter(filter);
        try {
            BarcodeRuleCollection barcodeRuleCollection = BarcodeRuleFactory.getLocalInstance(ctx).getBarcodeRuleCollection(ev);
            if (barcodeRuleCollection.size() > 0) {
                list.clear();
                list.add(barcodeRuleCollection.get(0).getId().toString());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public Set listToSet(List list) {
        LinkedHashSet set = new LinkedHashSet();
        for (int i = 0; i < list.size(); ++i) {
            set.add(list.get(i));
        }
        return set;
    }

    @Override
    public void checkBarcodeAnalysisIds(List list, String barcode, String srcBosType, String destBosType) {
    }

    @Override
    public void afterexecuteBarcode(String barcode, String destBosType, String transTypeNumber) {
    }
}

