/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeStateEnum;
import com.kingdee.eas.barcode.scm.BarcodeUploadFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BcTaskBillCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryBarcodeEntryCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryBarcodeEntryInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillFactory;
import com.kingdee.eas.barcode.scm.BcTaskBillInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillStatusEnum;
import com.kingdee.eas.barcode.scm.IBcTaskBill;
import com.kingdee.eas.barcode.scm.IndBarcodeBackInfo;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.barcodeUseTypeEmum;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.control.FinishedRptEntryCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryInfo;
import com.kingdee.eas.mm.control.FinishedRptFactory;
import com.kingdee.eas.mm.control.FinishedRptInfo;
import com.kingdee.eas.mm.control.IFinishedRpt;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreateEasyModeEASBillUtil {
    private static Logger logger = Logger.getLogger((String)CreateEasyModeEASBillUtil.class.getName());
    public static final String SRCBILLID = "sourceBillId";
    public static final String SRCBILLENTRYID = "sourceBillEntryId";
    public static final String REWRITE_EASID = "FEASID";
    public static final String REWRITE_EASBILLNUMBER = "FEASBILLNUMBER";
    public static final String REWRITE_ISUPLOADED = "FISUPLOAD";
    public static final String REWRITE_TABLE = "TABLE_NAME";
    public static final String SCANNING_RECODEID = "scanningRecodeId";
    public static final String SCANNING_TABLENAME = "scanningTableName";
    public static final String MANUFACTUREORDER_BOSTYPE = "1D0D80DD";
    public static final String PRODUCTIONORDER_BOSTYPE = "1F66774E";
    public static final String SUBCONTRACTORDER_BOSTYPE = "F99EE589";
    public static final String MATERIALREQBILL_BOSTYPE = "500AB75E";
    public static final String FINISHEDRPT_BOSTYPE = "F2901DDD";

    public static String creatEasyModeBcTask(Context ctx, ProductionOrderInfo productionOrderInfo, BcTaskBillInfo bcTaskBillInfo, IndubarodeParamsetInfo indubarodeParamsetInfo) throws BOSException, EASBizException {
        String number = null;
        String sbtIDs = bcTaskBillInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("srcBosType"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("actqty"));
        sic.add(new SelectorItemInfo("finqty"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("targetBosType"));
        sic.add(new SelectorItemInfo("targetBillId"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("botp.id"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.material.number"));
        sic.add(new SelectorItemInfo("entrys.barcodeEntrys.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sbtIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"4", CompareType.EQUALS));
        view.setFilter(filter);
        IBcTaskBill iBTB = BcTaskBillFactory.getLocalInstance(ctx);
        BcTaskBillCollection bcol = iBTB.getBcTaskBillCollection(view);
        BcTaskBillInfo btbinfo = null;
        String sNum = null;
        if (null != bcol && bcol.size() > 0) {
            Object srcBosType = null;
            Object bosType = null;
            for (int i = 0; i < bcol.size(); ++i) {
                btbinfo = bcol.get(i);
                if (null == btbinfo.getTargetBillId() || btbinfo.getTargetBillId().toString().length() <= 0) continue;
                sNum = null != sNum && sNum.length() > 0 ? sNum + "," + btbinfo.getNumber() : btbinfo.getNumber();
            }
            if (null != sNum && sNum.length() > 0) {
                logger.error((Object)("\u5355\u53f7\u4e3a" + sNum + "\u7684\u4efb\u52a1\u5df2\u7ecf\u751f\u6210\u5355\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\uff01"));
                throw new BOSException("\u5355\u53f7\u4e3a" + sNum + "\u7684\u4efb\u52a1\u5df2\u7ecf\u751f\u6210\u5355\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\uff01");
            }
            FinishedRptInfo bojValue = null;
            try {
                bojValue = CreateEasyModeEASBillUtil.processCompletion(ctx, bcol.get(0), productionOrderInfo.getBOSType().toString(), FINISHEDRPT_BOSTYPE, indubarodeParamsetInfo.getProcess().getId().toString(), productionOrderInfo);
                number = CreateEasyModeEASBillUtil.uploadBarcodeBill(ctx, bcol, bojValue.getBOSType().toString(), bcol.get(0).getTargetBosType().toString(), indubarodeParamsetInfo.getProStorage().getId().toString(), bojValue);
            }
            catch (Exception e) {
                if (bojValue != null) {
                    ObjectUuidPK pk;
                    IFinishedRpt iFinishedRpt = FinishedRptFactory.getLocalInstance((Context)ctx);
                    FinishedRptInfo finishedRpt = (FinishedRptInfo)iFinishedRpt.getValue((IObjectPK)(pk = new ObjectUuidPK(bojValue.getId())));
                    if (finishedRpt.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                        iFinishedRpt.unAudit((IObjectPK)pk);
                    }
                    iFinishedRpt.delete((IObjectPK)pk);
                }
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        return number;
    }

    protected static String uploadBarcodeBill(Context ctx, BcTaskBillCollection taskCol, String srcBosType, String bosType, String botpId, FinishedRptInfo bojValue) throws BOSException, EASBizException {
        long time = System.currentTimeMillis();
        logger.info((Object)(" uploadBarcodeBill begin\uff1a" + time));
        if (taskCol == null || taskCol.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        EntityObjectInfo entity = BarcodeUtils.getEntityByBosType(bosType);
        try {
            IObjectCollection easBills = CreateEasyModeEASBillUtil.getNewObjectCollection(ctx, entity);
            ArrayList<BOTRelationCollection> botReltes = new ArrayList<BOTRelationCollection>();
            HashMap relationMap = new HashMap();
            IObjectValue easBill = null;
            BOTMappingInfo mappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo(" where id = '" + botpId + "'");
            String entryName = BOTMappingUtil.getDestEntriesName((BOTMappingInfo)mappingInfo);
            String[] srcBillId = new String[1];
            ArrayList<String> srcBillEntryId = new ArrayList<String>();
            srcBillId[0] = bojValue.getId().toString();
            FinishedRptEntryCollection finishedRptEntryColl = bojValue.getEntrys();
            for (int i = 0; i < finishedRptEntryColl.size(); ++i) {
                FinishedRptEntryInfo finishedRptEntryInfo = finishedRptEntryColl.get(i);
                srcBillEntryId.add(finishedRptEntryInfo.getId().toString());
            }
            List rt = BotUtil.getSrcBillPropList((BOTMappingInfo)mappingInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            int size = rt.size();
            for (int j = 0; j < size; ++j) {
                sic.add(new SelectorItemInfo(rt.get(j).toString()));
            }
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BTPTransformResult btpResult = iBTPManager.transformForBotp(srcBillId, new String[]{BOTMappingUtil.getSrcEntriesName((BOTMappingInfo)mappingInfo)}, srcBillEntryId, sic, bosType, (IObjectPK)new ObjectUuidPK(mappingInfo.getId().toString()), srcBosType);
            IObjectCollection destBills = btpResult.getBills();
            BOTRelationCollection botRelationColl = btpResult.getBOTRelationCollection();
            if (destBills != null && destBills.size() > -1) {
                easBill = destBills.getObject(0);
                CreateEasyModeEASBillUtil.fillScanningToEasData(ctx, entity, taskCol, easBill, relationMap, "botp");
                BOTRelationInfo botRelationInfo = botRelationColl.get(0);
                CreateEasyModeEASBillUtil.resetBotRelation(easBill, entryName, botRelationInfo);
                botReltes.add(botRelationColl);
            }
            CreateEasyModeEASBillUtil.fillNullFields(easBill, entity);
            easBills.addObject(easBill);
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" uploadBarcodeBill end\uff1a" + time));
            return BarcodeUploadFacadeFactory.getLocalInstance(ctx).uploadEasBill(easBills, botReltes, bosType, relationMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void fillScanningToEasData(Context ctx, EntityObjectInfo entity, BcTaskBillCollection taskCol, IObjectValue easValue, Map relationMap, String way) throws EASBizException, BOSException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (taskCol == null || taskCol.size() <= 0) {
            return;
        }
        BOSUuid bid = null;
        if (easValue.get("id") == null) {
            bid = BOSUuid.create((String)easValue.getBOSType().toString());
            easValue.put("id", (Object)bid);
        } else {
            bid = (BOSUuid)easValue.get("id");
        }
        if ("botp".equals(way) && easValue instanceof InvBillBaseInfo) {
            InvBillBaseInfo invBill = (InvBillBaseInfo)easValue;
            String souID = null;
            if (null != invBill.getStorageOrgUnit()) {
                souID = invBill.getStorageOrgUnit().getId().toString();
            } else {
                StorageOrgUnitInfo sounit = ContextUtil.getCurrentStorageUnit((Context)ctx);
                invBill.setStorageOrgUnit(sounit);
                if (null != sounit) {
                    souID = sounit.getId().toString();
                }
            }
            String entryName = "entry";
            String entryBostype = invBill.getEntries().getObject(0).getBOSType().toString();
            EntityObjectInfo eEntity = BarcodeUtils.getEntityByBosType(entryBostype);
            IObjectCollection ecol = CreateEasyModeEASBillUtil.getNewObjectCollection(ctx, eEntity);
            ecol = invBill.getEntries();
            IObjectCollection tmpecol = CreateEasyModeEASBillUtil.getNewObjectCollection(ctx, eEntity);
            BcTaskBillEntryInfo bteinfo = null;
            Object tmpeinfo = null;
            CoreBaseCollection backCol = new CoreBaseCollection();
            CoreBaseCollection barcodeDossierCol = new CoreBaseCollection();
            CoreBaseCollection bctCol = new CoreBaseCollection();
            String transferNumber = null;
            if (easValue.get("transactionType") != null && easValue.get("transactionType") instanceof TransactionTypeInfo) {
                transferNumber = ((TransactionTypeInfo)easValue.get("transactionType")).getNumber();
            }
            int iUpdateType = 0;
            iUpdateType = BarcodeClientUtils.getInOrOutBill(ctx, easValue.getBOSType().toString(), transferNumber);
            int seq = null != ecol ? ecol.size() : 0;
            BigDecimal actQty = BigDecimal.ZERO;
            boolean isBarcode = true;
            for (int i = 0; i < taskCol.size(); ++i) {
                BcTaskBillInfo btbinfo = taskCol.get(i);
                String sNum = btbinfo.getNumber();
                String smaterialNum = null;
                if (null != btbinfo.getMaterial() && null != invBill.getStorageOrgUnit()) {
                    String smaterialID = btbinfo.getMaterial().getId().toString();
                    smaterialNum = btbinfo.getMaterial().getNumber();
                    MaterialInventoryInfo matinvInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(smaterialID, souID);
                    if (null != matinvInfo && matinvInfo.isIsBarcode()) {
                        isBarcode = true;
                    }
                }
                for (int j = 0; j < ecol.size(); ++j) {
                    InvBillBaseEntryInfo einfo = (InvBillBaseEntryInfo)ecol.getObject(j);
                    BcTaskBillEntryCollection btecol = btbinfo.getEntrys();
                    if (btecol.size() <= 0) continue;
                    for (int m = 0; btecol.size() > m; ++m) {
                        bteinfo = btecol.get(m);
                        if (einfo.getMaterial() == null || bteinfo.getMaterial() == null || !einfo.getMaterial().getId().toString().equalsIgnoreCase(bteinfo.getMaterial().getId().toString()) || !bteinfo.getTargetBillItemId().equals(einfo.getSourceBillEntryId())) continue;
                        if (null != bteinfo.getAsstAttr()) {
                            einfo.setAssistProperty(bteinfo.getAsstAttr());
                        } else {
                            einfo.setAssistProperty(btbinfo.getAsstAttr());
                        }
                        if (null != bteinfo.getLot()) {
                            einfo.setLot(bteinfo.getLot());
                        } else {
                            einfo.setLot(btbinfo.getLot());
                        }
                        if (null != bteinfo.getMgf()) {
                            einfo.setMfg(bteinfo.getMgf());
                        } else {
                            einfo.setMfg(btbinfo.getMgf());
                        }
                        if (null != bteinfo.getExp()) {
                            einfo.setExp(bteinfo.getExp());
                        } else {
                            einfo.setExp(btbinfo.getExp());
                        }
                        if (null != bteinfo.getUnit()) {
                            einfo.setUnit(bteinfo.getUnit());
                        } else {
                            einfo.setUnit(btbinfo.getBaseUnit());
                        }
                        if (null != bteinfo.getWarehouse()) {
                            einfo.setWarehouse(bteinfo.getWarehouse());
                        } else {
                            einfo.setWarehouse(btbinfo.getWarehouse());
                        }
                        if (null != bteinfo.getLocation()) {
                            einfo.setLocation(bteinfo.getLocation());
                        } else {
                            einfo.setLocation(btbinfo.getLocation());
                        }
                        if (null != bteinfo.getProject()) {
                            einfo.setProject(bteinfo.getProject());
                        } else {
                            einfo.setProject(btbinfo.getProject());
                        }
                        if (null != bteinfo.getTrackNumber()) {
                            einfo.setTrackNumber(bteinfo.getTrackNumber());
                        } else {
                            einfo.setTrackNumber(btbinfo.getTrackNumber());
                        }
                        einfo.setQty(bteinfo.getQty());
                        actQty = actQty.add(bteinfo.getQty());
                        if (isBarcode) {
                            if (null == bteinfo.getBarcodeEntrys() || null != bteinfo.getBarcodeEntrys() && bteinfo.getBarcodeEntrys().size() <= 0) {
                                throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599\u3010" + smaterialNum + "\u3011\u5df2\u542f\u7528\u6761\u7801\u7ba1\u7406,\u4f46" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                            }
                            CreateEasyModeEASBillUtil.setBack(ctx, bteinfo, easValue, (IObjectValue)einfo, backCol, barcodeDossierCol, iUpdateType);
                        }
                        bteinfo.setTargetBillItemId(einfo.getId().toString());
                    }
                }
                if (null != tmpecol && tmpecol.size() > 0) {
                    ecol.addObjectCollection(tmpecol);
                }
                btbinfo.setTargetBillId(bid);
                BigDecimal finishQty = actQty.add(btbinfo.getFinqty() != null ? btbinfo.getFinqty() : BigDecimal.ZERO);
                BigDecimal tQty = btbinfo.getQty() != null ? btbinfo.getQty() : BigDecimal.ZERO;
                btbinfo.setFinqty(finishQty);
                btbinfo.setStatus(BcTaskBillStatusEnum.FINISH);
                actQty = BigDecimal.ZERO;
                bctCol.add((CoreBaseInfo)btbinfo);
            }
            easValue.put("taskcol", (Object)bctCol);
            if (backCol.size() > 0) {
                easValue.put("barcodeBack", (Object)backCol);
                easValue.put("barcodeDossierCol", (Object)barcodeDossierCol);
            }
            easValue.put("entryName", (Object)entryName);
            easValue.put("bosType", (Object)entity.getBOSType().toString());
        }
    }

    private static void setBack(Context ctx, BcTaskBillEntryInfo bteinfo, IObjectValue easValue, IObjectValue entry, CoreBaseCollection backCol, CoreBaseCollection barcodeDossierCol, int iUpdateType) throws EASBizException, BOSException {
        BcTaskBillEntryBarcodeEntryCollection barcol = bteinfo.getBarcodeEntrys();
        BcTaskBillEntryBarcodeEntryInfo barinfo = null;
        for (int l = 0; l < barcol.size(); ++l) {
            barinfo = barcol.get(l);
            IndBarcodeBackInfo backInfo = new IndBarcodeBackInfo();
            backInfo.setId(BOSUuid.create((BOSObjectType)backInfo.getBOSType()));
            backInfo.setNumber(backInfo.getId().toString());
            backInfo.setName(barinfo.getBarcode());
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("useType"));
            sic.add(new SelectorItemInfo("barcodeState"));
            sic.add(new SelectorItemInfo("qty"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("barRule.id"));
            sic.add(new SelectorItemInfo("barRule.Entry.id"));
            sic.add(new SelectorItemInfo("barRule.Entry.name"));
            sic.add(new SelectorItemInfo("barRule.Entry.type"));
            sic.add(new SelectorItemInfo("barRule.Entry.*"));
            viewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barinfo.getBarcode(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            BarcodeDossierCollection dossiercol = null;
            BigDecimal barcodeQty = BigDecimal.ZERO;
            try {
                dossiercol = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(viewInfo);
                if (dossiercol.size() > 0) {
                    BarcodeDossierInfo dossierInfo = dossiercol.get(0);
                    barcodeQty = dossierInfo.getQty();
                    if (2 == iUpdateType) {
                        if (!barcodeUseTypeEmum.ordinary.equals((Object)dossierInfo.getUseType())) {
                            if (entry.get("warehouse") != null && entry.get("warehouse") instanceof WarehouseInfo) {
                                dossierInfo.put("warehouse", ((WarehouseInfo)entry.get("warehouse")).getNumber());
                            }
                            if (entry.get("location") != null && entry.get("location") instanceof LocationInfo) {
                                dossierInfo.put("location", ((LocationInfo)entry.get("location")).getNumber());
                            }
                            if (barinfo.getQty() != null && barcodeUseTypeEmum.deductible.equals((Object)dossierInfo.getUseType()) && BarcodeStateEnum.InWarehoued.equals((Object)dossierInfo.getBarcodeState())) {
                                dossierInfo.put("qty", barcodeQty.add(barinfo.getQty()));
                            }
                            dossierInfo.put("barcodeState", 2);
                            barcodeDossierCol.add((CoreBaseInfo)dossierInfo);
                        }
                    } else if (3 == iUpdateType && !barcodeUseTypeEmum.ordinary.equals((Object)dossierInfo.getUseType())) {
                        if (barinfo.getQty() != null && barcodeUseTypeEmum.deductible.equals((Object)dossierInfo.getUseType())) {
                            dossierInfo.put("qty", barcodeQty.subtract(barinfo.getQty()));
                        }
                        dossierInfo.put("barcodeState", 3);
                        barcodeDossierCol.add((CoreBaseInfo)dossierInfo);
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (barinfo.getQty() == null) {
                backInfo.setBarcodeQty(barcodeQty);
            } else {
                backInfo.setBarcodeQty(barinfo.getQty());
            }
            backInfo.setBizDate(new Date());
            backInfo.setBillType(CreateEasyModeEASBillUtil.getBillType(ctx, easValue.getBOSType().toString()));
            if (easValue.get("bizType") != null) {
                backInfo.setBizType((BizTypeInfo)easValue.get("bizType"));
            }
            backInfo.setRowNum(entry.get("id") == null ? "" : entry.get("id").toString());
            backInfo.setCreateTime(CreateEasyModeEASBillUtil.getTime());
            backInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            backInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            backCol.addObject((IObjectValue)backInfo);
        }
    }

    private static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private static BillTypeInfo getBillType(Context ctx, String bosType) throws EASBizException, BOSException {
        BillTypeInfo billType = null;
        try {
            billType = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo("where bosType='" + bosType + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return billType;
    }

    protected static void resetBotRelation(IObjectValue easBill, String entryName, BOTRelationInfo botRelationInfo) {
        IObjectCollection billBaseEntries = (IObjectCollection)easBill.get(entryName);
        BOTRelationEntryCollection newRelationEntries = new BOTRelationEntryCollection();
        for (int j = 0; j < billBaseEntries.size(); ++j) {
            IObjectValue objValue = billBaseEntries.getObject(j);
            String srcEntryId = objValue.getString(SRCBILLENTRYID);
            BOTRelationEntryInfo botEntryInfo = CreateEasyModeEASBillUtil.getBotEntryBySrcEntryId(botRelationInfo, srcEntryId);
            botEntryInfo.setDestEntryID(objValue.getString("id"));
            if (botEntryInfo == null) continue;
            newRelationEntries.add(botEntryInfo);
        }
        botRelationInfo.remove("relationEntries");
        botRelationInfo.put("relationEntries", (Object)newRelationEntries);
    }

    private static BOTRelationEntryInfo getBotEntryBySrcEntryId(BOTRelationInfo botRelationInfo, String srcEntryId) {
        for (int i = 0; i < botRelationInfo.getRelationEntries().size(); ++i) {
            BOTRelationEntryInfo entry = botRelationInfo.getRelationEntries().get(i);
            if (srcEntryId == null || !srcEntryId.equals(entry.getSrcEntryID())) continue;
            BOTRelationEntryInfo newEntryInfo = new BOTRelationEntryInfo();
            newEntryInfo.putAll((IObjectValue)entry);
            newEntryInfo.put("id", (Object)BOSUuid.create((String)entry.getBOSType().toString()));
            return newEntryInfo;
        }
        return null;
    }

    private static void fillNullFields(IObjectValue easBill, EntityObjectInfo entity) {
        for (int i = 0; i < entity.getEntityProperties().size(); ++i) {
            PropertyInfo pp = entity.getEntityProperties().get(i);
            String dataType = (String)pp.get("dataType");
            String field = pp.getName();
            if (dataType == null || easBill.get(field) != null) continue;
            if ("BigDecimal".equals(dataType)) {
                easBill.setBigDecimal(field, new BigDecimal("0.00"));
                continue;
            }
            if ("Boolean".equals(dataType) || !"Integer".equals(dataType)) continue;
            easBill.setInt(field, 0);
        }
    }

    public ICoreBase getInterface(Context ctx, EntityObjectInfo entity) throws BOSException {
        return (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entity.getType());
    }

    public static IObjectValue getNewObjectValue(Context ctx, EntityObjectInfo entity) {
        IObjectValue result = null;
        try {
            result = (IObjectValue)Class.forName(entity.getObjectValueClassRuntime()).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static IObjectCollection getNewObjectCollection(Context ctx, EntityObjectInfo entity) {
        IObjectCollection result = null;
        try {
            result = (IObjectCollection)Class.forName(entity.getObjectCollectionClassRuntime()).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static FinishedRptInfo processCompletion(Context ctx, BcTaskBillInfo bcTaskBillInfo, String srcBostype, String destBostype, String botpId, ProductionOrderInfo productionOrderInfo) throws EASBizException, BOSException {
        long time = System.currentTimeMillis();
        logger.info((Object)(" uploadBarcodeBill begin\uff1a" + time));
        if (bcTaskBillInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        boolean isBotp = false;
        if (botpId != null && !"".equals(botpId.trim())) {
            if (srcBostype == null || "".equals(srcBostype.trim())) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"67_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
            }
            isBotp = true;
        }
        EntityObjectInfo entity = BarcodeUtils.getEntityByBosType(destBostype);
        IObjectPK iObjectPK = null;
        try {
            IObjectCollection easBills = CreateEasyModeEASBillUtil.getNewObjectCollection(ctx, entity);
            ArrayList<BOTRelationCollection> botReltes = new ArrayList<BOTRelationCollection>();
            HashMap relationMap = new HashMap();
            IObjectValue easBill = null;
            if (isBotp) {
                BOTMappingInfo mappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo(" where id = '" + botpId + "'");
                String entryName = BOTMappingUtil.getDestEntriesName((BOTMappingInfo)mappingInfo);
                String[] srcBillId = new String[1];
                ArrayList<String> srcBillEntryId = new ArrayList<String>();
                srcBillId[0] = productionOrderInfo.getId().toString().toString();
                srcBillEntryId.add(productionOrderInfo.getId().toString());
                List rt = BotUtil.getSrcBillPropList((BOTMappingInfo)mappingInfo);
                SelectorItemCollection sic = new SelectorItemCollection();
                int size = rt.size();
                for (int j = 0; j < size; ++j) {
                    sic.add(new SelectorItemInfo(rt.get(j).toString()));
                }
                IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                CoreBillBaseCollection coreBillBaseCollection = new CoreBillBaseCollection();
                coreBillBaseCollection.add((CoreBillBaseInfo)productionOrderInfo);
                BTPTransformResult btpResult = iBTPManager.transformForBotp(coreBillBaseCollection, destBostype.toString(), (IObjectPK)new ObjectUuidPK(botpId));
                IObjectCollection destBills = btpResult.getBills();
                BOTRelationCollection botRelationColl = btpResult.getBOTRelationCollection();
                if (destBills != null && destBills.size() > -1) {
                    easBill = destBills.getObject(0);
                    CreateEasyModeEASBillUtil.fillScanningToEasData(ctx, entity, bcTaskBillInfo, easBill, relationMap, "botp");
                    BOTRelationInfo botRelationInfo = botRelationColl.get(0);
                    botReltes.add(botRelationColl);
                }
                CreateEasyModeEASBillUtil.fillNullFields(easBill, entity);
            }
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" uploadBarcodeBill end\uff1a" + time));
            if (botReltes != null && botReltes.size() > 0) {
                logger.info((Object)"BarcodeUpload.....SaveBotRelation Start...");
                for (int i = 0; i < botReltes.size(); ++i) {
                    BOTRelationCollection coll = (BOTRelationCollection)botReltes.get(i);
                    IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
                    if (coll == null || coll.size() <= 0) continue;
                    for (int j = 0; j < coll.size(); ++j) {
                        if (iBOTRelation.exists((IObjectPK)new ObjectUuidPK(coll.get(j).getId()))) {
                            iBOTRelation.update((IObjectPK)new ObjectUuidPK(coll.get(j).get("id").toString()), coll.get(j));
                            continue;
                        }
                        iBOTRelation.addnew(coll.get(j));
                    }
                }
                logger.info((Object)"BarcodeUpload.....SaveBotRelation End...");
            }
            EntityObjectInfo entityDest = BarcodeUtils.getEntityByBosType(easBill.getBOSType().toString());
            ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entityDest.getType());
            easBill.put("productionOrder", (Object)productionOrderInfo);
            iObjectPK = iCoreBase.save((CoreBaseInfo)easBill);
            iObjectPK = iCoreBase.submit((CoreBaseInfo)easBill);
            FinishedRptInfo bojValue = (FinishedRptInfo)iCoreBase.getValue(iObjectPK);
            return bojValue;
        }
        catch (Exception e) {
            IFinishedRpt iFinishedRpt = FinishedRptFactory.getLocalInstance((Context)ctx);
            if (iObjectPK != null) {
                iFinishedRpt.delete(iObjectPK);
            }
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private static void fillScanningToEasData(Context ctx, EntityObjectInfo entity, BcTaskBillInfo btbinfo, IObjectValue easBill, Map relationMap, String way) throws EASBizException, BOSException {
        if (btbinfo == null) {
            return;
        }
        BOSUuid bid = null;
        if (easBill.get("id") == null) {
            bid = BOSUuid.create((String)easBill.getBOSType().toString());
            easBill.put("id", (Object)bid);
        } else {
            bid = (BOSUuid)easBill.get("id");
        }
        if ("botp".equals(way) && easBill instanceof FinishedRptInfo) {
            FinishedRptInfo finishedRptInfo = (FinishedRptInfo)easBill;
            String souID = null;
            if (null != finishedRptInfo.getStorageOrgUnit()) {
                souID = finishedRptInfo.getStorageOrgUnit().getId().toString();
            } else {
                StorageOrgUnitInfo sounit = ContextUtil.getCurrentStorageUnit((Context)ctx);
                finishedRptInfo.setStorageOrgUnit(sounit);
                if (null != sounit) {
                    souID = sounit.getId().toString();
                }
            }
            String entryName = finishedRptInfo.getEntryName();
            String entryBostype = finishedRptInfo.getEntrys().get(0).getBOSType().toString();
            EntityObjectInfo eEntity = BarcodeUtils.getEntityByBosType(entryBostype);
            IObjectCollection ecol = CreateEasyModeEASBillUtil.getNewObjectCollection(ctx, eEntity);
            ecol = finishedRptInfo.getEntrys();
            IObjectCollection tmpecol = CreateEasyModeEASBillUtil.getNewObjectCollection(ctx, eEntity);
            BcTaskBillEntryInfo bteinfo = null;
            IObjectValue tmpeinfo = null;
            String transferNumber = null;
            if (easBill.get("transactionType") != null && easBill.get("transactionType") instanceof TransactionTypeInfo) {
                transferNumber = ((TransactionTypeInfo)easBill.get("transactionType")).getNumber();
            }
            int iUpdateType = 0;
            iUpdateType = BarcodeClientUtils.getInOrOutBill(ctx, easBill.getBOSType().toString(), transferNumber);
            int seq = null != ecol ? ecol.size() : 0;
            BigDecimal actQty = BigDecimal.ZERO;
            boolean isBarcode = false;
            BcTaskBillEntryCollection btecol = btbinfo.getEntrys();
            boolean isReappear = false;
            for (int i = 0; i < btecol.size(); ++i) {
                for (int j = 0; j < ecol.size(); ++j) {
                    FinishedRptEntryInfo einfo = (FinishedRptEntryInfo)ecol.getObject(j);
                    if (btecol.size() <= 0) continue;
                    bteinfo = btecol.get(i);
                    if (einfo.getMaterial() == null || bteinfo.getMaterial() == null || !einfo.getMaterial().getId().toString().equalsIgnoreCase(bteinfo.getMaterial().getId().toString()) || isReappear) continue;
                    isReappear = true;
                    if (null != bteinfo.getAsstAttr()) {
                        einfo.setAssistProperty(bteinfo.getAsstAttr());
                    }
                    if (null != bteinfo.getLot()) {
                        einfo.setLotNo(bteinfo.getLot());
                    }
                    if (null != bteinfo.getUnit()) {
                        einfo.setUnit(bteinfo.getUnit());
                    }
                    if (null != bteinfo.getWarehouse()) {
                        einfo.setWarehouse(bteinfo.getWarehouse());
                    }
                    einfo.setCommitQty(bteinfo.getQty());
                    einfo.setTotalPassQty(bteinfo.getQty());
                    actQty = actQty.add(bteinfo.getQty());
                    bteinfo.setTargetBillItemId(einfo.getId().toString());
                    for (int k = 0; k < btecol.size(); ++k) {
                        if (k == i) continue;
                        bteinfo = btecol.get(k);
                        tmpeinfo = CreateEasyModeEASBillUtil.getNewObjectValue(ctx, eEntity);
                        tmpeinfo.putAll((IObjectValue)einfo);
                        tmpeinfo.put("id", (Object)BOSUuid.create((String)tmpeinfo.getBOSType().toString()));
                        tmpeinfo.put("seq", (Object)seq);
                        ++seq;
                        if (null != bteinfo.getAsstAttr()) {
                            einfo.setAssistProperty(bteinfo.getAsstAttr());
                        }
                        if (null != bteinfo.getLot()) {
                            einfo.setLotNo(bteinfo.getLot());
                        }
                        if (null != bteinfo.getUnit()) {
                            einfo.setUnit(bteinfo.getUnit());
                        }
                        if (null != bteinfo.getWarehouse()) {
                            einfo.setWarehouse(bteinfo.getWarehouse());
                        }
                        einfo.setCommitQty(bteinfo.getQty());
                        einfo.setTotalPassQty(bteinfo.getQty());
                        bteinfo.setTargetBillItemId(tmpeinfo.get("id").toString());
                        tmpecol.addObject(tmpeinfo);
                    }
                }
            }
            if (null != tmpecol && tmpecol.size() > 0) {
                ecol.addObjectCollection(tmpecol);
            }
            easBill.put("entryName", (Object)entryName);
            easBill.put("bosType", (Object)entity.getBOSType().toString());
        }
    }
}

