/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SynAbsTask;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.FileNotFoundException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;

public class QueryCanBeTaskExec
extends SynAbsTask
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)QueryCanBeTaskExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new java.util.Date());
        try {
            long time = System.currentTimeMillis();
            logger.info((Object)(" QueryCanBeTaskExec begin\uff1a" + time));
            revlist = this.getCanBeTaskBills(ctx, params);
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" QueryCanBeTaskExec end,totalTime=\uff1a" + time));
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            System.out.println("QueryCanBeTaskExec" + e);
            logger.warn((Object)e);
        }
        return rv;
    }

    private void queryPurIn() {
        StringBuilder sb = new StringBuilder();
        sb.append("");
    }

    private EntityViewInfo getEntityFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("number");
        view.setSelector(sic);
        return view;
    }

    private Object getCanBeTaskBills(Context ctx, BarcodeMainParam params) throws BOSException, SQLException, EASBizException, FileNotFoundException, XMLStreamException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        logger.info((Object)("\u5207\u6362\u7ec4\u7ec7\u4e4b\u540e\uff1a" + ContextUtil.getCurrentOrgUnit((Context)ctx).getName()));
        String number = "";
        if (!params.getParams().containsKey("id") || BarcodeUtils.isObjectEmpty(params.getParams().get("id")).booleanValue()) {
            throw new EASBizException(new NumericExceptionSubItem(null, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u83dc\u5355\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\uff01\uff01"));
        }
        if (params.getParams().containsKey("_basefilter") && !BarcodeUtils.isObjectEmpty(params.getParams().get("_basefilter")).booleanValue()) {
            number = (String)params.getParams().get("_basefilter");
        }
        StringBuilder sb = new StringBuilder();
        BarcodeTaskRulesInfo barcodeTaskRulesInfo = BarcodeTaskRulesFactory.getLocalInstance(ctx).getBarcodeTaskRulesInfo((IObjectPK)new ObjectStringPK((String)params.getParams().get("id")));
        ArrayList<Map<String, Object>> rev = new ArrayList<Map<String, Object>>();
        if (barcodeTaskRulesInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem(null, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u83dc\u5355\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\uff01\uff01"));
        }
        rev.addAll(this.queryBillNumsByType(ctx, sb, barcodeTaskRulesInfo.getDesBosType(), barcodeTaskRulesInfo, number));
        return rev;
    }

    private List<Map<String, Object>> queryBillNumsByType(Context ctx, StringBuilder sb, String bosType, BarcodeTaskRulesInfo barcodeTaskRulesInfo, String number) throws BOSException, SQLException, EASBizException {
        BarcodeTaskPropertyKdtEntryCollection barcodeTaskPropertyentEntryColl = null;
        boolean srcSpecial = false;
        srcSpecial = this.getSpecial(barcodeTaskRulesInfo.getSrcBosType(), barcodeTaskRulesInfo.getDesBosType());
        barcodeTaskPropertyentEntryColl = srcSpecial ? BarcodeTaskPropertyKdtEntryFactory.getLocalInstance(ctx).getBarcodeTaskPropertyKdtEntryCollection(" where objectType='" + barcodeTaskRulesInfo.getSrcBosType() + "'  and  parent.status=1 and enablingHeader=1 ") : BarcodeTaskPropertyKdtEntryFactory.getLocalInstance(ctx).getBarcodeTaskPropertyKdtEntryCollection(" where objectType='" + barcodeTaskRulesInfo.getSrcBosType() + "'  and  parent.status=1 and enablingHeader=0  ");
        String qty = "";
        String org = "";
        int f = barcodeTaskPropertyentEntryColl.size();
        for (int i = 0; f > i; ++i) {
            BarcodeTaskPropertyKdtEntryInfo barcodeTaskPropertyEntryInfo = barcodeTaskPropertyentEntryColl.get(i);
            BarcodeTaskPropertyInfo barcodeTaskPropertyInfo = BarcodeTaskPropertyFactory.getLocalInstance(ctx).getBarcodeTaskPropertyInfo((IObjectPK)new ObjectUuidPK(barcodeTaskPropertyEntryInfo.getParent().getId()));
            if ("qty".equals(barcodeTaskPropertyInfo.getEntityField())) {
                qty = barcodeTaskPropertyEntryInfo.getTableField();
            }
            if (!"org".equals(barcodeTaskPropertyInfo.getEntityField())) continue;
            org = barcodeTaskPropertyEntryInfo.getTableField();
        }
        if (StringUtils.isEmpty((String)qty)) {
            throw new EASBizException(new NumericExceptionSubItem(null, "\u8bf7\u5728\u4efb\u52a1\u5c5e\u6027\u4e0a\u7ef4\u62a4\u597d\u6570\u91cf\uff01"));
        }
        if (StringUtils.isEmpty((String)org)) {
            throw new EASBizException(new NumericExceptionSubItem(null, "\u8bf7\u5728\u4efb\u52a1\u5c5e\u6027\u4e0a\u7ef4\u62a4\u597d\u7ec4\u7ec7\uff01"));
        }
        StringBuffer sub = new StringBuffer();
        if (!BarcodeUtils.isObjectEmpty(number).booleanValue()) {
            sub.append("  and  Fnumber like '%" + number + "%' ");
        } else {
            sub.append(" ");
        }
        sb.setLength(0);
        if (!"D9D2CA5D".equals(bosType)) {
            if (!barcodeTaskRulesInfo.isIsCheckMode()) {
                if (srcSpecial) {
                    sb.append(" select * from ( select  bill.FID as fid,bill.Fnumber as fnumber,max(bill.FBizDate ) bizdate,\n");
                    sb.append(" max(bill.").append(qty).append("-  case when task.FActQty is null then 0 else task.FActQty end) qty\n");
                    sb.append(" from ").append(this.getBillTable(ctx, barcodeTaskRulesInfo.getSrcBosType())).append("  bill\n");
                    sb.append(" left join (\n");
                    sb.append((CharSequence)this.getBcTaskFilterSql(barcodeTaskRulesInfo.getSrcBosType(), barcodeTaskRulesInfo.getDesBosType()));
                    sb.append(" )task on task.FsrcId =bill.FID\n");
                } else {
                    sb.append(" select * from ( select bill.FID as fid,bill.Fnumber as fnumber,max(bill.FBizDate) bizdate,\n");
                    sb.append(" max(entrys.").append(qty).append("-  case when task.FActQty is null then 0 else task.FActQty end) qty\n");
                    sb.append(" from ").append(this.getBillTable(ctx, barcodeTaskRulesInfo.getSrcBosType())).append("  bill\n");
                    sb.append(" left join ").append(this.getBillEntryTable(ctx, barcodeTaskRulesInfo.getSrcBosType())).append("  entrys on entrys.FParentid=bill.FID\n");
                    sb.append(" left join (\n");
                    sb.append((CharSequence)this.getBcTaskFilterSql(barcodeTaskRulesInfo.getSrcBosType(), barcodeTaskRulesInfo.getDesBosType()));
                    sb.append(" )task on task.FsrcItemID =entrys.FID\n");
                }
                if (barcodeTaskRulesInfo.isIsCheckMode()) {
                    sb.append(" where ( bill.Fbasestatus='1' or bill.Fbasestatus='2') and bill.").append(org).append("='").append(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString()).append("'  \n");
                } else {
                    sb.append(" where ( bill.Fbasestatus='4' or bill.Fbasestatus='5') and bill.").append(org).append("='").append(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString()).append("'  \n");
                }
                sb.append(" group by bill.FID,bill.Fnumber    \n");
                sb.append(" )t where qty>0   \n");
                sb.append(sub);
                sb.append("  ORDER BY Fnumber desc \n");
            } else {
                sb.append(" SELECT * FROM  ( select bill.FID as fid,bill.Fnumber as fnumber,max(bill.FBizDate ) bizdate, max(case when  (task.FStatus=7 or  task.FStatus=10 or task.FStatus is null  ) then 0 else 1 end) as FStatus from   ").append(this.getBillTable(ctx, barcodeTaskRulesInfo.getSrcBosType())).append("  bill\n");
                sb.append(" left join T_SCM_BcTaskBill\n");
                sb.append(" task on task.FsrcId =bill.FID \n");
                sb.append(" where ( bill.Fbasestatus='1' or bill.Fbasestatus='2') and bill.").append(org).append("='").append(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString()).append("'  \n");
                sb.append(" group by bill.FID,bill.Fnumber    \n");
                sb.append(" )t where FStatus=0   \n");
                sb.append(sub);
                sb.append("  ORDER BY Fnumber desc \n");
            }
        } else {
            sb.append(" select * from ( select bill.FID fid,countingTask.fnumber fnumber,WAREHOUSE.fnumber warehousecode,WAREHOUSE.fname_l2 bostypealias, \n");
            sb.append(" max(entrys.").append(qty).append(") qty \n");
            sb.append(" from T_IM_CountingTable  bill \n");
            sb.append(" left join T_IM_CountingTableEntry  entrys on entrys.FParentid=bill.FID \n");
            sb.append(" left join  T_IM_CountingTask countingTask  on countingTask.fid=bill.FCountingTaskid \n");
            sb.append(" left join  T_DB_WAREHOUSE  WAREHOUSE on WAREHOUSE.fid=bill.FWAREHOUSEid \n");
            sb.append(" where   ( countingTask.ftaskstatus='3' or countingTask.ftaskstatus='5') and bill.").append(org).append("='").append(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString()).append("'  \n");
            sb.append(" group by  bill.FID,countingTask.fnumber,WAREHOUSE.fnumber,WAREHOUSE.fname_l2    \n");
            sb.append(" ) t  where    1=1  \n");
            sb.append(sub);
            sb.append("    ORDER BY fnumber desc  \n");
        }
        String billAlias = this.getBillAlias(barcodeTaskRulesInfo.getSrcBosType());
        ArrayList<Map<String, Object>> rev = new ArrayList<Map<String, Object>>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Date date = null;
        while (rowSet.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            String fid = rowSet.getString("fid");
            String fnumber = rowSet.getString("fnumber");
            row.put("fid", fid);
            row.put("fnumber", fnumber);
            if ("D9D2CA5D".equals(bosType)) {
                row.put("bostypealias", rowSet.getString("bostypealias"));
            } else {
                row.put("bostypealias", billAlias);
                date = rowSet.getDate("bizdate");
                row.put("date", date);
            }
            rev.add(row);
        }
        return rev;
    }

    private String getBillAlias(String bosType) {
        EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosType));
        return eo.getAlias();
    }

    private String getBillTable(Context ctx, String bosType) throws BOSException {
        EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosType));
        return eo.getTable().getName();
    }

    private String getBillEntryTable(Context ctx, String bosType) throws BOSException {
        BarcodeTaskPropertyKdtEntryCollection barcodeTaskPropertyentColl = BarcodeTaskPropertyKdtEntryFactory.getLocalInstance(ctx).getBarcodeTaskPropertyKdtEntryCollection(" where objectType='" + bosType + "'  and  entryName is not null ");
        return barcodeTaskPropertyentColl.get(0).getEntryName();
    }

    private StringBuilder getBcTaskFilterSql(String bosType, String destBostype) {
        StringBuilder sb = new StringBuilder();
        sb.append("select FSrcBosType,FsrcId,FsrcItemID,sum(case when FFinqty<>0 then FFinqty else FQty end)  FActQty  from T_SCM_BcTaskBill where FSrcBosType='" + bosType + "'  and FTargetBosType='" + destBostype + "' and FStatus!='10' group by FSrcBosType,FsrcId,FsrcItemID");
        return sb;
    }
}

