/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.AssetsGroupEnum;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;

public class SynCheckList
implements SyncExec {
    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new java.util.Date());
        rv.setLastupdatetime(newReqTime);
        try {
            rv.setDefSucc();
            long time = System.currentTimeMillis();
            System.out.println(" SynCheckList begin\uff1a" + time);
            rv.setInfo(this.getScanTaskBillCol(ctx, params));
            time = System.currentTimeMillis() - time;
            System.out.println(" SynCheckList end,totalTime=\uff1a" + time);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        return rv;
    }

    private List getScanTaskBillCol(Context ctx, BarcodeMainParam params) throws BOSException, SQLException, EASBizException {
        BarcodeConfigInfo barcodeConfigInfo = null;
        IndubarodeParamsetInfo indubarodeParamsetInfo = BarcodeClientUtils.getParamValue(ctx);
        String pdaid = (String)params.getParams().get("id");
        String billid = (String)params.getParams().get("billid");
        BarcodePDAViewConfigInfo barcodePDAViewConfigInfo = BarcodePDAViewConfigFactory.getLocalInstance(ctx).getBarcodePDAViewConfigInfo((IObjectPK)new ObjectStringPK(pdaid));
        barcodeConfigInfo = barcodePDAViewConfigInfo.getScanConfig();
        barcodeConfigInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectStringPK(barcodeConfigInfo.getId().toString()));
        String src = " select  fid,foperatorid,fnumber,ftaskBillid,fcontrolunitid,fbegindate,fenddate  from  T_FA_StocktakingBill  where 1=1 and  fid='" + billid + "'";
        System.out.println(src);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)src);
        Map<String, Map<String, BarcodePDAViewConfigEntryInfo>> barcodepdaEntryInfoMap = null;
        HashMap<String, String> defalutConfigMap = null;
        if (rowSet.size() > 0) {
            defalutConfigMap = new HashMap<String, String>();
            barcodepdaEntryInfoMap = this.getBarcodePdaConfigMap(ctx, defalutConfigMap, pdaid);
        }
        ArrayList<Map> allArray = new ArrayList<Map>();
        while (rowSet.next()) {
            Map taskBillObj = this.scanTaskBillRow(ctx, rowSet, barcodepdaEntryInfoMap, barcodeConfigInfo, indubarodeParamsetInfo);
            allArray.add(taskBillObj);
        }
        return allArray;
    }

    private Map scanTaskBillRow(Context ctx, IRowSet rows, Map<String, Map<String, BarcodePDAViewConfigEntryInfo>> barcodepdaEntryInfoMap, BarcodeConfigInfo barcodeConfigInfo, IndubarodeParamsetInfo indubarodeParamsetInfo) throws SQLException, EASBizException, BOSException {
        LinkedHashMap<String, Object> taskBillObj = new LinkedHashMap<String, Object>();
        taskBillObj.put("billid", rows.getString("fid"));
        IObjectValue objectValue = null;
        if (rows.getString("foperatorid") != null) {
            objectValue = (IObjectValue)this.getIObjectValueByIdhead(ctx, rows.getString("foperatorid"));
            taskBillObj.put("executeobj", objectValue.get("name"));
        } else {
            taskBillObj.put("executeobj", null);
        }
        if (rows.getString("fcontrolunitid") != null) {
            objectValue = (IObjectValue)this.getIObjectValueByIdhead(ctx, rows.getString("fcontrolunitid"));
            taskBillObj.put("biz_org", objectValue.get("name"));
        } else {
            taskBillObj.put("biz_org", null);
        }
        taskBillObj.put("billtypeid", "84BEC1BB");
        taskBillObj.put("number", rows.getString("fnumber"));
        taskBillObj.put("bizdate", rows.getString("fbegindate"));
        taskBillObj.put("endbizdate", rows.getString("fenddate"));
        IObjectValue objectValues = (IObjectValue)this.getIObjectValueByIdhead(ctx, rows.getString("ftaskBillid"));
        taskBillObj.put("taskBill", objectValues.get("name"));
        Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap = barcodepdaEntryInfoMap.get(barcodeConfigInfo.getId().toString());
        BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(barcodeConfigInfo.getDetailsXML());
        String id = rows.getString("fid");
        Object o = this.getRecodesList(ctx, id, configXml);
        if (o != null) {
            List recodesList = (List)o;
            if (recodesList.size() > 0) {
                Map billObject = this.loadScanRecods(ctx, recodesList, barcodeEntryInfoMap, indubarodeParamsetInfo);
                taskBillObj.put("_bill", billObject);
            } else {
                return null;
            }
        }
        return taskBillObj;
    }

    protected Map loadScanRecods(Context ctx, List<BarcodeScanningRecodeInfo> recodesList, Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap, IndubarodeParamsetInfo indubarodeParamsetInfo) {
        LinkedHashMap<String, Cloneable> billObj = new LinkedHashMap<String, Cloneable>();
        ArrayList rowsArray = new ArrayList();
        ArrayList<String> collectproperties = new ArrayList<String>();
        LinkedHashMap<String, JSONObject> itemProObj = new LinkedHashMap<String, JSONObject>();
        LinkedHashMap<String, String> spcObj = new LinkedHashMap<String, String>();
        if (recodesList.size() == 0 || recodesList.get(0).getProperties() == null) {
            return null;
        }
        for (int i = 0; recodesList.size() > i; ++i) {
            BarcodeScanningRecodeInfo scaningRecodeInfo = recodesList.get(i);
            Iterator<String> it = scaningRecodeInfo.getProperties().keySet().iterator();
            LinkedHashMap<String, Object> rowsObj = new LinkedHashMap<String, Object>();
            while (it.hasNext()) {
                String temp = it.next();
                BarcodeScanningPropertyInfo property = scaningRecodeInfo.getProperties().get(temp);
                if (property.getKey().equals("id")) continue;
                BarcodeConfigXMLProperty xmlProperty = null;
                xmlProperty = property.getBcxmlProperty() == null ? new BarcodeConfigXMLProperty() : property.getBcxmlProperty();
                Object value = property.getValue();
                if (value == null || "".equals(value)) {
                    value = "";
                }
                if (value instanceof BigDecimal) {
                    if (value == null || "".equals(value) || BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
                        value = BigDecimal.ZERO;
                    }
                    BigDecimal qty = (BigDecimal)value;
                    value = new BigDecimal(qty.stripTrailingZeros().toPlainString());
                }
                rowsObj.put(property.getKey(), value);
                if (i != 0) continue;
                if (!"fid".equals(property.getKey()) && !"fbillid".equals(property.getKey())) {
                    spcObj.put(property.getKey(), property.getKey());
                    if (indubarodeParamsetInfo.getAssetsInvGroup() != null && AssetsGroupEnum.ASSETCLASS == indubarodeParamsetInfo.getAssetsInvGroup()) {
                        if (!StringUtils.isEmpty((String)xmlProperty.getAlias()) && "\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b".equals(xmlProperty.getAlias())) {
                            collectproperties.add(property.getKey());
                        }
                    } else if (indubarodeParamsetInfo.getAssetsInvGroup() != null && AssetsGroupEnum.DEPARTMENT == indubarodeParamsetInfo.getAssetsInvGroup()) {
                        if (!StringUtils.isEmpty((String)xmlProperty.getAlias()) && "\u7ba1\u7406\u90e8\u95e8".equals(xmlProperty.getAlias())) {
                            collectproperties.add(property.getKey());
                        }
                    } else if (!StringUtils.isEmpty((String)xmlProperty.getAlias()) && "\u5b58\u653e\u5730\u70b9".equals(xmlProperty.getAlias())) {
                        collectproperties.add(property.getKey());
                    }
                }
                itemProObj.put(property.getKey(), this.getJsonStr(ctx, property.getKey(), property.getValue(), xmlProperty, false, true, barcodeEntryInfoMap, property));
            }
            rowsArray.add(rowsObj);
        }
        billObj.put("_collectproperties", collectproperties);
        billObj.put("_itemproperties", itemProObj);
        billObj.put("_itemspekey", spcObj);
        billObj.put("rows", rowsArray);
        return billObj;
    }

    private JSONObject getJsonStr(Context ctx, String propertyName, Object value, BarcodeConfigXMLProperty xmlProperty, boolean isShowVal, boolean isLimit, Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap, BarcodeScanningPropertyInfo property) {
        if (value == null) {
            value = "";
        }
        JSONObject jsonObj = new JSONObject();
        if (isShowVal) {
            if (value != null && !"".equals(value)) {
                jsonObj.put((Object)"val", (Object)value.toString());
            } else {
                jsonObj.put((Object)"val", (Object)"");
            }
        }
        if (xmlProperty != null && xmlProperty.getAlias() == null) {
            xmlProperty.setAlias(propertyName);
        }
        if (isLimit && xmlProperty != null) {
            BarcodeConfigXMLProperty barcodeConfigXMLProperty;
            String type = "";
            StringBuffer limitStr = new StringBuffer();
            String key = propertyName;
            if (!xmlProperty.isLinkedProperty() && xmlProperty.getFullName() != null) {
                key = xmlProperty.getFullName();
            }
            if (key != null && barcodeEntryInfoMap != null && barcodeEntryInfoMap != null && barcodeEntryInfoMap.containsKey(key)) {
                BarcodePDAViewConfigEntryInfo configEntryInfo = barcodeEntryInfoMap.get(key);
                type = configEntryInfo.getColumnType();
                limitStr.append(configEntryInfo.isIsView() ? "1" : "0");
                limitStr.append(configEntryInfo.isIsEdit() ? "1" : "0");
                limitStr.append("0");
                limitStr.append("0");
                limitStr.append(xmlProperty.isScanQty() ? "1" : "0");
                jsonObj.put((Object)"alias", (Object)configEntryInfo.getPdaTitle());
                jsonObj.put((Object)"seq", (Object)(configEntryInfo.getScanSeq() + ""));
            } else {
                limitStr.append("0");
                limitStr.append("0");
                limitStr.append("0");
                limitStr.append("0");
                limitStr.append(xmlProperty.isScanQty() ? "1" : "0");
                jsonObj.put((Object)"alias", (Object)(xmlProperty != null ? xmlProperty.getAlias() : ""));
            }
            JSONObject jsonRg = new JSONObject();
            if (xmlProperty.isLinkedProperty()) {
                jsonObj.put((Object)"ct", (Object)"4");
                jsonRg.put((Object)"ft", (Object)xmlProperty.getLinkedBosType());
                jsonObj.put((Object)"rg", (Object)jsonRg);
            } else if (property.getFAListbcxmlProperty() != null && (barcodeConfigXMLProperty = property.getFAListbcxmlProperty()).isLinkedProperty()) {
                jsonObj.put((Object)"ct", (Object)"4");
                jsonRg.put((Object)"ft", (Object)barcodeConfigXMLProperty.getLinkedBosType());
                jsonObj.put((Object)"rg", (Object)jsonRg);
            }
            if (!StringUtils.isEmpty((String)type) && "\u65e5\u671f".equals(type)) {
                jsonObj.put((Object)"ct", (Object)"2");
                jsonRg.put((Object)"ft", (Object)"yyyy-MM-dd");
                jsonObj.put((Object)"rg", (Object)jsonRg);
            }
            if (!StringUtils.isEmpty((String)type) && "\u6570\u503c".equals(type)) {
                jsonObj.put((Object)"ct", (Object)"1");
            }
            jsonObj.put((Object)"limit", (Object)limitStr.toString());
        }
        return jsonObj;
    }

    private Map<String, Map<String, BarcodePDAViewConfigEntryInfo>> getBarcodePdaConfigMap(Context ctx, Map<String, String> defalutConfigMap, String pdaid) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pdaid, CompareType.EQUALS));
        view.setFilter(filterInfo);
        view.setSelector(this.getSelectors());
        BarcodePDAViewConfigCollection barcodePdaCol = BarcodePDAViewConfigFactory.getLocalInstance(ctx).getBarcodePDAViewConfigCollection(view);
        LinkedHashMap<String, Map<String, BarcodePDAViewConfigEntryInfo>> barcodepdaConfigMap = new LinkedHashMap<String, Map<String, BarcodePDAViewConfigEntryInfo>>();
        int size = barcodePdaCol.size();
        for (int i = 0; i < size; ++i) {
            BarcodePDAViewConfigInfo barcodePdaInfo = barcodePdaCol.get(i);
            String scanConfigId = barcodePdaInfo.getScanConfig().getId().toString();
            BarcodePDAViewConfigEntryCollection barcodePDAViewCol = barcodePdaInfo.getEntitys();
            LinkedHashMap<String, BarcodePDAViewConfigEntryInfo> configEntryMap = new LinkedHashMap<String, BarcodePDAViewConfigEntryInfo>();
            int m = barcodePDAViewCol.size();
            for (int j = 0; j < m; ++j) {
                BarcodePDAViewConfigEntryInfo configEntryInfo = barcodePDAViewCol.get(j);
                configEntryMap.put(configEntryInfo.getColumnCode(), configEntryInfo);
            }
            if (barcodePdaInfo.getDefualtSolution() != null) {
                defalutConfigMap.put(scanConfigId, barcodePdaInfo.getDefualtSolution().getId().toString());
            }
            barcodepdaConfigMap.put(scanConfigId, configEntryMap);
        }
        return barcodepdaConfigMap;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("entitys.*"));
        sic.add(new SelectorItemInfo("entitys.name"));
        sic.add(new SelectorItemInfo("entitys.pdaTitle"));
        sic.add(new SelectorItemInfo("entitys.consleType"));
        sic.add(new SelectorItemInfo("entitys.columnType"));
        sic.add(new SelectorItemInfo("entitys.scanSeq"));
        sic.add(new SelectorItemInfo("entitys.columnCode"));
        sic.add(new SelectorItemInfo("entitys.isView"));
        sic.add(new SelectorItemInfo("entitys.entryType"));
        sic.add(new SelectorItemInfo("entitys.proEventStr"));
        sic.add(new SelectorItemInfo("entitys.isEdit"));
        sic.add(new SelectorItemInfo("entitys.bosTypeStr"));
        sic.add(new SelectorItemInfo("entitys.parentBosTypeStr"));
        sic.add(new SelectorItemInfo("entitys.entryName"));
        sic.add(new SelectorItemInfo("entitys.specialColStr"));
        sic.add(new SelectorItemInfo("entitys.isListView"));
        sic.add(new SelectorItemInfo("entitys.tableName"));
        sic.add(new SelectorItemInfo("entitys.filedName"));
        sic.add(new SelectorItemInfo("entitys.LinkTableName"));
        sic.add(new SelectorItemInfo("entitys.fullName"));
        sic.add(new SelectorItemInfo("entitys.isSetDefault"));
        sic.add(new SelectorItemInfo("tableName"));
        sic.add(new SelectorItemInfo("offline"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("scanConfig.*"));
        } else {
            sic.add(new SelectorItemInfo("scanConfig.id"));
            sic.add(new SelectorItemInfo("scanConfig.number"));
            sic.add(new SelectorItemInfo("scanConfig.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("defualtSolution.*"));
        } else {
            sic.add(new SelectorItemInfo("defualtSolution.id"));
            sic.add(new SelectorItemInfo("defualtSolution.number"));
            sic.add(new SelectorItemInfo("defualtSolution.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("CU.*"));
        } else {
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("CU.name"));
        }
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("scanConfig.*"));
        sic.add(new SelectorItemInfo("entitys.fullName"));
        return sic;
    }

    protected Object getRecodesList(Context ctx, String id, Object xml) throws BOSException, EASBizException {
        BarcodeConfigXML xmlInfo = (BarcodeConfigXML)xml;
        List<BarcodeConfigXMLDetail> detailList = xmlInfo.getDetails();
        for (int i = 0; i < detailList.size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = detailList.get(i);
            EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)xmlDetail.getBosType()));
            if (xmlDetail.getParentBosType() == null) continue;
            String bosType = xmlDetail.getBosType();
            List<BarcodeConfigXMLProperty> propertyList = xmlDetail.getProperties();
            IRowSet rowSet = this.getRowSet(ctx, id, propertyList, bosType);
            ArrayList<BarcodeScanningRecodeInfo> recodesList = new ArrayList<BarcodeScanningRecodeInfo>();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            sic.add("number");
            sic.add("id");
            HashMap<String, Object> mapname = new HashMap<String, Object>();
            HashMap<String, Object> mapnumber = new HashMap<String, Object>();
            try {
                while (rowSet.next()) {
                    BarcodeScanningRecodeInfo recodeInfo = this.createRecodesInfo(ctx, propertyList, rowSet, sic, mapname, mapnumber);
                    recodesList.add(recodeInfo);
                }
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
            return recodesList;
        }
        return null;
    }

    private IRowSet getRowSet(Context ctx, String id, List<BarcodeConfigXMLProperty> propertyList, String bosType) throws EASBizException {
        String sql = "select ";
        sql = sql + "fcurcardid as curcard , fbizcardid as bizcard ,fassetcatid as assetcat,fassetnum as assetnum, fassetname as assetname,fspecs as specs,fmeasureunitid as measureunit,fassetamt as assetamt,fstocktakingamt as  stocktakingamt,faddressid as address,feconomicpurpid as economicpurp ,fusestatusid as usestatus,fadmindeptid as admindept,fusedeptid as  usedept,foldnumber as oldnumber ,fusepersonid as useperson,fbarcode as barcode, fkeeperid as keeper,fgroupnumber as groupnumber,fid,fbillid,fdescription as description  from T_FA_StocktakingBillEntry  where fbillid = '" + id + "' order by fseq";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            return rowSet;
        }
        catch (BOSException e1) {
            throw new EASBizException(new NumericExceptionSubItem("", e1.getMessage()));
        }
    }

    private BarcodeScanningRecodeInfo createRecodesInfo(Context ctx, List<BarcodeConfigXMLProperty> propertyList, IRowSet rowSet, SelectorItemCollection sic, Map<String, Object> mapname, Map<String, Object> mapnumber) throws SQLException, ParseException, EASBizException, BOSException {
        BarcodeScanningRecodeInfo recodeInfo = new BarcodeScanningRecodeInfo();
        recodeInfo.setFid(rowSet.getString("fid"));
        recodeInfo.setFparentId(rowSet.getString("fbillid"));
        LinkedHashMap<String, BarcodeScanningPropertyInfo> propertyMap = new LinkedHashMap<String, BarcodeScanningPropertyInfo>();
        boolean hasNumberFiled = false;
        for (int j = 0; j < propertyList.size(); ++j) {
            BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
            BarcodeConfigXMLProperty xmlPro = propertyList.get(j);
            String key = xmlPro.getName();
            if (xmlPro.isLinkedProperty()) {
                BarcodeScanningPropertyInfo proInfoname = new BarcodeScanningPropertyInfo();
                proInfo.setKey(key + "_number");
                IObjectValue objectValue = null;
                if (rowSet.getString(key) != null) {
                    String objId = rowSet.getString(key);
                    if (mapname.containsKey(objId)) {
                        proInfo.setValue(mapnumber.get(objId));
                        proInfoname.setValue(mapname.get(objId));
                    } else {
                        objectValue = (IObjectValue)this.getIObjectValueById(ctx, objId, sic);
                        mapname.put(objId, objectValue.get("name"));
                        mapnumber.put(objId, objectValue.get("number"));
                        proInfo.setValue(objectValue.get("number"));
                        proInfoname.setValue(objectValue.get("name"));
                    }
                } else {
                    proInfo.setValue(null);
                    proInfoname.setValue(null);
                }
                proInfo.setBcxmlProperty(xmlPro);
                propertyMap.put(key + "_number", proInfo);
                proInfoname.setFAListbcxmlProperty(xmlPro);
                proInfoname.setKey(key + "_name");
                propertyMap.put(key + "_name", proInfoname);
                continue;
            }
            if (key.equals("number")) {
                hasNumberFiled = true;
            }
            Object value = rowSet.getObject(key);
            if (xmlPro.getDataType().equals("Date") && value != null) {
                value = Date.valueOf(value.toString().substring(0, 10));
            }
            if (xmlPro.getDataType().equals("Boolean") && value != null) {
                value = !value.equals("false");
            }
            if (xmlPro.getDataType().equals("Integer") && value != null) {
                value = Integer.valueOf(rowSet.getString(key));
            }
            proInfo.setKey(key);
            proInfo.setValue(value);
            proInfo.setBcxmlProperty(xmlPro);
            propertyMap.put(key, proInfo);
        }
        propertyMap.put("fid", this.getCommonProInfo(rowSet, "fid"));
        propertyMap.put("fbillid", this.getCommonProInfo(rowSet, "fbillid"));
        System.out.println(propertyMap);
        recodeInfo.setProperties(propertyMap);
        return recodeInfo;
    }

    private BarcodeScanningPropertyInfo getCommonProInfo(IRowSet rowSet, String key) throws SQLException {
        BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(key);
        proInfo.setValue(rowSet.getObject(key));
        proInfo.setBcxmlProperty(new BarcodeConfigXMLProperty());
        return proInfo;
    }

    protected Object getIObjectValueById(Context ctx, String id, SelectorItemCollection sic) throws BOSException, EASBizException {
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.getBOSObjectType((String)id, (boolean)true));
        CoreBaseInfo value = null;
        try {
            if (iCoreBase.exists((IObjectPK)new ObjectUuidPK(id))) {
                value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id), sic);
            }
        }
        catch (EASBizException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return value;
    }

    protected Object getIObjectValueByIdhead(Context ctx, String id) throws BOSException, EASBizException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)true);
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("number");
        sic.add("id");
        CoreBaseInfo value = null;
        try {
            if (iCoreBase.exists((IObjectPK)new ObjectUuidPK(id))) {
                value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id), sic);
            }
        }
        catch (EASBizException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return value;
    }

    public Map<String, String> getSynEntryInfo(Context ctx, BarcodeConfigInfo configInfo) throws EASBizException, BOSException {
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(configInfo.getId()), this.getConfigInfoSelectors());
        String detailsXml = configInfo.getDetailsXML();
        BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(detailsXml);
        String topTab = "";
        for (int i = 0; i < xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail detail = xmlInfo.getDetails().get(i);
            EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)detail.getBosType()));
            StringBuffer fieldStr = new StringBuffer();
            fieldStr.append("  select ");
            fieldStr.append(" FID as id ");
            List<BarcodeConfigXMLProperty> xmlPropertyList = detail.getProperties();
            if (i == 0) {
                topTab = eo.getTable().getName();
            }
            String parentid = "";
            int m = xmlPropertyList.size();
            for (int j = 0; j < m; ++j) {
                EntityObjectInfo linkeEntity;
                BarcodeConfigXMLProperty xmlProperty = xmlPropertyList.get(j);
                if (xmlProperty.isLinkedProperty() && topTab.equals((linkeEntity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)xmlProperty.getLinkedBosType()))).getTable().getName())) {
                    parentid = eo.getPropertyByName(xmlProperty.getName()).getMappingField().getName();
                }
                ColumnInfo columnInfo = eo.getPropertyByName(xmlProperty.getName()).getMappingField();
                String field = columnInfo.getName();
                field = columnInfo.isMultilingual() ? field + "_L2  as  " + xmlProperty.getName() : field + " as " + xmlProperty.getName();
                if (fieldStr.length() > 0) {
                    fieldStr.append(",").append(field);
                    continue;
                }
                fieldStr.append(field);
            }
            fieldStr.append("  from  ").append(eo.getTable().getName());
            if (i != 0) {
                fieldStr.append(" where ").append(parentid).append(" = ");
            }
            sqlMap.put(detail.getBosType(), fieldStr.toString());
        }
        return sqlMap;
    }

    public SelectorItemCollection getConfigInfoSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("isPDA"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("botMapping.*"));
        } else {
            sic.add(new SelectorItemInfo("botMapping.id"));
            sic.add(new SelectorItemInfo("botMapping.name"));
        }
        sic.add(new SelectorItemInfo("srcAlias"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("CU.*"));
        } else {
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("CU.name"));
        }
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }
}

