/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.app.TaskAnalysis;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SynAbsTask;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BcTaskBillFactory;
import com.kingdee.eas.barcode.scm.BcTaskBillInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillStatusEnum;
import com.kingdee.eas.barcode.scm.IBcTaskBill;
import com.kingdee.eas.barcode.scm.StockingStatusEnum;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SynCreateScanTask
extends SynAbsTask
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SynCreateScanTask.class.getName());
    Map<String, Map<String, String>> mapNameAndNumber = new HashMap<String, Map<String, String>>();
    Map<String, Object> mapOjbect = new HashMap<String, Object>();
    Map<Object, BarcodeTaskRulesInfo> mapAndTaskRules = new HashMap<Object, BarcodeTaskRulesInfo>();
    Map<String, String> newMaps = null;

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        List revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            long time = System.currentTimeMillis();
            logger.info((Object)(" SynCreateScanTask begin\uff1a" + time));
            System.out.println(" SynCreateScanTask begin\uff1a" + time);
            revlist = this.createScanStockTakeRec(ctx, params);
            logger.info((Object)(" SynCreateScanTask end,totalTime=\uff1a" + time));
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
            time = System.currentTimeMillis() - time;
            System.out.println(" SynCreateScanTask end,totalTime=\uff1a" + time);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            System.out.println(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private List createScanStockTakeRec(Context ctx, BarcodeMainParam params) throws EASBizException, BOSException, SQLException {
        List entryid = (List)params.getParams().get("_info");
        String desbosobjecttype = "";
        boolean srcSpecial = false;
        IBcTaskBill ibcTaskBill = BcTaskBillFactory.getLocalInstance(ctx);
        boolean ipk = false;
        int datefor = entryid.size();
        HashMap<String, BcTaskBillInfo> bcTaskBillInfoMap = new HashMap<String, BcTaskBillInfo>();
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null) {
            throw new EASBizException(new NumericExceptionSubItem(null, "\u5f53\u524d\u7528\u6237\u4e0d\u5c5e\u4e8e\u804c\u5458\u8bf7\u7528\u804c\u5458\u64cd\u4f5c\uff01"));
        }
        for (int i = 0; datefor > i; ++i) {
            HashMap<String, String> strid = new HashMap<String, String>();
            JSONObject entrymap = JSONObject.fromObject(entryid.get(i));
            String bosobjecttype = (String)entrymap.get("srcbostype");
            desbosobjecttype = (String)entrymap.get("destbostype");
            srcSpecial = this.getSpecial(bosobjecttype, desbosobjecttype);
            StringBuffer sbstr = new StringBuffer();
            Map billmap = (Map)entrymap.get("_bill");
            String inEntryid = "";
            List rows = null;
            if (!srcSpecial) {
                rows = (List)billmap.get("rows");
                for (int y = 0; rows.size() > y; ++y) {
                    JSONObject rowsmap = JSONObject.fromObject(rows.get(y));
                    strid.put(rowsmap.get("entryid").toString(), "");
                    inEntryid = rows.size() - 1 == y ? inEntryid + "'" + rowsmap.get("entryid") + "'" : inEntryid + "'" + rowsmap.get("entryid") + "',";
                }
            } else {
                inEntryid = inEntryid + "'" + (String)entrymap.get("id") + "'";
            }
            List<TaskAnalysis> taskAnalysisList = this.getTaskAnalysisList(ctx, sbstr, bosobjecttype, inEntryid, srcSpecial);
            logger.info((Object)("SynCreateScanTasksql\uff1a" + sbstr.toString()));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbstr.toString());
            if (rowSet.size() <= 0) continue;
            this.setBcTaskBillData(ctx, rowSet, taskAnalysisList, strid, ibcTaskBill, (Map)entrymap, bcTaskBillInfoMap, bosobjecttype, desbosobjecttype, srcSpecial);
        }
        List<TaskAnalysis> destaskAnalysisList = this.getDesTaskAnalysisList(ctx, desbosobjecttype, false);
        Iterator it = bcTaskBillInfoMap.entrySet().iterator();
        ArrayList<LinkedHashMap<String, Object>> allArray = new ArrayList<LinkedHashMap<String, Object>>();
        HashMap<String, String> mapNumber = new HashMap<String, String>();
        Map<String, Object> taskBillObj = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            boolean fig = false;
            if (mapNumber.containsKey(((BcTaskBillInfo)entry.getValue()).getSrcNumber())) {
                fig = true;
            } else {
                if (taskBillObj != null) {
                    allArray.add((LinkedHashMap<String, Object>)taskBillObj);
                }
                taskBillObj = new LinkedHashMap<String, Object>();
            }
            taskBillObj = this.desScanTaskBillRow(ctx, (BcTaskBillInfo)entry.getValue(), destaskAnalysisList, taskBillObj, fig, (String)entry.getKey(), srcSpecial);
            if (mapNumber.containsKey(((BcTaskBillInfo)entry.getValue()).getSrcNumber())) continue;
            mapNumber.put(((BcTaskBillInfo)entry.getValue()).getSrcNumber(), "");
        }
        allArray.add((LinkedHashMap<String, Object>)taskBillObj);
        return allArray;
    }

    public Map desScanTaskBillRow(Context ctx, BcTaskBillInfo taskInfo, List<TaskAnalysis> taskAnalysislist, Map<String, Object> taskBillObj, boolean fig, String taskId, boolean srcSpecial) throws SQLException, EASBizException, BOSException {
        if (!fig) {
            LinkedHashMap<String, Object> billObject = new LinkedHashMap<String, Object>();
            ArrayList rowsArray = new ArrayList();
            ArrayList<String> collectproperties = new ArrayList<String>();
            LinkedHashMap<String, JSONObject> itemProObj = new LinkedHashMap<String, JSONObject>();
            LinkedHashMap<String, String> spcObj = new LinkedHashMap<String, String>();
            LinkedHashMap<String, Object> rowsObj = new LinkedHashMap<String, Object>();
            BarcodeTaskRulesInfo barcodeTaskRulesInfo = null;
            for (int i = 0; taskAnalysislist.size() > i; ++i) {
                Map<String, String> setVal;
                TaskAnalysis taskAnalysisInfo = taskAnalysislist.get(i);
                if (i == 0) {
                    if (!BarcodeUtils.isObjectEmpty(taskInfo.get("barTaskRules")).booleanValue()) {
                        Object barTaskRulesId = ((IObjectValue)taskInfo.get("barTaskRules")).get("id");
                        if (!this.mapAndTaskRules.containsKey(barTaskRulesId)) {
                            barcodeTaskRulesInfo = BarcodeTaskRulesFactory.getLocalInstance(ctx).getBarcodeTaskRulesInfo((IObjectPK)new ObjectStringPK(barTaskRulesId.toString()));
                            this.mapAndTaskRules.put(barTaskRulesId, barcodeTaskRulesInfo);
                        } else {
                            barcodeTaskRulesInfo = this.mapAndTaskRules.get(barTaskRulesId);
                        }
                    }
                    taskBillObj.put("type", this.getTypeParams(true, barcodeTaskRulesInfo, this.getModelType(taskInfo.getSrcBosType())));
                    String billMessage = "";
                    String headid = taskInfo.getSrcId().toString();
                    if (taskInfo.getStockingStatus() == StockingStatusEnum.CHECKREP) {
                        billMessage = this.getBillMessage(taskInfo.getSrcBosType(), taskInfo.getTargetBosType(), "\uff08\u53d1\u8d27\uff09");
                        taskBillObj.put("_sendmodel", 1);
                    } else {
                        billMessage = this.getBillMessage(taskInfo.getSrcBosType(), taskInfo.getTargetBosType(), "");
                    }
                    taskBillObj.put("_BillMessage", billMessage);
                    taskBillObj.put("id", headid);
                    taskBillObj.put("destbostype", taskInfo.getTargetBosType());
                    if (!srcSpecial) {
                        String entryid = taskInfo.getSrcItemId().toString();
                        rowsObj.put("entryid", entryid);
                    }
                    MaterialInfo materialInfo = (MaterialInfo)taskInfo.get("material");
                    MaterialInventoryCollection materialInventoryColl = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(" where  material='" + materialInfo.getId() + "'  and  orgUnit='" + ContextUtil.getCurrentStorageUnit((Context)ctx).getId() + "'");
                    if (materialInventoryColl.size() > 0) {
                        rowsObj.put("barcodemg", materialInventoryColl.get(0).isIsBarcode());
                    } else {
                        rowsObj.put("barcodemg", "false");
                    }
                    rowsObj.put("barcodemg", taskInfo.isBarcodemg());
                    spcObj.put("barcodemg", "barcodemg");
                }
                String key = "";
                String value = "";
                if (taskAnalysisInfo.isIstop()) {
                    setVal = this.setDesEntryProperty(ctx, taskAnalysisInfo, taskInfo, key, value);
                    key = setVal.get("key");
                    value = setVal.get("value");
                    billObject.put(key, this.getJsonStr(ctx, value, taskAnalysisInfo, barcodeTaskRulesInfo));
                } else {
                    setVal = this.setDesEntryProperty(ctx, taskAnalysisInfo, taskInfo, key, value);
                    key = setVal.get("key");
                    value = setVal.get("value");
                    if (!"".equals(key)) {
                        rowsObj.put(key, value);
                    }
                    itemProObj.put(key, this.getJsonStr(ctx, value, taskAnalysisInfo, barcodeTaskRulesInfo));
                }
                if (!StringUtils.isEmpty((String)taskAnalysisInfo.getItemspekey())) {
                    spcObj.put(taskAnalysisInfo.getItemspekey(), key);
                }
                if (taskAnalysisInfo.isTaskComField()) {
                    collectproperties.add(key);
                }
                if (!"D9D2CA5D".equals(taskAnalysisInfo.getObjectType()) || !"warehouse".equals(taskAnalysisInfo.getTaskname())) continue;
                itemProObj.put(key, this.getJsonStr(ctx, value, taskAnalysisInfo, barcodeTaskRulesInfo));
                if ("".equals(key)) continue;
                rowsObj.put(key, value);
            }
            rowsObj.put("_rowtmpid", taskId);
            rowsArray.add(rowsObj);
            billObject.put("_collectproperties", collectproperties);
            billObject.put("_itemproperties", itemProObj);
            billObject.put("_itemspekey", spcObj);
            billObject.put("rows", rowsArray);
            taskBillObj.put("_bill", billObject);
        } else {
            Map billObject = (Map)taskBillObj.get("_bill");
            List rowsArray = (List)billObject.get("rows");
            LinkedHashMap<String, Object> rowsObj = new LinkedHashMap<String, Object>();
            for (int i = 0; taskAnalysislist.size() > i; ++i) {
                Map<String, String> setVal;
                TaskAnalysis taskAnalysisInfo = taskAnalysislist.get(i);
                String key = "";
                String value = "";
                if (i == 0) {
                    if (!srcSpecial) {
                        String entryid = taskInfo.getSrcItemId().toString();
                        rowsObj.put("entryid", entryid);
                    }
                    MaterialInfo materialInfo = (MaterialInfo)taskInfo.get("material");
                    MaterialInventoryCollection materialInventoryColl = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(" where  material='" + materialInfo.getId() + "'  and  orgUnit='" + ContextUtil.getCurrentStorageUnit((Context)ctx).getId() + "'");
                    if (materialInventoryColl.size() > 0) {
                        rowsObj.put("barcodemg", materialInventoryColl.get(0).isIsBarcode());
                    } else {
                        rowsObj.put("barcodemg", "false");
                    }
                }
                if (taskAnalysisInfo.isIstop()) {
                    if (!"D9D2CA5D".equals(taskAnalysisInfo.getObjectType()) || !"warehouse".equals(taskAnalysisInfo.getTaskname()) && !"".equals(taskAnalysisInfo.getTaskname())) continue;
                    setVal = this.setDesEntryProperty(ctx, taskAnalysisInfo, taskInfo, key, value);
                    key = setVal.get("key");
                    value = setVal.get("value");
                    rowsObj.put(key, value);
                    continue;
                }
                setVal = this.setDesEntryProperty(ctx, taskAnalysisInfo, taskInfo, key, value);
                key = setVal.get("key");
                value = setVal.get("value");
                if ("".equals(key)) continue;
                rowsObj.put(key, value);
            }
            rowsObj.put("_rowtmpid", taskId);
            rowsArray.add(rowsObj);
            billObject.put("rows", rowsArray);
            taskBillObj.put("_bill", billObject);
        }
        return taskBillObj;
    }

    private Map<String, String> setDesEntryProperty(Context ctx, TaskAnalysis taskAnalysisInfo, BcTaskBillInfo taskInfo, String key, String value) throws SQLException, EASBizException, BOSException {
        HashMap<String, String> setValue = new HashMap<String, String>();
        if (taskAnalysisInfo.isLinkProperty()) {
            key = taskAnalysisInfo.getName() + "_" + taskAnalysisInfo.getPropertyname();
            if ("D9D2CA5D".equals(taskAnalysisInfo.getObjectType()) && "srcNumber".equals(taskAnalysisInfo.getTaskname())) {
                value = BarcodeUtils.isObjectEmpty(taskInfo.get(taskAnalysisInfo.getTaskname())) != false ? "" : taskInfo.get(taskAnalysisInfo.getTaskname()).toString();
                setValue.put("key", key);
                setValue.put("value", value);
                return setValue;
            }
            if (!"name".equals(taskAnalysisInfo.getPropertyname()) && !"number".equals(taskAnalysisInfo.getPropertyname())) {
                key = taskAnalysisInfo.getName() + "_" + taskAnalysisInfo.getPropertyname();
                value = taskInfo.get(taskAnalysisInfo.getTaskname()) != null ? taskInfo.get(taskAnalysisInfo.getTaskname()).toString() : "";
            } else if (!BarcodeUtils.isObjectEmpty(taskInfo.get(taskAnalysisInfo.getTaskname())).booleanValue()) {
                String objId = ((IObjectValue)taskInfo.get(taskAnalysisInfo.getTaskname())).get("id").toString();
                if (this.mapNameAndNumber.containsKey(objId)) {
                    Map<String, String> map = this.mapNameAndNumber.get(objId);
                    if (map.containsKey(taskAnalysisInfo.getPropertyname())) {
                        value = map.get(taskAnalysisInfo.getPropertyname());
                    } else {
                        IObjectValue objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, objId, "");
                        value = BarcodeUtils.isObjectEmpty(objectValues.get(taskAnalysisInfo.getPropertyname())) != false ? "" : objectValues.get(taskAnalysisInfo.getPropertyname()).toString();
                        map.put(taskAnalysisInfo.getPropertyname(), value);
                    }
                } else {
                    IObjectValue objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, objId, "");
                    value = BarcodeUtils.isObjectEmpty(objectValues.get(taskAnalysisInfo.getPropertyname())) != false ? "" : objectValues.get(taskAnalysisInfo.getPropertyname()).toString();
                    this.newMaps = new HashMap<String, String>();
                    this.newMaps.put(taskAnalysisInfo.getPropertyname(), value);
                    this.mapNameAndNumber.put(objId, this.newMaps);
                }
            } else {
                value = "";
            }
        } else {
            key = taskAnalysisInfo.getName();
            value = !StringUtils.isEmpty((String)taskInfo.getString(taskAnalysisInfo.getTaskname())) ? taskInfo.getString(taskAnalysisInfo.getTaskname()) : "";
        }
        if ("warehouse".equals(taskAnalysisInfo.getTaskname()) && BarcodeUtils.isObjectEmpty(taskInfo.get(taskAnalysisInfo.getTaskname())).booleanValue()) {
            MaterialInfo materialInfo = (MaterialInfo)taskInfo.get("material");
            MaterialInventoryCollection materialInventoryColl = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(" where  material='" + materialInfo.getId() + "'  and  orgUnit='" + ContextUtil.getCurrentStorageUnit((Context)ctx).getId() + "'");
            if (materialInventoryColl.size() > 0 && materialInventoryColl.get(0).getDefaultWarehouse() != null) {
                WarehouseInfo warehouseInfo = materialInventoryColl.get(0).getDefaultWarehouse();
                if (warehouseInfo != null) {
                    warehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouseInfo.getId()));
                    value = warehouseInfo.get(taskAnalysisInfo.getPropertyname()).toString();
                } else {
                    value = "";
                }
            }
        }
        if ("qty".equals(taskAnalysisInfo.getTaskname())) {
            value = new DecimalFormat("#.##########").format(Double.parseDouble(value));
        }
        setValue.put("key", key);
        setValue.put("value", value);
        return setValue;
    }

    private List<TaskAnalysis> getTaskAnalysisList(Context ctx, StringBuffer sbstr, String bosobjecttype, String inEntryid, boolean srcSpecial) throws BOSException, EASBizException, SQLException {
        BarcodeTaskPropertyKdtEntryCollection barcodeTaskPropertyentColl = null;
        ArrayList<TaskAnalysis> taskAnalysislist = new ArrayList<TaskAnalysis>();
        StringBuffer sb = new StringBuffer();
        if (srcSpecial) {
            barcodeTaskPropertyentColl = BarcodeTaskPropertyKdtEntryFactory.getLocalInstance(ctx).getBarcodeTaskPropertyKdtEntryCollection(" where objectType='" + bosobjecttype + "'  and  parent.status=1  and enablingHeader=1 ");
            sb.append("select  her.fnumber as number,her.fid as id, ");
        } else {
            barcodeTaskPropertyentColl = BarcodeTaskPropertyKdtEntryFactory.getLocalInstance(ctx).getBarcodeTaskPropertyKdtEntryCollection(" where objectType='" + bosobjecttype + "'  and  parent.status=1  and enablingHeader=0 ");
            if (!"D9D2CA5D".equals(bosobjecttype)) {
                sb.append("select  her.fnumber as number,ent.fid as entfid,her.fid as id, ");
            } else {
                sb.append("select  countingTask.fnumber as number,ent.fid as entfid,her.fid as id, ");
            }
        }
        HashMap<String, String> mapkey = new HashMap<String, String>();
        String entryTableName = "";
        for (int i = 0; barcodeTaskPropertyentColl.size() > i; ++i) {
            BarcodeTaskPropertyKdtEntryInfo barcodeTaskPropertyEntryInfo = barcodeTaskPropertyentColl.get(i);
            BarcodeTaskPropertyInfo barcodeTaskPropertyInfo = BarcodeTaskPropertyFactory.getLocalInstance(ctx).getBarcodeTaskPropertyInfo((IObjectPK)new ObjectUuidPK(barcodeTaskPropertyEntryInfo.getParent().getId()));
            if (barcodeTaskPropertyEntryInfo.isIsHeader()) {
                this.setTableName(barcodeTaskPropertyEntryInfo, mapkey, sb, "her");
            } else {
                if (srcSpecial) continue;
                if ("".equals(entryTableName)) {
                    entryTableName = barcodeTaskPropertyEntryInfo.getEntryName();
                }
                this.setTableName(barcodeTaskPropertyEntryInfo, mapkey, sb, "ent");
            }
            TaskAnalysis taskAnalysis = this.getTrelationship(barcodeTaskPropertyInfo, barcodeTaskPropertyEntryInfo);
            if (barcodeTaskPropertyEntryInfo.isIsLinkProperty()) {
                String[] fields = barcodeTaskPropertyEntryInfo.getName().split("\\.");
                if (fields.length > 1) {
                    taskAnalysis.setName(fields[0]);
                    taskAnalysis.setPropertyname(fields[1]);
                } else {
                    taskAnalysis.setName(barcodeTaskPropertyEntryInfo.getName());
                }
            } else {
                taskAnalysis.setName(barcodeTaskPropertyEntryInfo.getName());
            }
            taskAnalysis.setTableField(barcodeTaskPropertyEntryInfo.getTableField());
            taskAnalysislist.add(taskAnalysis);
        }
        String str = sb.toString().substring(0, sb.toString().lastIndexOf(","));
        EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosobjecttype.toString()));
        sb.setLength(0);
        sb.append(str);
        sb.append("  from ").append(eo.getTable().getName()).append(" as  her  ").append("\t\n");
        if ("D9D2CA5D".equals(bosobjecttype)) {
            sb.append("  left join  T_IM_CountingTask countingTask  on countingTask.fid=her.FCountingTaskid  ");
        }
        if (srcSpecial) {
            sb.append(" where her.fid in (" + inEntryid + ")");
        } else {
            sb.append("  left join  ").append(entryTableName).append(" as ent on").append(" her.fid=ent.FParentID  where ent.fid in (" + inEntryid + ")");
        }
        sbstr.append(sb);
        return taskAnalysislist;
    }

    private void setEntryProperty(Context ctx, TaskAnalysis taskAnalysisInfo, IRowSet rows, BcTaskBillInfo bcTaskBillInfo, Object value, String str) throws SQLException, EASBizException, BOSException {
        if (taskAnalysisInfo.isLinkProperty()) {
            String objId = rows.getString(str + taskAnalysisInfo.getTableField());
            if (!"name".equals(taskAnalysisInfo.getPropertyname()) && !"number".equals(taskAnalysisInfo.getPropertyname())) {
                IObjectValue objectValues;
                value = !StringUtils.isEmpty((String)objId) ? ((objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, objId, taskAnalysisInfo.getPropertyname())).get(taskAnalysisInfo.getPropertyname()) == null ? "" : objectValues.get(taskAnalysisInfo.getPropertyname()).toString()) : "";
            } else if (!StringUtils.isEmpty((String)objId)) {
                if (this.mapOjbect.containsKey(objId)) {
                    value = this.mapOjbect.get(objId);
                } else {
                    value = BarcodeUtils.getModelIObjectValueByIdhead(ctx, objId, "");
                    this.mapOjbect.put(objId, value);
                }
            } else {
                value = "";
            }
        } else {
            value = "mgf".equals(taskAnalysisInfo.getTaskname()) || "exp".equals(taskAnalysisInfo.getTaskname()) ? rows.getDate(str + taskAnalysisInfo.getTableField()) : rows.getString(str + taskAnalysisInfo.getTableField());
        }
        bcTaskBillInfo.put(taskAnalysisInfo.getTaskname(), value);
        if ("material".equals(taskAnalysisInfo.getTaskname())) {
            String materialId = rows.getString(str + taskAnalysisInfo.getTableField());
            MaterialInventoryCollection materialInventoryColl = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(" where  material='" + materialId + "'  and  orgUnit='" + ContextUtil.getCurrentStorageUnit((Context)ctx).getId() + "'");
            if (materialInventoryColl.size() > 0) {
                bcTaskBillInfo.setBarcodemg(materialInventoryColl.get(0).isIsBarcode());
            }
        }
    }

    private int setBcTaskBillData(Context ctx, IRowSet rowSet, List<TaskAnalysis> taskAnalysis, Map<String, String> strid, IBcTaskBill ibcTaskBill, Map entrymap, Map<String, BcTaskBillInfo> bcTaskBillInfoMap, String srcbostype, String desbosobjecttype, boolean srcSpecial) throws SQLException, EASBizException, BOSException {
        int amount = 0;
        Map billmap = (Map)entrymap.get("_bill");
        IObjectValue transactiontype = null;
        IObjectValue botpid = null;
        BarcodeTaskRulesInfo taskrules = null;
        if (entrymap.containsKey("botpid") && !BarcodeUtils.isObjectEmpty(entrymap.get("botpid")).booleanValue()) {
            botpid = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, (String)entrymap.get("botpid"), "");
        }
        if (entrymap.containsKey("taskrules") && !BarcodeUtils.isObjectEmpty(entrymap.get("taskrules")).booleanValue()) {
            if (this.mapAndTaskRules.containsKey((String)entrymap.get("taskrules"))) {
                taskrules = this.mapAndTaskRules.get((String)entrymap.get("taskrules"));
            } else {
                taskrules = BarcodeTaskRulesFactory.getLocalInstance(ctx).getBarcodeTaskRulesInfo((IObjectPK)new ObjectStringPK((String)entrymap.get("taskrules")));
                this.mapAndTaskRules.put((String)entrymap.get("taskrules"), taskrules);
            }
        }
        if (entrymap.containsKey("transactiontype") && !BarcodeUtils.isObjectEmpty(entrymap.get("transactiontype")).booleanValue()) {
            transactiontype = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, (String)entrymap.get("transactiontype"), "");
        }
        List srcRow = null;
        while (rowSet.next()) {
            IObjectPK pk;
            IRowSet rowSetQty;
            JSONObject emprowsmap = null;
            if (!srcSpecial) {
                srcRow = (List)billmap.get("rows");
                String entfidTask = rowSet.getString("entfid");
                int n = srcRow.size();
                for (int y = 0; n > y; ++y) {
                    JSONObject srcrowsmap = JSONObject.fromObject(srcRow.get(y));
                    if (!entfidTask.equals(srcrowsmap.get("entryid").toString())) continue;
                    emprowsmap = srcrowsmap;
                    break;
                }
                if (emprowsmap == null) continue;
            }
            BcTaskBillInfo bcTaskBillInfo = new BcTaskBillInfo();
            String srcqty = "";
            String qty = "";
            int n = taskAnalysis.size();
            for (int y = 0; n > y; ++y) {
                TaskAnalysis taskAnalysisInfo = taskAnalysis.get(y);
                String value = "";
                if (taskAnalysisInfo.isIstop()) {
                    this.setEntryProperty(ctx, taskAnalysisInfo, rowSet, bcTaskBillInfo, value, "her");
                } else {
                    if (srcSpecial) continue;
                    this.setEntryProperty(ctx, taskAnalysisInfo, rowSet, bcTaskBillInfo, value, "ent");
                }
                if (!"qty".equals(taskAnalysisInfo.getTaskname())) continue;
                if (srcSpecial) {
                    srcqty = rowSet.getString("her" + taskAnalysisInfo.getTableField());
                    Map qtyMap = (Map)billmap.get(taskAnalysisInfo.getName());
                    qty = (String)qtyMap.get("val");
                    continue;
                }
                srcqty = rowSet.getString("ent" + taskAnalysisInfo.getTableField());
                qty = (String)emprowsmap.get(taskAnalysisInfo.getName());
            }
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                bcTaskBillInfo.put("execperson", ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString());
            }
            if (!srcSpecial) {
                bcTaskBillInfo.setSrcItemId(BOSUuid.read((String)rowSet.getString("entfid")));
            }
            bcTaskBillInfo.setExectime(this.getTime());
            bcTaskBillInfo.setBizDate(this.getTime());
            bcTaskBillInfo.setSrcId(BOSUuid.read((String)rowSet.getString("id")));
            if (taskrules.isIsCheckMode()) {
                bcTaskBillInfo.setNumber("JY_" + rowSet.getString("number") + this.getTime());
            } else if ("D9D2CA5D".equals(desbosobjecttype)) {
                bcTaskBillInfo.setNumber("PD_" + rowSet.getString("number") + this.getTime());
            } else {
                bcTaskBillInfo.setNumber("PT_" + rowSet.getString("number") + this.getTime());
            }
            bcTaskBillInfo.setSrcNumber(rowSet.getString("number"));
            bcTaskBillInfo.setStatus(BcTaskBillStatusEnum.TAKE);
            bcTaskBillInfo.setFinqty(new BigDecimal("0"));
            bcTaskBillInfo.setSrcBosType(srcbostype);
            bcTaskBillInfo.setTargetBosType((String)entrymap.get("destbostype"));
            FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
            StorageOrgUnitInfo orgUnitInfo = ContextUtil.getCurrentStorageUnit((Context)ctx);
            fullOrgInfo.setId(orgUnitInfo.getId());
            fullOrgInfo.setName(orgUnitInfo.getName());
            fullOrgInfo.setNumber(orgUnitInfo.getNumber());
            bcTaskBillInfo.setOrg(fullOrgInfo);
            if (transactiontype != null) {
                bcTaskBillInfo.put("transactionType", transactiontype);
            }
            if (botpid != null) {
                bcTaskBillInfo.put("botp", botpid);
            }
            if (taskrules != null) {
                bcTaskBillInfo.put("barTaskRules", taskrules);
            }
            bcTaskBillInfo.setQty(new BigDecimal(StringUtils.isEmpty((String)qty) ? "0" : qty));
            bcTaskBillInfo.setDiffqty(new BigDecimal("0").subtract(new BigDecimal(StringUtils.isEmpty((String)qty) ? "0" : qty)));
            String strqty = "";
            if (!taskrules.isIsCheckMode() && !"D9D2CA5D".equals(desbosobjecttype) && (rowSetQty = DbUtil.executeQuery((Context)ctx, (String)(strqty = srcSpecial ? " select sum(case when FFinqty<>0 then FFinqty else FQty end) as fqty from  T_SCM_BcTaskBill  where FSrcId='" + rowSet.getString("id") + "'  and  FTargetBosType='" + entrymap.get("destbostype").toString() + "'" : " select sum(case when FFinqty<>0 then FFinqty else FQty end) as fqty from  T_SCM_BcTaskBill  where FSrcItemId='" + rowSet.getString("entfid") + "'  and  FTargetBosType='" + entrymap.get("destbostype").toString() + "'"))).size() > 0) {
                rowSetQty.next();
                String fqty = rowSetQty.getString("fqty");
                if (new BigDecimal(StringUtils.isEmpty((String)fqty) ? "0" : fqty).add(new BigDecimal(StringUtils.isEmpty((String)qty) ? "0" : qty)).compareTo(new BigDecimal(StringUtils.isEmpty((String)srcqty) ? "0" : srcqty)) > 0) {
                    throw new EASBizException(new NumericExceptionSubItem("\u8c03\u7528EAS\u63a5\u53e3\u5931\u8d25", "\u6570\u91cf\u5df2\u8d85\u6e90\u5355\u6570\u91cf\u4e0d\u80fd\u63d0\u4ea4\uff01"));
                }
            }
            if ((pk = ibcTaskBill.save((CoreBaseInfo)bcTaskBillInfo)) != null) {
                ++amount;
            }
            bcTaskBillInfoMap.put(pk.toString(), bcTaskBillInfo);
        }
        return amount;
    }

    public String getNewNumber(Context ctx, CoreBillBaseInfo info) {
        String number = "";
        ICodingRuleManager iCodingRuleManager = null;
        OrgUnitInfo orgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
        if (orgUnit == null) {
            return null;
        }
        try {
            iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (!iCodingRuleManager.isExist((IObjectValue)info, orgUnit.getId().toString())) {
                return null;
            }
            number = iCodingRuleManager.getNumber((IObjectValue)info, orgUnit.getId().toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return number;
    }
}

