/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.barcode.pda.app.TaskAnalysis;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SynAbsTask;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BcTaskBillCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillFactory;
import com.kingdee.eas.barcode.scm.BcTaskBillInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillStatusEnum;
import com.kingdee.eas.barcode.scm.IBcTaskBill;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SynNotSourceTask
extends SynAbsTask
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SynNotSourceTask.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        List revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            long time = System.currentTimeMillis();
            logger.info((Object)(" SynNotSourceTask begin\uff1a" + time));
            revlist = this.notSourceTask(ctx, params);
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" SynNotSourceTask end,totalTime=\uff1a" + time));
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            System.out.println(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private List notSourceTask(Context ctx, BarcodeMainParam params) throws EASBizException, BOSException, SQLException {
        String noSrcId = (String)params.getParams().get("id");
        String bostype = "";
        if (noSrcId.equals("_001")) {
            bostype = "783061E3";
        } else if (noSrcId.equals("_002")) {
            bostype = "CC3E933B";
        } else if (noSrcId.equals("_003")) {
            bostype = "500AB75E";
        } else if (noSrcId.equals("_004")) {
            bostype = "FA1292B4";
        } else if (noSrcId.equals("_005")) {
            bostype = "A4D04D23";
        } else if (noSrcId.equals("_006")) {
            bostype = "A4D04D24";
        } else if (noSrcId.equals("_007")) {
            bostype = "A4D04D25";
        }
        List<TaskAnalysis> taskAnalysisList = this.getDesTaskAnalysisList(ctx, bostype, false);
        IBcTaskBill ibcTaskBill = BcTaskBillFactory.getLocalInstance(ctx);
        String orgid = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            orgid = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("org.id", (Object)ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString()));
        if (StringUtils.isEmpty((String)orgid)) {
            throw new EASBizException(new NumericExceptionSubItem(null, "\u5f53\u524d\u7528\u6237\u4e0d\u5c5e\u4e8e\u804c\u5458\u8bf7\u7528\u804c\u5458\u64cd\u4f5c\uff01"));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("execperson.id", (Object)orgid));
        filterInfo.getFilterItems().add(new FilterItemInfo("targetBosType", (Object)bostype));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcBosType", null));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"3"));
        BcTaskBillInfo entObj = null;
        System.out.println("SynNotSourceTask-filterInfo:" + filterInfo);
        if (ibcTaskBill.exists(filterInfo)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            view.setSelector(sic);
            BcTaskBillCollection bcTaskBillCollection = ibcTaskBill.getBcTaskBillCollection(view);
            if (bcTaskBillCollection.size() > 0) {
                entObj = bcTaskBillCollection.get(0);
            }
        } else {
            BcTaskBillInfo bcTaskBillInfo = new BcTaskBillInfo();
            for (int i = 0; taskAnalysisList.size() > i; ++i) {
                IObjectValue objectValues;
                TaskAnalysis taskAnalysisInfo = taskAnalysisList.get(i);
                if (taskAnalysisInfo.isIstop()) {
                    if (StringUtils.isEmpty((String)taskAnalysisInfo.getDefaultValue())) continue;
                    if (taskAnalysisInfo.isLinkProperty()) {
                        if (taskAnalysisInfo == null) continue;
                        objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, taskAnalysisInfo.getDefaultValue(), "");
                        bcTaskBillInfo.put(taskAnalysisInfo.getTaskname(), objectValues);
                        continue;
                    }
                    bcTaskBillInfo.put(taskAnalysisInfo.getTaskname(), taskAnalysisInfo.getDefaultValue());
                    continue;
                }
                if (StringUtils.isEmpty((String)taskAnalysisInfo.getDefaultValue())) continue;
                if (taskAnalysisInfo.isLinkProperty()) {
                    if (taskAnalysisInfo == null) continue;
                    objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, taskAnalysisInfo.getDefaultValue(), "");
                    bcTaskBillInfo.put(taskAnalysisInfo.getTaskname(), objectValues);
                    continue;
                }
                bcTaskBillInfo.put(taskAnalysisInfo.getTaskname(), taskAnalysisInfo.getDefaultValue());
            }
            bcTaskBillInfo.setExecperson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            bcTaskBillInfo.setExectime(this.getTime());
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            Date d1 = new Date();
            String str1 = sdf1.format(d1);
            bcTaskBillInfo.setNumber("RW" + str1 + new Date().getTime());
            bcTaskBillInfo.setStatus(BcTaskBillStatusEnum.TAKE);
            bcTaskBillInfo.setTargetBosType(bostype);
            bcTaskBillInfo.setBizDate(this.getTime());
            FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
            StorageOrgUnitInfo orgUnitInfo = ContextUtil.getCurrentStorageUnit((Context)ctx);
            fullOrgInfo.setId(orgUnitInfo.getId());
            fullOrgInfo.setName(orgUnitInfo.getName());
            fullOrgInfo.setNumber(orgUnitInfo.getNumber());
            bcTaskBillInfo.setOrg(fullOrgInfo);
            IObjectPK pk = ibcTaskBill.save((CoreBaseInfo)bcTaskBillInfo);
            entObj = (BcTaskBillInfo)ibcTaskBill.getValue(pk);
        }
        ArrayList<LinkedHashMap<String, Object>> allArray = new ArrayList<LinkedHashMap<String, Object>>();
        Map<String, Object> taskBillObj = new LinkedHashMap<String, Object>();
        taskBillObj = this.scanTaskBillRow(ctx, taskAnalysisList, bostype, entObj, taskBillObj);
        allArray.add((LinkedHashMap<String, Object>)taskBillObj);
        return allArray;
    }

    private Map scanTaskBillRow(Context ctx, List<TaskAnalysis> taskAnalysislist, String bostype, BcTaskBillInfo entObj, Map<String, Object> taskBillObj) throws SQLException, EASBizException, BOSException {
        LinkedHashMap<String, Object> billObject = new LinkedHashMap<String, Object>();
        ArrayList rowsArray = new ArrayList();
        ArrayList<String> collectproperties = new ArrayList<String>();
        LinkedHashMap<String, JSONObject> itemProObj = new LinkedHashMap<String, JSONObject>();
        LinkedHashMap<String, String> spcObj = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> rowsObj = new LinkedHashMap<String, String>();
        int n = taskAnalysislist.size();
        for (int i = 0; n > i; ++i) {
            TaskAnalysis taskAnalysisInfo = taskAnalysislist.get(i);
            if (i == 0) {
                taskBillObj.put("destbostype", bostype);
                taskBillObj.put("_rowtmpid", entObj.getId().toString());
                taskBillObj.put("type", "310");
            }
            String key = "";
            String value = "";
            if (taskAnalysisInfo.isIstop()) {
                if (taskAnalysisInfo.isLinkProperty()) {
                    key = taskAnalysisInfo.getName() + "_" + taskAnalysisInfo.getPropertyname();
                    if (!BarcodeUtils.isObjectEmpty(entObj.get(taskAnalysisInfo.getTaskname())).booleanValue()) {
                        String objId = ((IObjectValue)entObj.get(taskAnalysisInfo.getTaskname())).get("id").toString();
                        IObjectValue objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, objId, "");
                        value = objectValues.get(taskAnalysisInfo.getPropertyname()).toString();
                    } else {
                        value = "";
                    }
                } else {
                    key = taskAnalysisInfo.getName();
                    value = !StringUtils.isEmpty((String)entObj.getString(taskAnalysisInfo.getTaskname())) ? entObj.getString(taskAnalysisInfo.getTaskname()) : "";
                }
                billObject.put(key, this.getJsonStr(ctx, value, taskAnalysisInfo, null));
            } else {
                Map<String, String> setVal = this.setEntryProperty(ctx, taskAnalysisInfo, entObj, key, value);
                key = setVal.get("key");
                value = setVal.get("value");
                if (!"".equals(key)) {
                    rowsObj.put(key, value);
                }
                itemProObj.put(key, this.getJsonStr(ctx, value, taskAnalysisInfo, null));
            }
            if (!StringUtils.isEmpty((String)taskAnalysisInfo.getItemspekey())) {
                spcObj.put(taskAnalysisInfo.getItemspekey(), key);
            }
            if (!taskAnalysisInfo.isTaskComField()) continue;
            collectproperties.add(key);
        }
        rowsArray.add(rowsObj);
        billObject.put("_collectproperties", collectproperties);
        billObject.put("_itemproperties", itemProObj);
        billObject.put("_itemspekey", spcObj);
        billObject.put("rows", rowsArray);
        taskBillObj.put("_bill", billObject);
        return taskBillObj;
    }

    private Map<String, String> setEntryProperty(Context ctx, TaskAnalysis taskAnalysisInfo, BcTaskBillInfo taskInfo, String key, String value) throws SQLException, EASBizException, BOSException {
        HashMap<String, String> setValue = new HashMap<String, String>();
        if (taskAnalysisInfo.isLinkProperty()) {
            key = taskAnalysisInfo.getName() + "_" + taskAnalysisInfo.getPropertyname();
            if (!"name".equals(taskAnalysisInfo.getPropertyname()) && !"number".equals(taskAnalysisInfo.getPropertyname())) {
                key = taskAnalysisInfo.getName() + "_" + taskAnalysisInfo.getPropertyname();
                value = taskInfo.get(taskAnalysisInfo.getTaskname()) != null ? taskInfo.get(taskAnalysisInfo.getTaskname()).toString() : "";
            } else if (!BarcodeUtils.isObjectEmpty(taskInfo.get(taskAnalysisInfo.getTaskname())).booleanValue()) {
                String objId = ((IObjectValue)taskInfo.get(taskAnalysisInfo.getTaskname())).get("id").toString();
                IObjectValue objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, objId, "");
                value = objectValues.get(taskAnalysisInfo.getPropertyname()).toString();
            } else {
                value = "";
            }
        } else {
            key = taskAnalysisInfo.getName();
            value = !StringUtils.isEmpty((String)taskInfo.getString(taskAnalysisInfo.getTaskname())) ? taskInfo.getString(taskAnalysisInfo.getTaskname()) : "";
        }
        setValue.put("key", key);
        setValue.put("value", value);
        return setValue;
    }
}

