/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.pda.app.TaskAnalysis;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SynAbsTask;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SynQueryTask
extends SynAbsTask
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SynQueryTask.class.getName());
    public static final String MANUFACTUREORDER_BOSTYPE = "1D0D80DD";

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        List revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            long time = System.currentTimeMillis();
            logger.info((Object)(" SynQueryTask begin\uff1a" + time));
            revlist = this.QueryTask(ctx, params);
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" SynQueryTask end,totalTime=\uff1a" + time));
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            System.out.println(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private List QueryTask(Context ctx, BarcodeMainParam params) throws BOSException, SQLException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String taskRulesId = (String)params.getParams().get("id");
        BarcodeTaskRulesInfo barcodeTaskRulesInfo = BarcodeTaskRulesFactory.getLocalInstance(ctx).getBarcodeTaskRulesInfo((IObjectPK)new ObjectStringPK(taskRulesId));
        String transactiontype = BarcodeUtils.isObjectEmpty(barcodeTaskRulesInfo.getTransactionType()) != false ? "" : barcodeTaskRulesInfo.getTransactionType().getId().toString();
        String botpid = BarcodeUtils.isObjectEmpty(barcodeTaskRulesInfo.getDocumentRules()) != false ? "" : barcodeTaskRulesInfo.getDocumentRules().getId().toString();
        String destbostype = barcodeTaskRulesInfo.getDesBosType();
        String srcbostype = barcodeTaskRulesInfo.getSrcBosType();
        String taskRules = barcodeTaskRulesInfo.getId().toString();
        boolean srcSpecial = this.getSpecial(srcbostype, destbostype);
        List<TaskAnalysis> taskAnalysislist = this.getTaskAnalysisList(ctx, sb, params, srcSpecial, barcodeTaskRulesInfo);
        System.out.println("sql\uff1a" + sb.toString());
        logger.info((Object)("QueryTasksql\uff1a" + sb.toString()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList<LinkedHashMap<String, Object>> allArray = new ArrayList<LinkedHashMap<String, Object>>();
        HashMap<String, String> mapNumber = new HashMap<String, String>();
        Map<String, Object> taskBillObj = null;
        if (rowSet.size() > 0) {
            while (rowSet.next()) {
                boolean fig = false;
                if (mapNumber.containsKey(rowSet.getString("number"))) {
                    fig = true;
                } else {
                    if (taskBillObj != null) {
                        allArray.add((LinkedHashMap<String, Object>)taskBillObj);
                    }
                    taskBillObj = new LinkedHashMap<String, Object>();
                }
                taskBillObj = this.scanTaskBillRow(ctx, rowSet, taskAnalysislist, taskBillObj, fig, srcSpecial, destbostype, barcodeTaskRulesInfo);
                taskBillObj.put("transactiontype", transactiontype);
                taskBillObj.put("botpid", botpid);
                taskBillObj.put("taskrules", taskRules);
                taskBillObj.put("destbostype", destbostype);
                if (mapNumber.containsKey(rowSet.getString("number"))) continue;
                mapNumber.put(rowSet.getString("number"), "");
            }
            allArray.add((LinkedHashMap<String, Object>)taskBillObj);
        }
        return allArray;
    }

    private Map scanTaskBillRow(Context ctx, IRowSet rows, List<TaskAnalysis> taskAnalysislist, Map<String, Object> taskBillObj, boolean fig, boolean srcSpecial, String destbostype, BarcodeTaskRulesInfo barcodeTaskRulesInfo) throws SQLException, EASBizException, BOSException {
        if (!fig) {
            LinkedHashMap<String, Object> billObject = new LinkedHashMap<String, Object>();
            ArrayList rowsArray = new ArrayList();
            ArrayList<String> collectproperties = new ArrayList<String>();
            LinkedHashMap<String, JSONObject> itemProObj = new LinkedHashMap<String, JSONObject>();
            LinkedHashMap<String, String> spcObj = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> rowsObj = new LinkedHashMap<String, String>();
            int n = taskAnalysislist.size();
            for (int i = 0; n > i; ++i) {
                Map<String, String> setVal;
                TaskAnalysis taskAnalysisInfo = taskAnalysislist.get(i);
                if (i == 0) {
                    taskBillObj.put("type", this.getTypeParams(true, barcodeTaskRulesInfo, this.getModelType(barcodeTaskRulesInfo.getSrcBosType())));
                    String headid = rows.getString("id");
                    IObjectValue objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, headid, "");
                    taskBillObj.put("id", headid);
                    taskBillObj.put("srcbostype", objectValues.getBOSType().toString());
                    if (!srcSpecial) {
                        String entryid = rows.getString("entryid");
                        rowsObj.put("entryid", entryid);
                    }
                }
                String key = "";
                String value = "";
                if (taskAnalysisInfo.isIstop()) {
                    setVal = this.setEntryProperty(ctx, taskAnalysisInfo, rows, "her", srcSpecial, destbostype, barcodeTaskRulesInfo);
                    key = setVal.get("key");
                    value = setVal.get("value");
                    billObject.put(key, this.getJsonStr(ctx, value, taskAnalysisInfo, barcodeTaskRulesInfo));
                } else {
                    if (srcSpecial) continue;
                    setVal = this.setEntryProperty(ctx, taskAnalysisInfo, rows, "ent", srcSpecial, destbostype, barcodeTaskRulesInfo);
                    key = setVal.get("key");
                    value = setVal.get("value");
                    if (!"".equals(key)) {
                        rowsObj.put(key, value);
                    }
                    itemProObj.put(key, this.getJsonStr(ctx, value, taskAnalysisInfo, barcodeTaskRulesInfo));
                }
                if ("D9D2CA5D".equals(taskAnalysisInfo.getObjectType()) && "warehouse".equals(taskAnalysisInfo.getTaskname())) {
                    itemProObj.put(key, this.getJsonStr(ctx, value, taskAnalysisInfo, barcodeTaskRulesInfo));
                    if (!"".equals(key)) {
                        rowsObj.put(key, value);
                    }
                }
                if (!StringUtils.isEmpty((String)taskAnalysisInfo.getItemspekey())) {
                    spcObj.put(taskAnalysisInfo.getItemspekey(), key);
                }
                if (!taskAnalysisInfo.isTaskComField()) continue;
                collectproperties.add(key);
            }
            rowsArray.add(rowsObj);
            billObject.put("_collectproperties", collectproperties);
            billObject.put("_itemproperties", itemProObj);
            billObject.put("_itemspekey", spcObj);
            billObject.put("rows", rowsArray);
            taskBillObj.put("_bill", billObject);
        } else {
            Map billObject = (Map)taskBillObj.get("_bill");
            List rowsArray = (List)billObject.get("rows");
            LinkedHashMap<String, String> rowsObj = new LinkedHashMap<String, String>();
            int n = taskAnalysislist.size();
            for (int i = 0; n > i; ++i) {
                TaskAnalysis taskAnalysisInfo = taskAnalysislist.get(i);
                if (i == 0) {
                    String entryid = rows.getString("entryid");
                    rowsObj.put("entryid", entryid);
                }
                String key = "";
                String value = "";
                if (taskAnalysisInfo.isIstop()) {
                    Map<String, String> setValCountingtable;
                    if (!"D9D2CA5D".equals(taskAnalysisInfo.getObjectType()) || !"warehouse".equals(taskAnalysisInfo.getTaskname()) && !"".equals(taskAnalysisInfo.getTaskname()) || "".equals((setValCountingtable = this.setEntryProperty(ctx, taskAnalysisInfo, rows, "her", srcSpecial, destbostype, barcodeTaskRulesInfo)).get("key"))) continue;
                    rowsObj.put(setValCountingtable.get("key"), setValCountingtable.get("value"));
                    continue;
                }
                if (srcSpecial) continue;
                Map<String, String> setVal = this.setEntryProperty(ctx, taskAnalysisInfo, rows, "ent", srcSpecial, destbostype, barcodeTaskRulesInfo);
                key = setVal.get("key");
                value = setVal.get("value");
                if ("".equals(key)) continue;
                rowsObj.put(key, value);
            }
            rowsArray.add(rowsObj);
            billObject.put("rows", rowsArray);
            taskBillObj.put("_bill", billObject);
        }
        return taskBillObj;
    }

    private List<TaskAnalysis> getTaskAnalysisList(Context ctx, StringBuffer sbstr, BarcodeMainParam params, boolean srcSpecial, BarcodeTaskRulesInfo barcodeTaskRulesInfo) throws BOSException, EASBizException {
        Object[] isrowArg = ((JSONArray)params.getParams().get("_info")).toArray();
        String bostype = barcodeTaskRulesInfo.getSrcBosType();
        String strId = "";
        String strNumber = "";
        if (isrowArg.length > 0) {
            int n = isrowArg.length;
            for (int i = 0; n > i; ++i) {
                Map numberAndId = (Map)isrowArg[i];
                if (!BarcodeUtils.isObjectEmpty(numberAndId.get("fnumber")).booleanValue()) {
                    strId = this.getStrJoint((String)numberAndId.get("fid"), i, strId);
                    continue;
                }
                strNumber = this.getStrJoint((String)numberAndId.get("fnumber"), i, strNumber);
            }
        }
        BarcodeTaskPropertyKdtEntryCollection barcodeTaskPropertyentColl = null;
        ArrayList<TaskAnalysis> taskAnalysislist = new ArrayList<TaskAnalysis>();
        StringBuffer sb = new StringBuffer();
        if (srcSpecial) {
            barcodeTaskPropertyentColl = BarcodeTaskPropertyKdtEntryFactory.getLocalInstance(ctx).getBarcodeTaskPropertyKdtEntryCollection(" where objectType='" + bostype + "'  and  parent.status=1 and enablingHeader=1 ");
            sb.append("select  her.fnumber as number,her.fid as id, ");
        } else {
            barcodeTaskPropertyentColl = BarcodeTaskPropertyKdtEntryFactory.getLocalInstance(ctx).getBarcodeTaskPropertyKdtEntryCollection(" where objectType='" + bostype + "'  and  parent.status=1 and enablingHeader=0 ");
            if (!"D9D2CA5D".equals(bostype)) {
                sb.append("select  her.fnumber as number,her.fid as id,ent.fid as entryid, ");
            } else {
                sb.append("select   countingTask.fnumber as number,her.fid as id,ent.fid as entryid, ");
            }
        }
        HashMap<String, String> mapkey = new HashMap<String, String>();
        String entryTableName = "";
        String qty = "";
        int f = barcodeTaskPropertyentColl.size();
        for (int i = 0; f > i; ++i) {
            BarcodeTaskPropertyKdtEntryInfo barcodeTaskPropertyEntryInfo = barcodeTaskPropertyentColl.get(i);
            BarcodeTaskPropertyInfo barcodeTaskPropertyInfo = BarcodeTaskPropertyFactory.getLocalInstance(ctx).getBarcodeTaskPropertyInfo((IObjectPK)new ObjectUuidPK(barcodeTaskPropertyEntryInfo.getParent().getId()));
            if (barcodeTaskPropertyEntryInfo.isIsHeader()) {
                this.setTableName(barcodeTaskPropertyEntryInfo, mapkey, sb, "her");
            } else {
                if (srcSpecial) continue;
                if ("".equals(entryTableName)) {
                    entryTableName = barcodeTaskPropertyEntryInfo.getEntryName();
                }
                this.setTableName(barcodeTaskPropertyEntryInfo, mapkey, sb, "ent");
            }
            TaskAnalysis taskAnalysis = this.getTrelationship(barcodeTaskPropertyInfo, barcodeTaskPropertyEntryInfo);
            if ("qty".equals(barcodeTaskPropertyInfo.getEntityField())) {
                qty = barcodeTaskPropertyEntryInfo.getTableField();
            }
            if (barcodeTaskPropertyEntryInfo.isIsLinkProperty()) {
                String[] fields = barcodeTaskPropertyEntryInfo.getName().split("\\.");
                if (fields.length > 1) {
                    taskAnalysis.setName(fields[0]);
                    taskAnalysis.setPropertyname(fields[1]);
                } else {
                    taskAnalysis.setName(barcodeTaskPropertyEntryInfo.getName());
                }
            } else {
                taskAnalysis.setName(barcodeTaskPropertyEntryInfo.getName());
            }
            taskAnalysis.setTableField(barcodeTaskPropertyEntryInfo.getTableField());
            taskAnalysislist.add(taskAnalysis);
        }
        String str = sb.toString().substring(0, sb.toString().lastIndexOf(","));
        EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bostype));
        sb.setLength(0);
        sb.append(str);
        sb.append("  from ").append(eo.getTable().getName()).append(" as  her  left join  ").append("\t\n");
        if (!barcodeTaskRulesInfo.isIsCheckMode()) {
            if (srcSpecial) {
                sb.append(" (select FSrcBosType,FsrcId,FsrcItemID,  sum(case when FFinqty<>0 then FFinqty else FQty end)  FQty  from T_SCM_BcTaskBill where FSrcBosType='").append(bostype).append("' and FTargetBosType='").append(barcodeTaskRulesInfo.getDesBosType()).append("'  and FStatus!='10' group by FSrcBosType,FsrcId,FsrcItemID)  as  BcTaskBill on BcTaskBill.FSrcId=her.fid  ").append("\t\n");
                sb.append(" where her.").append(qty).append("-(case  when  BcTaskBill.FQty is null THEN 0  else BcTaskBill.FQty end)>0  ");
            } else {
                if (!"D9D2CA5D".equals(bostype)) {
                    sb.append(entryTableName).append(" as ent on").append(" her.fid=ent.FParentID left join  ").append("\t\n");
                    sb.append(" (select FSrcBosType,FsrcId,FsrcItemID,  sum(case when FFinqty<>0 then FFinqty else FQty end)  FQty  from T_SCM_BcTaskBill where FSrcBosType='").append(bostype).append("'  and FTargetBosType='").append(barcodeTaskRulesInfo.getDesBosType()).append("'  and FStatus!='10' group by FSrcBosType,FsrcId,FsrcItemID)  as  BcTaskBill on BcTaskBill.FSrcItemId=ent.fid  ").append("\t\n");
                    sb.append(" where ent.").append(qty).append("-(case  when  BcTaskBill.FQty is null THEN 0  else BcTaskBill.FQty end)>0  ");
                } else {
                    sb.append(entryTableName).append(" as ent on").append(" her.fid=ent.FParentID left join  ").append("\t\n");
                    sb.append("  T_IM_CountingTask countingTask  on countingTask.fid=her.FCountingTaskid  ");
                    sb.append(" where 1=1 ");
                }
                if (bostype.equals(MANUFACTUREORDER_BOSTYPE)) {
                    sb.append(" and ent.FIsBackflush=0 ");
                }
            }
        } else if (!srcSpecial) {
            sb.append(entryTableName).append(" as ent on").append(" her.fid=ent.FParentID   where 1=1  ").append("\t\n");
            if (bostype.equals(MANUFACTUREORDER_BOSTYPE)) {
                sb.append(" and  ent.FIsBackflush=0 ");
            }
        }
        if (!StringUtils.isEmpty((String)strId)) {
            sb.append(" and her.fid in (" + strId + ") ");
        }
        if (!"D9D2CA5D".equals(bostype)) {
            if (!StringUtils.isEmpty((String)strNumber)) {
                sb.append(" and her.fnumber in (" + strNumber + ") ");
            }
            sb.append("  ORDER BY  her.fnumber ");
        } else {
            if (!StringUtils.isEmpty((String)strNumber)) {
                sb.append(" and countingTask.fnumber in (" + strNumber + ") ");
            }
            sb.append("  ORDER BY  countingTask.fnumber ");
        }
        sbstr.append(sb);
        return taskAnalysislist;
    }

    private Map<String, String> setEntryProperty(Context ctx, TaskAnalysis taskAnalysisInfo, IRowSet rows, String str, boolean srcSpecial, String destbostype, BarcodeTaskRulesInfo barcodeTaskRulesInfo) throws SQLException, EASBizException, BOSException {
        HashMap<String, String> setValue = new HashMap<String, String>();
        String key = "";
        String value = "";
        if (taskAnalysisInfo.isLinkProperty()) {
            IObjectValue objectValues;
            String objId = rows.getString(str + taskAnalysisInfo.getTableField());
            key = taskAnalysisInfo.getName() + "_" + taskAnalysisInfo.getPropertyname();
            if (!"name".equals(taskAnalysisInfo.getPropertyname()) && !"number".equals(taskAnalysisInfo.getPropertyname())) {
                key = taskAnalysisInfo.getPropertyname();
                value = !StringUtils.isEmpty((String)objId) ? ((objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, objId, taskAnalysisInfo.getPropertyname())).get(taskAnalysisInfo.getPropertyname()) == null ? "" : objectValues.get(taskAnalysisInfo.getPropertyname()).toString()) : "";
            } else {
                value = !StringUtils.isEmpty((String)objId) ? ((objectValues = (IObjectValue)BarcodeUtils.getModelIObjectValueByIdhead(ctx, objId, "")).get(taskAnalysisInfo.getPropertyname()) == null ? "" : objectValues.get(taskAnalysisInfo.getPropertyname()).toString()) : "";
            }
        } else {
            key = taskAnalysisInfo.getName();
            value = !StringUtils.isEmpty((String)rows.getString(str + taskAnalysisInfo.getTableField())) ? rows.getString(str + taskAnalysisInfo.getTableField()) : "";
        }
        if (barcodeTaskRulesInfo.isIsCheckMode() || "D9D2CA5D".equals(barcodeTaskRulesInfo.getSrcBosType())) {
            if ("qty".equals(taskAnalysisInfo.getTaskname())) {
                value = new DecimalFormat("#.##########").format(Double.parseDouble(value));
            }
        } else if ("qty".equals(taskAnalysisInfo.getTaskname())) {
            if (!StringUtils.isEmpty((String)rows.getString(str + taskAnalysisInfo.getTableField()))) {
                value = rows.getString(str + taskAnalysisInfo.getTableField());
            }
            String strqty = "";
            strqty = srcSpecial ? " select sum(case when FFinqty<>0 then FFinqty else FQty end) as fqty from  T_SCM_BcTaskBill  where FSrcId='" + rows.getString("id") + "'  and   FTargetBosType='" + destbostype + "' " : " select sum(case when FFinqty<>0 then FFinqty else FQty end) as fqty from  T_SCM_BcTaskBill  where FSrcItemId='" + rows.getString("entryid") + "' and   FTargetBosType='" + destbostype + "' ";
            IRowSet rowSetQty = DbUtil.executeQuery((Context)ctx, (String)strqty);
            if (rowSetQty.size() > 0) {
                rowSetQty.next();
                String fqty = rowSetQty.getString("fqty");
                value = new BigDecimal(value).subtract(new BigDecimal(StringUtils.isEmpty((String)fqty) ? "0" : fqty)).toString();
            }
            value = new DecimalFormat("#.##########").format(Double.parseDouble(value));
        }
        setValue.put("key", key);
        setValue.put("value", value);
        return setValue;
    }

    private String getStrJoint(String value, int i, String str) {
        str = i == 0 ? str + "'" + value + "'" : str + ",'" + value + "'";
        return str;
    }
}

