/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.pda.XmlSerHelper;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeScanningBarcodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeUploadFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.IScanTaskBill;
import com.kingdee.eas.barcode.scm.PDAOnlyMessageInfo;
import com.kingdee.eas.barcode.scm.ScanTaskBillFactory;
import com.kingdee.eas.barcode.scm.app.BarcodeServerUtils;
import com.kingdee.eas.barcode.scm.app.MoveBillCache;
import com.kingdee.eas.barcode.scm.app.MoveBillCacheManager;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SynTaskCreatebillExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.pda.app.sync.SynTaskCreatebillExec");

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv;
        block7: {
            rv = new BacodeMainReturn();
            String guuid = null;
            if (params.getParams().containsKey("_guid")) {
                guuid = params.getParams().get("_guid").toString();
            }
            try {
                rv = this.parseRecodeXml(ctx, params, guuid);
            }
            catch (EASBizException e) {
                rv.setCode("0");
                rv.setInnerError(e.getMessage());
                e.printStackTrace();
                if (guuid != null) {
                    PDAOnlyMessageInfo pdaOnlyInfo;
                    MoveBillCache moveBillcache = MoveBillCacheManager.getCacheInfo(guuid);
                    if (moveBillcache != null && moveBillcache.getValue() != null && !(pdaOnlyInfo = (PDAOnlyMessageInfo)moveBillcache.getValue()).isIsFlag()) {
                        MoveBillCacheManager.clearOnly(guuid);
                    }
                    logger.info((Object)("\u5355\u636e\u751f\u6210\u5931\u8d25\uff0c\u6e05\u7a7a\u7f13\u5b58 MoveBillCacheManager \u4e2d\u7684 " + guuid));
                }
            }
            catch (BOSException e) {
                PDAOnlyMessageInfo pdaOnlyInfo;
                rv.setCode("0");
                rv.setInnerError(e.getMessage());
                e.printStackTrace();
                if (guuid == null) break block7;
                MoveBillCache moveBillcache = MoveBillCacheManager.getCacheInfo(guuid);
                if (moveBillcache != null && moveBillcache.getValue() != null && !(pdaOnlyInfo = (PDAOnlyMessageInfo)moveBillcache.getValue()).isIsFlag()) {
                    MoveBillCacheManager.clearOnly(guuid);
                }
                logger.info((Object)("\u5355\u636e\u751f\u6210\u5931\u8d25\uff0c\u6e05\u7a7a\u7f13\u5b58 MoveBillCacheManager \u4e2d\u7684 " + guuid));
            }
        }
        return rv;
    }

    public BacodeMainReturn parseRecodeXml(Context ctx, BarcodeMainParam params, String guuid) throws EASBizException, BOSException {
        BacodeMainReturn rv = new BacodeMainReturn();
        JSONObject infoMap = JSONObject.fromObject(params.getParams().get("_info"));
        String bosType = infoMap.get("billtypeid").toString();
        JSONObject billDataMap = JSONObject.fromObject(infoMap.get("_bill"));
        String[] billNodeName = ((Map)billDataMap.get("_entryName")).get("val").toString().split("_");
        String entriesMapkey = billNodeName[0];
        String entryBosType = billNodeName[1];
        BarcodeScanningRecodeInfo scanningRecodeInfo = new BarcodeScanningRecodeInfo();
        HashMap<String, BarcodeScanningPropertyInfo> parentPropertiesMap = new HashMap<String, BarcodeScanningPropertyInfo>();
        EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosType));
        IScanTaskBill iScanTaskBill = ScanTaskBillFactory.getLocalInstance(ctx);
        BarcodeConfigInfo barcodeConfigInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(infoMap.get("barcodeConfigId").toString()));
        BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(barcodeConfigInfo.getDetailsXML());
        List oldRecodeList = (List)iScanTaskBill.getRecodesList(infoMap.get("billid").toString(), configXml);
        if (oldRecodeList == null || oldRecodeList.size() == 0) {
            rv.setCode("0");
            rv.setInnerError("\u6ca1\u6709\u626b\u63cf\u6570\u636e\uff0c\u63d0\u4ea4\u5931\u8d25\uff01");
            return rv;
        }
        BarcodeScanningRecodeInfo oldRecodeInfo = (BarcodeScanningRecodeInfo)oldRecodeList.get(0);
        Map<String, BarcodeScanningPropertyInfo> oldparentPropertiesMap = oldRecodeInfo.getProperties();
        Iterator it = billDataMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if ("rows".equalsIgnoreCase(key) || "_ENTRYNAME".equalsIgnoreCase(key) || "BARCODELIST".equalsIgnoreCase(key)) continue;
            Object objectValue = JSONObject.fromObject(billDataMap.get(key)).get(key);
            PropertyInfo property = entity.getPropertyByName(key);
            BarcodeScanningPropertyInfo parentPropertyInfo = XmlSerHelper.setPropertyValue(scanningRecodeInfo, property, key, objectValue);
            if (oldparentPropertiesMap.containsKey(key) && objectValue != null && !"".equals(objectValue)) {
                oldparentPropertiesMap.put(key, parentPropertyInfo);
            }
            if ("fid".equals(key) && objectValue != null && !"".equals(objectValue)) {
                key = "id";
            }
            parentPropertiesMap.put(key, parentPropertyInfo);
        }
        Object[] rowArg = ((JSONArray)billDataMap.get("rows")).toArray();
        LinkedHashMap<String, List<BarcodeScanningRecodeInfo>> entriesMap = new LinkedHashMap<String, List<BarcodeScanningRecodeInfo>>();
        SynTaskCreatebillExec.paresRecodeEntry(rowArg, entriesMapkey, bosType, entryBosType, entriesMap, oldRecodeInfo.getEntriesMap().get(entriesMapkey));
        if (entriesMap.size() == 0) {
            rv.setCode("0");
            rv.setInnerError("\u6ca1\u6709\u626b\u63cf\u6570\u636e\uff0c\u63d0\u4ea4\u5931\u8d25\uff01");
            return rv;
        }
        scanningRecodeInfo.setProperties(parentPropertiesMap);
        scanningRecodeInfo.setEntriesMap(entriesMap);
        scanningRecodeInfo.setPDA(true);
        scanningRecodeInfo.setFparentId(infoMap.get("billid").toString());
        scanningRecodeInfo.setFbosType(bosType);
        scanningRecodeInfo.setGuuid(guuid);
        ArrayList<BarcodeScanningRecodeInfo> recodeList = new ArrayList<BarcodeScanningRecodeInfo>();
        recodeList.add(scanningRecodeInfo);
        String srcBosType = infoMap.get("srcBosType") != null && !"".equals(infoMap.get("srcBosType")) ? infoMap.get("srcBosType").toString() : null;
        String botpId = infoMap.get("botpId") != null && !"".equals(infoMap.get("botpId")) ? infoMap.get("botpId").toString() : null;
        String number = BarcodeUploadFacadeFactory.getLocalInstance(ctx).uploadBarcodeBill(recodeList, null, srcBosType, bosType, botpId);
        if (null != guuid) {
            String billNumber = BarcodeServerUtils.checkReaptBill(ctx, guuid);
            if (billNumber != null && !"submit".equals(billNumber)) {
                throw new EASBizException(new NumericExceptionSubItem("\u8c03\u7528EAS\u63a5\u53e3\u5931\u8d25", "\u5df2\u7ecf\u751f\u6210\u5355\u636e\u3010" + billNumber + "\u3011,\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002"));
            }
            if (billNumber != null && "submit".equals(billNumber)) {
                throw new EASBizException(new NumericExceptionSubItem("\u8c03\u7528EAS\u63a5\u53e3\u5931\u8d25", "\u5355\u636e\u6b63\u5728\u63d0\u4ea4\u4e2d\u3002\u3002\u3002"));
            }
        }
        if (number != null) {
            BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
            proInfo.setKey("feasbillnumber");
            proInfo.setValue(number);
            oldparentPropertiesMap.put("feasbillnumber", proInfo);
            ScanTaskBillFactory.getLocalInstance(ctx).saveScanningRecodes(oldRecodeList, bosType, configXml);
            rv.setCode("1");
            rv.setMsg("\u5355\u636e\u3010" + number + "\u3011\u751f\u6210\u6210\u529f!");
        } else {
            rv.setCode("0");
            rv.setInnerError("\u63d0\u4ea4\u5931\u8d25\uff01");
        }
        return rv;
    }

    public static Map<String, List<BarcodeScanningRecodeInfo>> paresRecodeEntry(Object[] rowArg, String entriesMapkey, String bosType, String entryBosType, Map<String, List<BarcodeScanningRecodeInfo>> entriesMap, List<BarcodeScanningRecodeInfo> oldEntryScanningList) {
        ArrayList<BarcodeScanningRecodeInfo> entryRecodeList = new ArrayList<BarcodeScanningRecodeInfo>();
        LinkedHashMap<String, List<BarcodeScanningRecodeInfo>> countingTableRow = new LinkedHashMap<String, List<BarcodeScanningRecodeInfo>>();
        LinkedHashMap<String, BarcodeScanningRecodeInfo> oldentriesMap = new LinkedHashMap<String, BarcodeScanningRecodeInfo>();
        int size = oldEntryScanningList.size();
        for (int i = 0; i < size; ++i) {
            BarcodeScanningRecodeInfo oldRecodeInfo = oldEntryScanningList.get(i);
            if (oldRecodeInfo.getFid() == null) continue;
            oldentriesMap.put(oldRecodeInfo.getFid(), oldRecodeInfo);
        }
        size = rowArg.length;
        for (int k = 0; k < size; ++k) {
            BarcodeScanningRecodeInfo entryRecodeInfo = new BarcodeScanningRecodeInfo();
            JSONObject rowsMap = JSONObject.fromObject((Object)rowArg[k]);
            TreeMap<String, BarcodeScanningPropertyInfo> entryPropertiesMap = new TreeMap<String, BarcodeScanningPropertyInfo>();
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosType));
            String countTingTableID = null;
            entryRecodeInfo.setFparentBosType(bosType);
            entryRecodeInfo.setFbosType(entryBosType);
            Iterator it = rowsMap.keySet().iterator();
            if (!rowsMap.containsKey("barcodelist")) continue;
            BigDecimal splittedQty = BigDecimal.ZERO;
            BigDecimal difQty = BigDecimal.ZERO;
            while (it.hasNext()) {
                String key = it.next().toString();
                if (key.equalsIgnoreCase("BARCODELIST") || "BARCODE".equalsIgnoreCase(key)) continue;
                Object objectValue = rowsMap.get(key);
                PropertyInfo property = entity.getPropertyByName(key);
                BarcodeScanningPropertyInfo proInfo = XmlSerHelper.setPropertyValue(entryRecodeInfo, property, key, objectValue);
                if ("fid".equals(key) && objectValue != null && !"".equals(objectValue)) {
                    entryRecodeInfo.setFid(objectValue.toString());
                }
                if ("fsrcEntryId".equals(key) && objectValue != null && !"".equals(objectValue)) {
                    entryRecodeInfo.setFsrcEntryId(objectValue.toString());
                }
                if ("fsrcBillId".equals(key) && objectValue != null && !"".equals(objectValue)) {
                    entryRecodeInfo.setFsrcBillId(objectValue.toString());
                }
                if ("fdifQty".equals(key) && objectValue != null && !"".equals(objectValue)) {
                    difQty = new BigDecimal(objectValue.toString());
                    difQty = new BigDecimal(difQty.stripTrailingZeros().toPlainString());
                }
                if ("fsplittedQty".equals(key) && objectValue != null && !"".equals(objectValue)) {
                    splittedQty = new BigDecimal(objectValue.toString());
                    splittedQty = new BigDecimal(difQty.stripTrailingZeros().toPlainString());
                }
                entryPropertiesMap.put(key, proInfo);
                if (!"D9D2CA5D".equalsIgnoreCase(bosType) || !"parent_number".equals(key) || objectValue == null || "".equals(objectValue)) continue;
                countTingTableID = objectValue.toString();
            }
            BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
            proInfo.setKey("fdifSplitQty");
            BigDecimal difSplitQty = difQty.subtract(splittedQty);
            if (difSplitQty.compareTo(BigDecimal.ZERO) >= 0) {
                proInfo.setValue(difSplitQty);
            } else {
                proInfo.setValue(BigDecimal.ZERO);
            }
            entryPropertiesMap.put("fdifSplitQty", proInfo);
            Object[] barcodeArg = ((JSONArray)rowsMap.get("barcodelist")).toArray();
            ArrayList<BarcodeScanningBarcodeInfo> barcodeScanningBarcodeList = new ArrayList<BarcodeScanningBarcodeInfo>();
            int b = barcodeArg.length;
            for (int l = 0; l < b; ++l) {
                JSONObject barcodeMap = JSONObject.fromObject((Object)barcodeArg[l]);
                BarcodeScanningBarcodeInfo barcodeInfo = new BarcodeScanningBarcodeInfo();
                String barcode = barcodeMap.get("barcode").toString();
                String barcodeQty = barcodeMap.get("qty").toString();
                barcodeInfo.setBarcode(barcode);
                barcodeInfo.setBarcodeQty(new BigDecimal(barcodeQty));
                barcodeScanningBarcodeList.add(barcodeInfo);
            }
            entryRecodeInfo.setBarcodeList(barcodeScanningBarcodeList);
            entryRecodeInfo.setPDA(true);
            entryRecodeInfo.setProperties(entryPropertiesMap);
            if (countTingTableID != null) {
                if (!countingTableRow.containsKey(countTingTableID)) {
                    ArrayList<BarcodeScanningRecodeInfo> newentryRecodeList = new ArrayList<BarcodeScanningRecodeInfo>();
                    newentryRecodeList.add(entryRecodeInfo);
                    countingTableRow.put(countTingTableID, newentryRecodeList);
                } else {
                    List newentryRecodeList = (List)countingTableRow.get(countTingTableID);
                    newentryRecodeList.add(entryRecodeInfo);
                    countingTableRow.put(countTingTableID, newentryRecodeList);
                }
            } else {
                countingTableRow = null;
            }
            if (oldentriesMap.containsKey(entryRecodeInfo.getFid())) {
                BarcodeScanningRecodeInfo oldEntryRecondeInfo = (BarcodeScanningRecodeInfo)oldentriesMap.get(entryRecodeInfo.getFid());
                oldEntryRecondeInfo.setProperties(entryRecodeInfo.getProperties());
                oldEntryRecondeInfo.setBarcodeList(entryRecodeInfo.getBarcodeList());
                oldEntryRecondeInfo.setSeqNoList(entryRecodeInfo.getSeqNoList());
                oldentriesMap.put(entryRecodeInfo.getFid(), oldEntryRecondeInfo);
            }
            entryRecodeList.add(entryRecodeInfo);
        }
        entriesMap.put(entriesMapkey, entryRecodeList);
        return countingTableRow;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("issplit"));
        sic.add(new SelectorItemInfo("taskName"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("number"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("barcodeConfig.*"));
        } else {
            sic.add(new SelectorItemInfo("barcodeConfig.id"));
            sic.add(new SelectorItemInfo("barcodeConfig.number"));
            sic.add(new SelectorItemInfo("barcodeConfig.name"));
        }
        sic.add(new SelectorItemInfo("srcBosType"));
        sic.add(new SelectorItemInfo("destBosType"));
        sic.add(new SelectorItemInfo("priority"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("chidTask.*"));
        } else {
            sic.add(new SelectorItemInfo("chidTask.id"));
            sic.add(new SelectorItemInfo("chidTask.number"));
            sic.add(new SelectorItemInfo("chidTask.taskName"));
        }
        sic.add(new SelectorItemInfo("billtype"));
        sic.add(new SelectorItemInfo("vldto"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("billStatus"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("transactionType.*"));
        } else {
            sic.add(new SelectorItemInfo("transactionType.id"));
            sic.add(new SelectorItemInfo("transactionType.number"));
            sic.add(new SelectorItemInfo("transactionType.name"));
        }
        sic.add(new SelectorItemInfo("taskObject"));
        sic.add(new SelectorItemInfo("schedule"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("auditor.*"));
        } else {
            sic.add(new SelectorItemInfo("auditor.id"));
            sic.add(new SelectorItemInfo("auditor.number"));
            sic.add(new SelectorItemInfo("auditor.name"));
        }
        sic.add(new SelectorItemInfo("auditTime"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("creator.*"));
        } else {
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("creator.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        } else {
            sic.add(new SelectorItemInfo("lastUpdateUser.id"));
            sic.add(new SelectorItemInfo("lastUpdateUser.number"));
            sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        }
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("botpId"));
        sic.add(new SelectorItemInfo("botpNumber"));
        sic.add(new SelectorItemInfo("BdEntrys.seq"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("BdEntrys.*"));
        }
        sic.add(new SelectorItemInfo("BdEntrys.barcode"));
        sic.add(new SelectorItemInfo("BdEntrys.sourceEntryId"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entrys.material.*"));
        } else {
            sic.add(new SelectorItemInfo("entrys.material.id"));
            sic.add(new SelectorItemInfo("entrys.material.number"));
            sic.add(new SelectorItemInfo("entrys.material.name"));
        }
        sic.add(new SelectorItemInfo("entrys.sourceBillEntryId"));
        sic.add("*");
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("barcodeConfig.id"));
        sic.add(new SelectorItemInfo("barcodeConfig.botMapping.id"));
        sic.add(new SelectorItemInfo("barcodeConfig.srcBosType"));
        return sic;
    }
}

