/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BcTaskBillFactory;
import com.kingdee.eas.barcode.scm.BcTaskBillInfo;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import java.text.ParseException;
import net.sf.json.JSONArray;
import org.apache.log4j.Logger;

public class SynUpdateInvBillBase
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SynUpdateInvBillBase.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        String guuid = null;
        if (params.getParams().containsKey("_guid")) {
            guuid = params.getParams().get("_guid").toString();
        }
        try {
            long time = System.currentTimeMillis();
            logger.info((Object)(" SynUpdateInvBillBase begin\uff1a" + time));
            rv = this.updateInvBillBase(ctx, params, guuid);
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" SynUpdateInvBillBase end,totalTime=\uff1a" + time));
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            e.printStackTrace();
            logger.warn((Object)e);
        }
        return rv;
    }

    private BacodeMainReturn updateInvBillBase(Context ctx, BarcodeMainParam params, String guuid) throws EASBizException, BOSException, ParseException {
        BacodeMainReturn rv = new BacodeMainReturn();
        if (params.getParams().containsKey("_taskid") && !BarcodeUtils.isObjectEmpty(params.getParams().get("_taskid")).booleanValue()) {
            Object[] isrowArg = ((JSONArray)params.getParams().get("_taskid")).toArray();
            if (isrowArg.length > 0) {
                for (int i = 0; isrowArg.length > i; ++i) {
                    BcTaskBillInfo bcTaskBillInfo = BcTaskBillFactory.getLocalInstance(ctx).getBcTaskBillInfo((IObjectPK)new ObjectStringPK(isrowArg[i].toString()));
                    ObjectUuidPK objpk = new ObjectUuidPK(bcTaskBillInfo.getSrcItemId());
                    IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                    InvBillBaseEntryInfo easBill = (InvBillBaseEntryInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk);
                    ICoreBase iCoreBase = this.getInterface(ctx, easBill.getBOSType());
                    WarehouseInfo warehouseInfo = null;
                    if (params.getParams().containsKey("pc") && !BarcodeUtils.isObjectEmpty(params.getParams().get("pc")).booleanValue()) {
                        easBill.setLot(params.getParams().get("pc").toString());
                    }
                    if (params.getParams().containsKey("warehouse_number") && !BarcodeUtils.isObjectEmpty(params.getParams().get("warehouse_number")).booleanValue()) {
                        warehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo(" where number='" + params.getParams().get("warehouse_number").toString() + "'");
                        easBill.setWarehouse(warehouseInfo);
                    }
                    if (params.getParams().containsKey("location_number") && !BarcodeUtils.isObjectEmpty(params.getParams().get("location_number")).booleanValue()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("where  Warehouse.id='").append(warehouseInfo == null ? "----" : warehouseInfo.getId().toString()).append("' and  number='").append(params.getParams().get("location_number").toString()).append("' ");
                        easBill.setLocation(LocationFactory.getLocalInstance((Context)ctx).getLocationCollection(sb.toString()).get(0));
                    }
                    if (params.getParams().containsKey("asstAttr_number") && !BarcodeUtils.isObjectEmpty(params.getParams().get("asstAttr_number")).booleanValue()) {
                        easBill.setAssistProperty(AsstAttrValueFactory.getLocalInstance((Context)ctx).getAsstAttrValueInfo(" where number='" + params.getParams().get("asstAttr_number").toString() + "'"));
                    }
                    if (params.getParams().containsKey("trackNo_number") && !BarcodeUtils.isObjectEmpty(params.getParams().get("trackNo_number")).booleanValue()) {
                        easBill.setTrackNumber(TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo(" where number='" + params.getParams().get("trackNo_number").toString() + "'"));
                    }
                    if (params.getParams().containsKey("projectNo_number") && !BarcodeUtils.isObjectEmpty(params.getParams().get("projectNo_number")).booleanValue()) {
                        easBill.setProject(ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo(" where number='" + params.getParams().get("projectNo_number").toString() + "'"));
                    }
                    if (params.getParams().containsKey("proDate") && !BarcodeUtils.isObjectEmpty(params.getParams().get("proDate")).booleanValue()) {
                        easBill.setMfg(UWDateHelper.FORMAT_DAY.parse(params.getParams().get("proDate").toString()));
                    }
                    if (params.getParams().containsKey("untilDate") && !BarcodeUtils.isObjectEmpty(params.getParams().get("untilDate")).booleanValue()) {
                        easBill.setExp(UWDateHelper.FORMAT_DAY.parse(params.getParams().get("untilDate").toString()));
                    }
                    iCoreBase.save((CoreBaseInfo)easBill);
                }
            } else {
                rv.setInnerError("\u4fee\u6539\u5931\u8d25\u6ca1\u6709\u5bf9\u5e94\u7684\u5355\u636e\uff01");
                rv.setCode("0");
                return rv;
            }
            rv.setInnerError("\u4fee\u6539\u6210\u529f\uff01");
            rv.setCode("1");
            return rv;
        }
        rv.setInnerError("\u4fee\u6539\u5931\u8d25\u6ca1\u6709\u5bf9\u5e94\u7684\u5355\u636e\uff01");
        rv.setCode("0");
        return rv;
    }

    public ICoreBase getInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        return (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
    }
}

