/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.pda.BarcodePDAScanning;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResultItem;
import com.kingdee.eas.barcode.scm.BarcodeWSException;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryBarcodeEntryCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillFactory;
import com.kingdee.eas.barcode.scm.BcTaskBillInfo;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SyncAnalyticdossierExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncAnalyticdossierExec.class.getName());
    private String resourceBaseStr = "com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource";
    public static final String PRODUCTIONORDER_BOSTYPE = "1F66774E";
    public static final String FINISHEDRPT_BOSTYPE = "F2901DDD";
    public static final String ManufactureRecBill_BOSTYPE = "FA1292B4";

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        JSONObject revObje = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String barcode = null;
        String billType = null;
        String taskid = null;
        String nosrc = null;
        if (params.getParams().containsKey("_barcode")) {
            barcode = params.getParams().get("_barcode").toString();
        }
        if (params.getParams().containsKey("_billtype")) {
            billType = params.getParams().get("_billtype").toString();
        }
        if (params.getParams().containsKey("_taskid")) {
            taskid = params.getParams().get("_taskid").toString();
        }
        if (params.getParams().containsKey("_nosrc")) {
            nosrc = params.getParams().get("_nosrc").toString();
        }
        if (barcode == null) {
            rv.setInnerError("\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            revObje = this.getBarcodeAnalysis(ctx, barcode, billType, taskid, nosrc);
            rv.setDefSucc(newReqTime);
            rv.setInfo(revObje);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private JSONObject getBarcodeAnalysis(Context ctx, String barcode, String billType, String taskid, String nosrc) throws BOSException, EASBizException {
        IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getLocalInstance(ctx).getIndubarodeParamsetCollection();
        IndubarodeParamsetInfo indubarodeParamsetInfo = paramCol.get(0);
        boolean isSimpleMode = false;
        if (ManufactureRecBill_BOSTYPE.equalsIgnoreCase(billType) && !StringUtils.isEmpty((String)nosrc) && "1".equals(nosrc) && (isSimpleMode = indubarodeParamsetInfo.isIsSimpleMode()) && indubarodeParamsetInfo.getProcess() != null && indubarodeParamsetInfo.getProStorage() != null) {
            BOTMappingInfo bOTPProcess = indubarodeParamsetInfo.getProcess();
            bOTPProcess = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(bOTPProcess.getId()), this.getSelectorItemCollection());
            BOTMappingInfo bOTPProStorage = indubarodeParamsetInfo.getProStorage();
            bOTPProStorage = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(bOTPProStorage.getId()), this.getSelectorItemCollection());
            if (!PRODUCTIONORDER_BOSTYPE.equalsIgnoreCase(bOTPProcess.getSrcEntityName()) || !FINISHEDRPT_BOSTYPE.equalsIgnoreCase(bOTPProcess.getDestEntityName())) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u6b64\u89c4\u5219\u4e0d\u7b26\u5408\u6d41\u7a0b\u751f\u6210\u8ba2\u5355-\u6d41\u7a0b\u5b8c\u5de5\u6c47\u62a5\u5355\u89c4\u5219\uff01"));
            }
            if (!FINISHEDRPT_BOSTYPE.equalsIgnoreCase(bOTPProStorage.getSrcEntityName()) || !ManufactureRecBill_BOSTYPE.equalsIgnoreCase(bOTPProStorage.getDestEntityName())) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u6b64\u89c4\u5219\u4e0d\u7b26\u5408\u6d41\u7a0b\u5b8c\u5de5\u6c47\u62a5\u5355-\u751f\u4ea7\u5165\u5e93\u89c4\u5219\uff01"));
            }
        }
        boolean found = true;
        if (!StringUtils.isEmpty((String)taskid)) {
            BcTaskBillInfo bcTaskBillInfo = BcTaskBillFactory.getLocalInstance(ctx).getBcTaskBillInfo((IObjectPK)new ObjectStringPK(taskid));
            BcTaskBillEntryCollection bcTaskBillEntryColl = bcTaskBillInfo.getEntrys();
            int n = bcTaskBillEntryColl.size();
            for (int y = 0; y < n && found; ++y) {
                BcTaskBillEntryInfo bcTaskBillEntryInfo = bcTaskBillEntryColl.get(y);
                BcTaskBillEntryBarcodeEntryCollection bcTaskBillEntryBarcodeEntryColl = bcTaskBillEntryInfo.getBarcodeEntrys();
                int p = bcTaskBillEntryBarcodeEntryColl.size();
                for (int i = 0; i < p; ++i) {
                    if (!barcode.equals(bcTaskBillEntryBarcodeEntryColl.get(i).getBarcode())) continue;
                    found = false;
                }
            }
        }
        if (found && !StringUtils.isEmpty((String)taskid)) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u6b64\u6761\u7801\uff1a" + barcode + "\u4e0d\u5728\u5f53\u524d\u53d1\u8d27\u4efb\u52a1\u4e2d\u8bf7\u91cd\u65b0\u626b\u7801\uff01"));
        }
        String transTypeNumber = null;
        ArrayList<BarcodeAnalysisResult> barcodeResultList = new ArrayList<BarcodeAnalysisResult>();
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = BarcodeClientUtils.getParamValueStr(ctx);
        BarcodePDAScanning pdaScanning = new BarcodePDAScanning();
        boolean isPackage = pdaScanning.executeBarcode(ctx, barcode, transTypeNumber, null, billType, paramValue, ctrlUnitInfo, barcodeResultList, true);
        if (barcodeResultList.size() == 0) {
            throw new BarcodeWSException(BarcodeWSException.BARCODENULL);
        }
        JSONObject allBarcodeObj = new JSONObject();
        if (isPackage) {
            allBarcodeObj.put((Object)"barcode", (Object)this.getBarcodeJsonStr("barcode", barcode, "\u6761\u7801", false));
        }
        JSONObject childArray = new JSONObject();
        int size = barcodeResultList.size();
        for (int i = 0; i < size; ++i) {
            BarcodeAnalysisResult analysisResult = (BarcodeAnalysisResult)barcodeResultList.get(i);
            List<BarcodeAnalysisResultItem> resultItem = analysisResult.getItems();
            HashMap<String, String> exsitsMap = new HashMap<String, String>();
            JSONObject childBarcodeObj = new JSONObject();
            childBarcodeObj.put((Object)"isCumsumQty", (Object)this.getBarcodeJsonStr("isCumsumQty", Boolean.toString(analysisResult.isCumsumQty()), ResourceBase.getString((String)this.resourceBaseStr, (String)"isCumsumQty", (Locale)ctx.getLocale()), false));
            childBarcodeObj.put((Object)"isBarcodeRepeat", (Object)this.getBarcodeJsonStr("isBarcodeRepeat", Boolean.toString(analysisResult.isBarcodeRepeat()), ResourceBase.getString((String)this.resourceBaseStr, (String)"isBarcodeRepeat", (Locale)ctx.getLocale()), false));
            if (isSimpleMode) {
                if (StringUtils.isEmpty((String)analysisResult.getSrcBillNumber())) {
                    throw new EASBizException(new NumericExceptionSubItem("", "\u542f\u7528\u6d41\u7a0b\u751f\u4ea7\u8ba2\u5355\u4e0d\u80fd\u89e3\u6790\u6761\u7801\u6216\u8005\u6e90\u5355\u4e0d\u5b58\u5728\uff01"));
                }
                ProductionOrderInfo productionOrderInfo = null;
                try {
                    productionOrderInfo = ProductionOrderFactory.getLocalInstance((Context)ctx).getProductionOrderInfo((IObjectPK)new ObjectStringPK(analysisResult.getSrcBillId()));
                }
                catch (Exception e) {
                    throw new EASBizException(new NumericExceptionSubItem("", "\u6d41\u7a0b\u751f\u4ea7\u8ba2\u5355\u4e0d\u5728\u5f53\u524d\u6761\u7801\uff1a" + barcode + " \u4e2d\u8bf7\u68c0\u67e5\u6761\u7801\uff01"));
                }
                if (productionOrderInfo.getBaseStatus() == BillBaseStatusEnum.RELEASED) {
                    childBarcodeObj.put((Object)"_srcNumber", (Object)analysisResult.getSrcBillNumber());
                } else {
                    throw new EASBizException(new NumericExceptionSubItem("", "\u6e90\u5355" + analysisResult.getSrcBillNumber() + "\u72b6\u6001\u4e0d\u662f\u4e0b\u8fbe\u72b6\u6001\uff01"));
                }
            }
            if (!StringUtils.isEmpty((String)analysisResult.getMaterialID())) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)ContextUtil.getCurrentStorageUnit((Context)ctx).getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)analysisResult.getMaterialID(), CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                viewInfo.getSelector().add(new SelectorItemInfo("*"));
                MaterialInventoryCollection materialInventoryColl = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewInfo);
                if (materialInventoryColl.size() > 0) {
                    childBarcodeObj.put((Object)"_isperiodvalid", (Object)this.getBarcodeJsonStr("", materialInventoryColl.get(0).isIsPeriodValid(), "", false));
                    childBarcodeObj.put((Object)"_periodvalid", (Object)this.getBarcodeJsonStr("", materialInventoryColl.get(0).getPeriodValid(), "", false));
                    TimeUnitEnum periodValidUnit = materialInventoryColl.get(0).getPeriodValidUnit();
                    if (periodValidUnit.getValue() == 1) {
                        childBarcodeObj.put((Object)"_periodvalidunit", (Object)this.getBarcodeJsonStr("", 1, "", false));
                    } else if (periodValidUnit.getValue() == 2) {
                        childBarcodeObj.put((Object)"_periodvalidunit", (Object)this.getBarcodeJsonStr("", 2, "", false));
                    } else if (periodValidUnit.getValue() == 3) {
                        childBarcodeObj.put((Object)"_periodvalidunit", (Object)this.getBarcodeJsonStr("", 5, "", false));
                    }
                }
            }
            int m = resultItem.size();
            for (int j = 0; j < m; ++j) {
                BarcodeAnalysisResultItem item = resultItem.get(j);
                if (item.getValue() == null) {
                    item.setValue("");
                }
                if (item.isLinkedProperty()) {
                    if (exsitsMap.containsKey(item.getNumberProperty())) continue;
                    childBarcodeObj.put((Object)item.getNumberProperty(), (Object)this.getBarcodeJsonStr(item.getNumberProperty(), item.getValue(), item.getAlias(), item.getIsMatchItem()));
                    if (!exsitsMap.containsKey(item.getNumberProperty())) {
                        exsitsMap.put(item.getNumberProperty(), item.getNumberProperty());
                    }
                    if (item.getNameProperty() == null || exsitsMap.containsKey(item.getNameProperty())) continue;
                    childBarcodeObj.put((Object)item.getNameProperty(), (Object)this.getBarcodeJsonStr(item.getNameProperty(), item.getNameValue(), item.getAlias(), item.getIsMatchItem()));
                    exsitsMap.put(item.getNameProperty(), item.getNameProperty());
                    continue;
                }
                childBarcodeObj.put((Object)item.getMoveField(), (Object)this.getBarcodeJsonStr(item.getField(), item.getValue(), item.getAlias(), item.getIsMatchItem()));
            }
            childArray.put((Object)analysisResult.getBarcode(), (Object)childBarcodeObj);
            if (isPackage) continue;
            return childBarcodeObj;
        }
        allBarcodeObj.put((Object)"_children", (Object)childArray);
        return allBarcodeObj;
    }

    private JSONObject getBarcodeJsonStr(String propertyName, Object value, String aliasName, boolean isMatchItem) {
        if (value == null) {
            value = "";
        }
        JSONObject jsonObj = new JSONObject();
        if (value != null && !"".equals(value)) {
            jsonObj.put((Object)"val", (Object)value.toString());
        } else {
            jsonObj.put((Object)"val", (Object)"");
        }
        jsonObj.put((Object)"ismat", (Object)(isMatchItem ? 1 : 0));
        jsonObj.put((Object)"alias", (Object)aliasName);
        return jsonObj;
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection SelectorItemCollection2 = new SelectorItemCollection();
        SelectorItemCollection2.add(new SelectorItemInfo("srcEntityName"));
        SelectorItemCollection2.add(new SelectorItemInfo("destEntityName"));
        SelectorItemCollection2.add(new SelectorItemInfo("*"));
        return SelectorItemCollection2;
    }
}

