/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeRuleCollection;
import com.kingdee.eas.barcode.scm.BarcodeRuleEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.BarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.common.EASBizException;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SyncBarcodeRuleExec
implements SyncExec {
    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            rv.setInfo(this.getBarcodeRuleInfo(ctx, params));
            rv.setDefSucc(newReqTime);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rv;
    }

    private JSONArray getBarcodeRuleInfo(Context ctx, BarcodeMainParam params) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        view.setFilter(filterInfo);
        BarcodeRuleCollection ruleInfoCol = BarcodeRuleFactory.getLocalInstance(ctx).getBarcodeRuleCollection(view);
        JSONArray allArray = new JSONArray();
        int size = ruleInfoCol.size();
        for (int i = 0; i < size; ++i) {
            BarcodeRuleInfo barcodeRuleInfo = ruleInfoCol.get(i);
            allArray.add((Object)this.getScanTaskBillRow(ctx, barcodeRuleInfo));
        }
        return allArray;
    }

    private JSONObject getScanTaskBillRow(Context ctx, BarcodeRuleInfo barcodeRuleInfo) throws EASBizException, BOSException {
        JSONObject barcodeRuleObj = new JSONObject();
        barcodeRuleObj.put((Object)"number", (Object)barcodeRuleInfo.getNumber());
        barcodeRuleObj.put((Object)"name", (Object)barcodeRuleInfo.getName());
        barcodeRuleObj.put((Object)"barcodetype", (Object)barcodeRuleInfo.getBarcodeType().getNumber());
        barcodeRuleObj.put((Object)"length", (Object)barcodeRuleInfo.getLength());
        barcodeRuleObj.put((Object)"status", (Object)(barcodeRuleInfo.getStatus().getValue() == 1 ? 1 : 0));
        barcodeRuleObj.put((Object)"billitems", (Object)barcodeRuleInfo.getEntityBosType());
        barcodeRuleObj.put((Object)"rulesegment", (Object)(barcodeRuleInfo.isRuleSegment() ? 1 : 0));
        barcodeRuleObj.put((Object)"segmentnum", (Object)barcodeRuleInfo.getSegmentNum());
        barcodeRuleObj.put((Object)"delimiter", (Object)barcodeRuleInfo.getSeparators());
        barcodeRuleObj.put((Object)"pattern", (Object)barcodeRuleInfo.getPattern());
        EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)barcodeRuleInfo.getEntityBosType()));
        Map<String, EntityObjectInfo> mapEntity = BarcodeUtils.getEntryName(entity);
        EntityObjectInfo entryEntity = null;
        JSONArray allArray = new JSONArray();
        int size = barcodeRuleInfo.getDetails().size();
        for (int i = 0; i < size; ++i) {
            JSONObject bREntryObj = new JSONObject();
            BarcodeRuleEntryInfo ruleEntryInfo = barcodeRuleInfo.getDetails().get(i);
            bREntryObj.put((Object)"index", (Object)ruleEntryInfo.getSeq());
            bREntryObj.put((Object)"startswith", (Object)ruleEntryInfo.getStartsWith());
            bREntryObj.put((Object)"endswith", (Object)ruleEntryInfo.getEndsWith());
            bREntryObj.put((Object)"format", (Object)ruleEntryInfo.getFormat());
            bREntryObj.put((Object)"propertyalias", (Object)ruleEntryInfo.getPropertyAlias());
            bREntryObj.put((Object)"propertytype", (Object)ruleEntryInfo.getPropertyBosType());
            PropertyInfo propertyInfo = entity.getPropertyByName(ruleEntryInfo.getProperty());
            if (propertyInfo != null) {
                if (propertyInfo instanceof LinkPropertyInfo) {
                    bREntryObj.put((Object)"property", (Object)(propertyInfo.getName() + "_number"));
                } else {
                    bREntryObj.put((Object)"property", (Object)propertyInfo.getName());
                }
            } else {
                for (String key : ruleEntryInfo.getProperty().split("\\.")) {
                    if (mapEntity.containsKey(key)) {
                        if (entryEntity != null) continue;
                        entryEntity = mapEntity.get(key);
                        continue;
                    }
                    propertyInfo = entryEntity.getPropertyByName(key);
                    if (propertyInfo instanceof LinkPropertyInfo) {
                        bREntryObj.put((Object)"property", (Object)(propertyInfo.getName() + "_number"));
                        continue;
                    }
                    bREntryObj.put((Object)"property", (Object)propertyInfo.getName());
                }
            }
            allArray.add((Object)bREntryObj);
        }
        barcodeRuleObj.put((Object)"items", (Object)allArray);
        return barcodeRuleObj;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("isCumsumQty"));
        sic.add(new SelectorItemInfo("isBarcoeRepeat"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("CU.*"));
        } else {
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("CU.name"));
        }
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("details.id"));
        sic.add(new SelectorItemInfo("details.startsWith"));
        sic.add(new SelectorItemInfo("details.endsWith"));
        sic.add(new SelectorItemInfo("details.property"));
        sic.add(new SelectorItemInfo("details.format"));
        sic.add(new SelectorItemInfo("details.remark"));
        sic.add(new SelectorItemInfo("details.propertyBosType"));
        sic.add(new SelectorItemInfo("details.propertyAlias"));
        sic.add(new SelectorItemInfo("details.seq"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("details.*"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("details.barcodeDict.*"));
        } else {
            sic.add(new SelectorItemInfo("details.barcodeDict.id"));
            sic.add(new SelectorItemInfo("details.barcodeDict.name"));
            sic.add(new SelectorItemInfo("details.barcodeDict.number"));
        }
        sic.add(new SelectorItemInfo("details.isMatchItem"));
        sic.add(new SelectorItemInfo("details.segmentLocation"));
        sic.add(new SelectorItemInfo("entityAlias"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("barcodeType.*"));
        } else {
            sic.add(new SelectorItemInfo("barcodeType.id"));
            sic.add(new SelectorItemInfo("barcodeType.number"));
            sic.add(new SelectorItemInfo("barcodeType.name"));
        }
        sic.add(new SelectorItemInfo("pattern"));
        sic.add(new SelectorItemInfo("ruleSegment"));
        sic.add(new SelectorItemInfo("segmentNum"));
        sic.add(new SelectorItemInfo("length"));
        sic.add(new SelectorItemInfo("separators"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("barcodeType.*"));
        sic.add(new SelectorItemInfo("detailsXML"));
        return sic;
    }
}

