/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.barcode.pda.app.BarcodeMainFacadeHepler;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.ObjectTypeEnum;
import com.kingdee.eas.barcode.scm.PriorityEnum;
import com.kingdee.eas.barcode.scm.ScanTaskBillInfo;
import com.kingdee.eas.barcode.scm.util.TaskScanHepler;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class SyncCreateNewTaskExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncCreateNewTaskExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            revlist = this.createTask(ctx, params);
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private Object createTask(Context ctx, BarcodeMainParam params) throws BOSException, EASBizException {
        IObjectValue objectValue;
        StringBuilder sb = new StringBuilder();
        LinkedHashMap revTask = new LinkedHashMap();
        String menuId = (String)params.getParams().get("menuid");
        String srcNum = (String)params.getParams().get("source_num");
        ScanTaskBillInfo info = new ScanTaskBillInfo();
        info.setNumber("");
        info.setTaskName("");
        info.setBizDate(new Date());
        info.setPriority(PriorityEnum.middle);
        BarcodeConfigInfo configInfo = BarcodeMainFacadeHepler.getBarcodeConfigByMenuId(ctx, menuId);
        info.setDestBosType(configInfo.getDestBosType());
        info.setSrcBosType(configInfo.getSrcBosType());
        info.setBarcodeConfig(configInfo);
        String botMappingId = configInfo.getBotMapping() != null ? configInfo.getBotMapping().getId().toString() : null;
        info.setBotpId(botMappingId);
        info.setObjectNumber(srcNum);
        info.setTaskObject(ObjectTypeEnum.person);
        info.setTaskOperator(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        EntityObjectInfo entryObj = BarcodeMainFacadeHepler.getSelectEntity(ctx, configInfo.getSrcBosType(), configInfo.getDestBosType());
        CoreBaseInfo bill = this.getSourceBill(ctx, entryObj, srcNum);
        if (bill != null && (objectValue = TaskScanHepler.getTargetTempBillByBOTP(ctx, bill.getId().toString(), configInfo.getSrcBosType(), configInfo.getDestBosType(), botMappingId)) != null) {
            Enumeration keys = objectValue.keys();
            Object tempKey = null;
            Object tempVal = null;
            while (keys.hasMoreElements()) {
                tempKey = keys.nextElement();
                if (tempKey == null || !(tempKey instanceof String) || !((tempVal = objectValue.get((String)tempKey)) instanceof TransactionTypeInfo)) continue;
                TransactionTypeInfo transTypeInfo = (TransactionTypeInfo)tempVal;
                info.setTransactionType(transTypeInfo);
            }
        }
        return null;
    }

    protected CoreBaseInfo getSourceBill(Context ctx, EntityObjectInfo entryObj, String srcNum) throws BOSException {
        return BarcodeMainFacadeHepler.getEntryObjectByNum(ctx, entryObj, srcNum);
    }
}

