/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncDossierExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncDossierExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            revlist = this.getDossier(ctx, params);
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private Object getDossier(Context ctx, BarcodeMainParam params) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("material.number");
        sic.add("material.name");
        sic.add("faCurCard.number");
        sic.add("faCurCard.assetName");
        sic.add("model");
        sic.add("qty");
        sic.add("assistQty");
        sic.add("qrcode");
        sic.add("batchNumber");
        sic.add("measure");
        sic.add("remate");
        sic.add("barRule.ruleNumber");
        sic.add("template.codemd5");
        sic.add("useType");
        sic.add("entrys.seq");
        sic.add("entrys.name");
        sic.add("entrys.value");
        sic.add("entrys.displayName.name");
        view.setSelector(sic);
        String rows = (String)params.getParams().get("rows");
        String lastupdatetime = (String)params.getParams().get("lastupdatetime");
        String minnumber = (String)params.getParams().get("number");
        if (!StringUtils.isEmpty((String)lastupdatetime)) {
            filter.getFilterItems().add(new FilterItemInfo("lastupdatetime", (Object)UWDateHelper.tryParseDateStr(lastupdatetime), CompareType.GREATER));
        }
        if (!StringUtils.isEmpty((String)minnumber)) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)minnumber, CompareType.GREATER));
        }
        view.setTopCount(rows == null ? 49 : Integer.valueOf(rows));
        view.getSorter().add(new SorterItemInfo("number"));
        BarcodeDossierCollection coll = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
        BarcodeDossierInfo info = null;
        ArrayList allDos = new ArrayList();
        BarcodeDossierEntryCollection entrys = null;
        BarcodeDossierEntryInfo entry = null;
        String maxNum = null;
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            info = coll.get(i);
            HashMap<String, Object> indRow = new HashMap<String, Object>();
            maxNum = info.getNumber();
            indRow.put("number", info.getNumber());
            if (info.getFaCurCard() != null) {
                indRow.put("material", info.getFaCurCard().getNumber());
                indRow.put("material_name", info.getFaCurCard().getAssetName());
            } else if (info.getMaterial() != null) {
                indRow.put("material", info.getMaterial().getNumber());
                indRow.put("material_name", info.getMaterial().getName());
            }
            indRow.put("model", info.getModel());
            indRow.put("batch_number", info.getBatchNumber());
            indRow.put("measure", info.getMeasure());
            indRow.put("qty", info.getQty());
            indRow.put("assist_qty", info.getAssistQty());
            indRow.put("remate", info.getRemate());
            if (info.getTemplate() != null) {
                indRow.put("template", info.getTemplate().getCodemd5());
            }
            indRow.put("barcodemaster", info.getBarRule().getRuleNumber());
            indRow.put("qrode", info.getQrcode());
            indRow.put("useType", (Object)info.getUseType());
            ArrayList<Map> items = new ArrayList<Map>();
            entrys = info.getEntrys();
            int entrysize = entrys.size();
            for (int j = 0; j < entrysize; ++j) {
                entry = entrys.get(j);
                items.add(this.createDossierRow(entry));
            }
            indRow.put("items", items);
            allDos.add(indRow);
        }
        HashMap<String, Object> revMap = new HashMap<String, Object>();
        revMap.put("_maxnum", maxNum);
        revMap.put("_info", allDos);
        return revMap;
    }

    private Map createDossierRow(BarcodeDossierEntryInfo entry) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("index", entry.getSeq());
        row.put("name", entry.getName());
        row.put("value", entry.getValue());
        row.put("display_name_id", entry.getDisplayName().getName());
        return row;
    }
}

