/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.FtpConfigFactory;
import com.kingdee.eas.base.attachment.FtpConfigInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.enterprisedt.net.ftp.KDFileTransferClient;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class SyncDownEasDbExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncDownEasDbExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        rv.setLastupdatetime(newReqTime);
        try {
            byte[] datas = this._downData(ctx, params);
            Base64 base64 = new Base64();
            String info = new String(base64.encode(datas), "UTF-8");
            rv.setInfo(info);
            rv.setDefSucc();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            rv.setCode("-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            rv.setCode("-1");
        }
        catch (IOException e) {
            e.printStackTrace();
            rv.setCode("-1");
        }
        return rv;
    }

    protected byte[] _downData(Context ctx, BarcodeMainParam params) throws BOSException, IOException {
        OrgUnitInfo orgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
        if (orgUnit == null) {
            orgUnit = ContextUtil.getCurrentUserInfo((Context)ctx).getDefOrgUnit();
            try {
                OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).orgSwitch(orgUnit.getId().toString());
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
        }
        String sql = "select fid from CT_SCM_SynDataBase where CFCompanyID = '" + orgUnit.getId().toString() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String billId = null;
        try {
            if (rowSet != null && rowSet.next()) {
                billId = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (billId == null) {
            throw new BOSException("\u5f53\u524d\u7ec4\u7ec7\u6ca1\u7ef4\u62a4\u57fa\u7840\u6570\u636e\u540c\u6b65\u5355\u636e!");
        }
        sql = "select FAttachmentID from T_BAS_BoAttchAsso where FBoID = '" + billId + "'";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
        String attachmentID = null;
        try {
            if (rowSet != null && rowSet.next()) {
                attachmentID = rowSet.getString("FAttachmentID");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (attachmentID == null) {
            throw new BOSException("\u5f53\u524d\u7ec4\u7ec7\u6ca1\u7ef4\u62a4\u79bb\u7ebf\u6570\u636e\u5e93!");
        }
        try {
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            String param = ipc.getParamValue(null, "ATTACHMENTSTORAGE");
            AttachmentInfo attachmentInfo = iAttachment.getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachmentID));
            String remotePath = attachmentInfo.getRemotePath();
            if (attachmentInfo.getFtp() != null && !StringUtils.isEmpty((String)param) && "1".equals(param)) {
                FtpConfigInfo ftpConfigInfo = FtpConfigFactory.getLocalInstance((Context)ctx).getFtpConfigInfo((IObjectPK)new ObjectUuidPK(attachmentInfo.getFtp().getId()));
                String rootPath = ftpConfigInfo.getRootPath();
                return this.toByteArray(ftpConfigInfo, remotePath);
            }
            return attachmentInfo.getFile();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] toByteArray(FtpConfigInfo ftpConfigInfo, String remotePath) throws BOSException {
        KDFileTransferClient fileTransferClient = new KDFileTransferClient();
        try {
            fileTransferClient.setRemoteHost(ftpConfigInfo.getHost());
            fileTransferClient.setRemotePort(ftpConfigInfo.getPort());
            fileTransferClient.setUserName(ftpConfigInfo.getUserName());
            fileTransferClient.setPassword(CryptoTean.decrypt((String)ftpConfigInfo.getUserName(), (String)ftpConfigInfo.getPassword()));
            fileTransferClient.connect();
            System.out.println(remotePath);
            byte[] byArray = fileTransferClient.downloadByteArray(remotePath);
            return byArray;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u4e0b\u8f7d\u79bb\u7ebf\u5e93\u5931\u8d25\uff01");
        }
        finally {
            try {
                fileTransferClient.disconnect();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static byte[] toByteArray(String filename) throws IOException, BOSException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            long buf_size = file.length();
            if (buf_size > Integer.MAX_VALUE) {
                throw new BOSException("\u8bfb\u53d6\u7684\u6587\u4ef6\u8f83\u5927\uff01");
            }
            byte[] buffer = new byte[(int)buf_size];
            int len = 0;
            while (-1 != (len = in.read(buffer, 0, (int)buf_size))) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                bos.close();
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            in.close();
            bos.close();
        }
    }
}

