/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.ScanTaskBillFactory;
import com.kingdee.eas.barcode.scm.SynDataBaseCollection;
import com.kingdee.eas.barcode.scm.SynDataBaseFactory;
import com.kingdee.eas.barcode.scm.SynDataBaseInfo;
import com.kingdee.eas.barcode.scm.util.AttachmentServerManager;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class SyncOfflineDataExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncOfflineDataExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            revlist = this.getOfflineData(ctx, params);
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private Object getOfflineData(Context ctx, BarcodeMainParam params) throws BOSException, EASBizException {
        String orgid = params.getParams().get("orgid") != null ? params.getParams().get("orgid").toString() : null;
        this.initContext(ctx);
        ScanTaskBillFactory.getLocalInstance(ctx).exportData(null, null);
        EntityViewInfo view = null;
        FilterInfo filter0 = null;
        FilterInfo filter = null;
        view = new EntityViewInfo();
        filter0 = new FilterInfo();
        filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)orgid)) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgid));
            logger.info((Object)("getOfflineData by orgid\uff1a" + orgid));
        } else {
            CompanyOrgUnitInfo companyOrgUniInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            logger.info((Object)("getOfflineData by org:" + companyOrgUniInfo.getName()));
            if (companyOrgUniInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgUniInfo.getId()));
            }
        }
        if (filter != null && filter.getFilterItems().size() > 0) {
            SynDataBaseInfo synDateBaseinfo;
            view.setFilter(filter);
            SynDataBaseCollection synCol = SynDataBaseFactory.getLocalInstance(ctx).getSynDataBaseCollection(view);
            if (synCol.size() > 0 && (synDateBaseinfo = synCol.get(0)) != null && synDateBaseinfo.getId() != null) {
                String[] attachID = BoAttchAssoFactory.getLocalInstance((Context)ctx).getAttchIDsByBoID(synDateBaseinfo.getId().toString());
                StringBuffer str = new StringBuffer();
                int size = attachID.length;
                for (int i = 0; i < size; ++i) {
                    if (str.length() > 0) {
                        str.append(",").append(attachID[i]);
                        continue;
                    }
                    str.append(attachID[i]);
                }
                if (str.length() > 0) {
                    filter0.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INCLUDE));
                }
            }
        }
        if (filter0 != null && filter0.getFilterItems().size() <= 0) {
            filter0.getFilterItems().add(new FilterItemInfo("attachID", (Object)"synBaseData"));
        }
        view = new EntityViewInfo();
        view.setFilter(filter0);
        AttachmentCollection attaInfoCol = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentCollection(view);
        if (attaInfoCol.size() == 0) {
            return new byte[0];
        }
        AttachmentInfo attaInfo = attaInfoCol.get(0);
        try {
            AttachmentServerManager serverManager = new AttachmentServerManager(ctx);
            byte[] dataByte = serverManager.download(attaInfo.getId().toString());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(bos);
            gzip.write(dataByte);
            gzip.finish();
            gzip.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private void initContext(Context ctx) throws BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user.getDefOrgUnit() != null) {
            try {
                OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).orgSwitch(user.getDefOrgUnit().getId().toString());
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException("\u7528\u6237\u65e0\u7f3a\u7701\u7ec4\u7ec7");
            }
        }
    }
}

