/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SyncQueryIndHisExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncQueryIndHisExec.class.getName());
    private static final String materialReqBosType = "500AB75E";
    private static final String manufactureRecBill = "FA1292B4";
    private static final String preORnext_key = "preornext";

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        String barcode = (String)params.getParams().get("barcode");
        ArrayList<Map<String, Object>> barflowList = new ArrayList();
        try {
            barflowList = this.getBarFlowList(ctx, barcode);
            Set<String> materReqMfOdNumSet = this.getMaterialReqMfOdNum(barflowList);
            Set<String> manfacRecMfOdNumSet = this.getManufactureRecMfOdNum(barflowList);
            if (materReqMfOdNumSet.size() > 0) {
                List<Map<String, Object>> manufactRecBarCodeList = this.getBarFlowList(ctx, materReqMfOdNumSet.toArray(), manufactureRecBill);
                Map<String, Set<String>> nextBarCodeMap = this.getOdNumMapBarCodeByList(manufactRecBarCodeList);
                List<Map<String, Object>> nextBarFlowList = this.getBarFlowList(ctx, nextBarCodeMap.entrySet().toArray(), null);
                this.reflashList(barflowList, nextBarCodeMap, nextBarFlowList);
            }
            if (manfacRecMfOdNumSet.size() > 0) {
                List<Map<String, Object>> mtreqBarCodeList = this.getBarFlowList(ctx, manfacRecMfOdNumSet.toArray(), materialReqBosType);
                Map<String, Set<String>> preBarCodeMap = this.getOdNumMapBarCodeByList(mtreqBarCodeList);
                HashSet barcodeSet = new HashSet();
                for (Map.Entry<String, Set<String>> entry : preBarCodeMap.entrySet()) {
                    barcodeSet.addAll(entry.getValue());
                }
                List<Map<String, Object>> preBarFlowList = this.getBarFlowList(ctx, barcodeSet.toArray(), null);
                this.reflashList(barflowList, preBarCodeMap, preBarFlowList);
            }
            rv.setInfo(barflowList);
            rv.setDefSucc();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            rv.setInnerError(e1.getMessage());
            logger.warn((Object)e1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private List<Map<String, Object>> getBarFlowList(Context ctx, String barcode) throws BOSException, SQLException {
        return this.getBarFlowList(ctx, new String[]{barcode}, null);
    }

    private List<Map<String, Object>> getBarFlowList(Context ctx, Object[] paramArr, String bosType) throws BOSException, SQLException {
        String queryIndBackSql = this.getIndBackSql(paramArr.length, bosType);
        ArrayList<Map<String, Object>> barflowList = new ArrayList<Map<String, Object>>();
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)queryIndBackSql, (Object[])paramArr);
        while (rows.next()) {
            barflowList.add(this.createBarHisFlowRow(rows));
        }
        return barflowList;
    }

    private void reflashList(List<Map<String, Object>> mainList, Map<String, Set<String>> mfOdNumBarMap, List<Map<String, Object>> materReqMfList) {
        HashMap<String, ArrayList<Map<String, Object>>> barListMap = new HashMap<String, ArrayList<Map<String, Object>>>();
        String barcode = null;
        for (Map<String, Object> item : materReqMfList) {
            barcode = (String)item.get("barcode");
            ArrayList<Map<String, Object>> baritems = (ArrayList<Map<String, Object>>)barListMap.get(barcode);
            if (baritems == null) {
                baritems = new ArrayList<Map<String, Object>>();
            }
            baritems.add(item);
            barListMap.put(barcode, baritems);
        }
        HashMap mfodnum2ItemsMap = new HashMap();
        Iterator<String> it = mfOdNumBarMap.keySet().iterator();
        String mfodnum = null;
        Set<String> tempBarSet = null;
        while (it.hasNext()) {
            mfodnum = it.next();
            tempBarSet = mfOdNumBarMap.get(mfodnum);
            for (String tempBarCode : tempBarSet) {
                if (barListMap.get(tempBarCode) == null) continue;
                ArrayList list = (ArrayList)mfodnum2ItemsMap.get(mfodnum);
                if (list == null) {
                    list = new ArrayList();
                }
                list.addAll((Collection)barListMap.get(tempBarCode));
                mfodnum2ItemsMap.put(mfodnum, list);
            }
        }
        for (Map<String, Object> item : mainList) {
            mfodnum = (String)item.get("mfodnum");
            item.put(preORnext_key, mfodnum2ItemsMap.get(mfodnum));
        }
    }

    private Map<String, Set<String>> getOdNumMapBarCodeByList(List<Map<String, Object>> list) {
        HashMap<String, Set<String>> revMap = new HashMap<String, Set<String>>();
        String mfodnum = null;
        for (Map<String, Object> item : list) {
            mfodnum = (String)item.get("mfodnum");
            HashSet<String> set = (HashSet<String>)revMap.get(mfodnum);
            if (set == null) {
                set = new HashSet<String>();
            }
            set.add((String)item.get("barcode"));
            revMap.put(mfodnum, set);
        }
        return revMap;
    }

    private Map temp(Context ctx, Map map) {
        return null;
    }

    private String getIndBackSql(int size, String bosType) {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from t_barcode_barflow where  1=1 \n");
        String filed = "barcode";
        if (bosType != null) {
            filed = "mfodnum";
            sb.append(" and Fbostype='").append(bosType).append("' ");
        }
        if (size == 1) {
            sb.append(" and ").append(filed).append("  = ? ");
        } else {
            sb.append(" and  ").append(filed).append(" in ( ");
            for (int sign = 0; sign < size; ++sign) {
                sb.append("?,");
            }
            sb.setLength(sb.length() - 1);
            sb.append(" \n )\n");
        }
        sb.append(" and billType is not null  and qty is not null \n");
        sb.append(" order by bizdate asc \n");
        return sb.toString();
    }

    private Map<String, Object> createBarHisFlowRow(IRowSet rows) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("biztype", rows.getString("biztype"));
        row.put("billtype", rows.getString("billtype"));
        row.put("barcode", rows.getString("barcode"));
        row.put("billnum", rows.getString("billnum"));
        row.put("bizdate", UWDateHelper.FORMAT_TIME.format(rows.getDate("bizdate")));
        row.put("fromobj", rows.getString("fromobj"));
        row.put("toobj", rows.getString("toobj"));
        row.put("mfodnum", rows.getString("mfodnum"));
        row.put("bostype", rows.getString("fbostype"));
        row.put("qty", rows.getBigDecimal("qty").setScale(2, 5));
        return row;
    }

    private Set<String> getMaterialReqMfOdNum(List<Map<String, Object>> barflowList) {
        HashSet<String> revSet = new HashSet<String>();
        for (Map<String, Object> row : barflowList) {
            if (!materialReqBosType.equals(row.get("bostype")) || StringUtils.isEmpty((String)((String)row.get("mfodnum")))) continue;
            revSet.add((String)row.get("mfodnum"));
        }
        return revSet;
    }

    private Set<String> getManufactureRecMfOdNum(List<Map<String, Object>> barflowList) {
        HashSet<String> revSet = new HashSet<String>();
        for (Map<String, Object> row : barflowList) {
            if (!manufactureRecBill.equals(row.get("bostype")) || StringUtils.isEmpty((String)((String)row.get("mfodnum")))) continue;
            revSet.add((String)row.get("mfodnum"));
        }
        return revSet;
    }
}

