/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncQueryInvByMaterialExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncQueryInvByMaterialExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            revlist = this.getInventoryData(ctx, params);
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private Object getInventoryData(Context ctx, BarcodeMainParam params) throws BOSException, SQLException, EASBizException {
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "InventoryQuery");
        EntityViewInfo viewInfo = this.createInventoryFilter(ctx, params);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 100;
        exec.option().isIgnoreRowCount = true;
        exec.option().pageCount = 50;
        exec.option().isIgnorePermissionCheck = true;
        IRowSet rowSet = exec.executeQuery();
        ArrayList<Map<String, Object>> barflowList = new ArrayList<Map<String, Object>>();
        while (rowSet.next()) {
            barflowList.add(this.createInventoryRow(rowSet));
        }
        return barflowList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EntityViewInfo createInventoryFilter(Context ctx, BarcodeMainParam params) throws BOSException, EASBizException {
        StorageOrgUnitInfo sounit;
        String sounum;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (params.getParams().containsKey("_querytype") && !BarcodeUtils.isObjectEmpty(params.getParams().get("_querytype")).booleanValue() && 1 == (Integer)params.getParams().get("_querytype")) {
            String barcode = (String)params.getParams().get("_barcode");
            if (StringUtils.isEmpty((String)barcode)) throw new BOSException("\u6761\u7801\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
            BarcodeDossierCollection barcodeDossierColl = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(" where number='" + barcode + "'");
            if (barcodeDossierColl.size() > 0) {
                BarcodeDossierInfo barcodeDossierInfo = barcodeDossierColl.get(0);
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)barcodeDossierInfo.getMaterial().getId(), CompareType.EQUALS));
            }
        } else {
            if (params.getParams().containsKey("_materialnum") && !BarcodeUtils.isObjectEmpty(params.getParams().get("_materialnum")).booleanValue()) {
                filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)("%" + (String)params.getParams().get("_materialnum") + "%"), CompareType.LIKE));
            }
            if (params.getParams().containsKey("_warehouse") && !BarcodeUtils.isObjectEmpty(params.getParams().get("_warehouse")).booleanValue()) {
                filter.getFilterItems().add(new FilterItemInfo("warehouse.number", (Object)((String)params.getParams().get("_warehouse")), CompareType.EQUALS));
            }
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)"----------------", CompareType.EQUALS));
        }
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)(sounum = "")) && null != (sounit = ContextUtil.getCurrentStorageUnit((Context)ctx))) {
            sounum = sounit.getNumber();
        }
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)sounum)) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)sounum, CompareType.EQUALS));
        }
        view.setFilter(filter);
        return view;
    }

    private Map<String, Object> createInventoryRow(IRowSet rows) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("project", rows.getString("project.number"));
        row.put("trackNumber", rows.getString("trackNumber.number"));
        row.put("inventoryunit", rows.getString("inventoryUnit.name"));
        row.put("number", rows.getString("material.number"));
        row.put("name", rows.getString("material.name"));
        row.put("warehouse", rows.getString("warehouse.name"));
        row.put("location", rows.getString("location.name"));
        row.put("model", rows.getString("material.model"));
        row.put("lot", rows.getString("lot"));
        row.put("qty", rows.getBigDecimal("curMatStoreQty").setScale(4, 5));
        if (rows.getBigDecimal("lockQty") != null) {
            row.put("lockqty", rows.getBigDecimal("lockQty").setScale(4, 5));
        }
        row.put("curstoreqty", rows.getBigDecimal("curStoreQty").setScale(4, 5));
        if (rows.getDate("DateOfMinDurability.mfg") != null) {
            row.put("mfg", UWDateHelper.FORMAT_DAY.format(rows.getDate("DateOfMinDurability.mfg")));
        } else {
            row.put("mfg", null);
        }
        if (rows.getDate("DateOfMinDurability.exp") != null) {
            row.put("exp", UWDateHelper.FORMAT_DAY.format(rows.getDate("DateOfMinDurability.exp")));
        } else {
            row.put("exp", null);
        }
        row.put("assist", rows.getString("assistProperty.name"));
        return row;
    }
}

