/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncQueryInventoryExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncQueryInventoryExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            revlist = this.getInventoryData(ctx, params);
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private Object getInventoryData(Context ctx, BarcodeMainParam params) throws BOSException, SQLException {
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "InventoryQuery");
        EntityViewInfo viewInfo = this.createInventoryFilter(ctx, params);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 100;
        exec.option().isIgnoreRowCount = true;
        exec.option().pageCount = 50;
        exec.option().isIgnorePermissionCheck = true;
        IRowSet rowSet = exec.executeQuery();
        ArrayList<Map<String, Object>> barflowList = new ArrayList<Map<String, Object>>();
        while (rowSet.next()) {
            barflowList.add(this.createInventoryRow(rowSet));
        }
        return barflowList;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance(null, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 100;
        exec.option().isIgnoreRowCount = true;
        exec.option().pageCount = 50;
        return exec;
    }

    private EntityViewInfo createInventoryFilter(Context ctx, BarcodeMainParam params) throws BOSException {
        if (!params.getParams().containsKey("warehouse") && !params.getParams().containsKey("material.number")) {
            String barcode = (String)params.getParams().get("barcode");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)barcode));
            view.setTopCount(1);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("entrys.*");
            sic.add("entrys.displayName.id");
            sic.add("entrys.displayName.name");
            sic.add("barRule.Entry.*");
            sic.add(new SelectorItemInfo("template.entrys.name"));
            sic.add(new SelectorItemInfo("template.entrys.value"));
            sic.add(new SelectorItemInfo("template.entrys.displayName.id"));
            sic.add(new SelectorItemInfo("template.entrys.displayName.name"));
            view.setSelector(sic);
            BarcodeDossierCollection coll = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
            BarcodeDossierInfo info = coll.get(0);
            view.getFilter().getFilterItems().clear();
            view.getSelector().clear();
            this.createFilerByBarcodeDossier(ctx, info, view);
            return view;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String warehousenum = (String)params.getParams().get("warehouse");
        String materialnum = (String)params.getParams().get("material.number");
        if (!StringUtils.isEmpty((String)warehousenum)) {
            filter.getFilterItems().add(new FilterItemInfo("warehouse.number", (Object)warehousenum, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)materialnum)) {
            filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialnum, CompareType.EQUALS));
        }
        return view;
    }

    private void createFilerByBarcodeDossier(Context ctx, BarcodeDossierInfo info, EntityViewInfo view) {
        BarcodeDossierEntryCollection coll = info.getEntrysByTemplate();
        BarcodeDossierEntryInfo entry = null;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            entry = (BarcodeDossierEntryInfo)it.next();
            if (StringUtils.isEmpty((String)entry.getValue())) continue;
            if ("\u4ed3\u5e93".equalsIgnoreCase(entry.getDisplayName().getName()) || "\u4ed3\u5e93\u7f16\u7801".equalsIgnoreCase(entry.getDisplayName().getName())) {
                view.getFilter().getFilterItems().add(new FilterItemInfo("warehouse.number", (Object)entry.getValue(), CompareType.EQUALS));
                break;
            }
            if (!"\u4ed3\u5e93\u540d\u79f0".equalsIgnoreCase(entry.getDisplayName().getName())) continue;
            view.getFilter().getFilterItems().add(new FilterItemInfo("warehouse.name", (Object)entry.getValue(), CompareType.EQUALS));
            break;
        }
        if (info.getMaterial() != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getMaterial().getId().toString(), CompareType.EQUALS));
        }
    }

    private Map<String, Object> createInventoryRow(IRowSet rows) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("name", rows.getString("material.name"));
        row.put("number", rows.getString("material.number"));
        row.put("model", rows.getString("material.model"));
        row.put("org", rows.getString("storageOrgUnit.name"));
        row.put("inventoryunit", rows.getString("inventoryUnit.name"));
        row.put("lot", rows.getString("lot"));
        row.put("curstoreqty", rows.getBigDecimal("curStoreQty").setScale(4, 5));
        if (rows.getBigDecimal("curMatStoreQty") != null) {
            row.put("curmatstoreqty", rows.getBigDecimal("curMatStoreQty").setScale(4, 5));
        }
        if (rows.getBigDecimal("lockQty") != null) {
            row.put("lockqty", rows.getBigDecimal("lockQty").setScale(4, 5));
        }
        row.put("warehouse", rows.getString("warehouse.name"));
        row.put("location", rows.getString("location.name"));
        if (rows.getDate("DateOfMinDurability.mfg") != null) {
            row.put("mfg", UWDateHelper.FORMAT_DAY.format(rows.getDate("DateOfMinDurability.mfg")));
        }
        if (rows.getDate("DateOfMinDurability.exp") != null) {
            row.put("exp", UWDateHelper.FORMAT_DAY.format(rows.getDate("DateOfMinDurability.exp")));
        }
        return row;
    }
}

