/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.ScanTaskBillFactory;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SyncScanTaskBillExec
implements SyncExec {
    private String resourceBaseStr = "com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource";

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        rv.setLastupdatetime(newReqTime);
        try {
            rv.setDefSucc();
            rv.setInfo(this.getScanTaskBillCol(ctx, params));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        return rv;
    }

    private JSONArray getScanTaskBillCol(Context ctx, BarcodeMainParam params) throws BOSException, SQLException, EASBizException {
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.barcode.scm.app", "ScanTaskBillQuery");
        EntityViewInfo viewInfo = this.createScanTasFilter(ctx, params);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 100;
        exec.option().isIgnoreRowCount = true;
        exec.option().pageCount = 50;
        exec.option().isIgnorePermissionCheck = true;
        IRowSet rowSet = exec.executeQuery();
        Map<String, Map<String, BarcodePDAViewConfigEntryInfo>> barcodepdaEntryInfoMap = null;
        HashMap<String, String> defalutConfigMap = null;
        if (rowSet.size() > 0) {
            defalutConfigMap = new HashMap<String, String>();
            barcodepdaEntryInfoMap = this.getBarcodePdaConfigMap(ctx, defalutConfigMap);
        }
        JSONArray allArray = new JSONArray();
        StringBuffer scanBillIdStr = new StringBuffer();
        while (rowSet.next()) {
            JSONObject taskBillObj = this.scanTaskBillRow(ctx, rowSet, barcodepdaEntryInfoMap);
            if (taskBillObj == null) continue;
            if (defalutConfigMap != null) {
                String configId = rowSet.getString("barcodeConfig.id").toString();
                taskBillObj.put((Object)"defaultSolution", defalutConfigMap.get(configId));
            }
            allArray.add((Object)taskBillObj);
            if (scanBillIdStr.length() > 0) {
                scanBillIdStr.append("','").append(rowSet.getString("id"));
                continue;
            }
            scanBillIdStr.append(rowSet.getString("id"));
        }
        if (scanBillIdStr.length() > 0) {
            String updateSql = "update CT_SCM_ScanTaskBill set CFSchedule='2' where fid in('" + scanBillIdStr.toString() + "')";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        return allArray;
    }

    private EntityViewInfo createScanTasFilter(Context ctx, BarcodeMainParam params) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("schedule", (Object)"4", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)"4", CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private JSONObject scanTaskBillRow(Context ctx, IRowSet rows, Map<String, Map<String, BarcodePDAViewConfigEntryInfo>> barcodepdaEntryInfoMap) throws SQLException, EASBizException, BOSException {
        JSONObject taskBillObj = new JSONObject();
        taskBillObj.put((Object)"billid", (Object)rows.getString("id"));
        taskBillObj.put((Object)"srcBosType", (Object)rows.getString("srcBosType"));
        taskBillObj.put((Object)"destBosType", (Object)rows.getString("destBosType"));
        taskBillObj.put((Object)"botpId", (Object)rows.getString("botpId"));
        taskBillObj.put((Object)"barcodeConfigId", (Object)rows.getString("barcodeConfig.id"));
        taskBillObj.put((Object)"billtype", (Object)rows.getString("billtype"));
        taskBillObj.put((Object)"billtypeid", (Object)rows.getString("destBosType"));
        taskBillObj.put((Object)"biztype", (Object)"");
        taskBillObj.put((Object)"bizdate", (Object)(rows.getDate("bizDate") + ""));
        taskBillObj.put((Object)"biz_orgid", (Object)rows.getString("orgUnit.id"));
        taskBillObj.put((Object)"biz_org", (Object)rows.getString("orgUnit.name"));
        taskBillObj.put((Object)"number", (Object)rows.getString("number"));
        taskBillObj.put((Object)"exectype", (Object)(rows.getString("taskObject").equals("0") ? "department" : "person"));
        if (rows.getString("taskObject").equals("\u804c\u5458") && rows.getString("taskOperator") != null) {
            PersonInfo personinfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(rows.getString("taskOperator")));
            taskBillObj.put((Object)"taskOperator", (Object)personinfo.getName());
        }
        if (rows.getString("taskObject").equals("\u7ec4\u7ec7\u673a\u6784") && rows.getString("taskOperator") != null) {
            AdminOrgUnitInfo orgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(rows.getString("taskOperator")));
            taskBillObj.put((Object)"execdepart", (Object)orgUnitInfo.getName());
        }
        taskBillObj.put((Object)"vldto", (Object)rows.getString("vldto"));
        taskBillObj.put((Object)"level", (Object)rows.getString("priority"));
        taskBillObj.put((Object)"execprocess", (Object)rows.getString("schedule"));
        taskBillObj.put((Object)"issplit", (Object)rows.getBoolean("issplit"));
        taskBillObj.put((Object)"remark", (Object)rows.getString("remark"));
        String configId = rows.getString("barcodeConfig.id").toString();
        Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap = barcodepdaEntryInfoMap.get(configId);
        BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(configId));
        BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(configInfo.getDetailsXML());
        String id = rows.getString("id");
        Object o = ScanTaskBillFactory.getLocalInstance(ctx).getRecodesList(id, configXml);
        if (o != null) {
            List recodesList = (List)o;
            if (recodesList.size() > 0) {
                BarcodeScanningRecodeInfo scaningRecodeInfo = (BarcodeScanningRecodeInfo)recodesList.get(0);
                JSONObject billObject = this.loadScanRecods(ctx, scaningRecodeInfo, null, rows.getString("destBosType"), null, false, null, barcodeEntryInfoMap);
                taskBillObj.put((Object)"_bill", (Object)billObject);
            } else {
                return null;
            }
        }
        return taskBillObj;
    }

    protected JSONObject loadScanRecods(Context ctx, BarcodeScanningRecodeInfo recodeInfo, String entryName, String bosType, JSONObject billObj, boolean isItemPro, JSONObject rowsObj, Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap) {
        Map<String, List<BarcodeScanningRecodeInfo>> entryMap;
        if (billObj == null) {
            billObj = new JSONObject();
        }
        JSONArray rowsArray = null;
        JSONObject itemProObj = null;
        JSONObject spcObj = null;
        if (recodeInfo == null || recodeInfo.getProperties() == null) {
            return null;
        }
        Iterator<String> it = recodeInfo.getProperties().keySet().iterator();
        if (isItemPro) {
            itemProObj = new JSONObject();
            spcObj = new JSONObject();
        }
        while (it.hasNext()) {
            String temp = it.next();
            BarcodeScanningPropertyInfo property = recodeInfo.getProperties().get(temp);
            if (property.getKey().equals("id")) continue;
            BarcodeConfigXMLProperty xmlProperty = null;
            xmlProperty = property.getBcxmlProperty() == null ? new BarcodeConfigXMLProperty() : property.getBcxmlProperty();
            Object value = property.getValue();
            if (value == null || "".equals(value)) {
                value = "";
            }
            if (value instanceof BigDecimal) {
                if (value == null || "".equals(value) || BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
                    value = BigDecimal.ZERO;
                }
                BigDecimal qty = (BigDecimal)value;
                value = new BigDecimal(qty.stripTrailingZeros().toPlainString());
            }
            if (entryName != null) {
                rowsObj.put((Object)property.getKey(), value);
                if (!isItemPro) continue;
                itemProObj.put((Object)property.getKey(), (Object)this.getJsonStr(ctx, property.getKey(), property.getValue(), xmlProperty, false, true, barcodeEntryInfoMap));
                String spc = this.getSpc(property.getKey(), xmlProperty, barcodeEntryInfoMap);
                if (spc == null || "".equals(spc)) continue;
                spcObj.put((Object)spc, (Object)property.getKey());
                continue;
            }
            billObj.put((Object)property.getKey(), (Object)this.getJsonStr(ctx, property.getKey(), property.getValue(), xmlProperty, true, true, barcodeEntryInfoMap));
        }
        if (entryName != null && isItemPro) {
            billObj.put((Object)"_itemproperties", (Object)itemProObj);
            billObj.put((Object)"_itemspekey", (Object)spcObj);
            billObj.put((Object)"_entryName", (Object)this.getJsonStr(ctx, "_entryName", entryName + "_" + recodeInfo.getFbosType(), null, true, true, barcodeEntryInfoMap));
        }
        if ((entryMap = recodeInfo.getEntriesMap()) != null && entryMap.size() > 0) {
            Object[] keys = entryMap.keySet().toArray();
            String key = keys[0].toString();
            List<BarcodeScanningRecodeInfo> childRecodsList = entryMap.get(key);
            rowsArray = new JSONArray();
            int size = childRecodsList.size();
            for (int i = 0; i < size; ++i) {
                rowsObj = new JSONObject();
                if (i == 0) {
                    this.loadScanRecods(ctx, childRecodsList.get(i), key, bosType, billObj, true, rowsObj, barcodeEntryInfoMap);
                } else {
                    this.loadScanRecods(ctx, childRecodsList.get(i), key, bosType, billObj, false, rowsObj, barcodeEntryInfoMap);
                }
                rowsArray.add((Object)rowsObj);
            }
            if (rowsArray.size() > 0) {
                billObj.put((Object)"rows", (Object)rowsArray);
            }
        }
        return billObj;
    }

    private JSONObject getJsonStr(Context ctx, String propertyName, Object value, BarcodeConfigXMLProperty xmlProperty, boolean isShowVal, boolean isLimit, Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap) {
        if (value == null) {
            value = "";
        }
        JSONObject jsonObj = new JSONObject();
        if (isShowVal) {
            if (value != null && !"".equals(value)) {
                jsonObj.put((Object)"val", (Object)value.toString());
            } else {
                jsonObj.put((Object)"val", (Object)"");
            }
        }
        if (xmlProperty != null && xmlProperty.getAlias() == null) {
            xmlProperty.setAlias(propertyName);
        }
        if (isLimit && xmlProperty != null) {
            StringBuffer limitStr = new StringBuffer();
            String key = propertyName;
            if (!xmlProperty.isLinkedProperty()) {
                key = xmlProperty.getFullName();
            }
            if (key != null && barcodeEntryInfoMap != null && barcodeEntryInfoMap != null && barcodeEntryInfoMap.containsKey(key)) {
                BarcodePDAViewConfigEntryInfo configEntryInfo = barcodeEntryInfoMap.get(key);
                limitStr.append(configEntryInfo.isIsView() ? "1" : "0");
                limitStr.append(configEntryInfo.isIsEdit() ? "1" : "0");
                limitStr.append("0");
                limitStr.append("0");
                limitStr.append(xmlProperty.isScanQty() ? "1" : "0");
                jsonObj.put((Object)"alias", (Object)configEntryInfo.getPdaTitle());
            } else {
                if ("fsrcQty".equals(propertyName) || "fdifQty".equals(propertyName)) {
                    limitStr.append("1");
                    String srcQtyStr = this.getMassege(ctx, this.resourceBaseStr, "146_BarcodeScanningEditUI");
                    String difQtyStr = this.getMassege(ctx, this.resourceBaseStr, "148_BarcodeScanningEditUI");
                    if ("fsrcQty".equals(propertyName)) {
                        xmlProperty.setAlias(srcQtyStr);
                    }
                    if ("fdifQty".equals(propertyName)) {
                        xmlProperty.setAlias(difQtyStr);
                    }
                } else {
                    limitStr.append("0");
                }
                limitStr.append("0");
                limitStr.append("0");
                limitStr.append("0");
                limitStr.append(xmlProperty.isScanQty() ? "1" : "0");
                jsonObj.put((Object)"alias", (Object)(xmlProperty != null ? xmlProperty.getAlias() : ""));
            }
            jsonObj.put((Object)"limit", (Object)limitStr.toString());
        }
        return jsonObj;
    }

    private String getSpc(String propertyName, BarcodeConfigXMLProperty xmlPro, Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap) {
        String spacialCol = "";
        if (xmlPro.isScanQty()) {
            spacialCol = "qty";
            return spacialCol;
        }
        String proBosType = xmlPro.getLinkedBosType();
        if (proBosType == null) {
            return null;
        }
        EntityObjectInfo eoi = BarcodeUtils.getEntityByBosType(proBosType);
        if ("com.kingdee.eas.basedata.scm.common.app.BizType".equals(eoi.getFullName())) {
            spacialCol = "bizType";
        } else if ("com.kingdee.eas.basedata.master.cssp.app.Supplier".equals(eoi.getFullName())) {
            spacialCol = "supplier";
        } else if ("com.kingdee.eas.basedata.scm.im.inv.app.Warehouse".equals(eoi.getFullName())) {
            spacialCol = "warehouse";
        } else if ("com.kingdee.eas.basedata.scm.im.inv.app.Location".equals(eoi.getFullName())) {
            spacialCol = "location";
        } else if ("com.kingdee.eas.basedata.master.material.app.Material".equals(eoi.getFullName())) {
            spacialCol = "mtnum";
        } else if ("com.kingdee.eas.basedata.master.material.app.AsstAttrValue".equals(eoi.getFullName())) {
            spacialCol = "Assist";
        } else if ("com.kingdee.eas.basedata.scm.common.app.TransactionType".equals(eoi.getFullName())) {
            spacialCol = "transcationType";
        } else if ("com.kingdee.eas.basedata.master.cssp.app.Customer".equals(eoi.getFullName())) {
            spacialCol = "customer";
        } else if ("com.kingdee.eas.basedata.org.app.StorageOrgUnit".equals(eoi.getFullName())) {
            spacialCol = "storageOrgUnit";
        } else if ("com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(eoi.getFullName())) {
            if ("useDept".equals(xmlPro.getName())) {
                spacialCol = "useDept";
            }
            if ("adminDept".equals(xmlPro.getName())) {
                spacialCol = "adminDept";
            }
        }
        if ((spacialCol == null || "".equals(spacialCol)) && barcodeEntryInfoMap != null && barcodeEntryInfoMap.containsKey(propertyName)) {
            BarcodePDAViewConfigEntryInfo configEntryInfo = barcodeEntryInfoMap.get(propertyName);
            spacialCol = configEntryInfo.getSpecialColStr();
            return spacialCol;
        }
        return spacialCol;
    }

    private Map<String, Map<String, BarcodePDAViewConfigEntryInfo>> getBarcodePdaConfigMap(Context ctx, Map<String, String> defalutConfigMap) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectors());
        BarcodePDAViewConfigCollection barcodePdaCol = BarcodePDAViewConfigFactory.getLocalInstance(ctx).getBarcodePDAViewConfigCollection(view);
        LinkedHashMap<String, Map<String, BarcodePDAViewConfigEntryInfo>> barcodepdaConfigMap = new LinkedHashMap<String, Map<String, BarcodePDAViewConfigEntryInfo>>();
        int size = barcodePdaCol.size();
        for (int i = 0; i < size; ++i) {
            BarcodePDAViewConfigInfo barcodePdaInfo = barcodePdaCol.get(i);
            String scanConfigId = barcodePdaInfo.getScanConfig().getId().toString();
            BarcodePDAViewConfigEntryCollection barcodePDAViewCol = barcodePdaInfo.getEntitys();
            LinkedHashMap<String, BarcodePDAViewConfigEntryInfo> configEntryMap = new LinkedHashMap<String, BarcodePDAViewConfigEntryInfo>();
            int m = barcodePDAViewCol.size();
            for (int j = 0; j < m; ++j) {
                BarcodePDAViewConfigEntryInfo configEntryInfo = barcodePDAViewCol.get(j);
                configEntryMap.put(configEntryInfo.getColumnCode(), configEntryInfo);
            }
            if (barcodePdaInfo.getDefualtSolution() != null) {
                defalutConfigMap.put(scanConfigId, barcodePdaInfo.getDefualtSolution().getId().toString());
            }
            barcodepdaConfigMap.put(scanConfigId, configEntryMap);
        }
        return barcodepdaConfigMap;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("entitys.*"));
        sic.add(new SelectorItemInfo("entitys.name"));
        sic.add(new SelectorItemInfo("entitys.pdaTitle"));
        sic.add(new SelectorItemInfo("entitys.consleType"));
        sic.add(new SelectorItemInfo("entitys.columnType"));
        sic.add(new SelectorItemInfo("entitys.scanSeq"));
        sic.add(new SelectorItemInfo("entitys.columnCode"));
        sic.add(new SelectorItemInfo("entitys.isView"));
        sic.add(new SelectorItemInfo("entitys.entryType"));
        sic.add(new SelectorItemInfo("entitys.proEventStr"));
        sic.add(new SelectorItemInfo("entitys.isEdit"));
        sic.add(new SelectorItemInfo("entitys.bosTypeStr"));
        sic.add(new SelectorItemInfo("entitys.parentBosTypeStr"));
        sic.add(new SelectorItemInfo("entitys.entryName"));
        sic.add(new SelectorItemInfo("entitys.specialColStr"));
        sic.add(new SelectorItemInfo("entitys.isListView"));
        sic.add(new SelectorItemInfo("entitys.tableName"));
        sic.add(new SelectorItemInfo("entitys.filedName"));
        sic.add(new SelectorItemInfo("entitys.LinkTableName"));
        sic.add(new SelectorItemInfo("entitys.fullName"));
        sic.add(new SelectorItemInfo("entitys.isSetDefault"));
        sic.add(new SelectorItemInfo("tableName"));
        sic.add(new SelectorItemInfo("offline"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("scanConfig.*"));
        } else {
            sic.add(new SelectorItemInfo("scanConfig.id"));
            sic.add(new SelectorItemInfo("scanConfig.number"));
            sic.add(new SelectorItemInfo("scanConfig.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("defualtSolution.*"));
        } else {
            sic.add(new SelectorItemInfo("defualtSolution.id"));
            sic.add(new SelectorItemInfo("defualtSolution.number"));
            sic.add(new SelectorItemInfo("defualtSolution.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("CU.*"));
        } else {
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("CU.name"));
        }
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("scanConfig.*"));
        sic.add(new SelectorItemInfo("entitys.fullName"));
        return sic;
    }

    private String getMassege(Context ctx, String resourceStr, String key) {
        return ResourceBase.getString((String)resourceStr, (String)key, (Locale)ctx.getLocale());
    }
}

