/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.barcode.scm.BarDict4MobileEntryInfo;
import com.kingdee.eas.barcode.scm.BarDict4MobileInfo;
import com.kingdee.eas.barcode.scm.app.AbstractBarDict4MobileControllerBean;
import com.kingdee.eas.barcode.scm.util.Json;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class BarDict4MobileControllerBean
extends AbstractBarDict4MobileControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.BarDict4MobileControllerBean");

    @Override
    protected String _getQrLabDict(Context ctx) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.*"));
        BarDict4MobileInfo bill = this.getBarDict4MobileInfo(ctx, (IObjectPK)new ObjectUuidPK("8r0AAAAMlqhYhbIe"), sic);
        if (bill == null) {
            throw new EASBizException(new NumericExceptionSubItem("ffff", "uninitialized dict"));
        }
        LinkedHashMap<String, String> revMap = new LinkedHashMap<String, String>();
        BarDict4MobileEntryInfo entry = null;
        int count = bill.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            entry = bill.getEntrys().get(i);
            revMap.put(entry.getCode(), entry.getName());
        }
        return Json.toString(revMap, true);
    }

    @Override
    protected void _addValByType(Context ctx, IObjectPK pk, Set insertSet) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrs.*"));
        BarDict4MobileInfo bill = this.getBarDict4MobileInfo(ctx, (IObjectPK)new ObjectUuidPK("8r0AAAAMlqhYhbIe"), sic);
        if (bill == null) {
            throw new EASBizException(new NumericExceptionSubItem("ffff", "uninitialized dict"));
        }
        BarDict4MobileEntryInfo entry = null;
        String tempName = null;
        int count = bill.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            entry = bill.getEntrys().get(i);
            tempName = entry.getName();
            if (!insertSet.contains(tempName)) continue;
            insertSet.remove(tempName);
            if (insertSet.size() != 0) continue;
            return;
        }
        Iterator it = insertSet.iterator();
        while (it.hasNext()) {
            BarDict4MobileEntryInfo item = new BarDict4MobileEntryInfo();
            item.setCode(this.getCode(++count));
            item.setName((String)it.next());
            bill.getEntrys().add(item);
        }
        this._save(ctx, (IObjectValue)bill);
    }

    private String getCode(int maxNum) {
        if (maxNum >= 100) {
            return "" + maxNum;
        }
        if (maxNum >= 10) {
            return "0" + maxNum;
        }
        return "00" + maxNum;
    }
}

