/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResultItem;
import com.kingdee.eas.barcode.scm.BarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.BarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.PackageBarcodeFactory;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeAnalysisFacadeControllerBean;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BarcodeAnalysisFacadeControllerBean
extends AbstractBarcodeAnalysisFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.barcode.app.BarcodeAnalysisFacadeControllerBean");

    @Override
    protected List _findBarcodeRule(Context ctx, String barcode, String srcBosType, String destBosType, String CUNumber) throws BOSException, EASBizException {
        this.verify(ctx, barcode, destBosType, CUNumber);
        barcode = barcode.trim();
        destBosType = destBosType.trim();
        CUNumber = CUNumber.trim();
        HashMap<String, String> typeIdMap = new HashMap<String, String>();
        String sql = "select fid,fsign from t_bc_barcodetype where fuseSign=1";
        IRowSet byRs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (byRs.next()) {
                String byId = byRs.getString("fid");
                String sign = byRs.getString("fsign");
                if (!barcode.startsWith(sign)) continue;
                String analysisBarocde = barcode.substring(sign.length(), barcode.length());
                typeIdMap.put(byId, analysisBarocde);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String srcSql = null;
        if (srcBosType != null) {
            srcSql = "select br.fid as brId,br.fpattern as brPattern,bt.fid as btId from t_bc_barcoderule br  inner join T_ORG_CtrlUnit cu on br.fcontrolunitid=cu.fid inner join T_BC_BARCODETYPE bt on br.fbarcodetypeid=bt.fid where br.fentityBosType='" + srcBosType + "' and cu.fnumber='" + CUNumber + "' and bt.FBarcodeType=" + 1 + " and br.fstatus=1";
            srcSql = typeIdMap.size() > 0 ? srcSql + " and bt.fid in (" + this.idCollToStr(typeIdMap.keySet()) + ") " : srcSql + " and bt.fuseSign=0";
        }
        String destSql = "select br.fid as brId,br.fpattern as brPattern,bt.fid as btId from t_bc_barcoderule br  inner join T_ORG_CtrlUnit cu on br.fcontrolunitid=cu.fid inner join T_BC_BARCODETYPE bt on br.fbarcodetypeid=bt.fid where br.fentityBosType='" + destBosType + "' and cu.fnumber='" + CUNumber + "' and br.fstatus=1";
        destSql = typeIdMap.size() > 0 ? destSql + " and bt.fid in (" + this.idCollToStr(typeIdMap.keySet()) + ") " : destSql + " and bt.fuseSign=0";
        if (srcSql != null) {
            destSql = srcSql + " union all " + destSql;
        }
        ArrayList<String> idList = new ArrayList<String>();
        Pattern p = null;
        Matcher m = null;
        logger.debug((Object)("\u83b7\u5f97\u6b63\u5219\u4e4b\u540e\u518d\u5339\u914d,\u5f97\u5230\u5bf9\u5e94\u7684\u89c4\u5219ID\u7684SQl\uff1a" + destSql + "\n"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)destSql);
        try {
            while (rs.next()) {
                String pattern = rs.getString("brPattern");
                String brId = rs.getString("brId");
                String btId = rs.getString("btId");
                p = Pattern.compile(pattern);
                m = typeIdMap.size() == 0 ? p.matcher(barcode) : p.matcher(typeIdMap.get(btId).toString());
                if (!m.find()) continue;
                idList.add(brId);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (idList.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("", barcode + ":" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"3_BarcodeAnalysisFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        return idList;
    }

    private void verify(Context ctx, String barcode, String destBosType, String CUNumber) throws EASBizException {
        if (barcode == null || "".equals(barcode.trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"0_BarcodeAnalysisFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        if (destBosType == null || "".equals(destBosType.trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"1_BarcodeAnalysisFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        if (CUNumber == null || "".equals(CUNumber.trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"2_BarcodeAnalysisFacadeControllerBean", (Locale)ctx.getLocale())));
        }
    }

    private String idCollToStr(Set idColl) {
        if (idColl == null || idColl.size() == 0) {
            return "''";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = idColl.iterator();
        int count = 0;
        while (it.hasNext()) {
            if (count != 0) {
                sb.append(",");
            }
            sb.append("'" + it.next() + "'");
            ++count;
        }
        return sb.toString();
    }

    @Override
    protected BarcodeAnalysisResult _barcodeAnalysis(Context ctx, String barcode, String barcodeRuleId) throws BOSException, EASBizException {
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add("*");
        selectorColl.add("CU.number");
        selectorColl.add("barcodeType.*");
        selectorColl.add("details.*");
        selectorColl.add("details.barcodeDict.*");
        selectorColl.add("details.barcodeDict.details.*");
        BarcodeRuleInfo ruleInfo = BarcodeRuleFactory.getLocalInstance(ctx).getBarcodeRuleInfo((IObjectPK)new ObjectUuidPK(barcodeRuleId), selectorColl);
        return this._barcodeAnalysis(ctx, barcode, (IObjectValue)ruleInfo);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected BarcodeAnalysisResult _barcodeAnalysis(Context ctx, String barcode, IObjectValue info) throws BOSException, EASBizException {
        ruleInfo = (BarcodeRuleInfo)info;
        result = new BarcodeAnalysisResult();
        entity = BarcodeUtils.getEntityByBosType(ruleInfo.getEntityBosType());
        result.setBarcode(barcode);
        result.setBarcodeType(ruleInfo.getBarcodeType().getBarcodeType());
        result.setBosType(ruleInfo.getEntityBosType());
        result.setCumsumQty(ruleInfo.isIsCumsumQty());
        result.setBarcodeRepeat(ruleInfo.isIsBarcoeRepeat());
        items = new ArrayList<BarcodeAnalysisResultItem>();
        analysisBarcode = barcode;
        barcodeType = ruleInfo.getBarcodeType();
        if (barcodeType.isUseSign()) {
            analysisBarcode = barcode.substring(barcodeType.getSign().length(), barcode.length());
        }
        if (barcodeType.getBarcodeType().getValue() == 2) {
            barcodeList = new ArrayList<String>();
            if (ruleInfo.isRuleSegment()) {
                barcodeStrs = analysisBarcode.split(BarcodeUtils.unicodeEncode(ruleInfo.getSeparators()));
                for (i = 0; i < barcodeStrs.length; ++i) {
                    barcodeList.add(barcodeStrs[i]);
                }
            } else {
                pbColl = null;
                try {
                    pbColl = PackageBarcodeFactory.getLocalInstance(ctx).getPackageBarcodeCollection("Select entry.barcode where pacakgeBarcode='" + barcode + "' and status=1");
                    if (pbColl == null || pbColl.size() <= 0) ** GOTO lbl35
                    pbInfo = pbColl.get(0);
                    for (i = 0; i < pbInfo.getEntry().size(); ++i) {
                        barcodeList.add(pbInfo.getEntry().get(i).getBarcode());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
lbl35:
            // 4 sources

            result.setChidrenBarcodes(barcodeList);
        }
        segments = null;
        if (ruleInfo.isRuleSegment()) {
            segments = analysisBarcode.split(BarcodeUtils.unicodeEncode(ruleInfo.getSeparators()));
        }
        barRuleID = ruleInfo.getId().toString();
        for (i = 0; i < ruleInfo.getDetails().size(); ++i) {
            ruleEntry = ruleInfo.getDetails().get(i);
            item = new BarcodeAnalysisResultItem();
            key = "";
            if (ruleInfo.isRuleSegment()) {
                segmentLocation = ruleEntry.getSegmentLocation();
                try {
                    key = segments[segmentLocation - 1];
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                start = ruleEntry.getStartsWith();
                end = ruleEntry.getEndsWith();
                key = analysisBarcode.substring(start - 1, end);
            }
            field = ruleEntry.getProperty();
            value = null;
            number = null;
            name = null;
            entryEntity = entity;
            fields = field.split("\\.");
            length = fields.length > 2 ? fields.length - 1 : fields.length;
            propery = null;
            for (k = 0; k < length; ++k) {
                if (k != length - 1) {
                    propery = entryEntity.getPropertyByName(fields[k]);
                    entryEntity = ((LinkPropertyInfo)propery).getRelationship().getSupplierObject();
                    continue;
                }
                if (fields[k].equals("sequenceNumber")) continue;
                propery = entryEntity.getPropertyByName(fields[k]);
            }
            if (ruleEntry.getBarcodeDict() != null) {
                matchEntry = ruleEntry.getBarcodeDict().getDetailByKey(key);
                if (matchEntry != null) {
                    value = matchEntry.getNumber();
                    number = matchEntry.getNumber();
                    name = matchEntry.getName();
                } else {
                    value = key;
                }
            } else if (ruleEntry.getFormat() != null) {
                if (propery != null && propery.get("dataType") != null) {
                    dataType = (String)propery.get("dataType");
                    format = ruleEntry.getFormat();
                    if ("BigDecimal".equals(dataType)) {
                        value = this.formatDecimal(key, format);
                    }
                }
            } else {
                value = key;
            }
            if ("Date".equals(propery.get("dataType")) || "TimeStamp".equals(propery.get("dataType"))) {
                value = this.formatDate(key);
            } else if ("Boolean".equals(propery.get("dataType"))) {
                value = Boolean.FALSE;
                if ("1".equals(key) || "true".equalsIgnoreCase(key)) {
                    value = Boolean.TRUE;
                }
            }
            item.setField(ruleEntry.getProperty());
            item.setIsMatchItem(ruleEntry.isIsMatchItem());
            item.setKey(key);
            item.setValue(value);
            item.setBosType(entryEntity.getType().toString());
            item.setLinkedProperty(propery instanceof LinkPropertyInfo);
            if (item.isLinkedProperty()) {
                if (fields.length > 2) {
                    item.setNumberProperty(propery.getName() + "_" + fields[fields.length - 1]);
                    if ("number".equalsIgnoreCase(fields[fields.length - 1])) {
                        item.setField(fields[0] + "." + fields[1]);
                    }
                } else {
                    item.setNumberProperty(propery.getName() + "_number");
                    item.setNameProperty(propery.getName() + "_name");
                }
                baseEntity = ((LinkPropertyInfo)propery).getRelationship().getSupplierObject();
                this.setBaseDataValue(ctx, baseEntity, baseEntity.getType(), value, item, result);
            }
            if ("com.kingdee.eas.basedata.master.material.app.Material".equals(entryEntity.getFullName())) {
                this.setBaseDataValue(ctx, entryEntity, entryEntity.getType(), value, item, result);
            }
            item.setNumber(number);
            item.setName(name);
            item.setBarcodeRuleId(barRuleID);
            item.setAlias(propery.getAlias());
            if (propery != null) {
                item.setMoveField(propery.getName());
            } else {
                item.setMoveField(item.getField());
            }
            items.add(item);
        }
        result.setItems(items);
        return result;
    }

    private void setBaseDataValue(Context ctx, EntityObjectInfo baseEntity, BOSObjectType bosType, Object value, BarcodeAnalysisResultItem item, BarcodeAnalysisResult result) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("number");
        sic.add("id");
        if ("com.kingdee.eas.basedata.master.material.app.Material".equals(baseEntity.getFullName())) {
            sic.add("model");
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", value));
        view.setFilter(filterInfo);
        view.setSelector(sic);
        CoreBaseCollection coreBaseInfoCol = iCoreBase.getCollection(view);
        if (coreBaseInfoCol.size() > 0) {
            CoreBaseInfo coreBarseInfo = coreBaseInfoCol.get(0);
            item.setNameValue(coreBarseInfo.get("name"));
            if (coreBarseInfo instanceof MaterialInfo) {
                if (result.getMaterialID() == null) {
                    result.setMaterialID(coreBarseInfo.get("id").toString());
                } else {
                    String materialID = result.getMaterialID() + "," + coreBarseInfo.get("id").toString();
                    result.setMaterialID(materialID);
                }
                if (coreBarseInfo.get("model") != null) {
                    item.setMaterialMode(coreBarseInfo.get("model").toString());
                }
            }
        }
    }

    private Object formatDate(String key) {
        String temp;
        String value = null;
        if (key.length() == 8) {
            value = temp = key.substring(0, 4) + "-" + key.substring(4, 6) + "-" + key.substring(6, 8);
        }
        if (key.length() == 10) {
            value = key;
        }
        if (key.length() == 6) {
            value = temp = "20" + key.substring(0, 2) + "-" + key.substring(2, 4) + "-" + key.substring(4, 6);
        }
        return value;
    }

    private Object formatDecimal(String subBarcode, String format) {
        String realFormat = format.replaceAll("\\d", "0");
        int pointIndex = realFormat.lastIndexOf(".");
        String pointBefore = subBarcode;
        pointBefore.replaceAll("\\.", "");
        String pointAfter = null;
        if (pointIndex > -1) {
            int pointAfterLength = realFormat.length() - pointIndex - 1;
            if (subBarcode.length() > pointAfterLength) {
                pointAfter = subBarcode.substring(subBarcode.length() - pointAfterLength);
                pointBefore = subBarcode.substring(0, subBarcode.length() - pointAfterLength);
            } else {
                pointAfter = subBarcode;
                pointBefore = "0";
            }
            pointAfter.replaceAll("\\.", "");
            pointAfter = "." + pointAfter;
        }
        double afterDouble = 0.0;
        double beferDouble = 0.0;
        BigDecimal value = new BigDecimal("0");
        try {
            if (pointAfter != null) {
                afterDouble = Double.parseDouble(pointAfter);
            }
            beferDouble = 0.0;
            if (pointBefore != null) {
                beferDouble = Double.parseDouble(pointBefore);
            }
            DecimalFormat formatter = new DecimalFormat(realFormat);
            value = new BigDecimal(formatter.format(beferDouble)).add(new BigDecimal(formatter.format(afterDouble)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }
}

