/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeInventoryCollection;
import com.kingdee.eas.barcode.scm.BarcodeInventoryFactory;
import com.kingdee.eas.barcode.scm.BarcodeInventoryInfo;
import com.kingdee.eas.barcode.scm.BarcodeOfDateMinFactory;
import com.kingdee.eas.barcode.scm.BarcodeOfDateMinInfo;
import com.kingdee.eas.barcode.scm.IBarcodeInventory;
import com.kingdee.eas.barcode.scm.IPosition;
import com.kingdee.eas.barcode.scm.PositionCollection;
import com.kingdee.eas.barcode.scm.PositionFactory;
import com.kingdee.eas.barcode.scm.PositionInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;

public class BarcodeInvInitImport
extends AbstractDataTransmission {
    private BarcodeInventoryInfo barcodeInventoryinfo = null;
    private ImportDataCache dataPool = new ImportDataCache();

    public BarcodeInvInitImport() {
        this.barcodeInventoryinfo = new BarcodeInventoryInfo();
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BarcodeInventoryFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        String str = this.barcodeInventoryinfo.getBarcode();
        IBarcodeInventory iBarcodeInventory = (IBarcodeInventory)this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iBarcodeInventory.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iBarcodeInventory.addnew(coreBaseInfo);
                BarcodeOfDateMinInfo barcodeofDateInfo = new BarcodeOfDateMinInfo();
                BarcodeInventoryInfo addnewcoreBaseInfo = (BarcodeInventoryInfo)coreBaseInfo;
                barcodeofDateInfo.setBarcode(addnewcoreBaseInfo.getBarcode());
                barcodeofDateInfo.setLot(addnewcoreBaseInfo.getLot());
                barcodeofDateInfo.setInWarehouseDate(new Date());
                barcodeofDateInfo.setQty(addnewcoreBaseInfo.getCurStoreQty());
                barcodeofDateInfo.setBarcodeInventory(addnewcoreBaseInfo);
                BarcodeOfDateMinFactory.getLocalInstance(ctx).addnew(barcodeofDateInfo);
            } else {
                iBarcodeInventory.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        this.barcodeInventoryinfo = new BarcodeInventoryInfo();
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String str = null;
        str = ((DataToken)hsData.get((Object)"FBarcode")).data.toString();
        if (!StringUtil.isEmpty((String)str)) {
            try {
                IBarcodeInventory iBarcodeInventory = (IBarcodeInventory)this.getController(ctx);
                BarcodeInventoryCollection biOcollection = iBarcodeInventory.getBarcodeInventoryCollection("select id,barcode from  where barcode ='" + str + "'");
                if (biOcollection.size() > 0) {
                    this.barcodeInventoryinfo = biOcollection.get(0);
                }
                this.barcodeInventoryinfo.setBarcode(str);
            }
            catch (BOSException e) {
                throw new TaskExternalException("", (Throwable)e);
            }
        }
        try {
            this.loadmaterial(hsData, ctx);
            str = ((DataToken)hsData.get((Object)"FLot")).data.toString();
            if (!StringUtil.isEmpty((String)str)) {
                this.barcodeInventoryinfo.setLot(str);
            }
            this.loadstorageOrgUnit(hsData, ctx);
            this.loadwarehosue(hsData, ctx);
            this.loadLocation(hsData, ctx);
            this.loadPosition(hsData, ctx);
            str = ((DataToken)hsData.get((Object)"FCurStoreQty")).data.toString();
            if (!StringUtil.isEmpty((String)str)) {
                BigDecimal curStoreQty = new BigDecimal(str);
                this.barcodeInventoryinfo.setCurStoreQty(curStoreQty);
            }
            StoreStateInfo stateInfo = new StoreStateInfo();
            stateInfo.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
            this.barcodeInventoryinfo.setStorestatus(stateInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return this.barcodeInventoryinfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadstorageOrgUnit(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)hsData.get((Object)"FStorageOrgUnit_number")).data;
        if (souData == null || souData.toString().trim().length() <= 0) throw new TaskExternalException(souData + "\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        StorageOrgUnitInfo info = this.dataPool.getStorageOrgUnitInfo(souData.toString().trim());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userInfoID = null;
        if (userInfo != null) {
            userInfoID = userInfo.getId().toString();
        }
        if (info == null) {
            IStorageOrgUnit istorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitCollection collection = istorageOrgUnit.getStorageOrgUnitCollection(this.getFilter(souData.toString().trim()));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(souData + "\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            info = collection.get(0);
        }
        this.barcodeInventoryinfo.setStorageOrgUnit(info);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadwarehosue(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)hsData.get((Object)"FWarehouse_number")).data;
        if (souData == null || souData.toString().trim().length() <= 0) throw new TaskExternalException(souData + "\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        WarehouseInfo info = this.dataPool.getWarehouseInfo(souData.toString().trim());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userInfoID = null;
        if (userInfo != null) {
            userInfoID = userInfo.getId().toString();
        }
        if (info == null) {
            IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
            WarehouseCollection collection = iWarehouse.getWarehouseCollection(this.getFilter(souData.toString().trim()));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(souData + "\u4ed3\u5e93\u4e0d\u5b58\u5728");
            info = collection.get(0);
        }
        this.barcodeInventoryinfo.setWarehouse(info);
    }

    private void loadLocation(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)hsData.get((Object)"FLocation_number")).data;
        if (souData != null && souData.toString().trim().length() > 0) {
            LocationInfo info = this.dataPool.getLocation(souData.toString().trim());
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userInfoID = null;
            if (userInfo != null) {
                userInfoID = userInfo.getId().toString();
            }
            if (info == null) {
                ILocation iLocation = LocationFactory.getLocalInstance((Context)ctx);
                LocationCollection collection = iLocation.getLocationCollection(this.getFilter(souData.toString().trim()));
                if (collection != null && collection.size() > 0) {
                    info = collection.get(0);
                    if (info == null && this.barcodeInventoryinfo.getWarehouse().isHasLocation()) {
                        throw new TaskExternalException("");
                    }
                } else {
                    throw new TaskExternalException(souData + "\u5e93\u4f4d\u4e0d\u5b58\u5728");
                }
            }
            if (this.barcodeInventoryinfo.getWarehouse().isHasLocation()) {
                this.barcodeInventoryinfo.setLocation(info);
            }
        } else if (this.barcodeInventoryinfo.getWarehouse().isHasLocation()) {
            throw new TaskExternalException(souData + "\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void loadPosition(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)hsData.get((Object)"FPosition_number")).data;
        if (souData != null && souData.toString().trim().length() > 0) {
            PositionInfo info = null;
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userInfoID = null;
            if (userInfo != null) {
                userInfoID = userInfo.getId().toString();
            }
            if (info == null) {
                IPosition iPosition = PositionFactory.getLocalInstance(ctx);
                PositionCollection collection = iPosition.getPositionCollection(this.getFilter(souData.toString().trim()));
                if (collection != null && collection.size() > 0) {
                    info = collection.get(0);
                    if (info == null && this.barcodeInventoryinfo.getWarehouse().isHasLocation()) {
                        throw new TaskExternalException("");
                    }
                } else {
                    throw new TaskExternalException(souData + "\u4f4d\u7f6e\u4e0d\u5b58\u5728");
                }
            }
            this.barcodeInventoryinfo.setPosition(info);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadmaterial(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)hsData.get((Object)"FMaterial_number4idx")).data;
        if (souData == null || souData.toString().trim().length() <= 0) throw new TaskExternalException(souData + "\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialInfo info = this.dataPool.getMaterialInfoInfo(souData.toString().trim());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userInfoID = null;
        if (userInfo != null) {
            userInfoID = userInfo.getId().toString();
        }
        if (info == null) {
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            MaterialCollection collection = iMaterial.getMaterialCollection(this.getFilter(souData.toString().trim()));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(souData + "\u7269\u6599\u4e0d\u5b58\u5728");
            info = collection.get(0);
            if (info != null) {
                // empty if block
            }
        }
        this.barcodeInventoryinfo.setMaterial(info);
    }

    private EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }
}

