/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.scm.BarcodeRuleCollection;
import com.kingdee.eas.barcode.scm.BarcodeRuleEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.BarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.BarcodeTypeInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeRuleControllerBean;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BarcodeRuleControllerBean
extends AbstractBarcodeRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.barcode.app.BarcodeRuleControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verify(model, ctx);
        BarcodeRuleInfo info = (BarcodeRuleInfo)model;
        if (info.getStatus().getValue() == 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"11_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        info.setAdminCU(info.getCU());
        info.setPattern(this.genPattern(ctx, info));
        return super._submit(ctx, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BarcodeRuleInfo info = (BarcodeRuleInfo)model;
        if (info.getStatus().getValue() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"12_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        info.setStatus(StatusEnum.INACTIVE);
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BarcodeRuleInfo info = (BarcodeRuleInfo)model;
        if (info.getStatus().getValue() == 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"19_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        info.setStatus(StatusEnum.ACTIVE);
        super._cancelCancel(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BarcodeRuleInfo info = (BarcodeRuleInfo)this._getValue(ctx, pk);
        if (info.getStatus().getValue() == 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"20_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl;
        CUBDControlInfo controlInfo;
        this.verify(model, ctx);
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)model;
        if (dataBaseDInfo != null && (dataBaseDInfo.getAdminCU() == null || dataBaseDInfo.getAdminCU().getId() == null)) {
            dataBaseDInfo.setAdminCU(this.getDefaultCU(ctx));
        }
        if (dataBaseDInfo != null && (dataBaseDInfo.getCU() == null || dataBaseDInfo.getCU().getId() == null)) {
            dataBaseDInfo.setCU(this.getDefaultCU(ctx));
        }
        if ((controlInfo = (iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx)).getBDCtrlInfo(dataBaseDInfo.getBOSType().toString(), dataBaseDInfo.getCU().getId().toString())) == null) {
            controlInfo = new CUBDControlInfo();
            controlInfo.setBDBOSType(model.getBOSType().toString());
            controlInfo.setBDName("\u6761\u5f62\u7801\u89c4\u5219");
            controlInfo.setBDName("\u6761\u5f62\u7801\u89c4\u5219", Locale.CHINESE);
            controlInfo.setIsSubordinateAddnewable(true);
            controlInfo.setIsSuperiorViewable(false);
            controlInfo.setIsSubordinateEditable(true);
            controlInfo.setIsSubordinateDeletable(true);
            controlInfo.setIsSubordinateAssign(false);
            controlInfo.setIsSubordinateUpgradable(false);
            controlInfo.setCU(dataBaseDInfo.getCU());
            controlInfo.setIndex(999);
            iCUBDControl.submit((CoreBaseInfo)controlInfo);
        }
        return super._addnew(ctx, model);
    }

    protected String genPattern(Context ctx, BarcodeRuleInfo info) {
        String result = "";
        if (info.isRuleSegment()) {
            String singlePattern = "";
            String separatorunicode = BarcodeUtils.unicodeEncode(info.getSeparators());
            singlePattern = info.getSeparators().length() == 1 ? "([^" + separatorunicode + "]*)" : "(((?!" + separatorunicode + ").)*)";
            result = info.getBarcodeType() != null && info.getBarcodeType().getBarcodeType() != null && info.getBarcodeType().getBarcodeType().getValue() == 2 ? "^(" + singlePattern + separatorunicode + ")+" + singlePattern + "$" : "^(" + singlePattern + separatorunicode + "){" + (info.getSegmentNum() - 1) + "}" + singlePattern + "$";
        } else {
            result = "^(.){" + info.getLength() + "}$";
        }
        return result;
    }

    public boolean isPackageType(BarcodeTypeInfo bti) {
        return bti != null && bti.getBarcodeType().getValue() == 2;
    }

    protected void verify(IObjectValue model, Context ctx) throws EASBizException, BOSException {
        BarcodeRuleInfo info = (BarcodeRuleInfo)model;
        this.verifyHeader(ctx, info);
        this.verifyDetails(ctx, info);
        this.verifyUnique(ctx, info);
    }

    private void verifyDetails(Context ctx, BarcodeRuleInfo info) throws EASBizException {
        int preEndsWith = 0;
        int preSegmentLocation = 0;
        for (int i = 0; i < info.getDetails().size(); ++i) {
            BarcodeRuleEntryInfo entry = info.getDetails().get(i);
            if (entry.getProperty() == null) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"36_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
            }
            if (info.isRuleSegment()) {
                if (i == 0 && entry.getSegmentLocation() <= 0) {
                    throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"37_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
                }
                if (entry.getSegmentLocation() <= preSegmentLocation) {
                    throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"38_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
                }
                if (entry.getSegmentLocation() > info.getSegmentNum()) {
                    throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"39_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
                }
                preSegmentLocation = entry.getSegmentLocation();
                entry.setStartsWith(0);
                entry.setEndsWith(0);
                continue;
            }
            if (entry.getEndsWith() < entry.getStartsWith()) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"40_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
            }
            if (i == 0 && entry.getStartsWith() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"41_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
            }
            if (entry.getStartsWith() <= preEndsWith) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"42_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
            }
            if (entry.getEndsWith() > info.getLength()) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"43_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
            }
            preEndsWith = entry.getEndsWith();
            entry.setSegmentLocation(0);
        }
    }

    private void verifyHeader(Context ctx, BarcodeRuleInfo info) throws EASBizException {
        if (info.getNumber() == null || "".equals(info.getNumber().trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"7_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.getName() == null || "".equals(info.getName().trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"8_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.isRuleSegment()) {
            if (!this.isPackageType(info.getBarcodeType()) && info.getSegmentNum() <= 0) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"31_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
            }
            if (info.getSeparators() == null || "".equals(info.getSeparators())) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"32_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
            }
            info.setLength(0);
        } else {
            if (info.getLength() <= 0) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"33_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
            }
            info.setSegmentNum(0);
            info.setSeparators(null);
        }
        if (info.getCU() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"34_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.getBarcodeType() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"35_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
        }
    }

    private void verifyUnique(Context ctx, BarcodeRuleInfo info) throws BOSException, EASBizException {
        String idFilter = "";
        if (info.getId() != null) {
            idFilter = " and id<>'" + info.getId().toString() + "'";
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        BarcodeRuleCollection coll = BarcodeRuleFactory.getLocalInstance(ctx).getBarcodeRuleCollection(view);
        if (coll != null && coll.size() >= 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"10_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.isRuleSegment()) {
            if (this._exists(ctx, "where barcodeType.id='" + info.getBarcodeType().getId() + "'  and segmentNum=" + info.getSegmentNum() + "  and separators='" + info.getSeparators() + "'  and entityBosType='" + info.getEntityBosType() + "'  and cu.id='" + info.getCU().getId() + "' " + idFilter)) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"44_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
            }
        } else if (this._exists(ctx, "where barcodeType.id='" + info.getBarcodeType().getId() + "'  and length=" + info.getLength() + "  and entityBosType='" + info.getEntityBosType() + "'  and cu.id='" + info.getCU().getId() + "' " + idFilter)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"45_BarcodeRuleControllerBean", (Locale)ctx.getLocale())));
        }
    }

    private IObjectPK getDefaultCUPK(Context ctx) {
        return new ObjectUuidPK(this.getDefaultCU(ctx).getId());
    }

    private CtrlUnitInfo getDefaultCU(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }
}

