/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.app.BillServerUtil;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionFactory;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLItem;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningBarcodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.BcTaskBillFactory;
import com.kingdee.eas.barcode.scm.IBarcodeDossier;
import com.kingdee.eas.barcode.scm.IIndBarcodeBack;
import com.kingdee.eas.barcode.scm.IndBarcodeBackFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeBackInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.barcode.scm.IndDossierGenerateFacodeFactory;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.PackageBarcodeEntryFactory;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeUploadFacadeControllerBean;
import com.kingdee.eas.barcode.scm.app.BarcodeServerUtils;
import com.kingdee.eas.barcode.scm.app.bizprocess.ScmDataProcess;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.barcode.scm.util.SerialNumberHelper;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.CountingTableEntryInfo;
import com.kingdee.eas.scm.im.inv.CountingTableFactory;
import com.kingdee.eas.scm.im.inv.CountingTableInfo;
import com.kingdee.eas.scm.im.inv.CountingTaskInfo;
import com.kingdee.eas.scm.im.inv.IManufactureRecBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillEntryInfo;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.MoveLocationBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveLocationBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BarcodeUploadFacadeControllerBean
extends AbstractBarcodeUploadFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.barcode.app.BarcodeUploadFacadeControllerBean");
    public static final String SRCBILLID = "sourceBillId";
    public static final String SRCBILLENTRYID = "sourceBillEntryId";
    public static final String EASID = "FEASID";
    public static final String REWRITE_EASID = "FEASID";
    public static final String REWRITE_EASBILLNUMBER = "FEASBILLNUMBER";
    public static final String REWRITE_ISUPLOADED = "FISUPLOAD";
    public static final String REWRITE_TABLE = "TABLE_NAME";
    public static final String SCANNING_RECODEID = "scanningRecodeId";
    public static final String SCANNING_TABLENAME = "scanningTableName";
    public String barcodeScanningId;
    public static final String COUNTINGTABLE_BOSTYPE = "D9D2CA5D";
    public static final String FACOUNTINGTABLE_BOSTYPE = "84BEC1BB";
    public static final String BOTP_WAY = "botp";
    public static final String ADDNEW_WAY = "addnew";
    public static final String FILL_WAY = "fill";
    private final Map dataCache = new HashMap();
    protected String invAddResource = "com.kingdee.eas.scm.im.inv.InvAddResource";

    @Override
    protected String _uploadEasBill(Context ctx, IObjectCollection easBills, String bosType) throws BOSException, EASBizException {
        return this._uploadEasBill(ctx, easBills, null, bosType, null);
    }

    @Override
    protected String _uploadEasBill(Context ctx, IObjectCollection easBills, List botReltes, String bosType, Map relationMap) throws BOSException, EASBizException {
        int i;
        long time = System.currentTimeMillis();
        logger.info((Object)(" uploadEasBill begin\uff1a" + time));
        logger.info((Object)(" invockEas begin\uff1a" + time));
        if (easBills == null || easBills.size() == 0 || bosType == null) {
            return null;
        }
        ArrayList<String> rewriteSqlList = new ArrayList<String>();
        StringBuffer numberStr = new StringBuffer();
        IIndBarcodeBack iIndBarcodeBack = IndBarcodeBackFactory.getLocalInstance(ctx);
        IndubarodeParamsetInfo indParasetInfo = BarcodeClientUtils.getParamValue(ctx);
        String guuid = null;
        for (i = 0; i < easBills.size(); ++i) {
            CountingTaskInfo taskInfo;
            Object obj;
            IObjectValue value = easBills.getObject(i);
            CoreBaseCollection barcodeBack = (CoreBaseCollection)value.get("barcodeBack");
            EntityObjectInfo entity = BarcodeUtils.getEntityByBosType(value.getBOSType().toString());
            ICoreBase iCoreBase = this.getInterface(ctx, entity);
            if (value.get("guuid") != null) {
                guuid = value.get("guuid").toString();
            }
            IObjectPK pk = null;
            this.beforeInvockEas(ctx, iCoreBase, value);
            try {
                this.saveSerialNumberOfBarcode(ctx, value, barcodeBack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pk = this.invockEas(ctx, iCoreBase, value);
            if (pk == null) {
                throw new EASBizException(new NumericExceptionSubItem(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"58_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"59_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
            }
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" invockEas end\uff1a" + time));
            String billNumber = null;
            if (COUNTINGTABLE_BOSTYPE.equals(bosType)) {
                obj = value.get("countingTask");
                if (obj != null) {
                    taskInfo = (CountingTaskInfo)value.get("countingTask");
                    billNumber = taskInfo.getNumber();
                }
            } else if (FACOUNTINGTABLE_BOSTYPE.equals(bosType)) {
                obj = value.get("taskBill");
                if (obj != null) {
                    taskInfo = (FaStocktakingTaskBillInfo)value.get("taskBill");
                    billNumber = taskInfo.getNumber();
                }
            } else {
                billNumber = value.getString("number");
            }
            IObjectPK[] indBarcodeBackCollPK = null;
            Object barTaskRules = null;
            if (billNumber != null) {
                String recodeId = value.getString(SCANNING_RECODEID);
                String tableName = value.getString(SCANNING_TABLENAME);
                if (!(billNumber == null || "".equals(billNumber.trim()) || recodeId == null || "".equals(recodeId.trim()) || tableName == null || "".equals(tableName.trim()))) {
                    rewriteSqlList.add("update " + tableName + " set " + REWRITE_EASBILLNUMBER + "='" + billNumber + "' where fid='" + recodeId + "'");
                }
                if (null != barcodeBack && barcodeBack.size() > 0) {
                    StringBuffer barcodeStr = new StringBuffer();
                    LinkedHashMap<String, String> barcodeEntryIdMap = new LinkedHashMap<String, String>();
                    LinkedHashMap entryIdBarcodeMap = new LinkedHashMap();
                    for (int j = 0; j < barcodeBack.size(); ++j) {
                        List<CoreBaseInfo> baseInfoList;
                        String entryid;
                        CoreBaseInfo baseInfo = barcodeBack.get(j);
                        baseInfo.put("num", (Object)billNumber);
                        baseInfo.put("storageOrgUnit", value.get("storageOrgUnit") == null ? ContextUtil.getCurrentStorageUnit((Context)ctx) : value.get("storageOrgUnit"));
                        baseInfo.put("transactionType", value.get("transactionType"));
                        baseInfo.putAll((IObjectValue)baseInfo);
                        String barcode = baseInfo.get("name") != null ? baseInfo.get("name").toString() : "";
                        String string = entryid = baseInfo.get("rowNum") != null ? baseInfo.get("rowNum").toString() : "";
                        if (barcodeStr.length() > 0 && barcode.length() > 0) {
                            barcodeStr.append(",").append(barcode);
                        } else {
                            barcodeStr.append(barcode);
                        }
                        if (!barcodeEntryIdMap.containsKey(barcode)) {
                            barcodeEntryIdMap.put(barcode, entryid);
                        }
                        if (!entryIdBarcodeMap.containsKey(entryid)) {
                            baseInfoList = new ArrayList<CoreBaseInfo>();
                            baseInfoList.add(baseInfo);
                            entryIdBarcodeMap.put(entryid, baseInfoList);
                            continue;
                        }
                        baseInfoList = (List)entryIdBarcodeMap.get(entryid);
                        baseInfoList.add(baseInfo);
                        entryIdBarcodeMap.put(entryid, baseInfoList);
                    }
                    if (barcodeStr.length() > 0) {
                        FilterInfo filterInfo;
                        if (barcodeStr.length() > 0) {
                            String transferNumber = null;
                            if (value.get("transactionType") != null) {
                                if (((TransactionTypeInfo)value.get("transactionType")).get("number") != null) {
                                    transferNumber = ((TransactionTypeInfo)value.get("transactionType")).get("number").toString();
                                }
                                time = System.currentTimeMillis();
                                if (transferNumber != null) {
                                    logger.info((Object)(" \u6761\u7801\u6863\u6848\u66f4\u65b0\u72b6\u6001\uff1a" + (System.currentTimeMillis() - time) / 1000L + "S"));
                                }
                            }
                        }
                        if (value.get("transactionType") != null) {
                            TransactionTypeInfo transactionTypeInfo = (TransactionTypeInfo)value.get("transactionType");
                            int intOrUnitBill = BarcodeServerUtils.getInOrOutBill(ctx, value.getBOSType().toString(), transactionTypeInfo.getNumber());
                            if (intOrUnitBill == 3) {
                                filterInfo = new FilterInfo();
                                filterInfo.getFilterItems().add(new FilterItemInfo("barcode", (Object)barcodeStr.toString(), CompareType.INCLUDE));
                                PackageBarcodeEntryFactory.getLocalInstance(ctx).delete(filterInfo);
                            }
                        }
                        HashMap<String, Serializable> dataMap = new HashMap<String, Serializable>();
                        EntityViewInfo view = new EntityViewInfo();
                        filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcodeStr.toString(), CompareType.INCLUDE));
                        view.setFilter(filterInfo);
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("number"));
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("barRule.id"));
                        view.setSelector(sic);
                        BarcodeDossierCollection barcodeCol = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
                        String barcodeMasterId = null;
                        for (int j = 0; j < barcodeCol.size(); ++j) {
                            String barcode = barcodeCol.get(j).getNumber();
                            if (barcodeEntryIdMap.containsKey(barcode)) {
                                barcodeEntryIdMap.remove(barcode);
                            }
                            if (barcodeMasterId != null) continue;
                            barcodeMasterId = barcodeCol.get(j).getBarRule().getId().toString();
                        }
                        if (barcodeEntryIdMap.size() > 0) {
                            dataMap.put("barcodeEntryIdMap", barcodeEntryIdMap);
                            dataMap.put("setupInfo", this.getBarcodeSetupInfo(ctx, value.getBOSType().toString(), barcodeMasterId));
                            dataMap.put("editData", (Serializable)value);
                            IndDossierGenerateFacodeFactory.getLocalInstance(ctx).generateDossier(dataMap);
                        }
                    }
                    time = System.currentTimeMillis();
                    logger.info((Object)(" iIndBarcodeBack.addnewBatchData begin\uff1a" + time));
                    indBarcodeBackCollPK = iIndBarcodeBack.addnewBatchData(barcodeBack);
                    time = System.currentTimeMillis() - time;
                    logger.info((Object)(" iIndBarcodeBack.addnewBatchData end\uff1a" + time));
                    CoreBaseCollection barcodeDossierCol = (CoreBaseCollection)value.get("barcodeDossierCol");
                    if (null != barcodeDossierCol && barcodeDossierCol.size() > 0) {
                        this.updateBarcodeDossire(ctx, barcodeDossierCol);
                    }
                }
                if (numberStr.length() > 0) {
                    numberStr.append(",").append(billNumber);
                } else {
                    numberStr.append(billNumber);
                }
                CoreBaseCollection taskCol = (CoreBaseCollection)value.get("taskCol");
                if (null != taskCol && taskCol.size() > 0) {
                    for (int j = 0; j < taskCol.size(); ++j) {
                        taskCol.get(j).put("destNumber", (Object)billNumber);
                        barTaskRules = taskCol.get(j).get("barTaskRules");
                    }
                    BcTaskBillFactory.getLocalInstance(ctx).updateBatchData(taskCol);
                }
            }
            if (!(iCoreBase.getValue(pk) instanceof SCMBillBaseInfo) || iCoreBase.getValue(pk) instanceof MoveLocationBillInfo) continue;
            SCMBillBaseInfo coreBasSave = (SCMBillBaseInfo)iCoreBase.getValue(pk);
            ISCMBillBase iSCMBillBase = (ISCMBillBase)iCoreBase;
            if (barTaskRules == null) continue;
            BarcodeTaskRulesInfo barcodeTaskRulesInfo = BarcodeTaskRulesFactory.getLocalInstance(ctx).getBarcodeTaskRulesInfo((IObjectPK)new ObjectStringPK(((IObjectValue)barTaskRules).get("id").toString()));
            if (indParasetInfo.isIsSheetStatus() && coreBasSave.getBaseStatus() == BillBaseStatusEnum.TEMPORARILYSAVED) {
                if ("2".equals(barcodeTaskRulesInfo.getDocStatus().getValue())) {
                    pk = iCoreBase.submit((CoreBaseInfo)value);
                    continue;
                }
                if (!"3".equals(barcodeTaskRulesInfo.getDocStatus().getValue())) continue;
                pk = iCoreBase.submit((CoreBaseInfo)value);
                iSCMBillBase.audit(pk);
                continue;
            }
            if (!indParasetInfo.isIsSheetStatus() || coreBasSave.getBaseStatus() != BillBaseStatusEnum.SUBMITED || !"3".equals(barcodeTaskRulesInfo.getDocStatus().getValue())) continue;
            iSCMBillBase.audit(pk);
        }
        if (botReltes != null && botReltes.size() > 0) {
            logger.info((Object)"BarcodeUpload.....SaveBotRelation Start...");
            for (i = 0; i < botReltes.size(); ++i) {
                BOTRelationCollection coll = (BOTRelationCollection)botReltes.get(i);
                IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
                if (coll == null || coll.size() <= 0) continue;
                for (int j = 0; j < coll.size(); ++j) {
                    if (iBOTRelation.exists((IObjectPK)new ObjectUuidPK(coll.get(j).getId()))) {
                        iBOTRelation.update((IObjectPK)new ObjectUuidPK(coll.get(j).get("id").toString()), coll.get(j));
                        continue;
                    }
                    iBOTRelation.addnew(coll.get(j));
                }
            }
            logger.info((Object)"BarcodeUpload.....SaveBotRelation End...");
        }
        if (relationMap != null) {
            logger.info((Object)"BarcodeUpload.....ReWriteScanningInfo Start...");
            Set keySet = relationMap.keySet();
            for (String key : keySet) {
                Map reWrite = (Map)relationMap.get(key);
                if (reWrite == null) continue;
                Set fieldSet = reWrite.keySet();
                Iterator fieldIt = fieldSet.iterator();
                StringBuffer reWriteSql = new StringBuffer();
                StringBuffer reWriteField = new StringBuffer();
                String tableName = null;
                while (fieldIt.hasNext()) {
                    String field = (String)fieldIt.next();
                    if (REWRITE_TABLE.equals(field)) {
                        tableName = (String)reWrite.get(REWRITE_TABLE);
                        continue;
                    }
                    reWriteField.append("," + field + "='" + reWrite.get(field) + "' ");
                }
                reWriteSql.append("update " + tableName + " set " + reWriteField.substring(1));
                reWriteSql.append(",FISUPLOAD=1");
                reWriteSql.append(" where fid='" + key + "'");
                rewriteSqlList.add(reWriteSql.toString());
            }
            if (rewriteSqlList.size() > 0) {
                BarcodeServerUtils.executeBatchUpdate(ctx, rewriteSqlList);
            }
            logger.info((Object)"BarcodeUpload.....ReWriteScanningInfo End...");
        }
        if (null != guuid && numberStr.length() > 0) {
            BarcodeServerUtils.updatePDAOnlyMessageInfo(ctx, guuid, true, numberStr.toString());
        }
        time = System.currentTimeMillis() - time;
        logger.info((Object)(" uploadEasBill end\uff1a" + time));
        return numberStr.toString();
    }

    private void saveSerialNumberOfBarcode(Context ctx, IObjectValue value, CoreBaseCollection barcodeBack) throws Exception {
        if (barcodeBack == null) {
            return;
        }
        String entryName = value.get("entryName").toString();
        String entryBosType = value.get("bosType").toString();
        LinkedHashMap<String, List<CoreBaseInfo>> entryIdBarcodeMap = new LinkedHashMap<String, List<CoreBaseInfo>>();
        for (int j = 0; j < barcodeBack.size(); ++j) {
            List<CoreBaseInfo> baseInfoList;
            String entryid;
            CoreBaseInfo baseInfo = barcodeBack.get(j);
            String string = entryid = baseInfo.get("rowNum") != null ? baseInfo.get("rowNum").toString() : "";
            if (!entryIdBarcodeMap.containsKey(entryid)) {
                baseInfoList = new ArrayList<CoreBaseInfo>();
                baseInfoList.add(baseInfo);
                entryIdBarcodeMap.put(entryid, baseInfoList);
                continue;
            }
            baseInfoList = (List)entryIdBarcodeMap.get(entryid);
            baseInfoList.add(baseInfo);
            entryIdBarcodeMap.put(entryid, baseInfoList);
        }
        new SerialNumberHelper().saveSerialNumberOfBarcode(ctx, value, barcodeBack, entryName, entryBosType, entryIdBarcodeMap);
    }

    public IObjectPK invockEas(Context ctx, ICoreBase iCoreBase, IObjectValue value) throws EASBizException, BOSException {
        IObjectPK pk = null;
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"64_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale()));
        if (COUNTINGTABLE_BOSTYPE.equals(value.getBOSType().toString())) {
            pk = iCoreBase.submit((CoreBaseInfo)value);
            CountingTableInfo info = (CountingTableInfo)value;
            info.setCountingPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            CountingTableFactory.getLocalInstance((Context)ctx).updateCountingPerson((IObjectValue)info);
        } else if (FACOUNTINGTABLE_BOSTYPE.equals(value.getBOSType().toString())) {
            IObjectPK[] pkArg;
            CoreBaseCollection stocktakingCol = new CoreBaseCollection();
            stocktakingCol.addObjectCollection((IObjectCollection)((FaStocktakingBillEntryCollection)value.get("entries")));
            if (stocktakingCol.size() > 0 && (pkArg = FaStocktakingBillEntryFactory.getLocalInstance((Context)ctx).submitBatchData(stocktakingCol)).length > 0) {
                pk = pkArg[0];
            }
        } else if (value instanceof SaleIssueBillInfo) {
            SaleIssueBillInfo billInfo = (SaleIssueBillInfo)value;
            TransactionTypeInfo typeInfo = billInfo.getTransactionType();
            if (typeInfo != null) {
                SelectorItemCollection seleCol = new SelectorItemCollection();
                seleCol.add(new SelectorItemInfo("id"));
                seleCol.add(new SelectorItemInfo("number"));
                seleCol.add(new SelectorItemInfo("name"));
                seleCol.add(new SelectorItemInfo("rIType.*"));
                seleCol.add(new SelectorItemInfo("rIType.dataDirection"));
                typeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(typeInfo.getId()), seleCol);
                billInfo.setTransactionType(typeInfo);
            }
            if (!value.containsKey("baseStatus") || BillBaseStatusEnum.TEMPORARILYSAVED == value.get("baseStatus")) {
                pk = iCoreBase.save((CoreBaseInfo)value);
            } else if (value.containsKey("id") && !BarcodeUtils.isObjectEmpty(value.get("id")).booleanValue()) {
                pk = new ObjectStringPK(value.get("id").toString());
            }
        } else if (!value.containsKey("baseStatus") || BillBaseStatusEnum.TEMPORARILYSAVED == value.get("baseStatus")) {
            pk = iCoreBase.save((CoreBaseInfo)value);
        } else if (value.containsKey("id") && !BarcodeUtils.isObjectEmpty(value.get("id")).booleanValue()) {
            pk = new ObjectStringPK(value.get("id").toString());
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"65_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale()));
        return pk;
    }

    private void beforeInvockEas(Context ctx, ICoreBase iCoreBase, IObjectValue value) throws BOSException, EASBizException {
        IMaterial imateral;
        CostObjectInfo costObjectInfo;
        WarehouseInfo warehouseInfo;
        SelectorItemCollection coll;
        LocationInfo locationInfoValue;
        LocationCollection col;
        FilterInfo filter;
        EntityViewInfo view;
        MaterialInfo materialInfo;
        ManufactureRecBillEntryInfo entryInfo;
        int i;
        LocationInfo locationInfoValue2;
        LocationCollection col2;
        PurInWarehsEntryInfo entryInfo2;
        ILocation iLocation;
        IMaterial imateral2;
        IMaterial imateral3;
        FaStocktakingBillInfo billInfo;
        try {
            this.initContext(ctx);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        if (COUNTINGTABLE_BOSTYPE.equals(value.getBOSType().toString())) {
            CountingTableInfo tableInfo = (CountingTableInfo)value;
            CountingTableEntryInfo firstEntryInfo = null;
            MeasureUnitInfo assitUnitInfo = null;
            MaterialInfo material = null;
            MeasureUnitInfo unitInfo = null;
            MultiMeasureUnitInfo mulUnit = null;
            int size = tableInfo.getEntry().size();
            for (int i2 = 0; i2 < size; ++i2) {
                MultiMeasureUnitInfo assitmulUnit;
                CountingTableEntryInfo entryInfo3 = tableInfo.getEntry().get(i2);
                if (firstEntryInfo == null && i2 == 0) {
                    firstEntryInfo = entryInfo3;
                }
                BigDecimal countingQty = entryInfo3.getCountingQty() != null ? entryInfo3.getCountingQty() : BigDecimal.ZERO;
                BigDecimal accountQty = entryInfo3.getAccountQty() != null ? entryInfo3.getAccountQty() : BigDecimal.ZERO;
                BigDecimal adjustQty = entryInfo3.getAdjustQty() != null ? entryInfo3.getAdjustQty() : BigDecimal.ZERO;
                entryInfo3.setDifferQty(countingQty.subtract(accountQty).subtract(adjustQty));
                assitUnitInfo = entryInfo3.getAssistUnit();
                material = entryInfo3.getMaterial();
                unitInfo = entryInfo3.getUnit();
                mulUnit = this.getMulUnit(ctx, unitInfo, material);
                if (assitUnitInfo != null && (assitmulUnit = this.getMulUnit(ctx, assitUnitInfo, material)) != null) {
                    BigDecimal coefficient = assitmulUnit.getBaseConvsRate();
                    mulUnit = this.getMulUnit(ctx, assitUnitInfo, material);
                    int precision = mulUnit.getQtyPrecision();
                    entryInfo3.setCountingAssistQty(this.calAssitQtyByQty(ctx, countingQty, coefficient, precision));
                    entryInfo3.setAcctAssistQty(this.calAssitQtyByQty(ctx, accountQty, coefficient, precision));
                    entryInfo3.setAdjustAssistQty(this.calAssitQtyByQty(ctx, adjustQty, coefficient, precision));
                }
                BigDecimal acctAssistQty = entryInfo3.getAcctAssistQty() != null ? entryInfo3.getAcctAssistQty() : BigDecimal.ZERO;
                BigDecimal countingAssistQty = entryInfo3.getCountingAssistQty() != null ? entryInfo3.getCountingAssistQty() : BigDecimal.ZERO;
                BigDecimal adjustAssistQty = entryInfo3.getAdjustAssistQty() != null ? entryInfo3.getAdjustAssistQty() : BigDecimal.ZERO;
                entryInfo3.setDiffAssistQty(acctAssistQty.subtract(countingAssistQty).subtract(adjustAssistQty));
                if (entryInfo3.getUnit() == null && entryInfo3.getMaterial() != null) {
                    MaterialInfo mateiralInfo = entryInfo3.getMaterial();
                    try {
                        mateiralInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(mateiralInfo.getId()));
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    entryInfo3.setUnit(mateiralInfo.getBaseUnit());
                    entryInfo3.setAssistUnit(mateiralInfo.getAssistUnit());
                }
                if (entryInfo3.getLocation() == null) {
                    entryInfo3.setLocation(firstEntryInfo.getLocation());
                }
                if (entryInfo3.getStoreType() == null) {
                    entryInfo3.setStoreType(firstEntryInfo.getStoreType());
                }
                if (entryInfo3.getStoreStatus() == null) {
                    entryInfo3.setStoreStatus(firstEntryInfo.getStoreStatus());
                }
                if (entryInfo3.getInventoryID() != null) continue;
                entryInfo3.setInventoryID(firstEntryInfo.getInventoryID());
            }
            tableInfo.setCountingPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            value.putAll((IObjectValue)tableInfo);
        }
        if (FACOUNTINGTABLE_BOSTYPE.equals(value.getBOSType().toString())) {
            billInfo = (FaStocktakingBillInfo)value;
            IFaCurCard ifacurCard = FaCurCardFactory.getLocalInstance((Context)ctx);
            int size = billInfo.getEntries().size();
            for (int i3 = 0; i3 < size; ++i3) {
                FaCurCardInfo faCurCardInfo;
                FaStocktakingBillEntryInfo entryInfo4 = billInfo.getEntries().get(i3);
                if (entryInfo4.getAssetCat() != null && entryInfo4.getUseStatus() != null && entryInfo4.getMeasureUnit() != null && entryInfo4.getEconomicPurp() != null || entryInfo4.getAssetNum() == null || (faCurCardInfo = ifacurCard.getFaCurCardInfo("select assetCat.id,useStatus.id,measureUnit.id,economicPurp.id where number='" + entryInfo4.getAssetNum() + "'")) == null) continue;
                if (entryInfo4.getAssetCat() == null) {
                    entryInfo4.setAssetCat(faCurCardInfo.getAssetCat());
                }
                if (entryInfo4.getUseStatus() == null) {
                    entryInfo4.setUseStatus(faCurCardInfo.getUseStatus());
                }
                if (entryInfo4.getMeasureUnit() == null) {
                    entryInfo4.setMeasureUnit(faCurCardInfo.getMeasureUnit());
                }
                if (entryInfo4.getEconomicPurp() != null) continue;
                entryInfo4.setEconomicPurp(faCurCardInfo.getEconomicPurp());
            }
        }
        if (value instanceof StockTransferBillInfo) {
            imateral3 = MaterialFactory.getLocalInstance((Context)ctx);
            StockTransferBillInfo transferInfo = (StockTransferBillInfo)value;
            this.initContext(ctx);
            if (transferInfo.getIssueCompanyOrgUnit() == null) {
                transferInfo.setIssueCompanyOrgUnit(ContextUtil.getCurrentFIUnit((Context)ctx));
            }
            if (transferInfo.getIssueCompanyOrgUnit() != null) {
                logger.info((Object)("\u5e93\u5b58\u8c03\u62e8\u5355\u7684\u8c03\u51fa\u8d22\u52a1\u7ec4\u7ec7\uff1a" + transferInfo.getIssueCompanyOrgUnit().getId()));
            }
            if (transferInfo.getReceiptCompanyOrgUnit() == null) {
                transferInfo.setReceiptCompanyOrgUnit(ContextUtil.getCurrentFIUnit((Context)ctx));
            }
            if (transferInfo.getReceiptCompanyOrgUnit() != null) {
                logger.info((Object)("\u5e93\u5b58\u8c03\u62e8\u5355\u7684\u8c03\u5165\u8d22\u52a1\u7ec4\u7ec7\uff1a" + transferInfo.getReceiptCompanyOrgUnit().getId()));
            }
            if (value.get("issueStorageOrgUnit") == null) {
                transferInfo.setIssueStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            if (transferInfo.getReceiptStorageOrgUnit() == null) {
                transferInfo.setReceiptStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            transferInfo.setHasEffected(false);
            transferInfo.setIsShipment(false);
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(BOSUuid.read((String)"dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
            if (transferInfo.getCurrency() == null) {
                transferInfo.setCurrency(currencyInfo);
                transferInfo.setExchangeRate(BigDecimal.ONE);
            }
            transferInfo.setIsInitBill(false);
            transferInfo.setIsInTax(false);
            ILocation iLocation2 = LocationFactory.getLocalInstance((Context)ctx);
            int size = transferInfo.getEntry().size();
            for (int i4 = 0; i4 < size; ++i4) {
                LocationInfo locationInfoValue3;
                LocationCollection col3;
                FilterInfo filter2;
                EntityViewInfo view2;
                StockTransferBillEntryInfo entryInfo5 = transferInfo.getEntry().get(i4);
                MaterialInfo materialInfo2 = entryInfo5.getMaterial();
                if (materialInfo2.getId() != null) {
                    materialInfo2 = imateral3.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo2.getId()));
                }
                entryInfo5.setAssistUnit(materialInfo2.getAssistUnit());
                entryInfo5.setBaseUnit(materialInfo2.getBaseUnit());
                entryInfo5.setUnit(materialInfo2.getBaseUnit());
                if (entryInfo5.getIssueLocation() != null && entryInfo5.getIssueWarehouse() != null) {
                    view2 = new EntityViewInfo();
                    filter2 = new FilterInfo();
                    filter2.appendFilterItem("number", (Object)entryInfo5.getIssueLocation().getNumber());
                    filter2.appendFilterItem("Warehouse.id", (Object)entryInfo5.getIssueWarehouse().getId());
                    view2.setFilter(filter2);
                    col3 = iLocation2.getLocationCollection(view2);
                    if (col3.size() > 0) {
                        locationInfoValue3 = col3.get(0);
                        entryInfo5.setIssueLocation(locationInfoValue3);
                    }
                }
                if (entryInfo5.getReceiptLocation() != null && entryInfo5.getReceiptWarehouse() != null) {
                    view2 = new EntityViewInfo();
                    filter2 = new FilterInfo();
                    filter2.appendFilterItem("number", (Object)entryInfo5.getReceiptLocation().getNumber());
                    filter2.appendFilterItem("Warehouse.id", (Object)entryInfo5.getReceiptWarehouse().getId());
                    view2.setFilter(filter2);
                    col3 = iLocation2.getLocationCollection(view2);
                    if (col3.size() > 0) {
                        locationInfoValue3 = col3.get(0);
                        entryInfo5.setReceiptLocation(locationInfoValue3);
                    }
                }
                if (entryInfo5.getIssuePlanDate() == null) {
                    entryInfo5.setIssuePlanDate(new Date());
                }
                if (entryInfo5.getReceiptPlanDate() == null) {
                    entryInfo5.setReceiptPlanDate(new Date());
                }
                if (entryInfo5.getIssueStorageOrgUnit() == null) {
                    entryInfo5.setIssueStorageOrgUnit(transferInfo.getIssueStorageOrgUnit());
                }
                if (entryInfo5.getReceiveStorageOrgUnit() == null) {
                    entryInfo5.setReceiveStorageOrgUnit(transferInfo.getReceiptStorageOrgUnit());
                }
                entryInfo5.setIsPresent(false);
            }
        }
        if (value instanceof PurInWarehsBillInfo) {
            PurInWarehsBillInfo purBillInfo = (PurInWarehsBillInfo)value;
            if (purBillInfo.getStorageOrgUnit() == null) {
                purBillInfo.setStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            imateral2 = MaterialFactory.getLocalInstance((Context)ctx);
            iLocation = LocationFactory.getLocalInstance((Context)ctx);
            int size = purBillInfo.getEntry().size();
            for (int i5 = 0; i5 < size; ++i5) {
                entryInfo2 = purBillInfo.getEntry().get(i5);
                MaterialInfo materialInfo3 = entryInfo2.getMaterial();
                if (materialInfo3.getId() != null) {
                    materialInfo3 = imateral2.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo3.getId()));
                }
                if (entryInfo2.getAssistUnit() == null) {
                    entryInfo2.setAssistUnit(materialInfo3.getAssistUnit());
                }
                if (entryInfo2.getBaseUnit() == null) {
                    entryInfo2.setBaseUnit(materialInfo3.getBaseUnit());
                }
                if (entryInfo2.getUnit() == null) {
                    entryInfo2.setUnit(materialInfo3.getBaseUnit());
                }
                if (entryInfo2.getWarehouse() == null || entryInfo2.getLocation() == null) continue;
                EntityViewInfo view3 = new EntityViewInfo();
                FilterInfo filter3 = new FilterInfo();
                filter3.appendFilterItem("number", (Object)entryInfo2.getLocation().getNumber());
                filter3.appendFilterItem("Warehouse.id", (Object)entryInfo2.getLocation().getId());
                view3.setFilter(filter3);
                col2 = iLocation.getLocationCollection(view3);
                if (col2.size() <= 0) continue;
                locationInfoValue2 = col2.get(0);
                entryInfo2.setLocation(locationInfoValue2);
            }
        }
        try {
            if (value instanceof ManufactureRecBillInfo) {
                imateral3 = MaterialFactory.getLocalInstance((Context)ctx);
                ILocation iLocation3 = LocationFactory.getLocalInstance((Context)ctx);
                IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
                ManufactureRecBillInfo manufactureRecBillInfo = (ManufactureRecBillInfo)value;
                CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
                logger.info((Object)("\u83b7\u53d6\u65e0\u6e90\u5355\u751f\u4ea7\u5165\u5e93\u8d22\u52a1\u7ec4\u7ec7\uff1a" + aCompanyOrgUnitInfo));
                IManufactureRecBill iIManufactureRecBill = ManufactureRecBillFactory.getLocalInstance((Context)ctx);
                ManufactureRecBillEntryCollection manuRecBillEntry = manufactureRecBillInfo.getEntry();
                int size = manuRecBillEntry.size();
                for (i = 0; i < size; ++i) {
                    entryInfo = manuRecBillEntry.get(i);
                    materialInfo = entryInfo.getMaterial();
                    if (materialInfo != null) {
                        if (materialInfo.getId() != null) {
                            materialInfo = imateral3.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
                        }
                        if (entryInfo.getAssistUnit() == null) {
                            entryInfo.setAssistUnit(materialInfo.getAssistUnit());
                        }
                        if (entryInfo.getBaseUnit() == null) {
                            entryInfo.setBaseUnit(materialInfo.getBaseUnit());
                        }
                        if (entryInfo.getUnit() == null) {
                            entryInfo.setUnit(materialInfo.getBaseUnit());
                        }
                    }
                    if (entryInfo.getLocation() != null && entryInfo.getWarehouse() != null) {
                        view = new EntityViewInfo();
                        filter = new FilterInfo();
                        filter.appendFilterItem("number", (Object)entryInfo.getLocation().getNumber());
                        filter.appendFilterItem("Warehouse.id", (Object)entryInfo.getLocation().getId());
                        view.setFilter(filter);
                        col = iLocation3.getLocationCollection(view);
                        if (col.size() > 0) {
                            locationInfoValue = col.get(0);
                            entryInfo.setLocation(locationInfoValue);
                        }
                    }
                    if (entryInfo.getWarehouse() != null && manufactureRecBillInfo.getStorageOrgUnit() == null) {
                        coll = new SelectorItemCollection();
                        coll.add(new SelectorItemInfo("id"));
                        coll.add(new SelectorItemInfo("storageOrg.id"));
                        warehouseInfo = iWarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(entryInfo.getWarehouse().getId()));
                        manufactureRecBillInfo.setStorageOrgUnit(warehouseInfo.getStorageOrg());
                    }
                    if (aCompanyOrgUnitInfo != null) {
                        costObjectInfo = iIManufactureRecBill.getDefaultCostObject(materialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString(), null);
                        entryInfo.setCostObject(costObjectInfo);
                    }
                    if (entryInfo.getStorageOrgUnit() != null) continue;
                    entryInfo.setStorageOrgUnit(manufactureRecBillInfo.getStorageOrgUnit());
                }
                if (manufactureRecBillInfo.getStorageOrgUnit() == null) {
                    value.put("storageOrgUnit", (Object)ContextUtil.getCurrentStorageUnit((Context)ctx));
                }
                if (manufactureRecBillInfo.getCostCenterOrgUnit() == null) {
                    value.put("costCenterOrgUnit", (Object)ContextUtil.getCurrentCostUnit((Context)ctx));
                }
                value.put("entry", (Object)manufactureRecBillInfo.getEntry());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (value instanceof MaterialReqBillInfo) {
            MaterialReqBillInfo materialReqBillInfo = (MaterialReqBillInfo)value;
            imateral2 = MaterialFactory.getLocalInstance((Context)ctx);
            iLocation = LocationFactory.getLocalInstance((Context)ctx);
            IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
            IManufactureRecBill iIManufactureRecBill = ManufactureRecBillFactory.getLocalInstance((Context)ctx);
            if (materialReqBillInfo.getSupplyStoreOrgUnit() == null) {
                materialReqBillInfo.setSupplyStoreOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            if (materialReqBillInfo.getSupplyCompanyOrgUnit() == null) {
                materialReqBillInfo.setSupplyCompanyOrgUnit(ContextUtil.getCurrentFIUnit((Context)ctx));
            }
            if (materialReqBillInfo.getStorageOrgUnit() == null) {
                materialReqBillInfo.setStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            if (materialReqBillInfo.getCostCenterOrgUnit() == null) {
                materialReqBillInfo.setCostCenterOrgUnit(ContextUtil.getCurrentCostUnit((Context)ctx));
            }
            materialReqBillInfo.setIsInitBill(false);
            CompanyOrgUnitInfo companyOrgUnitInfo = materialReqBillInfo.getSupplyCompanyOrgUnit();
            MaterialReqBillEntryCollection materialReqEntry = materialReqBillInfo.getEntry();
            int size = materialReqEntry.size();
            for (i = 0; i < size; ++i) {
                entryInfo = materialReqEntry.get(i);
                materialInfo = entryInfo.getMaterial();
                if (materialInfo != null) {
                    if (materialInfo.getId() != null) {
                        materialInfo = imateral2.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
                    }
                    if (entryInfo.getAssistUnit() == null) {
                        entryInfo.setAssistUnit(materialInfo.getAssistUnit());
                    }
                    if (entryInfo.getBaseUnit() == null) {
                        entryInfo.setBaseUnit(materialInfo.getBaseUnit());
                    }
                    if (entryInfo.getUnit() == null) {
                        entryInfo.setUnit(materialInfo.getBaseUnit());
                    }
                }
                if (entryInfo.getLocation() != null && entryInfo.getWarehouse() != null) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.appendFilterItem("number", (Object)entryInfo.getLocation().getNumber());
                    filter.appendFilterItem("Warehouse.id", (Object)entryInfo.getLocation().getId());
                    view.setFilter(filter);
                    col = iLocation.getLocationCollection(view);
                    if (col.size() > 0) {
                        locationInfoValue = col.get(0);
                        entryInfo.setLocation(locationInfoValue);
                    }
                }
                if (entryInfo.getWarehouse() != null) {
                    coll = new SelectorItemCollection();
                    coll.add(new SelectorItemInfo("id"));
                    coll.add(new SelectorItemInfo("storageOrg.id"));
                    coll.add(new SelectorItemInfo("whman.id"));
                    warehouseInfo = iWarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(entryInfo.getWarehouse().getId()));
                    entryInfo.setStocker(warehouseInfo.getWhman());
                    if (materialReqBillInfo.getStorageOrgUnit() == null) {
                        materialReqBillInfo.setStorageOrgUnit(warehouseInfo.getStorageOrg());
                    }
                }
                if (entryInfo.getCostCenterOrgUnit() == null) {
                    entryInfo.setCostCenterOrgUnit(ContextUtil.getCurrentCostUnit((Context)ctx));
                }
                if (companyOrgUnitInfo != null && entryInfo.getCostObject() == null) {
                    costObjectInfo = iIManufactureRecBill.getDefaultCostObject(materialInfo.getId().toString(), companyOrgUnitInfo.getId().toString(), entryInfo.getLot());
                    entryInfo.setCostObject(costObjectInfo);
                }
                if (entryInfo.getSupplyWarehouse() == null) {
                    entryInfo.setSupplyWarehouse(entryInfo.getWarehouse());
                }
                if (entryInfo.getSupplyLocation() == null) {
                    entryInfo.setSupplyLocation(entryInfo.getLocation());
                }
                if (entryInfo.getStorageOrgUnit() != null) continue;
                entryInfo.setStorageOrgUnit(materialReqBillInfo.getStorageOrgUnit());
            }
        }
        if (value instanceof OtherIssueBillInfo) {
            OtherIssueBillInfo otherIssueInfo = (OtherIssueBillInfo)value;
            if (otherIssueInfo.getStorageOrgUnit() == null) {
                otherIssueInfo.setStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            imateral2 = MaterialFactory.getLocalInstance((Context)ctx);
            iLocation = LocationFactory.getLocalInstance((Context)ctx);
            int size = otherIssueInfo.getEntry().size();
            for (int i6 = 0; i6 < size; ++i6) {
                entryInfo2 = otherIssueInfo.getEntry().get(i6);
                MaterialInfo materialInfo4 = entryInfo2.getMaterial();
                if (materialInfo4.getId() != null) {
                    materialInfo4 = imateral2.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo4.getId()));
                }
                if (entryInfo2.getAssistUnit() == null) {
                    entryInfo2.setAssistUnit(materialInfo4.getAssistUnit());
                }
                if (entryInfo2.getBaseUnit() == null) {
                    entryInfo2.setBaseUnit(materialInfo4.getBaseUnit());
                }
                if (entryInfo2.getUnit() == null) {
                    entryInfo2.setUnit(materialInfo4.getBaseUnit());
                }
                if (entryInfo2.getLocation() == null || entryInfo2.getWarehouse() == null) continue;
                EntityViewInfo view4 = new EntityViewInfo();
                FilterInfo filter4 = new FilterInfo();
                filter4.appendFilterItem("number", (Object)entryInfo2.getLocation().getNumber());
                filter4.appendFilterItem("Warehouse.id", (Object)entryInfo2.getLocation().getId());
                view4.setFilter(filter4);
                col2 = iLocation.getLocationCollection(view4);
                if (col2.size() <= 0) continue;
                locationInfoValue2 = col2.get(0);
                entryInfo2.setLocation(locationInfoValue2);
            }
        }
        if (value instanceof MoveIssueBillInfo) {
            imateral3 = MaterialFactory.getLocalInstance((Context)ctx);
            MoveIssueBillInfo moveIssueInfo = (MoveIssueBillInfo)value;
            if (moveIssueInfo instanceof MoveIssueBillInfo) {
                MoveIssueBillEntryCollection moveIssueEntry = moveIssueInfo.getEntry();
                int size = moveIssueEntry.size();
                for (int i7 = 0; i7 < size; ++i7) {
                    entryInfo2 = moveIssueEntry.get(i7);
                    MaterialInfo materialInfo5 = entryInfo2.getMaterial();
                    if (materialInfo5.getId() != null && (entryInfo2.getUnit() == null || entryInfo2.getBaseUnit() == null)) {
                        materialInfo5 = imateral3.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo5.getId()));
                    }
                    if (entryInfo2.getAssistUnit() == null) {
                        entryInfo2.setAssistUnit(materialInfo5.getAssistUnit());
                    }
                    if (entryInfo2.getBaseUnit() == null) {
                        entryInfo2.setBaseUnit(materialInfo5.getBaseUnit());
                    }
                    if (entryInfo2.getUnit() != null) continue;
                    entryInfo2.setUnit(materialInfo5.getBaseUnit());
                }
            }
        }
        if (value instanceof SaleIssueBillInfo) {
            billInfo = (SaleIssueBillInfo)value;
            ISaleIssueBill iBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
            imateral = MaterialFactory.getLocalInstance((Context)ctx);
            billInfo.setIsInitBill(false);
            if (billInfo.getStorageOrgUnit() == null) {
                billInfo.setStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            SaleIssueEntryInfo entryInfo6 = null;
            int size = billInfo.getEntry().size();
            for (int i8 = 0; i8 < size; ++i8) {
                MaterialInfo materialInfo6;
                entryInfo6 = billInfo.getEntry().get(i8);
                if (entryInfo6.getStorageOrgUnit() == null) {
                    entryInfo6.setStorageOrgUnit(billInfo.getStorageOrgUnit());
                }
                if (entryInfo6.getBaseStatus() == null) {
                    entryInfo6.setBaseStatus(EntryBaseStatusEnum.ADD);
                }
                if ((materialInfo6 = entryInfo6.getMaterial()).getId() != null && (entryInfo6.getAssistUnit() == null || entryInfo6.getUnit() == null || entryInfo6.getBaseUnit() == null)) {
                    materialInfo6 = imateral.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo6.getId()));
                }
                if (entryInfo6.getAssistUnit() == null) {
                    entryInfo6.setAssistUnit(materialInfo6.getAssistUnit());
                }
                if (entryInfo6.getBaseUnit() == null) {
                    entryInfo6.setBaseUnit(materialInfo6.getBaseUnit());
                }
                if (entryInfo6.getUnit() == null) {
                    entryInfo6.setUnit(materialInfo6.getBaseUnit());
                }
                if (billInfo.getCustomer() != null && entryInfo6.getBalanceCustomer() == null) {
                    entryInfo6.setBalanceCustomer(billInfo.getCustomer());
                }
                entryInfo6.setIsPresent(false);
            }
        }
        if (value instanceof FaStocktakingBillInfo) {
            FaStocktakingBillInfo faStocktakingBillInfo = (FaStocktakingBillInfo)value;
            EntityViewInfo entityView = new EntityViewInfo();
            SelectorItemCollection coll2 = new SelectorItemCollection();
            coll2.add(new SelectorItemInfo("assetCat.id"));
            coll2.add(new SelectorItemInfo("assetCat.name"));
            coll2.add(new SelectorItemInfo("assetCat.number"));
            coll2.add(new SelectorItemInfo("number"));
            coll2.add(new SelectorItemInfo("assetName"));
            coll2.add(new SelectorItemInfo("id"));
            coll2.add(new SelectorItemInfo("measureUnit.id"));
            coll2.add(new SelectorItemInfo("measureUnit.name"));
            coll2.add(new SelectorItemInfo("measureUnit.number"));
            entityView.setSelector(coll2);
            int size = faStocktakingBillInfo.getEntries().size();
            for (int i9 = 0; i9 < size; ++i9) {
                FaStocktakingBillEntryInfo entryInfo7 = faStocktakingBillInfo.getEntries().get(i9);
                if (entryInfo7.getBill() == null) {
                    entryInfo7.setBill(faStocktakingBillInfo);
                }
                if (entryInfo7.getAssetCat() != null || entryInfo7.getAssetNum() == null) continue;
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)CompareType.EQUALS));
                entityView.setFilter(filterInfo);
                FaCurCardCollection facurCol = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection(entityView);
                if (facurCol.size() <= 0) continue;
                FaCurCardInfo facurCardInfo = facurCol.get(0);
                entryInfo7.setAssetCat(facurCardInfo.getAssetCat());
                entryInfo7.setAssetName(facurCardInfo.getAssetName());
                if (entryInfo7.getMeasureUnit() != null) continue;
                entryInfo7.setMeasureUnit(facurCardInfo.getMeasureUnit());
            }
        }
        if (value instanceof InvStateAdjustBillInfo) {
            billInfo = (InvStateAdjustBillInfo)value;
            imateral2 = MaterialFactory.getLocalInstance((Context)ctx);
            billInfo.setIsInitBill(false);
            if (billInfo.getStorageOrgUnit() == null) {
                billInfo.setStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            InvStateAdjustBillEntryInfo entryInfo8 = null;
            int size = billInfo.getEntry().size();
            for (int i10 = 0; i10 < size; ++i10) {
                MaterialInfo materialInfo7;
                entryInfo8 = billInfo.getEntry().get(i10);
                if (entryInfo8.getStorageOrgUnit() == null) {
                    entryInfo8.setStorageOrgUnit(billInfo.getStorageOrgUnit());
                }
                if (entryInfo8.getBaseStatus() == null) {
                    entryInfo8.setBaseStatus(EntryBaseStatusEnum.ADD);
                }
                if ((materialInfo7 = entryInfo8.getMaterial()).getId() != null && (entryInfo8.getAssistUnit() == null || entryInfo8.getUnit() == null || entryInfo8.getBaseUnit() == null)) {
                    materialInfo7 = imateral2.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo7.getId()));
                }
                if (entryInfo8.getAssistUnit() == null) {
                    entryInfo8.setAssistUnit(materialInfo7.getAssistUnit());
                }
                if (entryInfo8.getBaseUnit() == null) {
                    entryInfo8.setBaseUnit(materialInfo7.getBaseUnit());
                }
                if (entryInfo8.getUnit() != null) continue;
                entryInfo8.setUnit(materialInfo7.getBaseUnit());
            }
            this.checkInvStateAdjust(ctx, value);
        }
        if (value instanceof MoveLocationBillInfo) {
            MoveLocationBillInfo moveLocationInfo = (MoveLocationBillInfo)value;
            IWarehouse iwarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
            imateral = MaterialFactory.getLocalInstance((Context)ctx);
            if (moveLocationInfo.getStorageOrgUnit() == null) {
                moveLocationInfo.setStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            int size = moveLocationInfo.getEntry().size();
            for (int i11 = 0; i11 < size; ++i11) {
                MoveLocationBillEntryInfo entryInfo9 = moveLocationInfo.getEntry().get(i11);
                MaterialInfo materialInfo8 = entryInfo9.getMaterial();
                if (materialInfo8.getId() != null && (entryInfo9.getAssistUnit() == null || entryInfo9.getUnit() == null || entryInfo9.getBaseUnit() == null)) {
                    materialInfo8 = imateral.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo8.getId()));
                }
                if (entryInfo9.getAssistUnit() == null) {
                    entryInfo9.setAssistUnit(materialInfo8.getAssistUnit());
                }
                if (entryInfo9.getBaseUnit() == null) {
                    entryInfo9.setBaseUnit(materialInfo8.getBaseUnit());
                }
                if (entryInfo9.getUnit() == null) {
                    entryInfo9.setUnit(materialInfo8.getBaseUnit());
                }
                if (entryInfo9.getStoreStatus() == null) {
                    entryInfo9.setStoreStatus(StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateInfo(" where name='\u53ef\u7528' "));
                }
                if (entryInfo9.getStoreType() == null) {
                    entryInfo9.setStoreType(StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo(" where name='\u666e\u901a' "));
                }
                if (entryInfo9.getWarehouse() != null && entryInfo9.getWarehouse().getWhman() != null) {
                    entryInfo9.setStocker(entryInfo9.getWarehouse().getWhman());
                } else {
                    entryInfo9.setStocker(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() : null);
                }
                if (entryInfo9.getStorageOrgUnit() == null) {
                    if (entryInfo9.getWarehouse() != null) {
                        WarehouseInfo warehouseInfo2 = iwarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(entryInfo9.getWarehouse().getId()));
                        entryInfo9.setStorageOrgUnit(warehouseInfo2.getStorageOrg());
                    } else {
                        entryInfo9.setStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
                    }
                }
                if (entryInfo9.getCompanyOrgUnit() != null) continue;
                entryInfo9.setCompanyOrgUnit(ContextUtil.getCurrentFIUnit((Context)ctx));
            }
        }
        new ScmDataProcess().beforeSaveEasBill(ctx, value);
    }

    private void initContext(Context ctx) throws BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        try {
            OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).orgSwitch(user.getDefOrgUnit().getId().toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException("\u7528\u6237\u65e0\u7f3a\u7701\u7ec4\u7ec7");
        }
    }

    public ICoreBase getInterface(Context ctx, EntityObjectInfo entity) throws BOSException {
        return (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entity.getType());
    }

    public IObjectValue getNewObjectValue(Context ctx, EntityObjectInfo entity, boolean autoDefault) {
        IObjectValue result = null;
        try {
            result = (IObjectValue)Class.forName(entity.getObjectValueClassRuntime()).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected void _uploadBarcodeBill(Context ctx, IObjectValue barcodeScanningInfo) throws BOSException, EASBizException {
    }

    @Override
    protected String _uploadBarcodeBill(Context ctx, List barcodeBillList, String defaultSolutionId, String srcBosType, String bosType, String botpId) throws BOSException, EASBizException {
        BarcodeDefaultSolutionInfo solInfo;
        long time = System.currentTimeMillis();
        logger.info((Object)(" uploadBarcodeBill begin\uff1a" + time));
        if (barcodeBillList == null || barcodeBillList.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        boolean isBotp = false;
        if (botpId != null && !"".equals(botpId.trim())) {
            if (srcBosType == null || "".equals(srcBosType.trim())) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"67_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
            }
            isBotp = true;
        }
        EntityObjectInfo entity = BarcodeUtils.getEntityByBosType(bosType);
        this.barcodeScanningId = ((BarcodeScanningRecodeInfo)barcodeBillList.get(0)).getFparentId();
        if (defaultSolutionId != null && !"".equals(defaultSolutionId) && (solInfo = BarcodeDefaultSolutionFactory.getLocalInstance(ctx).getBarcodeDefaultSolutionInfo((IObjectPK)new ObjectUuidPK(defaultSolutionId))) != null) {
            this.fillDefaultSolution(ctx, solInfo, barcodeBillList);
        }
        try {
            IObjectCollection easBills = (IObjectCollection)Class.forName(entity.getObjectCollectionClassRuntime()).newInstance();
            ArrayList<BOTRelationCollection> botReltes = new ArrayList<BOTRelationCollection>();
            HashMap relationMap = new HashMap();
            for (int i = 0; i < barcodeBillList.size(); ++i) {
                SelectorItemCollection sic;
                BarcodeScanningRecodeInfo recodeInfo = (BarcodeScanningRecodeInfo)barcodeBillList.get(i);
                IObjectValue easBill = null;
                if (isBotp) {
                    BOTMappingInfo mappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo(" where id = '" + botpId + "'");
                    String entryName = BOTMappingUtil.getDestEntriesName((BOTMappingInfo)mappingInfo);
                    String srcBillId = this.getSrcBillId(recodeInfo, entryName);
                    List srcEntriesKey = this.getSrcEntriesIds(recodeInfo, entryName);
                    if (srcEntriesKey.size() < -1) continue;
                    List rt = BotUtil.getSrcBillPropList((BOTMappingInfo)mappingInfo);
                    sic = new SelectorItemCollection();
                    int size = rt.size();
                    for (int j = 0; j < size; ++j) {
                        sic.add(new SelectorItemInfo(rt.get(j).toString()));
                    }
                    IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                    BTPTransformResult btpResult = iBTPManager.transformForBotp(new String[]{srcBillId}, new String[]{BOTMappingUtil.getSrcEntriesName((BOTMappingInfo)mappingInfo)}, srcEntriesKey, sic, bosType, (IObjectPK)new ObjectUuidPK(mappingInfo.getId().toString()), srcBosType);
                    IObjectCollection destBills = btpResult.getBills();
                    BOTRelationCollection botRelationColl = btpResult.getBOTRelationCollection();
                    if (destBills != null && destBills.size() > -1) {
                        easBill = destBills.getObject(0);
                        this.fillScanningToEasData(ctx, entity, recodeInfo, easBill, relationMap, BOTP_WAY);
                        BOTRelationInfo botRelationInfo = botRelationColl.get(0);
                        this.resetBotRelation(easBill, entryName, botRelationInfo);
                        botReltes.add(botRelationColl);
                    }
                } else {
                    String way = ADDNEW_WAY;
                    if (recodeInfo.getProperties().get("id") != null) {
                        way = FILL_WAY;
                        BarcodeScanningPropertyInfo property = recodeInfo.getProperties().get("id");
                        if (COUNTINGTABLE_BOSTYPE.equals(recodeInfo.getFbosType())) {
                            if (property.getValue() != null && !"null".equals(property.getValue().toString()) && !"".equals(property.getValue().toString())) {
                                String select = "select *,countingTask.number,storageOrgUnit.number,storageOrgUnit.name,warehouse.number,warehouse.name,countingPerson.number,countingPerson.name,countingAgainPerson.number,countingAgainPerson.name,countingMonitorer.number,entry.*,entry.location.number,entry.location.name,entry.material.number,entry.material.name,entry.storeType.number,entry.storeType.name,entry.unit.number,entry.unit.name,entry.assistUnit.number,entry.assistUnit.name,entry.storeStatus.number,entry.storeStatus.name";
                                String whereSql = select + " where id = '" + property.getValue() + "'";
                                ObjectBaseCollection collCount = ((IObjectBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)COUNTINGTABLE_BOSTYPE))).getObjectBaseCollection(whereSql);
                                easBill = collCount.getObject(0);
                            } else {
                                way = ADDNEW_WAY;
                            }
                        } else if (FACOUNTINGTABLE_BOSTYPE.equals(recodeInfo.getFbosType())) {
                            if (property.getValue() != null && !"null".equals(property.getValue().toString()) && !"".equals(property.getValue().toString())) {
                                List srcEntriesKey = this.getEntriesIds(recodeInfo, "entries");
                                StringBuffer entryIdStr = new StringBuffer();
                                int size = srcEntriesKey.size();
                                for (int j = 0; j < size; ++j) {
                                    if (entryIdStr.length() > 0) {
                                        entryIdStr.append("','").append(srcEntriesKey.get(j));
                                        continue;
                                    }
                                    entryIdStr.append(srcEntriesKey.get(j));
                                }
                                FaStocktakingBillInfo stockBillInfo = new FaStocktakingBillInfo();
                                stockBillInfo.setId(BOSUuid.read((String)property.getValue().toString()));
                                if (entryIdStr.length() > 0) {
                                    String select = "select assetCat.id,assetCat.number,assetCat.name,assetNum,assetName,specs,measureUnit.name,measureUnit.number,assetAmt,stocktakingAmt,address.id,address.*,economicPurp.id,economicPurp.*,useStatus.id,adminDept.*,entries.adminDept.*,bill.*,usePerson.id,usePerson.*,barcode,keeper.id,keeper.*,useDept.id,useDept.*,bill.id,bill.taskBill.number";
                                    String whereSql = select + " where id in('" + entryIdStr + "')";
                                    FaStocktakingBillEntryCollection stockbillCol = FaStocktakingBillEntryFactory.getLocalInstance((Context)ctx).getFaStocktakingBillEntryCollection(whereSql);
                                    if (stockbillCol.size() > 0) {
                                        stockBillInfo.putAll((IObjectValue)stockbillCol.get(0).getBill());
                                        stockBillInfo.getEntries().clear();
                                    } else {
                                        SelectorItemCollection sic2 = new SelectorItemCollection();
                                        sic2.add("id");
                                        sic2.add("taskBill.id");
                                        sic2.add("taskBill.number");
                                        stockBillInfo = FaStocktakingBillFactory.getLocalInstance((Context)ctx).getFaStocktakingBillInfo((IObjectPK)new ObjectUuidPK(property.getValue().toString()), sic2);
                                        stockBillInfo.getEntries().clear();
                                    }
                                    stockBillInfo.getEntries().addCollection(stockbillCol);
                                } else {
                                    sic = new SelectorItemCollection();
                                    sic.add("id");
                                    sic.add("taskBill.id");
                                    sic.add("taskBill.number");
                                    stockBillInfo = FaStocktakingBillFactory.getLocalInstance((Context)ctx).getFaStocktakingBillInfo((IObjectPK)new ObjectUuidPK(property.getValue().toString()), sic);
                                    stockBillInfo.getEntries().clear();
                                }
                                easBill = stockBillInfo;
                            } else {
                                way = ADDNEW_WAY;
                            }
                        } else {
                            String id = property.getValue().toString();
                            ICoreBase icoreBase = this.getInterface(ctx, entity);
                            if (icoreBase.exists((IObjectPK)new ObjectUuidPK(id))) {
                                if (icoreBase instanceof ISaleIssueBill) {
                                    ISaleIssueBill iSaleIssueBill = (ISaleIssueBill)icoreBase;
                                    easBill = iSaleIssueBill.getValue((IObjectPK)new ObjectUuidPK(id), BillServerUtil.getSelectors());
                                } else {
                                    easBill = icoreBase.getValue((IObjectPK)new ObjectUuidPK(id));
                                }
                            }
                        }
                    }
                    if (easBill == null) {
                        easBill = this.getNewObjectValue(ctx, entity, true);
                    }
                    this.fillScanningToEasData(ctx, entity, recodeInfo, easBill, relationMap, way);
                    botReltes.add(null);
                }
                if (!COUNTINGTABLE_BOSTYPE.equals(bosType)) {
                    this.fillNullFields(easBill, entity);
                }
                easBill.put(SCANNING_RECODEID, (Object)recodeInfo.getFid());
                easBill.put(SCANNING_TABLENAME, (Object)("T_BC_" + recodeInfo.getFbosType()));
                BillTypeInfo billType = this.getBillType(ctx, easBill.getBOSType().toString());
                if (billType != null) {
                    easBill.put("billType", (Object)billType);
                }
                easBills.addObject(easBill);
            }
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" uploadBarcodeBill end\uff1a" + time));
            return this._uploadEasBill(ctx, easBills, botReltes, bosType, relationMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private BillTypeInfo getBillType(Context ctx, String bosType) throws EASBizException, BOSException {
        BillTypeInfo billType = null;
        if (FACOUNTINGTABLE_BOSTYPE.equals(bosType)) {
            return billType;
        }
        try {
            billType = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo("where bosType='" + bosType + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return billType;
    }

    protected void resetBotRelation(IObjectValue easBill, String entryName, BOTRelationInfo botRelationInfo) {
        IObjectCollection billBaseEntries = (IObjectCollection)easBill.get(entryName);
        BOTRelationEntryCollection newRelationEntries = new BOTRelationEntryCollection();
        for (int j = 0; j < billBaseEntries.size(); ++j) {
            IObjectValue objValue = billBaseEntries.getObject(j);
            String srcEntryId = objValue.getString(SRCBILLENTRYID);
            BOTRelationEntryInfo botEntryInfo = this.getBotEntryBySrcEntryId(botRelationInfo, srcEntryId);
            botEntryInfo.setDestEntryID(objValue.getString("id"));
            if (botEntryInfo == null) continue;
            newRelationEntries.add(botEntryInfo);
        }
        botRelationInfo.remove("relationEntries");
        botRelationInfo.put("relationEntries", (Object)newRelationEntries);
    }

    private BOTRelationEntryInfo getBotEntryBySrcEntryId(BOTRelationInfo botRelationInfo, String srcEntryId) {
        for (int i = 0; i < botRelationInfo.getRelationEntries().size(); ++i) {
            BOTRelationEntryInfo entry = botRelationInfo.getRelationEntries().get(i);
            if (srcEntryId == null || !srcEntryId.equals(entry.getSrcEntryID())) continue;
            BOTRelationEntryInfo newEntryInfo = new BOTRelationEntryInfo();
            newEntryInfo.putAll((IObjectValue)entry);
            newEntryInfo.put("id", (Object)BOSUuid.create((String)entry.getBOSType().toString()));
            return newEntryInfo;
        }
        return null;
    }

    private void fillNullFields(IObjectValue easBill, EntityObjectInfo entity) {
        for (int i = 0; i < entity.getEntityProperties().size(); ++i) {
            PropertyInfo pp = entity.getEntityProperties().get(i);
            String dataType = (String)pp.get("dataType");
            String field = pp.getName();
            if (dataType == null || easBill.get(field) != null) continue;
            if ("BigDecimal".equals(dataType)) {
                easBill.setBigDecimal(field, new BigDecimal("0.00"));
                continue;
            }
            if ("Boolean".equals(dataType) || !"Integer".equals(dataType)) continue;
            easBill.setInt(field, 0);
        }
    }

    public void fillScanningToEasData(Context ctx, EntityObjectInfo entity, BarcodeScanningRecodeInfo recodeInfo, IObjectValue easValue, Map relationMap, String way) throws InstantiationException, IllegalAccessException, ClassNotFoundException, EASBizException, BOSException {
        if (recodeInfo == null || recodeInfo.getProperties() == null) {
            return;
        }
        Iterator<String> it = recodeInfo.getProperties().keySet().iterator();
        if (easValue.get("id") == null) {
            easValue.put("id", (Object)BOSUuid.create((String)easValue.getBOSType().toString()));
        }
        HashMap<String, String> reWrite = new HashMap<String, String>();
        reWrite.put(REWRITE_TABLE, "T_BC_" + recodeInfo.getFbosType());
        reWrite.put("FEASID", easValue.get("id").toString());
        relationMap.put(recodeInfo.getFid(), reWrite);
        boolean isTableInfo = false;
        if (easValue instanceof CountingTableEntryInfo || easValue instanceof FaStocktakingBillEntryInfo) {
            isTableInfo = true;
        }
        while (it.hasNext()) {
            String temp = it.next();
            BarcodeScanningPropertyInfo property = recodeInfo.getProperties().get(temp);
            if (property.getKey().equals("id") || property.getKey().equalsIgnoreCase("number") && easValue.get(property.getKey()) != null) continue;
            if (property.getKey().indexOf("_") > -1) {
                if (!property.getKey().split("_")[1].equalsIgnoreCase("number")) continue;
                String key = property.getKey().split("_")[0];
                if (property.getValue() == null || "".equals(property.getValue())) continue;
                this.handleLinkProperty(ctx, key, property.getValue().toString(), easValue, entity);
                continue;
            }
            PropertyInfo propertyInfo = entity.getPropertyByName(property.getKey());
            if (propertyInfo == null) continue;
            if (isTableInfo && recodeInfo.isPDA() && "countingQty".equals(property.getKey()) && easValue.get(property.getKey()) != null && property.getValue() != null) {
                BigDecimal countingQty = new BigDecimal(easValue.get(property.getKey()).toString());
                BigDecimal newQty = new BigDecimal(property.getValue().toString());
                property.setValue(countingQty.add(newQty));
            }
            BarcodeUtils.putValue(easValue, propertyInfo, property.getKey(), property.getValue());
        }
        if (recodeInfo != null && recodeInfo.getEntriesMap() != null) {
            for (String entryName : recodeInfo.getEntriesMap().keySet()) {
                List<BarcodeScanningRecodeInfo> entries = recodeInfo.getEntriesMap().get(entryName);
                IObjectCollection destColl = (IObjectCollection)easValue.get(entryName);
                if (entries == null || entries.size() <= 0) continue;
                LinkedHashMap<String, IObjectValue> exstsMap = new LinkedHashMap<String, IObjectValue>();
                EntityObjectInfo entryEntity = BarcodeUtils.getEntityByBosType(entries.get(0).getFbosType());
                IObjectCollection entryColl = (IObjectCollection)Class.forName(entryEntity.getObjectCollectionClassRuntime()).newInstance();
                CoreBaseCollection backCol = new CoreBaseCollection();
                CoreBaseCollection barcodeDossierCol = new CoreBaseCollection();
                IBarcodeDossier iBarcodeDossier = BarcodeDossierFactory.getLocalInstance(ctx);
                String transferNumber = null;
                if (easValue.get("transactionType") != null && easValue.get("transactionType") instanceof TransactionTypeInfo) {
                    transferNumber = ((TransactionTypeInfo)easValue.get("transactionType")).getNumber();
                }
                boolean isUpdate = false;
                if (2 == BarcodeClientUtils.getInOrOutBill(ctx, easValue.getBOSType().toString(), transferNumber)) {
                    isUpdate = true;
                }
                boolean isEntryAddNew = false;
                for (int i = 0; i < entries.size(); ++i) {
                    BarcodeScanningRecodeInfo bsri = entries.get(i);
                    IObjectValue entry = null;
                    if (way.equals(BOTP_WAY)) {
                        entry = this.getEntryBySourceId(ctx, destColl, bsri.getFsrcBillId(), bsri.getFsrcEntryId(), entryEntity);
                    } else if (way.equals(ADDNEW_WAY)) {
                        entry = this.getNewObjectValue(ctx, entryEntity, true);
                    } else if (way.equals(FILL_WAY) && (entry = this.getEntryByEasValue(ctx, destColl, bsri, entryEntity, exstsMap)).get("id") == null) {
                        isEntryAddNew = true;
                    }
                    if (entry != null) {
                        if (!"CF0E4015".equals(entryEntity.getType().toString()) && !"5FD5E4B5".equals(entryEntity.getType().toString())) {
                            this.fillNullFields(entry, entity);
                        }
                        this.fillScanningToEasData(ctx, entryEntity, bsri, entry, relationMap, way);
                        if (way.equals(FILL_WAY)) {
                            if (isEntryAddNew) {
                                entryColl.addObject(entry);
                            }
                        } else {
                            entryColl.addObject(entry);
                        }
                    }
                    int size = bsri.getBarcodeList().size();
                    for (int j = 0; j < size; ++j) {
                        BarcodeScanningBarcodeInfo barcodeInfo = bsri.getBarcodeList().get(j);
                        IndBarcodeBackInfo backInfo = new IndBarcodeBackInfo();
                        backInfo.setId(BOSUuid.create((BOSObjectType)backInfo.getBOSType()));
                        backInfo.setNumber(backInfo.getId().toString());
                        backInfo.setName(barcodeInfo.getBarcode());
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("qty"));
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("number"));
                        sic.add(new SelectorItemInfo("barRule.id"));
                        sic.add(new SelectorItemInfo("barRule.Entry.id"));
                        sic.add(new SelectorItemInfo("barRule.Entry.name"));
                        sic.add(new SelectorItemInfo("barRule.Entry.type"));
                        sic.add(new SelectorItemInfo("barRule.Entry.*"));
                        viewInfo.setSelector(sic);
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcodeInfo.getBarcode(), CompareType.EQUALS));
                        viewInfo.setFilter(filterInfo);
                        BarcodeDossierCollection dossiercol = null;
                        BigDecimal barcodeQty = BigDecimal.ZERO;
                        try {
                            dossiercol = iBarcodeDossier.getBarcodeDossierCollection(viewInfo);
                            if (dossiercol.size() > 0) {
                                BarcodeDossierInfo dossierInfo = dossiercol.get(0);
                                barcodeQty = dossierInfo.getQty();
                                if (isUpdate) {
                                    if (entry.get("warehouse") != null && entry.get("warehouse") instanceof WarehouseInfo) {
                                        dossierInfo.put("warehouse", ((WarehouseInfo)entry.get("warehouse")).getNumber());
                                    }
                                    if (entry.get("location") != null && entry.get("location") instanceof LocationInfo) {
                                        dossierInfo.put("location", ((LocationInfo)entry.get("location")).getNumber());
                                    }
                                    barcodeDossierCol.add((CoreBaseInfo)dossierInfo);
                                }
                            }
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        if (barcodeInfo.getBarcodeQty() == null) {
                            backInfo.setBarcodeQty(barcodeQty);
                        } else {
                            backInfo.setBarcodeQty(barcodeInfo.getBarcodeQty());
                        }
                        backInfo.setBizDate(new Date());
                        if (entity.getPropertyByName("billType") != null && backInfo.getBillType() == null && !FACOUNTINGTABLE_BOSTYPE.equals(easValue.getBOSType().toString())) {
                            backInfo.setBillType(this.getBillType(ctx, easValue.getBOSType().toString()));
                        }
                        if (easValue.get("bizType") != null) {
                            backInfo.setBizType((BizTypeInfo)easValue.get("bizType"));
                        }
                        backInfo.setRowNum(entry.get("id") == null ? "" : entry.get("id").toString());
                        backInfo.setCreateTime(this.getTime());
                        backInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                        backInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                        backCol.addObject((IObjectValue)backInfo);
                    }
                }
                if (way.equals(FILL_WAY)) {
                    if (entryColl.size() > 0) {
                        destColl.addObjectCollection(entryColl);
                        easValue.put(entryName, (Object)destColl);
                    }
                } else {
                    easValue.put(entryName, (Object)entryColl);
                }
                if (backCol.size() > 0) {
                    easValue.put("barcodeBack", (Object)backCol);
                    easValue.put("barcodeDossierCol", (Object)barcodeDossierCol);
                }
                easValue.put("entryName", (Object)entryName);
                easValue.put("bosType", (Object)entries.get(0).getFbosType());
            }
        }
    }

    private IObjectValue getEntryByEasValue(Context ctx, IObjectCollection coll, BarcodeScanningRecodeInfo bsri, EntityObjectInfo entryEntity, Map<String, IObjectValue> exstsMap) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String id = null;
        if (bsri.getProperties().get("id") != null) {
            BarcodeScanningPropertyInfo bspi = bsri.getProperties().get("id");
            id = (String)bspi.getValue();
            for (int i = 0; i < coll.size(); ++i) {
                IObjectValue obj = coll.getObject(i);
                if (obj.get("id") == null || !obj.get("id").toString().equals(id)) continue;
                if (exstsMap.containsKey(id)) {
                    IObjectValue newObj = this.getNewObjectValue(ctx, entryEntity, true);
                    newObj.putAll(obj);
                    newObj.put("id", null);
                    return newObj;
                }
                exstsMap.put(id, obj);
                return obj;
            }
        }
        return this.getNewObjectValue(ctx, entryEntity, true);
    }

    public void handleLinkProperty(Context ctx, String key, String number, IObjectValue bill, EntityObjectInfo entity) throws EASBizException, BOSException {
        PropertyInfo property = entity.getPropertyByName(key);
        if (property != null && property instanceof LinkPropertyInfo) {
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            if (relation.getType().equals((Object)RelationshipType.COMPOSITION)) {
                return;
            }
            EntityObjectInfo fieldEntity = relation.getSupplierObject();
            String cacheKey = fieldEntity.getType().toString() + "|" + number;
            if (this.dataCache.get(cacheKey) == null) {
                ICoreBase coreBase = this.getInterface(ctx, fieldEntity);
                try {
                    CoreBaseCollection coreBarcol;
                    CoreBaseInfo coreBaseInfo = null;
                    if (coreBase instanceof ILocation) {
                        if (bill.get("warehouse") != null) {
                            IObjectValue warehouseInfo = (IObjectValue)bill.get("warehouse");
                            String warehouseId = warehouseInfo.get("id").toString();
                            ILocation iLocation = LocationFactory.getLocalInstance((Context)ctx);
                            EntityViewInfo view = new EntityViewInfo();
                            FilterInfo filter = new FilterInfo();
                            filter.appendFilterItem("number", (Object)number);
                            filter.appendFilterItem("Warehouse.id", (Object)warehouseId);
                            view.setFilter(filter);
                            CoreBaseCollection col = iLocation.getCollection(view);
                            if (col.size() > 0) {
                                coreBaseInfo = col.get(0);
                            }
                        } else {
                            EntityViewInfo view = new EntityViewInfo();
                            FilterInfo filter = new FilterInfo();
                            filter.appendFilterItem("number", (Object)number);
                            view.setFilter(filter);
                            CoreBaseCollection col = coreBase.getCollection(view);
                            if (col.size() > 0) {
                                coreBaseInfo = col.get(0);
                            }
                        }
                    }
                    if (coreBase instanceof IWarehouse && bill.get("location") != null) {
                        ILocation iLocation = LocationFactory.getLocalInstance((Context)ctx);
                        IObjectValue locationInfo = (IObjectValue)bill.get("location");
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.appendFilterItem("number", locationInfo.get("number"));
                        filter.appendFilterItem("Warehouse.number", (Object)number);
                        view.setFilter(filter);
                        CoreBaseCollection col = iLocation.getCollection(view);
                        if (col.size() > 0) {
                            CoreBaseInfo locationInfoValue = col.get(0);
                            bill.put("location", (Object)locationInfoValue);
                        }
                    }
                    if (coreBaseInfo == null && (coreBarcol = coreBase.getCollection("select id,number where number='" + number + "'")).size() > 0) {
                        coreBaseInfo = coreBarcol.get(0);
                    }
                    this.dataCache.put(cacheKey, coreBaseInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new EASBizException(new NumericExceptionSubItem("", "[" + entity.getAlias() + "." + fieldEntity.getAlias() + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"68_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"69_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                }
            }
            bill.put(key, this.dataCache.get(cacheKey));
        }
    }

    public IObjectValue getEntryBySourceId(Context ctx, IObjectCollection coll, String srcBillId, String srcEntryId, EntityObjectInfo entryEntity) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        for (int i = 0; i < coll.size(); ++i) {
            IObjectValue obj = coll.getObject(i);
            if (srcBillId == null || srcEntryId == null || !srcBillId.equals(obj.getString(SRCBILLID)) || !srcEntryId.equals(obj.getString(SRCBILLENTRYID))) continue;
            IObjectValue value = this.getCloneInfo(ctx, obj, entryEntity);
            return value;
        }
        return null;
    }

    public IObjectValue getCloneInfo(Context ctx, IObjectValue source, EntityObjectInfo entryEntity) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        IObjectValue value = this.getNewObjectValue(ctx, entryEntity, true);
        value.putAll(source);
        value.put("id", (Object)BOSUuid.create((String)entryEntity.getType().toString()));
        return value;
    }

    public String getSrcBillId(BarcodeScanningRecodeInfo recodeInfo, String entryKey) {
        List<BarcodeScanningRecodeInfo> entryList = recodeInfo.getEntriesMap().get(entryKey);
        if (entryList != null && entryList.size() > 0) {
            return entryList.get(0).getFsrcBillId();
        }
        return null;
    }

    public List getSrcEntriesIds(BarcodeScanningRecodeInfo recodeInfo, String entryKey) {
        List<BarcodeScanningRecodeInfo> entryList = recodeInfo.getEntriesMap().get(entryKey);
        ArrayList<String> result = new ArrayList<String>();
        if (entryList != null && entryList.size() > 0) {
            for (int i = 0; i < entryList.size(); ++i) {
                String fsrcEntryID = entryList.get(i).getFsrcEntryId();
                if (fsrcEntryID == null || "".equals(fsrcEntryID)) continue;
                result.add(fsrcEntryID);
            }
        }
        return result;
    }

    public List getEntriesIds(BarcodeScanningRecodeInfo recodeInfo, String entryKey) {
        List<BarcodeScanningRecodeInfo> entryList = recodeInfo.getEntriesMap().get(entryKey);
        ArrayList<String> result = new ArrayList<String>();
        if (entryList != null && entryList.size() > 0) {
            for (int i = 0; i < entryList.size(); ++i) {
                String fid = entryList.get(i).getFid();
                if (fid == null || "".equals(fid)) continue;
                result.add(fid);
            }
        }
        return result;
    }

    public String getBarcodeScanningId() {
        return this.barcodeScanningId;
    }

    public void setBarcodeScanningId(String barcodeScanningId) {
        this.barcodeScanningId = barcodeScanningId;
    }

    public void fillDefaultSolution(Context ctx, BarcodeDefaultSolutionInfo dsi, List<BarcodeScanningRecodeInfo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            BarcodeScanningRecodeInfo recodeInfo = list.get(i);
            this.fillDefaultSolution(ctx, dsi, recodeInfo);
        }
    }

    public void fillDefaultSolution(Context ctx, BarcodeDefaultSolutionInfo dsi, BarcodeScanningRecodeInfo recodeInfo) {
        if (recodeInfo == null || dsi == null || dsi.getDetailsXML() == null || !dsi.getEntityBosType().trim().equals(recodeInfo.getFbosType())) {
            return;
        }
        BarcodeDefaultXMLInfo defaultXmlInfo = BarcodeXMLHelper.toBarcodeDefaultXMLInfo(dsi.getDetailsXML());
        for (int i = 0; i < defaultXmlInfo.getItems().size(); ++i) {
            BarcodeDefaultXMLItem item = defaultXmlInfo.getItems().get(i);
            String fullField = item.getField();
            String[] fields = fullField.split("\\.");
            if (fields.length > 2) continue;
            if (fields.length == 2) {
                List<BarcodeScanningRecodeInfo> list = recodeInfo.getEntriesMap().get(fields[0]);
                if (list == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    this.fillLeafProperty(fields[1], list.get(j), item);
                }
                continue;
            }
            this.fillLeafProperty(fields[0], recodeInfo, item);
        }
    }

    public void fillLeafProperty(String field, BarcodeScanningRecodeInfo recode, BarcodeDefaultXMLItem item) {
        BarcodeScanningPropertyInfo newProperty;
        if (item == null || recode == null) {
            return;
        }
        if (item.getName() != null) {
            field = field + "_number";
        }
        BarcodeScanningPropertyInfo property = recode.getProperties().get(field);
        if (item.getDataType() != null && "Boolean".equals(item.getDataType())) {
            newProperty = new BarcodeScanningPropertyInfo();
            newProperty.setKey(field);
            newProperty.setValue(item.getValue());
            recode.putProperty(field, newProperty);
        }
        if (property == null || property.getValue() == null || "".equals(property.getValue())) {
            newProperty = new BarcodeScanningPropertyInfo();
            newProperty.setKey(field);
            newProperty.setValue(item.getValue());
            recode.putProperty(field, newProperty);
        }
    }

    private boolean isNeedSaveEntries(Context ctx, BOTMappingInfo mappingInfo) throws EASBizException, BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo srcEntity = loader.getEntity(BOSObjectType.create((String)mappingInfo.getSrcEntityName()));
        EntityObjectInfo destEntity = loader.getEntity(BOSObjectType.create((String)mappingInfo.getDestEntityName()));
        return false;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private IndBarcodeSetupInfo getBarcodeSetupInfo(Context ctx, String destBosType, String barruleId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)destBosType));
        filter.getFilterItems().add(new FilterItemInfo("master.id", (Object)barruleId));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("master.*");
        sic.add("master.barcodeType.*");
        sic.add("Entry.*");
        sic.add("Entry.property.*");
        view.setSelector(sic);
        IndBarcodeSetupCollection setupCol = IndBarcodeSetupFactory.getLocalInstance(ctx).getIndBarcodeSetupCollection(view);
        if (setupCol.size() > 0) {
            IndBarcodeSetupInfo setupInfo = setupCol.get(0);
            return setupInfo;
        }
        return null;
    }

    private void updateBarcodeDossire(Context ctx, CoreBaseCollection barcodeDossierCol) throws BOSException {
        BarcodeDossierInfo dossierInfo = (BarcodeDossierInfo)barcodeDossierCol.get(0);
        String masterid = dossierInfo.getBarRule().getId().toString();
        String warehouseMasterEntryId = BarcodeClientUtils.getIndBarcodeMasterEntry(ctx, masterid, "\u4ed3\u5e93");
        String locationMasterEntryId = BarcodeClientUtils.getIndBarcodeMasterEntry(ctx, masterid, "\u5e93\u4f4d");
        String qtyMasterEntryId = BarcodeClientUtils.getIndBarcodeMasterEntry(ctx, masterid, "\u6570\u91cf");
        ArrayList<String> updateSqlList = new ArrayList<String>();
        int size = barcodeDossierCol.size();
        for (int j = 0; j < size; ++j) {
            StringBuffer updateSql;
            dossierInfo = (BarcodeDossierInfo)barcodeDossierCol.get(j);
            if (dossierInfo.get("warehouse") != null && warehouseMasterEntryId != null) {
                updateSql = new StringBuffer();
                updateSql.append(" update CT_IND_BarcodeDossierEntry set CFValue='").append(dossierInfo.get("warehouse").toString()).append("' where CFDisplayNameID='").append(warehouseMasterEntryId).append("' and fparentid='").append(dossierInfo.getId().toString()).append("'; \n");
                updateSqlList.add(updateSql.toString());
            }
            if (dossierInfo.get("location") != null && locationMasterEntryId != null) {
                updateSql = new StringBuffer();
                updateSql.append(" update CT_IND_BarcodeDossierEntry set CFValue='").append(dossierInfo.get("location").toString()).append("' where CFDisplayNameID='").append(locationMasterEntryId).append("' and fparentid='").append(dossierInfo.getId().toString()).append("';");
                updateSqlList.add(updateSql.toString());
            }
            if (dossierInfo.get("qty") != null && locationMasterEntryId != null) {
                updateSql = new StringBuffer();
                updateSql.append(" update CT_IND_BarcodeDossierEntry set CFValue=").append(dossierInfo.get("qty").toString()).append(" where CFDisplayNameID='").append(qtyMasterEntryId).append("' and fparentid='").append(dossierInfo.getId().toString()).append("';");
                updateSqlList.add(updateSql.toString());
            }
            if (dossierInfo.get("barcodeState") == null) continue;
            updateSql = new StringBuffer();
            updateSql.append(" update CT_IND_BarcodeDossier set CFBarcodeState=").append(dossierInfo.get("barcodeState").toString()).append(" where FID='").append(dossierInfo.getId().toString()).append("';");
            updateSqlList.add(updateSql.toString());
        }
        if (updateSqlList.size() > 0) {
            BarcodeServerUtils.executeBatchUpdate(ctx, updateSqlList);
        }
    }

    private void checkReapterBill(Context ctx, IObjectValue value, CoreBaseCollection barcodeBack, IIndBarcodeBack iIndBarcodeBack, CoreBaseCollection barcodeDossierCol, IBarcodeDossier iBarcodeDossier, String guuid) throws EASBizException, BOSException {
    }

    protected void checkInvStateAdjust(Context ctx, IObjectValue value) throws BOSException {
        int focusRowIndex = -1;
        InvStateAdjustBillInfo stateAdjustInfo = (InvStateAdjustBillInfo)value;
        StringBuffer sb = new StringBuffer();
        String strTemp = "";
        if (stateAdjustInfo.getStorageOrgUnit() == null) {
            strTemp = this.getMassege(ctx, this.invAddResource, "StorageOrgUnitNotNull");
            if (sb.toString().length() == 0) {
                sb.append(strTemp);
            }
        }
        int cout = 0;
        int rowCount2 = stateAdjustInfo.getEntry().size();
        if (rowCount2 > 0) {
            MaterialInfo materialNum = null;
            for (int i = 0; i < rowCount2; ++i) {
                InvStateAdjustBillEntryInfo adjustBillEntryInfo = stateAdjustInfo.getEntry().get(i);
                materialNum = adjustBillEntryInfo.getMaterial();
                if (materialNum == null || materialNum.getId() == null) {
                    if (focusRowIndex == -1) {
                        focusRowIndex = i;
                    }
                    ++cout;
                    if (sb.toString().length() == 0) {
                        sb.append(ResourceBase.getString((String)this.invAddResource, (String)"FieldCannotBeBlank", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1), "\u7269\u6599\u7f16\u7801"}));
                    } else {
                        sb.append("\n");
                        sb.append(ResourceBase.getString((String)this.invAddResource, (String)"FieldCannotBeBlank", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1), "\u7269\u6599\u7f16\u7801"}));
                    }
                }
                BigDecimal qty = null;
                BigDecimal o = null;
                o = adjustBillEntryInfo.getQty();
                if (o != null && StringUtil.isNumber((String)((Object)o).toString())) {
                    qty = new BigDecimal(((Object)o).toString());
                }
                if (qty == null || qty.compareTo(BigDecimal.ZERO) <= 0) {
                    if (focusRowIndex == -1) {
                        focusRowIndex = i;
                    }
                    strTemp = ResourceBase.getString((String)this.invAddResource, (String)"QtyGreaterZero", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)});
                    ++cout;
                    if (sb.toString().length() == 0) {
                        sb.append(strTemp);
                    } else {
                        sb.append("\n");
                        sb.append(strTemp);
                    }
                }
                if (adjustBillEntryInfo.getAssistUnit() != null) {
                    BigDecimal assistantQty = null;
                    BigDecimal object = null;
                    object = adjustBillEntryInfo.getAssociateQty();
                    if (object != null && StringUtil.isNumber((String)((Object)object).toString())) {
                        assistantQty = new BigDecimal(((Object)object).toString());
                    }
                    if (assistantQty == null) {
                        if (focusRowIndex == -1) {
                            focusRowIndex = i;
                        }
                        ++cout;
                        if (sb.toString().length() == 0) {
                            sb.append(ResourceBase.getString((String)this.invAddResource, (String)"FieldCannotBeBlank", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1), "\u8f85\u52a9\u6570\u91cf"}));
                        } else {
                            sb.append("\n");
                            sb.append(ResourceBase.getString((String)this.invAddResource, (String)"FieldCannotBeBlank", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1), "\u8f85\u52a9\u6570\u91cf"}));
                        }
                    }
                }
                if (adjustBillEntryInfo.getDestStoreStatus() == null) {
                    if (focusRowIndex == -1) {
                        focusRowIndex = i;
                    }
                    strTemp = ResourceBase.getString((String)this.invAddResource, (String)"INVSTATEADJUST_DESTSTORESTAUS_CANNOT_NULL", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)});
                    ++cout;
                    if (sb.toString().length() == 0) {
                        sb.append(strTemp);
                        continue;
                    }
                    sb.append("\n");
                    sb.append(strTemp);
                    continue;
                }
                StoreStateInfo srcStoreStatus = adjustBillEntryInfo.getSrcStoreStatus();
                StoreStateInfo destStoreStatus = adjustBillEntryInfo.getDestStoreStatus();
                if (srcStoreStatus == null || !destStoreStatus.getId().toString().equals(srcStoreStatus.getId().toString())) continue;
                if (focusRowIndex == -1) {
                    focusRowIndex = i;
                }
                strTemp = ResourceBase.getString((String)this.invAddResource, (String)"INVSTATEADJUST_SRC_DESTSTORESTAUS_CANNOT_SAME", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)});
                ++cout;
                if (sb.toString().length() == 0) {
                    sb.append(strTemp);
                    continue;
                }
                sb.append("\n");
                sb.append(strTemp);
            }
        } else {
            strTemp = "\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a";
            if (sb.toString().length() == 0) {
                sb.append(strTemp);
            } else {
                sb.append("\n");
                sb.append(strTemp);
            }
        }
        if (sb.length() > 0) {
            throw new BOSException(sb.toString());
        }
    }

    private String getMassege(Context ctx, String resourceStr, String key) {
        return ResourceBase.getString((String)resourceStr, (String)key, (Locale)ctx.getLocale());
    }

    protected MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws BOSException, EASBizException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = null;
        immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    protected BigDecimal calAssitQtyByQty(Context ctx, BigDecimal baseQty, BigDecimal convsRate, int precision) {
        BigDecimal assQty;
        BigDecimal coefficient = convsRate != null ? convsRate : new BigDecimal("1.00");
        BigDecimal bigDecimal = assQty = baseQty != null ? baseQty : new BigDecimal("0.00000");
        if (baseQty != null) {
            assQty = baseQty.divide(coefficient, precision, 4);
        }
        return assQty;
    }
}

