/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.AbstractIndBarcodeSetupEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResultItem;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeTypeInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.IndBarcodeBackCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeBackInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.barcode.scm.PackageBarcodeCollection;
import com.kingdee.eas.barcode.scm.PackageBarcodeFactory;
import com.kingdee.eas.barcode.scm.PackageBarcodeInfo;
import com.kingdee.eas.barcode.scm.app.AbstractIndBarcodeAnalysisFacadeControllerBean;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndBarcodeAnalysisFacadeControllerBean
extends AbstractIndBarcodeAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.IndBarcodeAnalysisFacadeControllerBean");

    @Override
    protected BarcodeAnalysisResult _barcodeAnalysis(Context ctx, String barcode, IObjectValue info, IObjectValue info2) throws BOSException, EASBizException {
        long time = System.currentTimeMillis();
        BarcodeDossierInfo ruleInfo = (BarcodeDossierInfo)info;
        IndBarcodeSetupInfo setupInfo = (IndBarcodeSetupInfo)info2;
        BarcodeAnalysisResult result = new BarcodeAnalysisResult();
        EntityObjectInfo entity = BarcodeUtils.getEntityByBosType(setupInfo.getBusinessObjectID());
        result.setBarcode(barcode);
        String barRuleID = ruleInfo.getBarRule().getId().toString();
        BarcodeTypeInfo barcodeType = ruleInfo.getBarRule().getBarcodeType();
        result.setBosType(setupInfo.getBusinessObjectID());
        result.setCumsumQty(setupInfo.isIsCumsumQty());
        result.setBarcodeRepeat(setupInfo.isIsBarcodeRepeat());
        result.setBarcodeQty(ruleInfo.getQty());
        result.setScan(ruleInfo.isIsScan());
        result.setBarcodeState(ruleInfo.getBarcodeState().getValue());
        if (barcodeType != null) {
            result.setBarcodeType(barcodeType.getBarcodeType());
            String analysisBarcode = barcode;
            if (barcodeType.isUseSign()) {
                analysisBarcode = barcode.substring(barcodeType.getSign().length(), barcode.length());
            }
            if (barcodeType.getBarcodeType().getValue() == 2) {
                ArrayList<String> barcodeList = new ArrayList<String>();
                PackageBarcodeCollection pbColl = null;
                try {
                    pbColl = PackageBarcodeFactory.getLocalInstance(ctx).getPackageBarcodeCollection("Select entry.barcode where pacakgeBarcode='" + barcode + "' and status=1");
                    if (pbColl != null && pbColl.size() > 0) {
                        PackageBarcodeInfo pbInfo = pbColl.get(0);
                        for (int i = 0; i < pbInfo.getEntry().size(); ++i) {
                            barcodeList.add(pbInfo.getEntry().get(i).getBarcode());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                result.setChidrenBarcodes(barcodeList);
                return result;
            }
        }
        ArrayList<BarcodeAnalysisResultItem> items = new ArrayList<BarcodeAnalysisResultItem>();
        BarcodeAnalysisResultItem item = null;
        Map<String, EntityObjectInfo> mapEntity = BarcodeUtils.getEntryName(entity);
        BarcodeDossierEntryInfo ruleEntry = null;
        AbstractIndBarcodeSetupEntryInfo setupEntry = null;
        BarcodeDossierEntryCollection entrys = ruleInfo.getEntrysByTemplate();
        FaCurCardInfo curCardInfo = null;
        this.setFaCurCardInfo(ctx, ruleInfo);
        if (ruleInfo.getFaCurCard() != null) {
            curCardInfo = ruleInfo.getFaCurCard();
            boolean isRelatedAtt = false;
            int itemsize = entrys.size();
            for (int i = 0; i < itemsize; ++i) {
                ruleEntry = entrys.get(i);
                if (!ruleEntry.getDisplayName().isRelatedAtt()) continue;
                isRelatedAtt = true;
                break;
            }
            if (isRelatedAtt) {
                curCardInfo = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), this._getSelectors());
            }
        }
        int itemsize = entrys.size();
        for (int i = 0; i < itemsize; ++i) {
            String dataType;
            ruleEntry = entrys.get(i);
            setupEntry = null;
            for (int j = 0; j < setupInfo.getEntry().size(); ++j) {
                if (!ruleEntry.getDisplayName().getId().equals((Object)setupInfo.getEntry().get(j).getProperty().getId())) continue;
                setupEntry = setupInfo.getEntry().get(j);
                break;
            }
            item = new BarcodeAnalysisResultItem();
            String key = "";
            if (setupEntry == null) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u89e3\u6790\u51fa\u9519\uff1a\u6761\u7801\u6863\u6848\u4e0e\u5355\u636e\u65e0\u6cd5\u8054\u7cfb"));
            }
            String field = setupEntry.getFullName();
            if (field == null) continue;
            Object value = null;
            Object number = null;
            Object name = null;
            EntityObjectInfo entryEntity = entity;
            String[] fields = field.split("\\.");
            int length = fields.length > 2 ? fields.length - 1 : fields.length;
            PropertyInfo propery = null;
            for (int k = 0; k < length; ++k) {
                if (k != length - 1) {
                    propery = entryEntity.getPropertyByName(fields[k]);
                    entryEntity = ((LinkPropertyInfo)propery).getRelationship().getSupplierObject();
                    continue;
                }
                if (fields[k].equals("sequenceNumber")) continue;
                if (length == 2) {
                    if (!mapEntity.containsKey(fields[k - 1])) continue;
                    propery = entryEntity.getPropertyByName(fields[k]);
                    continue;
                }
                propery = entryEntity.getPropertyByName(fields[k]);
            }
            key = ruleEntry.getValue();
            value = ruleEntry.getValue();
            if (ruleEntry.getDisplayName().isRelatedAtt() && curCardInfo != null && propery != null) {
                if (!(propery instanceof LinkPropertyInfo)) {
                    value = curCardInfo.get(propery.getName());
                } else if (curCardInfo.get(propery.getName()) != null) {
                    IObjectValue objectValue = (IObjectValue)curCardInfo.get(propery.getName());
                    value = objectValue.get(fields[fields.length - 1]);
                }
            }
            if (propery != null && propery.get("dataType") != null && "BigDecimal".equals(dataType = (String)propery.get("dataType"))) {
                value = this.formatDecimal(key);
            }
            if (propery != null) {
                if ("Date".equals(propery.get("dataType")) || "TimeStamp".equals(propery.get("dataType"))) {
                    value = this.formatDate(key);
                } else if ("Boolean".equals(propery.get("dataType"))) {
                    value = Boolean.FALSE;
                    if ("1".equals(key) || "true".equalsIgnoreCase(key)) {
                        value = Boolean.TRUE;
                    }
                }
            }
            item.setField(setupEntry.getFullName());
            item.setIsMatchItem(setupEntry.isPipei());
            item.setKey(value + "");
            item.setValue(value);
            item.setBosType(entryEntity.getType().toString());
            item.setLinkedProperty(propery instanceof LinkPropertyInfo);
            if (item.isLinkedProperty()) {
                if (fields.length > 2) {
                    item.setNumberProperty(propery.getName() + "_" + fields[fields.length - 1]);
                    if ("number".equalsIgnoreCase(fields[fields.length - 1])) {
                        item.setField(fields[0] + "." + fields[1]);
                    }
                } else {
                    item.setNumberProperty(propery.getName() + "_number");
                    String namePopery = propery.getName() + "_name";
                    item.setNameProperty(namePopery);
                }
                EntityObjectInfo baseEntity = ((LinkPropertyInfo)propery).getRelationship().getSupplierObject();
                this.setBaseDataValue(ctx, baseEntity.getType(), value, item, result);
            }
            if ("com.kingdee.eas.basedata.master.material.app.Material".equals(entryEntity.getFullName())) {
                this.setBaseDataValue(ctx, entryEntity.getType(), value, item, result);
            }
            item.setBarcodeRuleId(barRuleID);
            if (setupEntry.getProperty() != null) {
                item.setAlias(setupEntry.getProperty().getName());
            }
            if (propery != null) {
                item.setMoveField(propery.getName());
            } else {
                item.setMoveField(item.getField());
            }
            items.add(item);
        }
        result.setItems(items);
        time = System.currentTimeMillis() - time;
        logger.info((Object)(" \u5f53\u72ec\u89e3\u6790\u6761\u7801\u4fe1\u606f\u6d88\u8017\u65f6\u95f4 _barcodeAnalysis end\uff1a" + time));
        return result;
    }

    protected void setFaCurCardInfo(Context ctx, BarcodeDossierInfo ruleInfo) throws BOSException, EASBizException {
        FaCurCardCollection facurcardCol;
        if (ruleInfo.getMaterial() != null && ruleInfo.getFaCurCard() == null && (facurcardCol = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection("select id from where number='" + ruleInfo.getMaterial().getNumber() + "'")).size() > 0) {
            ruleInfo.setFaCurCard(facurcardCol.get(0));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("faCurCard"));
            BarcodeDossierFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)ruleInfo, sic);
        }
    }

    private void setBaseDataValue(Context ctx, BOSObjectType bosType, Object value, BarcodeAnalysisResultItem item, BarcodeAnalysisResult result) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("number");
        sic.add("id");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", value));
        view.setFilter(filterInfo);
        view.setSelector(sic);
        CoreBaseCollection coreBaseInfoCol = iCoreBase.getCollection(view);
        if (coreBaseInfoCol.size() > 0) {
            CoreBaseInfo coreBarseInfo = coreBaseInfoCol.get(0);
            item.setNameValue(coreBarseInfo.get("name"));
            if (coreBarseInfo.get("name") != null) {
                item.setName(coreBarseInfo.get("name").toString());
            }
            if (coreBarseInfo.get("number") != null) {
                item.setNumber(coreBarseInfo.get("number").toString());
            }
            if (coreBarseInfo instanceof MaterialInfo) {
                if (result.getMaterialID() == null) {
                    result.setMaterialID(coreBarseInfo.get("id").toString());
                } else {
                    String materialID = result.getMaterialID() + "," + coreBarseInfo.get("id").toString();
                    result.setMaterialID(materialID);
                }
            }
        }
    }

    private void setLogersInfo(IndBarcodeBackCollection backCol, IndBarcodeBackInfo backInfo, IObjectValue editData, IObjectValue entryInfo, String barcode) {
        backInfo = new IndBarcodeBackInfo();
        backInfo.setId(BOSUuid.create((BOSObjectType)backInfo.getBOSType()));
        backInfo.setNumber(backInfo.getId().toString());
        backInfo.setBizDate(new Date());
        if (editData.get("billType") != null) {
            backInfo.setBillType((BillTypeInfo)editData.get("billType"));
        }
        if (editData.get("bizType") != null) {
            backInfo.setBizType((BizTypeInfo)editData.get("bizType"));
        }
        backInfo.setNum(editData.get("number") == null ? "" : editData.get("number").toString());
        if (entryInfo != null) {
            backInfo.setRowNum(entryInfo.get("seq") == null ? "" : entryInfo.get("seq").toString());
        }
        backCol.add(backInfo);
    }

    @Override
    protected BarcodeAnalysisResult _barcodeAnalysis(Context ctx, String barcode, String barcodeRuleId) throws BOSException, EASBizException {
        return super.barcodeAnalysis(ctx, barcode, barcodeRuleId);
    }

    @Override
    protected List _findBarcodeRule(Context ctx, String barcode, String srcBosType, String destBosType, String CUNumber) throws BOSException, EASBizException {
        return super.findBarcodeRule(ctx, barcode, srcBosType, destBosType, CUNumber);
    }

    private Object formatDate(String key) {
        String value = null;
        if (key != null) {
            value = key;
        }
        return value;
    }

    private Object formatDecimal(String key) {
        BigDecimal value = null;
        try {
            if (key != null) {
                value = new BigDecimal(new BigDecimal(key).stripTrailingZeros().toPlainString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    protected SelectorItemCollection _getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("assetAmt"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("measureUnit.*"));
        } else {
            sic.add(new SelectorItemInfo("measureUnit.id"));
            sic.add(new SelectorItemInfo("measureUnit.number"));
            sic.add(new SelectorItemInfo("measureUnit.name"));
        }
        sic.add(new SelectorItemInfo("accountDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("storeCity.*"));
        } else {
            sic.add(new SelectorItemInfo("storeCity.id"));
            sic.add(new SelectorItemInfo("storeCity.number"));
            sic.add(new SelectorItemInfo("storeCity.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("economicPurp.*"));
        } else {
            sic.add(new SelectorItemInfo("economicPurp.id"));
            sic.add(new SelectorItemInfo("economicPurp.number"));
            sic.add(new SelectorItemInfo("economicPurp.name"));
        }
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("pArea"));
        sic.add(new SelectorItemInfo("mfr"));
        sic.add(new SelectorItemInfo("levFrDate"));
        sic.add(new SelectorItemInfo("paperNo"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("company.*"));
        } else {
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("dept.*"));
        } else {
            sic.add(new SelectorItemInfo("dept.id"));
            sic.add(new SelectorItemInfo("dept.number"));
            sic.add(new SelectorItemInfo("dept.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("keeper.*"));
        } else {
            sic.add(new SelectorItemInfo("keeper.id"));
            sic.add(new SelectorItemInfo("keeper.number"));
            sic.add(new SelectorItemInfo("keeper.name"));
        }
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originUnit"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("originMethod.*"));
        } else {
            sic.add(new SelectorItemInfo("originMethod.id"));
            sic.add(new SelectorItemInfo("originMethod.number"));
            sic.add(new SelectorItemInfo("originMethod.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("useStatus.*"));
        } else {
            sic.add(new SelectorItemInfo("useStatus.id"));
            sic.add(new SelectorItemInfo("useStatus.number"));
            sic.add(new SelectorItemInfo("useStatus.name"));
        }
        sic.add(new SelectorItemInfo("fiAccountDate"));
        sic.add(new SelectorItemInfo("wrtyPeriod"));
        sic.add(new SelectorItemInfo("wrtyNumber"));
        sic.add(new SelectorItemInfo("tempUseTermCount"));
        sic.add(new SelectorItemInfo("tempDeprTermCount"));
        sic.add(new SelectorItemInfo("tempDeprMethod"));
        sic.add(new SelectorItemInfo("isOveraged"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("originAmt"));
        sic.add(new SelectorItemInfo("addons"));
        sic.add(new SelectorItemInfo("exRate"));
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("buyValue"));
        sic.add(new SelectorItemInfo("buyAccuDepr"));
        sic.add(new SelectorItemInfo("evalLeftPeriod"));
        sic.add(new SelectorItemInfo("useYears"));
        sic.add(new SelectorItemInfo("deliverDate"));
        sic.add(new SelectorItemInfo("startUseDate"));
        sic.add(new SelectorItemInfo("useTermCount"));
        sic.add(new SelectorItemInfo("deprTermCount"));
        sic.add(new SelectorItemInfo("accuDepr"));
        sic.add(new SelectorItemInfo("neatRemValue"));
        sic.add(new SelectorItemInfo("accuDeprTYear"));
        sic.add(new SelectorItemInfo("decValue"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("deprMethod.*"));
        } else {
            sic.add(new SelectorItemInfo("deprMethod.id"));
            sic.add(new SelectorItemInfo("deprMethod.number"));
            sic.add(new SelectorItemInfo("deprMethod.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("measureUnitWL.*"));
        } else {
            sic.add(new SelectorItemInfo("measureUnitWL.id"));
            sic.add(new SelectorItemInfo("measureUnitWL.number"));
            sic.add(new SelectorItemInfo("measureUnitWL.name"));
        }
        sic.add(new SelectorItemInfo("neatValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("accuDeprAll"));
        sic.add(new SelectorItemInfo("monthDepreRate"));
        sic.add(new SelectorItemInfo("treatmentIncome"));
        sic.add(new SelectorItemInfo("fairValue"));
        sic.add(new SelectorItemInfo("neatLeftRate"));
        sic.add(new SelectorItemInfo("addonFare"));
        sic.add(new SelectorItemInfo("inputTax"));
        sic.add(new SelectorItemInfo("evalAssetValue"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("evalDeprMode.*"));
        } else {
            sic.add(new SelectorItemInfo("evalDeprMode.id"));
            sic.add(new SelectorItemInfo("evalDeprMode.number"));
            sic.add(new SelectorItemInfo("evalDeprMode.name"));
        }
        sic.add(new SelectorItemInfo("evalMonthRate"));
        sic.add(new SelectorItemInfo("evalNeatLeftRate"));
        sic.add(new SelectorItemInfo("evalRemValue"));
        sic.add(new SelectorItemInfo("evalDecValue"));
        sic.add(new SelectorItemInfo("evalNeatValue"));
        sic.add(new SelectorItemInfo("evalNeatAmt"));
        sic.add(new SelectorItemInfo("evalDeprTTerm"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.*"));
        } else {
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.id"));
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.number"));
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.name"));
        }
        sic.add(new SelectorItemInfo("evalYearDepr"));
        sic.add(new SelectorItemInfo("evalAddDepr"));
        sic.add(new SelectorItemInfo("evalTaxLeftPeriod"));
        sic.add(new SelectorItemInfo("evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("evalUseTermCount"));
        sic.add(new SelectorItemInfo("evalReInAccountDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountAsset.*"));
        } else {
            sic.add(new SelectorItemInfo("accountAsset.id"));
            sic.add(new SelectorItemInfo("accountAsset.number"));
            sic.add(new SelectorItemInfo("accountAsset.name"));
            sic.add(new SelectorItemInfo("accountAsset.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountAccuDepr.*"));
        } else {
            sic.add(new SelectorItemInfo("accountAccuDepr.id"));
            sic.add(new SelectorItemInfo("accountAccuDepr.number"));
            sic.add(new SelectorItemInfo("accountAccuDepr.name"));
            sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountDecValue.*"));
        } else {
            sic.add(new SelectorItemInfo("accountDecValue.id"));
            sic.add(new SelectorItemInfo("accountDecValue.number"));
            sic.add(new SelectorItemInfo("accountDecValue.name"));
            sic.add(new SelectorItemInfo("accountDecValue.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.number"));
        }
        sic.add(new SelectorItemInfo("faCurCostCenter.remark"));
        sic.add(new SelectorItemInfo("faCurCostCenter.apportionScale"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.facilityNumber"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityName"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityModel"));
        sic.add(new SelectorItemInfo("faCurFacility.registerDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.id"));
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.name"));
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.id"));
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.name"));
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.number"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.quantity"));
        sic.add(new SelectorItemInfo("faCurFacility.amount"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.keeper.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.keeper.id"));
            sic.add(new SelectorItemInfo("faCurFacility.keeper.name"));
            sic.add(new SelectorItemInfo("faCurFacility.keeper.number"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.remark"));
        sic.add(new SelectorItemInfo("faCurFacility.id"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.id"));
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.name"));
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.id"));
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.name"));
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.number"));
        }
        sic.add(new SelectorItemInfo("faCurDepartment.usage"));
        sic.add(new SelectorItemInfo("faCurDepartment.remark"));
        sic.add(new SelectorItemInfo("faCurDepartment.id"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("assetCat.*"));
        } else {
            sic.add(new SelectorItemInfo("assetCat.id"));
            sic.add(new SelectorItemInfo("assetCat.number"));
            sic.add(new SelectorItemInfo("assetCat.name"));
            sic.add(new SelectorItemInfo("assetCat.displayName"));
        }
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("assetName"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("creator.*"));
        } else {
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("creator.name"));
        }
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("oldNumber"));
        sic.add(new SelectorItemInfo("groupNumber"));
        sic.add(new SelectorItemInfo("barCode"));
        SelectorItemCollection newSic = new SelectorItemCollection();
        for (int i = 0; i < sic.size(); ++i) {
            SelectorItemInfo selector = sic.get(i);
            if (selector.getPropertyName().endsWith(".*") && !selector.getPropertyName().equalsIgnoreCase("originUnit.*")) {
                String propName = selector.get("propertyName").toString();
                String prefix = propName.substring(0, propName.length() - 1);
                newSic.add(new SelectorItemInfo(prefix + "id"));
                newSic.add(new SelectorItemInfo(prefix + "name"));
                newSic.add(new SelectorItemInfo(prefix + "number"));
                continue;
            }
            newSic.add(selector);
        }
        newSic.add(new SelectorItemInfo("*"));
        newSic.add(new SelectorItemInfo("currency.id"));
        newSic.add(new SelectorItemInfo("currency.number"));
        newSic.add(new SelectorItemInfo("currency.name"));
        newSic.add(new SelectorItemInfo("currency.isoCode"));
        newSic.add(new SelectorItemInfo("currency.sign"));
        newSic.add(new SelectorItemInfo("currency.baseUnit"));
        newSic.add(new SelectorItemInfo("currency.precision"));
        newSic.add(new SelectorItemInfo("assetCat.isDeductInputTax"));
        newSic.add(new SelectorItemInfo("assetCat.isLeaf"));
        newSic.add(new SelectorItemInfo("assetCat.displayName"));
        newSic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        newSic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        newSic.add(new SelectorItemInfo("assetCat.measureUnit.name"));
        newSic.add(new SelectorItemInfo("assetCat.measureUnit.number"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.number"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.name"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.isCustom"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.isWorkload"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.*"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.detailCollection.*"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.number"));
        newSic.add(new SelectorItemInfo("assetCat.company.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.id"));
        newSic.add(new SelectorItemInfo("assetCat.numberRule"));
        newSic.add(new SelectorItemInfo("assetCat.number"));
        newSic.add(new SelectorItemInfo("assetCat.gcUseLimitAndPureRate"));
        newSic.add(new SelectorItemInfo("dept.id"));
        newSic.add(new SelectorItemInfo("dept.name"));
        newSic.add(new SelectorItemInfo("dept.number"));
        newSic.add(new SelectorItemInfo("CU.id"));
        newSic.add(new SelectorItemInfo("CU.name"));
        newSic.add(new SelectorItemInfo("CU.number"));
        newSic.add(new SelectorItemInfo("number"));
        newSic.add(new SelectorItemInfo("effectedStatus"));
        newSic.add(new SelectorItemInfo("checkedStatus"));
        newSic.add(new SelectorItemInfo("originMethod.isLeaf"));
        newSic.add(new SelectorItemInfo("useStatus.isLeaf"));
        newSic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        newSic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        newSic.add(new SelectorItemInfo("dept.isLeaf"));
        newSic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        newSic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        newSic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        newSic.add(new SelectorItemInfo("faCurFacility.seq"));
        newSic.add(new SelectorItemInfo("faCurDepartment.seq"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.seq"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        newSic.add(new SelectorItemInfo("accountAsset.longName"));
        newSic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        newSic.add(new SelectorItemInfo("accountDecValue.longName"));
        newSic.add(new SelectorItemInfo("company.*"));
        newSic.add(new SelectorItemInfo("company.id"));
        newSic.add(new SelectorItemInfo("company.number"));
        newSic.add(new SelectorItemInfo("company.name"));
        newSic.add(new SelectorItemInfo("deprMethod.isCustom"));
        newSic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        newSic.add(new SelectorItemInfo("period.beginDate"));
        newSic.add(new SelectorItemInfo("period.endDate"));
        newSic.add(new SelectorItemInfo("period.periodYear"));
        newSic.add(new SelectorItemInfo("period.periodNumber"));
        newSic.add(new SelectorItemInfo("faCurDepartment.useDepartment.displayName"));
        newSic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        newSic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        return newSic;
    }
}

