/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleEntryInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleSNCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleSNFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleSNInfo;
import com.kingdee.eas.barcode.scm.RuleSNEnum;
import com.kingdee.eas.barcode.scm.app.AbstractIndBarcodeRuleSNControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class IndBarcodeRuleSNControllerBean
extends AbstractIndBarcodeRuleSNControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.IndBarcodeRuleSNControllerBean");

    @Override
    protected String _generateBarcode(Context ctx, IObjectValue ruleSNInfo, Date barCodeDate) throws BOSException, EASBizException {
        IndBarcodeRuleEntryInfo ruleEntryInfo = (IndBarcodeRuleEntryInfo)ruleSNInfo;
        String number = this.barCodeNumber(ruleEntryInfo, barCodeDate);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ruleId.id", (Object)ruleEntryInfo.getParent().getId(), CompareType.EQUALS));
        if (number != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo itemInfo = new SorterItemInfo("maxValue");
        itemInfo.setPropertyName("maxValue");
        itemInfo.setSortType(SortType.DESCEND);
        sic.add(itemInfo);
        viewInfo.setSorter(sic);
        IndBarcodeRuleSNCollection snCol = IndBarcodeRuleSNFactory.getLocalInstance(ctx).getIndBarcodeRuleSNCollection(viewInfo);
        IndBarcodeRuleSNInfo snInfo = null;
        if (snCol != null && snCol.size() > 0) {
            snInfo = snCol.get(0);
            String maxValue = snInfo.getMaxValue().toString();
            if (maxValue.length() > ruleEntryInfo.getLengt() && !ruleEntryInfo.isIsDilatation()) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u987a\u5e8f\u53f7\u7684\u6700\u5927\u503c\u5df2\u7ecf\u8d85\u8fc7\u4e0a\u9650,\u8bf7\u4fee\u6539\u751f\u6210\u89c4\u5219"));
            }
            BigDecimal maxValueBig = snInfo.getMaxValue().add(BigDecimal.ONE);
            snInfo.setMaxValue(maxValueBig);
            IndBarcodeRuleSNFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(snInfo.getId()), snInfo);
            maxValue = maxValueBig.toString();
            for (int i = maxValue.length(); i < ruleEntryInfo.getLengt(); ++i) {
                maxValue = "0" + maxValue;
            }
            return maxValue;
        }
        snInfo = new IndBarcodeRuleSNInfo();
        snInfo.setRuleId(ruleEntryInfo.getParent());
        snInfo.setNumber(number);
        snInfo.setMaxValue(new BigDecimal(1));
        IndBarcodeRuleSNFactory.getLocalInstance(ctx).save(snInfo);
        String maxValue = snInfo.getMaxValue().toString();
        for (int i = maxValue.length(); i < ruleEntryInfo.getLengt(); ++i) {
            maxValue = "0" + maxValue;
        }
        return maxValue;
    }

    private String barCodeNumber(IndBarcodeRuleEntryInfo ruleEntryInfo, Date barCodeDate) {
        if (barCodeDate == null) {
            barCodeDate = new Date();
        }
        IndBarcodeRuleInfo ruleInfo = ruleEntryInfo.getParent();
        RuleSNEnum ruleSNEnum = ruleInfo.getFlowBasis();
        String number = null;
        Calendar dateC = Calendar.getInstance();
        dateC.setTime(barCodeDate);
        if (RuleSNEnum.YEAR.equals((Object)ruleSNEnum)) {
            number = dateC.get(1) + "";
        } else if (RuleSNEnum.MONTH.equals((Object)ruleSNEnum)) {
            number = dateC.get(2) + 1 + "";
        } else if (RuleSNEnum.DATE.equals((Object)ruleSNEnum)) {
            number = dateC.get(1) + "" + (dateC.get(2) + 1) + "" + dateC.get(5) + "";
        }
        return number;
    }

    @Override
    protected String _generateBarcode(Context ctx, IObjectValue ruleInfo, String numberPart, IObjectValue ruleEntryInfo) throws BOSException, EASBizException {
        IndBarcodeRuleInfo indRuleInfo = (IndBarcodeRuleInfo)ruleInfo;
        IndBarcodeRuleEntryInfo indRuleEntryInfo = (IndBarcodeRuleEntryInfo)ruleEntryInfo;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ruleId.id", (Object)indRuleInfo.getId(), CompareType.EQUALS));
        if (numberPart != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)numberPart, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo itemInfo = new SorterItemInfo("maxValue");
        itemInfo.setPropertyName("maxValue");
        itemInfo.setSortType(SortType.DESCEND);
        sic.add(itemInfo);
        viewInfo.setSorter(sic);
        IndBarcodeRuleSNCollection snCol = IndBarcodeRuleSNFactory.getLocalInstance(ctx).getIndBarcodeRuleSNCollection(viewInfo);
        IndBarcodeRuleSNInfo snInfo = null;
        if (snCol != null && snCol.size() > 0) {
            snInfo = snCol.get(0);
            String maxValue = snInfo.getMaxValue().toString();
            if (maxValue.length() > indRuleEntryInfo.getLengt() && !indRuleEntryInfo.isIsDilatation()) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u987a\u5e8f\u53f7\u7684\u6700\u5927\u503c\u5df2\u7ecf\u8d85\u8fc7\u4e0a\u9650,\u8bf7\u4fee\u6539\u751f\u6210\u89c4\u5219"));
            }
            BigDecimal maxValueBig = snInfo.getMaxValue().add(BigDecimal.ONE);
            snInfo.setMaxValue(maxValueBig);
            IndBarcodeRuleSNFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(snInfo.getId()), snInfo);
            maxValue = maxValueBig.toString();
            for (int i = maxValue.length(); i < indRuleEntryInfo.getLengt(); ++i) {
                maxValue = "0" + maxValue;
            }
            return maxValue;
        }
        snInfo = new IndBarcodeRuleSNInfo();
        snInfo.setRuleId(indRuleInfo);
        snInfo.setNumber(numberPart);
        snInfo.setMaxValue(new BigDecimal(1));
        IndBarcodeRuleSNFactory.getLocalInstance(ctx).save(snInfo);
        String maxValue = snInfo.getMaxValue().toString();
        for (int i = maxValue.length(); i < indRuleEntryInfo.getLengt(); ++i) {
            maxValue = "0" + maxValue;
        }
        return maxValue;
    }

    @Override
    protected BigDecimal _getBarcodeMaxValue(Context ctx, IObjectValue ruleInfo, String numberPart, IObjectValue ruleEntryInfo, BigDecimal thisBarcodeCount) throws BOSException, EASBizException {
        IndBarcodeRuleInfo indRuleInfo = (IndBarcodeRuleInfo)ruleInfo;
        IndBarcodeRuleEntryInfo indRuleEntryInfo = (IndBarcodeRuleEntryInfo)ruleEntryInfo;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ruleId.id", (Object)indRuleInfo.getId(), CompareType.EQUALS));
        if (numberPart != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)numberPart, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo itemInfo = new SorterItemInfo("maxValue");
        itemInfo.setPropertyName("maxValue");
        itemInfo.setSortType(SortType.DESCEND);
        sic.add(itemInfo);
        viewInfo.setSorter(sic);
        IndBarcodeRuleSNCollection snCol = IndBarcodeRuleSNFactory.getLocalInstance(ctx).getIndBarcodeRuleSNCollection(viewInfo);
        IndBarcodeRuleSNInfo snInfo = null;
        if (snCol != null && snCol.size() > 0) {
            snInfo = snCol.get(0);
            String maxValue = snInfo.getMaxValue().toString();
            if (indRuleEntryInfo != null && maxValue.length() > indRuleEntryInfo.getLengt() && !indRuleEntryInfo.isIsDilatation()) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u987a\u5e8f\u53f7\u7684\u6700\u5927\u503c\u5df2\u7ecf\u8d85\u8fc7\u4e0a\u9650,\u8bf7\u4fee\u6539\u751f\u6210\u89c4\u5219"));
            }
            BigDecimal maxValueBig = snInfo.getMaxValue();
            snInfo.setMaxValue(maxValueBig);
            logger.info((Object)("maxValue of snInfo " + snInfo.getMaxValue()));
            logger.info((Object)("ruleId of snInfo " + snInfo.getRuleId()));
            logger.info((Object)("number of snInfo " + snInfo.getNumber()));
            logger.info((Object)("id of snInfo " + snInfo.getId()));
            IndBarcodeRuleSNFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(snInfo.getId()), snInfo);
            maxValue = maxValueBig.toString();
            return maxValueBig;
        }
        snInfo = new IndBarcodeRuleSNInfo();
        snInfo.setRuleId(indRuleInfo);
        snInfo.setNumber(numberPart);
        snInfo.setMaxValue(new BigDecimal(0));
        IndBarcodeRuleSNFactory.getLocalInstance(ctx).save(snInfo);
        return snInfo.getMaxValue();
    }

    @Override
    protected void _updateBarcodeRuleSN(Context ctx, IObjectValue ruleInfo, String numberPart, BigDecimal thisBarcodeCount) throws BOSException, EASBizException {
        IndBarcodeRuleInfo indRuleInfo = (IndBarcodeRuleInfo)ruleInfo;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ruleId.id", (Object)indRuleInfo.getId(), CompareType.EQUALS));
        if (numberPart != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)numberPart, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo itemInfo = new SorterItemInfo("maxValue");
        itemInfo.setPropertyName("maxValue");
        itemInfo.setSortType(SortType.DESCEND);
        sic.add(itemInfo);
        viewInfo.setSorter(sic);
        IndBarcodeRuleSNCollection snCol = IndBarcodeRuleSNFactory.getLocalInstance(ctx).getIndBarcodeRuleSNCollection(viewInfo);
        IndBarcodeRuleSNInfo snInfo = null;
        if (snCol != null && snCol.size() > 0) {
            snInfo = snCol.get(0);
            BigDecimal maxValueBig = snInfo.getMaxValue().add(thisBarcodeCount);
            snInfo.setMaxValue(maxValueBig);
            IndBarcodeRuleSNFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(snInfo.getId()), snInfo);
        } else {
            snInfo = new IndBarcodeRuleSNInfo();
            snInfo.setRuleId(indRuleInfo);
            snInfo.setNumber(numberPart);
            snInfo.setMaxValue(thisBarcodeCount);
            IndBarcodeRuleSNFactory.getLocalInstance(ctx).save(snInfo);
        }
    }
}

