/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeWSException;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupEntryCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupEntryInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.barcode.scm.app.AbstractIndBarcodeSetupControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IndBarcodeSetupControllerBean
extends AbstractIndBarcodeSetupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.IndBarcodeSetupControllerBean");

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IndBarcodeSetupInfo indRuleInfo = (IndBarcodeSetupInfo)model;
        if (indRuleInfo.getState().getValue() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"12_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        indRuleInfo.setState(StatusEnum.INACTIVE);
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IndBarcodeSetupInfo indRuleInfo = (IndBarcodeSetupInfo)model;
        if (indRuleInfo.getState().getValue() == 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"19_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        indRuleInfo.setState(StatusEnum.ACTIVE);
        super._cancelCancel(ctx, pk, model);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SorterItemCollection sorterCol = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo("Entry.seq");
        sorterInfo.setSortType(SortType.ASCEND);
        sorterCol.add(sorterInfo);
        return super._getValue(ctx, pk, selector, sorterCol);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IndBarcodeSetupInfo setupInfo = (IndBarcodeSetupInfo)this.getValue(ctx, pk);
        if (setupInfo.isIsDefault()) {
            throw new BarcodeWSException(BarcodeWSException.ISDEFAULTSTEPUP);
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    private void updateDetailTable(Context ctx, IndBarcodeSetupInfo barcodeSetUpInfo) throws BOSException, SQLException {
        String tableName = "T_INDBS_" + barcodeSetUpInfo.getBusinessObjectID();
        boolean isExists = this.isExistsTable(ctx, tableName);
        Map<String, String> fields = null;
        fields = this.getConfigDetailFieldsNoDupl(ctx, barcodeSetUpInfo, isExists);
        if (fields.size() == 0) {
            return;
        }
        this.updateTableColums(ctx, tableName, isExists, fields);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"4_BarcodeConfigControllerBean", (Locale)ctx.getLocale()) + tableName + "#"));
    }

    private boolean isExistsTable(Context ctx, String tablename) throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select 1 from KSQL_USERTABLES WHERE KSQL_TABNAME='" + tablename + "'"));
        return rs.next();
    }

    private Map<String, String> getConfigDetailFieldsNoDupl(Context ctx, IndBarcodeSetupInfo barcodeSetUpInfo, boolean isTableExists) throws BOSException, SQLException {
        HashSet<String> existSet = new HashSet<String>();
        if (isTableExists) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_TABNAME='T_INDBS_" + barcodeSetUpInfo.getBusinessObjectID() + "'"));
            while (rs.next()) {
                existSet.add(rs.getString("KSQL_COL_NAME").toUpperCase());
            }
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (!isTableExists) {
            map.putAll(this.getCommonFields());
        }
        map.keySet().removeAll(existSet);
        IndBarcodeSetupEntryCollection setEntryCol = barcodeSetUpInfo.getEntry();
        EntityObjectInfo entity = BarcodeUtils.getEntityByBosType(barcodeSetUpInfo.getBusinessObjectID());
        Map<String, EntityObjectInfo> mapEntity = BarcodeUtils.getEntryName(entity);
        for (int i = 0; i < setEntryCol.size(); ++i) {
            IndBarcodeSetupEntryInfo setupEntry = setEntryCol.get(i);
            if (setupEntry.getFullName() == null || "".equals(setupEntry.getFullName())) continue;
            String field = setupEntry.getFullName();
            EntityObjectInfo entryEntity = entity;
            String[] fields = field.split("\\.");
            int length = fields.length > 2 ? fields.length - 1 : fields.length;
            PropertyInfo property = null;
            for (int k = 0; k < length; ++k) {
                if (k != length - 1) {
                    property = entryEntity.getPropertyByName(fields[k]);
                    entryEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
                    continue;
                }
                if (fields[k].equals("sequenceNumber")) continue;
                if (length == 2) {
                    if (!mapEntity.containsKey(fields[k - 1])) continue;
                    property = entryEntity.getPropertyByName(fields[k]);
                    continue;
                }
                property = entryEntity.getPropertyByName(fields[k]);
            }
            if (property == null) continue;
            if (property instanceof LinkPropertyInfo) {
                String name = property.getName().toUpperCase() + "_NUMBER";
                if (!existSet.contains(name)) {
                    map.put(name, "NVARCHAR(255)");
                }
                if (existSet.contains(name = property.getName().toUpperCase() + "_NAME")) continue;
                map.put(name, "NVARCHAR(255)");
                continue;
            }
            String name = property.getName().toUpperCase();
            if (existSet.contains(name)) continue;
            int dataType = property.getMappingField().getSQLType();
            if (SQLType.NUMERIC.getSQLType() == dataType) {
                map.put(name, "NUMERIC(28,14)");
                continue;
            }
            if (SQLType.DATETIME.getSQLType() == dataType) {
                map.put(name, "DateTime");
                continue;
            }
            map.put(name, "NVARCHAR(255)");
        }
        return map;
    }

    protected void updateTableColums(Context ctx, String tableName, boolean isExistsTable, Map<String, String> columns) throws BOSException {
        if (columns.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        if (isExistsTable) {
            sql.append("ALTER TABLE " + tableName + " ADD ");
        } else {
            sql.append("CREATE TABLE " + tableName + " (");
        }
        Set<String> set = columns.keySet();
        Iterator<String> it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            if (count != 0) {
                sql.append(",");
            }
            ++count;
            String key = it.next();
            sql.append(key + " " + columns.get(key));
        }
        if (!isExistsTable) {
            sql.append(")");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private Map<String, String> getCommonFields() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("FID", "VARCHAR(44)");
        result.put("CFBarRuleID", "VARCHAR(44) ");
        result.put("CFBarcodeState", "int default 0 ");
        result.put("CFIsBarcodeRepeat", "int default 0 ");
        result.put("CFIsCumsumQty", "int default 0 ");
        result.put("CFMatchField", "NVARCHAR(255) ");
        result.put("FBosType", "NVARCHAR(255) ");
        return result;
    }
}

