/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeBillCustColInfo;
import com.kingdee.eas.barcode.scm.BarcodeBillUIConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeGenResult;
import com.kingdee.eas.barcode.scm.BarcodeGenerateParamInfo;
import com.kingdee.eas.barcode.scm.BarcodeGenerateParams;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.FormtEnum;
import com.kingdee.eas.barcode.scm.IBarcodeDossier;
import com.kingdee.eas.barcode.scm.IBarcodeFacade;
import com.kingdee.eas.barcode.scm.IndBarcodeBackCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeBackFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeBackInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleSNFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupEntryInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.barcode.scm.app.AbstractIndDossierGenerateFacodeControllerBean;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndDossierGenerateFacodeControllerBean
extends AbstractIndDossierGenerateFacodeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.IndDossierGenerateFacodeControllerBean");
    private String barcodeQty = "1";
    private List<String> custCols = null;
    private Map<String, EntityObjectInfo> entryEntityObjectMap = null;

    public Map<String, EntityObjectInfo> getEntryEntityObjectMap() {
        return this.entryEntityObjectMap;
    }

    public void setEntryEntityObjectMap(Map<String, EntityObjectInfo> entryEntityObjectMap) {
        this.entryEntityObjectMap = entryEntityObjectMap;
    }

    private Map<String, EntityObjectInfo> getEntryEntityObjectInfo(EntityObjectInfo billEntity) {
        HashMap<String, EntityObjectInfo> bosTypeMap = new HashMap<String, EntityObjectInfo>();
        PropertyCollection pyColl = billEntity.getEntityProperties();
        for (int i = 0; i < pyColl.size(); ++i) {
            PropertyInfo property = pyColl.get(i);
            if (property.getName().equalsIgnoreCase("ID") || !BarcodeUtils.isEntryProperty(billEntity, property)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            String bosType = relation.getSupplierObject().getType().toString();
            EntityObjectInfo entryEntity = BarcodeUtils.getEntityByBosType(bosType);
            bosTypeMap.put(property.getName(), entryEntity);
        }
        this.setEntryEntityObjectMap(bosTypeMap);
        return bosTypeMap;
    }

    @Override
    protected IObjectPK[] _generateDossier(Context ctx, Map config) throws BOSException, EASBizException {
        IndBarcodeSetupInfo setupInfo = (IndBarcodeSetupInfo)config.get("setupInfo");
        IObjectValue editData = (IObjectValue)config.get("editData");
        if (editData.get("id") == null) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u518d\u751f\u6210/\u67e5\u8be2\u6761\u7801\uff01"));
        }
        IndBarcodeRuleInfo ruleInfo = null;
        ruleInfo = !config.containsKey("ruleInfo") && setupInfo != null && setupInfo.getMaster() != null ? this.getBarcodeRuleInfo(ctx, editData.getBOSType().toString(), setupInfo.getMaster().getBarcodeType().getId().toString()) : (IndBarcodeRuleInfo)config.get("ruleInfo");
        if (ruleInfo == null) {
            return null;
        }
        Map barcodeEntryIdMap = new LinkedHashMap();
        boolean isAddEntry = false;
        if (config.containsKey("barcodeEntryIdMap")) {
            barcodeEntryIdMap = (Map)config.get("barcodeEntryIdMap");
            isAddEntry = true;
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(editData.getBOSType());
        this.custCols = this.getCustCols(ctx, entity, setupInfo);
        String entryName = this.getEntryName(ctx, entity, setupInfo);
        BarcodeGenerateParams param = new BarcodeGenerateParams();
        ArrayList<BarcodeGenerateParamInfo> pList = new ArrayList<BarcodeGenerateParamInfo>();
        IObjectCollection objectCol = null;
        boolean isBaseData = false;
        int size = 0;
        if (entryName != null) {
            objectCol = (IObjectCollection)editData.get(entryName);
            size = objectCol.size();
        } else {
            size = 1;
            isBaseData = true;
        }
        int n = size;
        for (int i = 0; i < n; ++i) {
            IObjectValue objValue = null;
            if (objectCol != null) {
                if (isAddEntry) {
                    objValue = objectCol.getObject(i);
                    String entryId = objValue.get("id").toString();
                    if (entryId != null && !barcodeEntryIdMap.containsKey(entryId)) {
                        continue;
                    }
                } else {
                    objValue = objectCol.getObject(i);
                }
            } else {
                objValue = editData;
            }
            Object val = editData.get("id");
            BarcodeGenerateParamInfo pInfo = new BarcodeGenerateParamInfo();
            if (val != null) {
                pInfo.setBillId(val.toString());
            }
            if ((val = objValue.get("id")) != null) {
                pInfo.setEntryId(val.toString());
            }
            pInfo.setBarcodeCount(1);
            if (editData.get("bizDate") != null) {
                pInfo.setBarcodeDate((Date)editData.get("bizDate"));
            }
            pInfo.setBarcodeQty(new BigDecimal(this.barcodeQty));
            pInfo.setTotalCount(new BigDecimal(this.barcodeQty));
            if (this.custCols != null) {
                HashMap<String, String> rowValueMap = new HashMap<String, String>();
                int m = this.custCols.size();
                for (int j = 0; j < m; ++j) {
                    String columnName = this.custCols.get(j);
                    if (columnName == null) continue;
                    val = objValue.get(columnName);
                    rowValueMap.put(columnName, val == null ? "" : val.toString());
                }
                pInfo.setRowValueMap(rowValueMap);
            }
            if (editData.get("storageOrgUnit") != null) {
                pInfo.setStorageOrgUnitInfo((StorageOrgUnitInfo)editData.get("storageOrgUnit"));
            } else {
                pInfo.setStorageOrgUnitInfo(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            pList.add(pInfo);
        }
        if (pList.size() > 0) {
            param.setEntity(entity);
            if (ruleInfo.getId() != null) {
                param.setBarcodeRuleId(ruleInfo.getId().toString());
            }
            param.setParamList(pList);
            param.setIndBarcodeSetupId(setupInfo.getId().toString());
            if (entryName != null) {
                String[] strArg = entryName.split("\\.");
                String key = strArg[0];
                Map<String, EntityObjectInfo> entryEntityMap = null;
                if (this.getEntryEntityObjectMap() == null) {
                    this.setEntryEntityObjectMap(this.getEntryEntityObjectInfo(entity));
                }
                if ((entryEntityMap = this.getEntryEntityObjectMap()).containsKey(key)) {
                    param.setEntrtyEntity(entryEntityMap.get(key));
                }
            }
        }
        param.setSave(true);
        if (entity.getType().toString().equals("42AC39EC")) {
            param.setBaseData(true);
        } else {
            param.setBaseData(isBaseData);
        }
        if (editData.get("storageOrgUnit") != null) {
            param.setOrgUnitInfo((StorageOrgUnitInfo)editData.get("storageOrgUnit"));
        } else {
            param.setOrgUnitInfo(ContextUtil.getCurrentStorageUnit((Context)ctx));
        }
        IBarcodeFacade iFacade = BarcodeFacadeFactory.getLocalInstance(ctx);
        BarcodeGenResult barcodesRslt = iFacade.geneateBarcodes(param);
        ObjectUuidPK[] iObjectPK = null;
        if (barcodesRslt != null) {
            List<String> pkList = barcodesRslt.getPkList();
            iObjectPK = new ObjectUuidPK[pkList.size()];
            for (int i = 0; i < pkList.size(); ++i) {
                iObjectPK[i] = new ObjectUuidPK(pkList.get(i).toString());
            }
        }
        return iObjectPK;
    }

    private String getEntryName(Context ctx, EntityObjectInfo entity, IndBarcodeSetupInfo setupInfo) throws BOSException, EASBizException {
        List<String> custCols = this.getCustCols(ctx, entity, setupInfo);
        String entryName = null;
        if (custCols != null) {
            String propName = null;
            String[] propArr = null;
            int n = custCols.size();
            for (int i = 0; i < n; ++i) {
                propName = custCols.get(i);
                if (StringUtils.isEmpty((String)propName)) continue;
                propArr = propName.split("\\.");
                if (propArr.length == 2) {
                    entryName = propArr[0];
                }
                if (propArr.length <= 2) continue;
                entryName = propArr[0];
                break;
            }
            Map<String, EntityObjectInfo> mapEntity = BarcodeUtils.getEntryName(entity);
            if (entryName != null && !mapEntity.containsKey(entryName)) {
                entryName = null;
            }
        }
        return entryName;
    }

    private List<String> getCustCols(Context ctx, EntityObjectInfo entity, IndBarcodeSetupInfo setupInfo) throws BOSException, EASBizException {
        IBarcodeFacade iFacade = BarcodeFacadeFactory.getLocalInstance(ctx);
        BarcodeBillUIConfigInfo uiConfigInfo = iFacade.getBillUIConfigInfo(setupInfo.getId().toString());
        List<BarcodeBillCustColInfo> bcol = uiConfigInfo.getCustCols();
        ArrayList<String> custCols = new ArrayList<String>(bcol.size());
        int size = bcol.size();
        for (int i = 0; i < size; ++i) {
            custCols.add(bcol.get(i).getPropertyName());
        }
        return custCols;
    }

    private BarcodeDossierEntryCollection sortCollection(BarcodeDossierEntryCollection entryCols, BarcodeDossierEntryCollection entryCol) {
        int kk;
        Object[] obj = entryCols.toArray();
        BarcodeDossierEntryInfo minentry = null;
        BarcodeDossierEntryInfo maxentry = null;
        BarcodeDossierEntryInfo tempentry = null;
        for (kk = 1; kk < obj.length; ++kk) {
            for (int jj = 0; jj < obj.length - kk; ++jj) {
                minentry = (BarcodeDossierEntryInfo)obj[jj];
                maxentry = (BarcodeDossierEntryInfo)obj[jj + 1];
                if (minentry.getSeq() <= maxentry.getSeq()) continue;
                tempentry = minentry;
                obj[jj] = maxentry;
                obj[jj + 1] = tempentry;
            }
        }
        for (kk = 0; kk < obj.length; ++kk) {
            entryCol.add((BarcodeDossierEntryInfo)obj[kk]);
        }
        return entryCol;
    }

    private List saveORshowDossier(Context ctx, String filter, String sql, int count, List pkList, BarcodeDossierInfo dossierInfo, IndBarcodeBackCollection backCol, IndBarcodeBackInfo backInfo, IObjectValue editData, Object num) throws EASBizException, BOSException, SQLException {
        IBarcodeDossier iBarcodedossier = BarcodeDossierFactory.getLocalInstance(ctx);
        FilterInfo filerInfo = new FilterInfo();
        filerInfo.getFilterItems().add(new FilterItemInfo("number", (Object)dossierInfo.getNumber(), CompareType.EQUALS));
        if (iBarcodedossier.exists(filerInfo)) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("id"));
            view.setSelector(coll);
            view.setFilter(filerInfo);
            BarcodeDossierCollection barcodeDossierCol = iBarcodedossier.getBarcodeDossierCollection(view);
            if (barcodeDossierCol.size() > 0) {
                BarcodeDossierInfo barcodeSossierInfo = barcodeDossierCol.get(0);
                pkList.add(barcodeSossierInfo.getId().toString());
            } else {
                IObjectPK pk = iBarcodedossier.save((CoreBaseInfo)dossierInfo);
                pkList.add(pk);
            }
        } else {
            IObjectPK pk = iBarcodedossier.save((CoreBaseInfo)dossierInfo);
            pkList.add(pk);
        }
        return pkList;
    }

    private Object getPropVal(BarcodeDossierInfo dossierInfo, IObjectValue info, String propName, int index) {
        Object propVal = null;
        String[] propArr = propName.split("\\.");
        for (int i = index; i < propArr.length; ++i) {
            String propNameAr = propArr[index];
            propVal = info.get(propNameAr);
            if (!(propVal instanceof IObjectValue)) continue;
            if (propVal instanceof MaterialInfo && propVal != null) {
                dossierInfo.setMaterial((MaterialInfo)propVal);
            }
            propVal = this.getPropVal(dossierInfo, (IObjectValue)propVal, propName, ++i);
            break;
        }
        return propVal;
    }

    private String setInfoValue(BarcodeDossierInfo dossierInfo, BarcodeDossierEntryInfo entryInfo, IndBarcodeSetupEntryInfo setupEntryInfo, IObjectValue editData, String field, String filter, int count, boolean isEntry) {
        entryInfo.setDisplayName(setupEntryInfo.getProperty());
        entryInfo.setSeq(setupEntryInfo.getProperty().getSeq());
        entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        entryInfo.setName(setupEntryInfo.getFullName());
        String[] fields = field.split("\\.");
        if (fields.length > 1) {
            Object object = null;
            object = isEntry ? this.getPropVal(dossierInfo, editData, field, 1) : this.getPropVal(dossierInfo, editData, field, 0);
            if (object != null) {
                if (object instanceof BigDecimal) {
                    entryInfo.setValue(this.clearZero(object.toString()));
                } else {
                    entryInfo.setValue(object.toString() + "");
                }
            }
        } else if (editData.get(field) instanceof CoreBaseInfo) {
            if (editData.get(field) instanceof MaterialInfo && editData.get(field) != null) {
                dossierInfo.setMaterial((MaterialInfo)editData.get(field));
            }
            entryInfo.setValue(((CoreBaseInfo)editData.get(field)).get("number") + "");
        } else if (editData.get(field) != null) {
            if (editData.get(field) instanceof BigDecimal) {
                entryInfo.setValue(this.clearZero(editData.get(field).toString()));
            } else {
                entryInfo.setValue(editData.get(field) + "");
            }
        }
        if (BarcodeClientUtils.getBarcodeResource("Count").equals(setupEntryInfo.getProperty().getName())) {
            this.barcodeQty = entryInfo.getValue() != null ? entryInfo.getValue() : "1";
        }
        if ("barcodeQ".equals(entryInfo.getName())) {
            entryInfo.setValue(this.barcodeQty);
            if (entryInfo.getValue() != null && !"".equals(entryInfo.getValue())) {
                dossierInfo.setQty(new BigDecimal(entryInfo.getValue()));
            }
        }
        if ("barcodeRemart".equals(entryInfo.getName())) {
            dossierInfo.setRemate(entryInfo.getValue());
        }
        if (setupEntryInfo.getProperty().isIsCheck()) {
            filter = filter != null ? (entryInfo.getValue() == null ? filter + "or (CFDisplayNameID='" + setupEntryInfo.getProperty().getId() + "' and CFValue is null) \n" : filter + "or (CFDisplayNameID='" + setupEntryInfo.getProperty().getId() + "' and CFValue='" + entryInfo.getValue() + "') \n") : (entryInfo.getValue() == null ? "(CFDisplayNameID='" + setupEntryInfo.getProperty().getId() + "' and CFValue is null) \n" : "(CFDisplayNameID='" + setupEntryInfo.getProperty().getId() + "' and CFValue='" + entryInfo.getValue() + "') \n");
        }
        return filter;
    }

    private String clearZero(String numValue) {
        int dotIndex = numValue.lastIndexOf(".");
        int zeroIndex = numValue.length();
        if (dotIndex > -1) {
            for (int i = numValue.length(); i > dotIndex; --i) {
                if (!"0".equals(numValue.substring(i - 1, i))) {
                    if (!".".equals(numValue.substring(i - 1, i))) break;
                    zeroIndex = i - 1;
                    break;
                }
                zeroIndex = i - 1;
            }
        }
        if (dotIndex > 0) {
            numValue = numValue.substring(0, zeroIndex);
        }
        return numValue;
    }

    private String generateNumber(Context ctx, IndBarcodeRuleInfo ruleInfo, IObjectValue editData, CtrlUnitInfo ctrlUnitInfo, IObjectValue entryInfo, int seq) throws BOSException, EASBizException {
        String genNumber = "";
        String field = null;
        String[] fields = null;
        AbstractObjectCollection valueCol = null;
        for (int i = 0; i < ruleInfo.getEntry().size(); ++i) {
            if (ruleInfo.getEntry().get(i).getPerType() == FormtEnum.fasten) {
                if (ruleInfo.getEntry().get(i).getFormt() == null) continue;
                genNumber = genNumber + ruleInfo.getEntry().get(i).getFormt();
                continue;
            }
            if (ruleInfo.getEntry().get(i).getPerType() == FormtEnum.property) {
                field = ruleInfo.getEntry().get(i).getFullName();
                fields = field.split("\\.");
                if (fields.length == 1) {
                    if (editData.get(field) instanceof CoreBaseInfo) {
                        if (((CoreBaseInfo)editData.get(field)).get("number") == null) continue;
                        genNumber = genNumber + ((CoreBaseInfo)editData.get(field)).get("number");
                        continue;
                    }
                    if (editData.get(field) == null) continue;
                    genNumber = genNumber + editData.get(field);
                    continue;
                }
                if (fields.length < 2 || entryInfo == null || (valueCol = (AbstractObjectCollection)editData.get(fields[0])) == null || valueCol.getObject(entryInfo.get("id")) == null) continue;
                if (entryInfo.get(fields[1]) instanceof CoreBaseInfo) {
                    if (fields.length == 2) {
                        if (((CoreBaseInfo)entryInfo.get(fields[1])).get("number") == null) continue;
                        genNumber = genNumber + ((CoreBaseInfo)entryInfo.get(fields[1])).get("number");
                        continue;
                    }
                    if (fields.length <= 2 || ((CoreBaseInfo)entryInfo.get(fields[1])).get("number") == null) continue;
                    genNumber = genNumber + ((CoreBaseInfo)entryInfo.get(fields[1])).get(fields[2]);
                    continue;
                }
                if ("seq".equalsIgnoreCase(fields[1]) && entryInfo.get(fields[1]) == null) {
                    entryInfo.put("seq", (Object)(seq + 1));
                }
                if (entryInfo.get(fields[1]) == null) continue;
                Object propVal = entryInfo.get(fields[1]);
                if (propVal instanceof BigDecimal) {
                    BigDecimal amt = (BigDecimal)propVal;
                    if (amt.compareTo(BigDecimal.ZERO) == 0) {
                        genNumber = genNumber + "0";
                        continue;
                    }
                    genNumber = genNumber + amt.stripTrailingZeros().toPlainString();
                    continue;
                }
                genNumber = genNumber + entryInfo.get(fields[1]);
                continue;
            }
            if (FormtEnum.sysDate.equals((Object)ruleInfo.getEntry().get(i).getPerType())) {
                SimpleDateFormat time = new SimpleDateFormat(ruleInfo.getEntry().get(i).getFormt());
                genNumber = genNumber + time.format(new Date());
                continue;
            }
            if (ruleInfo.getEntry().get(i).getPerType() != FormtEnum.li) continue;
            String sn = IndBarcodeRuleSNFactory.getLocalInstance(ctx).generateBarcode(ruleInfo.getEntry().get(i), new Date());
            if (sn == null) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u751f\u6210\u6761\u7801\u503c\u9519\u8bef"));
            }
            genNumber = genNumber + sn;
        }
        return genNumber;
    }

    @Override
    protected void _generateLogers(Context ctx, Map pramMap) throws BOSException, EASBizException {
        IndBarcodeBackCollection backCol = (IndBarcodeBackCollection)((Object)pramMap.get("data"));
        CoreBaseCollection coreCol = new CoreBaseCollection();
        if (backCol == null) {
            backCol = new IndBarcodeBackCollection();
            IndBarcodeBackInfo backInfo = new IndBarcodeBackInfo();
            IObjectValue editData = (IObjectValue)pramMap.get("editData");
            Object rowNum = pramMap.get("rowNum");
            String barcode = (String)pramMap.get("barcode");
            BigDecimal barcodeQty = new BigDecimal("1");
            if (barcode != null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("qty"));
                viewInfo.setSelector(sic);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcode, CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                BarcodeDossierCollection dossiercol = null;
                try {
                    dossiercol = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(viewInfo);
                    if (dossiercol.size() > 0) {
                        BarcodeDossierInfo dossierInfo = dossiercol.get(0);
                        barcodeQty = dossierInfo.getQty();
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            this.setLogersInfo(ctx, backCol, backInfo, editData, rowNum, barcode, barcodeQty);
        }
        coreCol.addObjectCollection((IObjectCollection)backCol);
        if (coreCol != null) {
            IndBarcodeBackFactory.getLocalInstance(ctx).addnewBatchData(coreCol);
        }
    }

    private void setLogersInfo(Context ctx, IndBarcodeBackCollection backCol, IndBarcodeBackInfo backInfo, IObjectValue editData, Object rowNum, String barcode, BigDecimal barcodeQty) {
        backInfo = new IndBarcodeBackInfo();
        backInfo.setId(BOSUuid.create((BOSObjectType)backInfo.getBOSType()));
        backInfo.setNumber(backInfo.getId().toString());
        backInfo.setName(barcode);
        backInfo.setBizDate(new Date());
        if (editData.get("billType") != null) {
            backInfo.setBillType((BillTypeInfo)editData.get("billType"));
        }
        if (editData.get("bizType") != null) {
            backInfo.setBizType((BizTypeInfo)editData.get("bizType"));
        }
        backInfo.setNum(editData.get("number") == null ? "" : editData.get("number").toString());
        if (rowNum != null && !"0".equals(rowNum)) {
            backInfo.setRowNum(rowNum + "");
        }
        backInfo.put("storageOrgUnit", editData.get("storageOrgUnit") == null ? ContextUtil.getCurrentStorageUnit((Context)ctx) : editData.get("storageOrgUnit"));
        backInfo.setBarcodeQty(barcodeQty);
        backInfo.setCreateTime(this.getTime());
        backInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        backInfo.put("transactionType", editData.get("transactionType"));
        backInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        backInfo.setCreateTime(this.getTime());
        backInfo.setLastUpdateTime(this.getTime());
        backInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        backCol.add(backInfo);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected void _unWriteQty(Context ctx, Map parmMap) throws BOSException, EASBizException {
        IObjectValue obj = (IObjectValue)parmMap.get("editData");
        Object type = parmMap.get("type");
        if (type != null) {
            return;
        }
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)obj.getBOSType()));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ctrlUnitInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("master.*");
        sic.add("master.Entry.*");
        sic.add("Entry.*");
        sic.add("Entry.property.*");
        ev.setSelector(sic);
        IndBarcodeSetupCollection setupCol = IndBarcodeSetupFactory.getLocalInstance(ctx).getIndBarcodeSetupCollection(ev);
        IndBarcodeSetupInfo setupInfo = null;
        IndBarcodeMasterInfo masterInfo = null;
        if (setupCol.size() < 1) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u672a\u627e\u5230\u6863\u6848\u4e0e\u5355\u636e\u5173\u7cfb"));
        }
        setupInfo = setupCol.get(0);
        masterInfo = setupInfo.getMaster();
        HashMap<BOSUuid, String> headItems = new HashMap<BOSUuid, String>();
        HashMap<BOSUuid, String> entryItems = new HashMap<BOSUuid, String>();
        String field = null;
        String[] fields = null;
        Object propery = null;
        String entrys = null;
        for (int i = 0; i < setupInfo.getEntry().size(); ++i) {
            field = setupInfo.getEntry().get(i).getFullName();
            if (field == null) continue;
            fields = field.split("\\.");
            if (fields.length == 1) {
                headItems.put(setupInfo.getEntry().get(i).getId(), field);
                continue;
            }
            if (fields.length != 2) continue;
            if (entrys == null) {
                entrys = fields[0];
            }
            entryItems.put(setupInfo.getEntry().get(i).getId(), fields[1]);
        }
        if (obj instanceof PurInWarehsBillInfo || obj instanceof ManufactureRecBillInfo || obj instanceof MoveInWarehsBillInfo || obj instanceof OtherInWarehsBillInfo) {
            try {
                if ("audit".equals(type)) {
                    this.unWriteCheck(ctx, obj, setupInfo, headItems, entryItems, new BigDecimal(1), entrys);
                }
                this.unWriteCheck(ctx, obj, setupInfo, headItems, entryItems, new BigDecimal(-1), entrys);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (obj instanceof SaleIssueBillInfo || obj instanceof MaterialReqBillInfo || obj instanceof MoveIssueBillInfo || obj instanceof OtherIssueBillInfo) {
            try {
                if ("audit".equals(type)) {
                    this.unWriteCheck(ctx, obj, setupInfo, headItems, entryItems, new BigDecimal(-1), entrys);
                } else {
                    this.unWriteCheck(ctx, obj, setupInfo, headItems, entryItems, new BigDecimal(1), entrys);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void unWriteCheck(Context ctx, IObjectValue obj, IndBarcodeSetupInfo setupInfo, Map headItems, Map entryItems, BigDecimal type, String entrys) throws BOSException, SQLException, EASBizException {
        block16: {
            String sql;
            String filterSql;
            FilterInfo filter;
            EntityViewInfo ev;
            String property;
            InvBillBaseEntryInfo entryInfo;
            block17: {
                AbstractObjectCollection col = null;
                if (entrys != null) {
                    col = (AbstractObjectCollection)obj.get(entrys);
                }
                entryInfo = null;
                property = null;
                ev = null;
                filter = null;
                filterSql = null;
                sql = "select FPARENTID,COUNT(*) NUM from CT_IND_barcodeDossierEntry \n";
                if (col == null) break block17;
                block0: for (int i = 0; i < col.size(); ++i) {
                    int count = 0;
                    entryInfo = (InvBillBaseEntryInfo)col.getObject(i);
                    ev = new EntityViewInfo();
                    filter = new FilterInfo();
                    filterSql = null;
                    for (int j = 0; j < setupInfo.getEntry().size(); ++j) {
                        if (!setupInfo.getEntry().get(j).getProperty().isIsCheck()) continue;
                        ++count;
                        if (headItems.get(setupInfo.getEntry().get(j).getId()) != null) {
                            property = headItems.get(setupInfo.getEntry().get(j).getId()).toString();
                            if (filterSql == null) {
                                filterSql = "(CFDisplayNameID='" + setupInfo.getEntry().get(j).getProperty().getId() + "'";
                                if (obj.get(property) instanceof CoreBaseInfo) {
                                    filterSql = filterSql + "and cfvalue='" + ((CoreBaseInfo)obj.get(property)).get("number") + "')";
                                    continue;
                                }
                                filterSql = filterSql + "and cfvalue='" + obj.get(property) + "') \n";
                                continue;
                            }
                            filterSql = filterSql + "or (CFDisplayNameID='" + setupInfo.getEntry().get(j).getProperty().getId() + "'";
                            if (obj.get(property) instanceof CoreBaseInfo) {
                                filterSql = filterSql + "and cfvalue='" + ((CoreBaseInfo)obj.get(property)).get("number") + "')";
                                continue;
                            }
                            filterSql = filterSql + "and cfvalue='" + obj.get(property) + "') \n";
                            continue;
                        }
                        if (entryItems.get(setupInfo.getEntry().get(j).getId()) == null) continue;
                        property = entryItems.get(setupInfo.getEntry().get(j).getId()).toString();
                        if (filterSql == null) {
                            filterSql = "(CFDisplayNameID='" + setupInfo.getEntry().get(j).getProperty().getId() + "'";
                            if (entryInfo.get(property) instanceof CoreBaseInfo) {
                                filterSql = filterSql + "and cfvalue='" + ((CoreBaseInfo)entryInfo.get(property)).get("number") + "')";
                                continue;
                            }
                            filterSql = filterSql + "and cfvalue='" + entryInfo.get(property) + "') \n";
                            continue;
                        }
                        filterSql = filterSql + "or (CFDisplayNameID='" + setupInfo.getEntry().get(j).getProperty().getId() + "'";
                        filterSql = entryInfo.get(property) instanceof CoreBaseInfo ? filterSql + "and cfvalue='" + ((CoreBaseInfo)entryInfo.get(property)).get("number") + "')" : filterSql + "and cfvalue='" + entryInfo.get(property) + "') \n";
                    }
                    if (count <= 0) continue;
                    sql = sql + " where  \n";
                    sql = sql + filterSql;
                    sql = sql + " GROUP BY FPARENTID \n";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rowSet.next()) {
                        BarcodeDossierEntryInfo info;
                        if (rowSet.getInt("NUM") != count) continue;
                        String barRuleID = null;
                        for (int j = 0; j < setupInfo.getEntry().size(); ++j) {
                            if (!"\u6570\u91cf".equals(setupInfo.getEntry().get(j).getProperty().getName())) continue;
                            barRuleID = setupInfo.getEntry().get(j).getProperty().getId().toString();
                            break;
                        }
                        if (barRuleID == null || (info = BarcodeDossierEntryFactory.getLocalInstance(ctx).getBarcodeDossierEntryInfo("where parent.id='" + rowSet.getString("FPARENTID") + "' and displayName.id='" + barRuleID + "'")) == null) continue block0;
                        BigDecimal qty = new BigDecimal(info.getValue());
                        qty = qty.add(entryInfo.getBaseQty().multiply(type));
                        DbUtil.execute((Context)ctx, (String)("update CT_IND_barcodeDossierEntry set cfvalue='" + qty + "' where fid='" + info.getId() + "'"));
                        continue block0;
                    }
                }
                break block16;
            }
            int count = 0;
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filterSql = null;
            for (int j = 0; j < setupInfo.getEntry().size(); ++j) {
                if (!setupInfo.getEntry().get(j).getProperty().isIsCheck()) continue;
                ++count;
                if (headItems.get(setupInfo.getEntry().get(j).getId()) == null) continue;
                property = headItems.get(setupInfo.getEntry().get(j).getId()).toString();
                if (filterSql == null) {
                    filterSql = "(CFDisplayNameID='" + setupInfo.getEntry().get(j).getProperty().getId() + "'";
                    if (obj.get(property) instanceof CoreBaseInfo) {
                        filterSql = filterSql + "and cfvalue='" + ((CoreBaseInfo)obj.get(property)).get("number") + "')";
                        continue;
                    }
                    filterSql = filterSql + "and cfvalue='" + obj.get(property) + "') \n";
                    continue;
                }
                filterSql = filterSql + "or (CFDisplayNameID='" + setupInfo.getEntry().get(j).getProperty().getId() + "'";
                filterSql = obj.get(property) instanceof CoreBaseInfo ? filterSql + "and cfvalue='" + ((CoreBaseInfo)obj.get(property)).get("number") + "')" : filterSql + "and cfvalue='" + obj.get(property) + "') \n";
            }
            if (count <= 0) break block16;
            sql = sql + " where  \n";
            sql = sql + filterSql;
            sql = sql + " GROUP BY FPARENTID \n";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                BarcodeDossierEntryInfo info;
                if (rowSet.getInt("NUM") != count) continue;
                String barRuleID = null;
                for (int j = 0; j < setupInfo.getEntry().size(); ++j) {
                    if (!"\u6570\u91cf".equals(setupInfo.getEntry().get(j).getProperty().getName())) continue;
                    barRuleID = setupInfo.getEntry().get(j).getProperty().getId().toString();
                    break;
                }
                if (barRuleID == null || (info = BarcodeDossierEntryFactory.getLocalInstance(ctx).getBarcodeDossierEntryInfo("where parent.id='" + rowSet.getString("FPARENTID") + "' and displayName.id='" + barRuleID + "'")) == null) break;
                BigDecimal qty = new BigDecimal(info.getValue());
                qty = qty.add(entryInfo.getBaseQty().multiply(type));
                DbUtil.execute((Context)ctx, (String)("update CT_IND_barcodeDossierEntry set cfvalue='" + qty + "' where fid='" + info.getId() + "'"));
                break;
            }
        }
    }

    private IndBarcodeRuleInfo getBarcodeRuleInfo(Context ctx, String bosType, String barcodeType) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("barcodeType", (Object)barcodeType));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        IndBarcodeRuleCollection ruleCol = IndBarcodeRuleFactory.getLocalInstance(ctx).getIndBarcodeRuleCollection(ev);
        if (ruleCol.size() > 0) {
            return ruleCol.get(0);
        }
        return null;
    }
}

