/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.BarcodeLicenseUtils;
import com.kingdee.eas.barcode.pda.app.Util2;
import com.kingdee.eas.barcode.scm.LiceControlCollection;
import com.kingdee.eas.barcode.scm.LiceControlInfo;
import com.kingdee.eas.barcode.scm.app.AbstractLiceControlControllerBean;
import com.kingdee.eas.barcode.scm.app.LicenseCache;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LiceControlControllerBean
extends AbstractLiceControlControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.LiceControlControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LiceControlInfo info = (LiceControlInfo)model;
        if (info.getId().toString().equals("8r0AAAAKd7DEH5St")) {
            Map<String, Object> lisense = Util2.getLisense(ctx);
            int users = 0;
            if (lisense.get("users") != null) {
                users = Integer.valueOf((String)lisense.get("users"));
            }
            if (info.getEntry().size() > users) {
                for (int i = 1; i < info.getEntry().size(); ++i) {
                    info.getEntry().removeObject(i);
                }
            }
            info.setLicnum(users);
            LiceControlInfo oldInfo = this.getLiceControlInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            Set oldKeys = oldInfo.getAllKey();
            String key = null;
            for (int i = 0; i < info.getEntry().size(); ++i) {
                key = info.getEntry().get(i).getCondition();
                if (oldKeys.contains(key)) continue;
                info.getEntry().get(i).setOnline(false);
                info.getEntry().get(i).setLastonlinetime(null);
            }
            LicenseCache.freshCache(ctx, info);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    public String getMachineCode(Context ctx) throws BOSException, EASBizException {
        try {
            LicenseSrvAgent iILicenseSrvAgent = new LicenseSrvAgent();
            LicenseBaseInfo licenseBaInfo = iILicenseSrvAgent.getLicenseBaseInfo();
            String machineCode = licenseBaInfo.getMechineCode();
            if (StringUtils.isEmpty((String)machineCode)) {
                iILicenseSrvAgent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
                machineCode = iILicenseSrvAgent.getLicenseBaseInfo().getMechineCode();
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                machineCode = runtime.getName();
            }
            return machineCode;
        }
        catch (LicenseException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("-100", "\u83b7\u53d6\u673a\u5668\u7279\u5f81\u7801\u5f02\u5e38"), (Throwable)e);
        }
    }

    @Override
    public String getMetaRumTime(Context ctx) throws BOSException, EASBizException {
        LiceControlInfo info = this.getMetaRumTimeInfo(ctx);
        return info.getName();
    }

    private LiceControlInfo getMetaRumTimeInfo(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)new ObjectUuidPK("fDGyyXoL40+G+EdlgNu9i8QflK0=")));
        LiceControlCollection coll = this.getLiceControlCollection(ctx, view);
        LiceControlInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
        } else {
            info = new LiceControlInfo();
            info.setId(BOSUuid.read((String)"fDGyyXoL40+G+EdlgNu9i8QflK0="));
            info.setNumber("meta.runtime");
            info.setName(this.genRunTimeId());
            info.setDescription("");
            IObjectPK pk = this._addnew(ctx, (IObjectValue)info);
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        return info;
    }

    private String genRunTimeId() {
        return Uuid.randomUUID().toString();
    }

    @Override
    public String genApplyInfo(Context ctx, int users, Date expdate) throws BOSException, EASBizException {
        String machineCode = this.getMachineCode(ctx);
        LiceControlInfo rumtime = this.getMetaRumTimeInfo(ctx);
        FullOrgUnitInfo org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        String customName = null;
        if (org != null) {
            customName = org.getName();
        }
        String reqInfo = BarcodeLicenseUtils.getLicenseApplyText(customName, "" + users, "999", DateUtil.formatDate((Date)expdate), rumtime.getName(), machineCode);
        return reqInfo;
    }

    @Override
    public Map _importBarLicenseInfo(Context ctx, String info) throws BOSException, EASBizException {
        HashMap<String, Integer> revMap = new HashMap<String, Integer>();
        try {
            int status = BarcodeLicenseUtils.importLicenseText(ctx, info);
            if (status == 1) {
                LicenseCache.setLicenseInfo(ctx, info);
            }
            revMap.put("status", status);
        }
        catch (Exception e) {
            e.printStackTrace();
            revMap.put("status", -3);
        }
        return revMap;
    }
}

