/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.barcode.pda.app.Util2;
import com.kingdee.eas.barcode.scm.LicControlFacadeFactory;
import com.kingdee.eas.barcode.scm.LiceControlInfo;
import com.kingdee.eas.barcode.scm.util.Json;
import com.kingdee.eas.barcode.scm.util.PropertiesUtil;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LicenseCache {
    private static Map dataCacheMap = new HashMap();
    private static Map data_jsonMap = new HashMap();

    private LicenseCache() {
    }

    public static void setLicenseInfo(Context ctx, String license) {
        data_jsonMap.put(ctx.getAIS(), license);
    }

    public static String getDataJson(Context ctx) {
        return (String)data_jsonMap.get(ctx.getAIS());
    }

    public static void freshCache(Context ctx, LiceControlInfo info) {
        Object o = dataCacheMap.get(ctx.getAIS());
        if (o == null) {
            for (int i = 0; i < info.getEntry().size(); ++i) {
                info.getEntry().get(i).setOnline(false);
                info.getEntry().get(i).setLastonlinetime(null);
            }
            dataCacheMap.put(ctx.getAIS(), info);
        } else if (o instanceof LiceControlInfo) {
            dataCacheMap.put(ctx.getAIS(), info);
        } else {
            return;
        }
    }

    public static void checkLicense(Context ctx, String key) throws LicenseException {
        LiceControlInfo info = (LiceControlInfo)LicenseCache.getLicenseInfo(ctx, key);
        if (info == null) {
            throw new LicenseException(LicenseCache.getMassege(ctx, "noLicense"));
        }
    }

    public static void checkPDA(Context ctx, String key) throws LicenseException {
        LiceControlInfo info = (LiceControlInfo)LicenseCache.getLicenseInfo(ctx, key);
        if (info != null) {
            if (info.getEntry(key) != null) {
                info.getEntry(key).setOnline(true);
                info.getEntry(key).setLastonlinetime(new Date());
                return;
            }
            throw new LicenseException(LicenseCache.getMassege(ctx, "noRegister"));
        }
    }

    public static void releaseLicense(Context ctx, String key) throws LicenseException {
        LiceControlInfo info = (LiceControlInfo)LicenseCache.getLicenseInfo(ctx, key);
        if (info.getOnlineSet().contains(key)) {
            int count = info.getEntry().size();
            for (int i = 0; i < count; ++i) {
                if (!info.getEntry().get(i).getCondition().equals(key)) continue;
                info.getEntry().get(i).setOnline(false);
            }
            return;
        }
        if (info.getEntry(key) != null) {
            return;
        }
        throw new LicenseException(LicenseCache.getMassege(ctx, "nodeviceExists"));
    }

    public static Object getLicenseInfo(Context ctx, String key) throws LicenseException {
        return LicenseCache.getLicenseInfo(ctx, true, key);
    }

    public static Object getLicenseInfo(Context ctx, boolean needLoad, String equ) throws LicenseException {
        Object o;
        String key;
        Map license = (Map)Json.toObject(LicenseCache.getDataJson(ctx));
        if (license == null) {
            return null;
        }
        String json = (String)license.get("json");
        if (!Util2.isValid(json, key = (String)license.get("key"))) {
            return null;
        }
        String expire = (String)((Map)Json.toObject((String)license.get("json"))).get("expire");
        if (expire != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            expire = expire.substring(0, 19);
            Date expdate = new Date();
            try {
                expdate = sdf.parse(expire);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Date nowdate = new Date();
            if (nowdate.after(expdate)) {
                return null;
            }
        }
        if ((o = dataCacheMap.get(ctx.getAIS())) == null) {
            if (!needLoad) {
                return o;
            }
            try {
                Map revMap = LicControlFacadeFactory.getLocalInstance(ctx).getLicenseInfo(equ);
                return dataCacheMap.put(ctx.getAIS(), revMap.get("info"));
            }
            catch (BOSException e) {
                e.printStackTrace();
                return null;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                return null;
            }
        }
        return o;
    }

    public static Map<String, String> getBarcodeVersion() {
        return PropertiesUtil.readBarcodeVersionFile();
    }

    public static void checkBarcodeVersion(Context ctx, String key) throws LicenseException {
        Map<String, String> barcodeVersionMap = LicenseCache.getBarcodeVersion();
        if (barcodeVersionMap == null || !barcodeVersionMap.containsValue(key)) {
            throw new LicenseException(LicenseCache.getMassege(ctx, "machineCode"));
        }
    }

    private static String getMassege(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)key, (Locale)ctx.getLocale());
    }
}

