/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.barcode.scm.PackageBarcodeCollection;
import com.kingdee.eas.barcode.scm.PackageBarcodeEntryInfo;
import com.kingdee.eas.barcode.scm.PackageBarcodeFactory;
import com.kingdee.eas.barcode.scm.PackageBarcodeInfo;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class PackgeBarcodeImport
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PackageBarcodeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.toString(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        PackageBarcodeInfo info = (PackageBarcodeInfo)coreBaseInfo;
        info.setStatus(StatusEnum.SAVED);
        try {
            PackageBarcodeCollection coll;
            int model = (Integer)this.getContextParameter().get("DATATASKMODE");
            if (model == 16 && (coll = PackageBarcodeFactory.getLocalInstance(ctx).getPackageBarcodeCollection("select id where pacakgeBarcode = '" + info.getPacakgeBarcode() + "'")) != null && coll.size() > 0) {
                String id = coll.get(0).getId().toString();
                this.getController(ctx).delete((IObjectPK)new ObjectUuidPK(id));
            }
            this.getController(ctx).submit((CoreBaseInfo)info);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PackageBarcodeInfo info = null;
        this.verify(hsData, ctx);
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (info == null) {
                info = new PackageBarcodeInfo();
                Object barcode = ((DataToken)lineData.get((Object)"FPacakgeBarcode")).data;
                info.setPacakgeBarcode(barcode.toString());
            }
            PackageBarcodeEntryInfo entryInfo = new PackageBarcodeEntryInfo();
            Object detailBarcode = ((DataToken)lineData.get((Object)"FEntry_barcode")).data;
            entryInfo.setBarcode(detailBarcode.toString());
        }
        return info;
    }

    protected void verify(Hashtable hsData, Context ctx) throws TaskExternalException {
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            Object barcode = ((DataToken)lineData.get((Object)"FPacakgeBarcode")).data;
            Object detailBarcode = ((DataToken)lineData.get((Object)"FEntry_barcode")).data;
            if (barcode == null || barcode.toString().equals("")) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"74_PackageBarcodeControllerBean", (Locale)ctx.getLocale()));
            }
            if (detailBarcode != null && !detailBarcode.toString().equals("")) continue;
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"80_PackgeBarcodeImport", (Locale)ctx.getLocale()));
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FPacakgeBarcode", rs.getString("pacakgeBarcode"));
            result.put("FEntry_barcode", rs.getString("entry.barcode"));
        }
        catch (SQLException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.barcode.app.PackageBarcodeQueryForExport";
    }

    public String getMainField() {
        return "FPacakgeBarcode";
    }
}

