/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.barcode.common.BillBaseStatusEnum;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodeScanningBarcodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.IScanTaskBill;
import com.kingdee.eas.barcode.scm.IScanTaskBillChirdEntry;
import com.kingdee.eas.barcode.scm.ScanTaskBillChirdEntryFactory;
import com.kingdee.eas.barcode.scm.ScanTaskBillChirdEntryInfo;
import com.kingdee.eas.barcode.scm.ScanTaskBillCollection;
import com.kingdee.eas.barcode.scm.ScanTaskBillEntryInfo;
import com.kingdee.eas.barcode.scm.ScanTaskBillFactory;
import com.kingdee.eas.barcode.scm.ScanTaskBillInfo;
import com.kingdee.eas.barcode.scm.ScheduleEnum;
import com.kingdee.eas.barcode.scm.SynDataBaseBaseEntryInfo;
import com.kingdee.eas.barcode.scm.SynDataBaseCollection;
import com.kingdee.eas.barcode.scm.SynDataBaseFactory;
import com.kingdee.eas.barcode.scm.SynDataBaseInfo;
import com.kingdee.eas.barcode.scm.app.AbstractScanTaskBillControllerBean;
import com.kingdee.eas.barcode.scm.app.bizprocess.ScmDataProcess;
import com.kingdee.eas.barcode.scm.util.CalculateLotBarcodeHelper;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.CodingRuleUtils;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ScanTaskBillControllerBean
extends AbstractScanTaskBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.ScanTaskBillControllerBean");
    public String barcodeScanningId = null;
    public static String countTableEntryBosType = "CF0E4015";
    public static String countTalbeBosType = "D9D2CA5D";
    public List<BarcodeConfigXMLDetail> xmlDetail;
    public static final String COUNTINGTABLE_BOSTYPE = "D9D2CA5D";
    public static final String COUNTINGTASK_BOSTYPE = "AC301916";
    public static final String COUNTINGTABLEENTRY_BOSTYPE = "CF0E4015";

    @Override
    protected Object _getDestBill(Context ctx, Object argument) throws BOSException, EASBizException {
        LinkedHashMap paramMap = (LinkedHashMap)argument;
        ObjectBaseCollection destBillColl = new ObjectBaseCollection();
        String bosType = null;
        if (paramMap.get("srcBosType") != null && !paramMap.get("srcBosType").equals("")) {
            bosType = paramMap.get("srcBosType").toString();
        } else if (paramMap.get("destBosType") != null && !paramMap.get("destBosType").equals("")) {
            bosType = paramMap.get("destBosType").toString();
        }
        if (bosType == null) {
            return null;
        }
        String idStr = paramMap.get("idStr").toString();
        if (idStr.length() < 0) {
            return null;
        }
        SelectorItemCollection sic = (SelectorItemCollection)paramMap.get("sic");
        CoreBillBaseInfo info = null;
        if (!paramMap.containsKey("splitMap")) {
            ICoreBillBase iCoreBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bosType));
            EntityViewInfo view = new EntityViewInfo();
            if (sic != null) {
                view.setSelector(sic);
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            CoreBillBaseCollection coll = iCoreBase.getCoreBillBaseCollection(view);
            if (coll != null && coll.size() > 0) {
                info = coll.get(0);
            } else {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"46_BarcodeScanningControllerBean", (Locale)ctx.getLocale())));
            }
        }
        if (paramMap.get("srcBosType") != null && !paramMap.get("srcBosType").equals("")) {
            if (paramMap.get("srcBosType").toString().equals(COUNTINGTASK_BOSTYPE)) {
                String select = this.getSelectFields();
                String whereSql = select + " where countingTask.id = '" + info.getId().toString() + "'";
                ObjectBaseCollection objcoll = ((IObjectBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)COUNTINGTABLE_BOSTYPE))).getObjectBaseCollection(whereSql);
                destBillColl.addObjectCollection((IObjectCollection)objcoll);
            } else if (paramMap.get("srcBosType").toString().length() > 0) {
                IBTPManager ibtp = BTPManagerFactory.getLocalInstance((Context)ctx);
                BOTMappingInfo botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo(" where name = '" + paramMap.get("botpNumber") + "'");
                BTPTransformResult result = null;
                String entryName = BOTMappingUtil.getDestEntriesName((Context)ctx, (BOTMappingInfo)botMappingInfo);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo(entryName + ".warehouse.id"));
                if (paramMap.containsKey("splitMap")) {
                    IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                    Map splitMap = (Map)paramMap.get("splitMap");
                    String scanQtyFiled = paramMap.get("scanQtyFiled").toString();
                    Map billIDMap = (Map)paramMap.get("billIDMap");
                    result = iBTPManager.transformForBotp(new String[]{idStr}, new String[]{BOTMappingUtil.getSrcEntriesName((BOTMappingInfo)botMappingInfo)}, Arrays.asList((Object[])splitMap.keySet().toArray()), sic, bosType, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()), paramMap.get("srcBosType").toString());
                    IObjectCollection resultCol = result.getBills();
                    IObjectValue objectValue = resultCol.getObject(0);
                    IObjectCollection objectCol = (IObjectCollection)objectValue.get(entryName);
                    int size = objectCol.size();
                    for (int i = 0; i < size; ++i) {
                        IObjectValue entryValue = objectCol.getObject(i);
                        String srcEntryId = entryValue.get("sourceBillEntryId").toString();
                        if (splitMap.containsKey(srcEntryId)) {
                            BigDecimal qty = (BigDecimal)splitMap.get(srcEntryId);
                            entryValue.put(scanQtyFiled, (Object)qty);
                        }
                        if (!billIDMap.containsKey(srcEntryId)) continue;
                        entryValue.put("fsrcScanEntryId", (Object)billIDMap.get(srcEntryId).toString());
                    }
                } else {
                    result = ibtp.transform(info, botMappingInfo);
                }
                IObjectCollection resultCol = result.getBills();
                IObjectValue editData = resultCol.getObject(0);
                this.calculateLot(ctx, editData, botMappingInfo);
                destBillColl.addObject(editData);
            }
        } else {
            destBillColl.addObject(info);
        }
        return destBillColl;
    }

    private IObjectValue calculateLot(Context ctx, IObjectValue editData, BOTMappingInfo botMappingInfo) throws EASBizException, BOSException {
        if (editData instanceof InvBillBaseInfo) {
            InvBillBaseInfo billInfo = (InvBillBaseInfo)editData;
            String entryName = BOTMappingUtil.getDestEntriesName((Context)ctx, (BOTMappingInfo)botMappingInfo);
            IObjectCollection objectCol = (IObjectCollection)editData.get(entryName);
            ArrayList<IObjectValue> billEntryList = new ArrayList<IObjectValue>();
            ArrayList<String> materialList = new ArrayList<String>();
            if (billInfo.getStorageOrgUnit() == null) {
                billInfo.setStorageOrgUnit(ContextUtil.getCurrentStorageUnit((Context)ctx));
            }
            int size = objectCol.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entryValue = objectCol.getObject(i);
                if (!(entryValue instanceof InvBillBaseEntryInfo)) continue;
                InvBillBaseEntryInfo invEntryInfo = (InvBillBaseEntryInfo)entryValue;
                billEntryList.add((IObjectValue)invEntryInfo);
                if (invEntryInfo.getMaterial() != null && invEntryInfo.getMaterial().getId() != null) {
                    materialList.add(invEntryInfo.getMaterial().getId().toString());
                }
                if (invEntryInfo.getStorageOrgUnit() == null) {
                    invEntryInfo.setStorageOrgUnit(billInfo.getStorageOrgUnit());
                }
                if (invEntryInfo.getWarehouse() == null) {
                    invEntryInfo.put("warehouse", null);
                }
                if (invEntryInfo.getLocation() != null) continue;
                invEntryInfo.put("location", null);
            }
            try {
                if (billInfo.getBillType() == null) {
                    billInfo.setBillType(this.getBillType(ctx, billInfo.getBOSType().toString()));
                }
                if (billInfo.getTransactionType() == null && billInfo.getBillType() != null && billInfo.getBizType() != null) {
                    billInfo.setTransactionType(InvCommonUtils.getDefaultTransactionType((Context)ctx, (String)billInfo.getBillType().getId().toString(), (String)billInfo.getBizType().getId().toString()));
                }
                new ScmDataProcess().beforeSaveEasBill(ctx, (IObjectValue)billInfo);
                Map<String, Object> indexMap = new CalculateLotBarcodeHelper().matchLot(ctx, billInfo, billEntryList);
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection coll = new SelectorItemCollection();
                coll.add(new SelectorItemInfo("defaultWarehouse.id"));
                coll.add(new SelectorItemInfo("material.id"));
                viewInfo.setSelector(coll);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)billInfo.getStorageOrgUnit().getId()));
                HashSet<String> materialSet = new HashSet<String>();
                materialSet.addAll(materialList);
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                MaterialInventoryCollection materialInvCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewInfo);
                objectCol = (IObjectCollection)editData.get(entryName);
                int size2 = materialInvCol.size();
                for (int i = 0; i < size2; ++i) {
                    MaterialInventoryInfo materialInvInfo = materialInvCol.get(i);
                    int m = objectCol.size();
                    for (int j = 0; j < m; ++j) {
                        InvBillBaseEntryInfo invEntryInfo;
                        IObjectValue entryValue = objectCol.getObject(j);
                        if (!(entryValue instanceof InvBillBaseEntryInfo) || (invEntryInfo = (InvBillBaseEntryInfo)entryValue).getWarehouse() != null) continue;
                        if (invEntryInfo.get("supplyWarehouse") != null) {
                            invEntryInfo.put("warehouse", invEntryInfo.get("supplyWarehouse"));
                            continue;
                        }
                        if (invEntryInfo.getMaterial() == null || !materialInvInfo.getMaterial().getId().equals((Object)invEntryInfo.getMaterial().getId())) continue;
                        invEntryInfo.setWarehouse(materialInvInfo.getDefaultWarehouse());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return editData;
    }

    private BillTypeInfo getBillType(Context ctx, String bosType) throws EASBizException, BOSException {
        BillTypeInfo billType = null;
        try {
            billType = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo("where bosType='" + bosType + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return billType;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ScanTaskBillInfo info = (ScanTaskBillInfo)model;
        if (info.getNumber() == null || info.getNumber().equals("")) {
            String number = CodingRuleUtils.getNumberByCtrlBean((Context)ctx, (IObjectValue)model, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            info.setNumber(number);
        }
        this.verfiy(ctx, model);
        if (info.getBillStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem(null, "\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u4e0d\u80fd\u63d0\u4ea4\uff01"));
        }
        boolean isAddNewSave = false;
        if (info.getCreateTime() == null) {
            isAddNewSave = true;
        }
        IObjectPK pk = super._submit(ctx, model);
        if (isAddNewSave) {
            String sql = "update CT_SCM_ScanTaskBill  set flastupdateuserid = null,flastupdatetime = null where fid = '" + pk.toString() + "'";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
        }
        String oql = "select id,detailsXML where id ='" + info.getBarcodeConfig().getId() + "'";
        BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo(oql);
        BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(configInfo.getDetailsXML());
        this._saveScanningRecodes(ctx, info.getScanRecodeList(), info.getDestBosType(), configXml);
        return pk;
    }

    private void verfiy(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ScanTaskBillInfo info = (ScanTaskBillInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        IScanTaskBill iScanTaskBill = ScanTaskBillFactory.getLocalInstance(ctx);
        ScanTaskBillCollection coll = iScanTaskBill.getScanTaskBillCollection(view);
        if (coll != null && coll.size() >= 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"10_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        if (info.getTaskName() != null) {
            filter.getFilterItems().add(new FilterItemInfo("taskName", (Object)info.getTaskName(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        if (iScanTaskBill.exists(filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"taskName", (Locale)ctx.getLocale())));
        }
    }

    private String getSelectFields() {
        String select = "select *,storageOrgUnit.number,storageOrgUnit.name,warehouse.number,warehouse.name,countingPerson.number,countingPerson.name,countingAgainPerson.number,countingAgainPerson.name,countingMonitorer.number,entry.*,entry.location.number,entry.location.name,entry.material.number,entry.material.name,entry.storeType.number,entry.storeType.name,entry.unit.number,entry.unit.name,entry.assistUnit.number,entry.assistUnit.name,entry.storeStatus.number,entry.storeStatus.name";
        return select;
    }

    @Override
    protected void _saveScanningRecodes(Context ctx, List list, String entityBosType, Object xml) throws BOSException, EASBizException {
        List recodeList;
        BarcodeConfigXML configXml = (BarcodeConfigXML)xml;
        this.xmlDetail = configXml.getDetails();
        if (list != null && (recodeList = list).size() > 0) {
            this.barcodeScanningId = ((BarcodeScanningRecodeInfo)recodeList.get(0)).getFparentId();
            this.deleteRecodesAndSeq(ctx, entityBosType);
            this.updateData(ctx, recodeList);
            this.updateRecodesList(ctx, entityBosType, recodeList);
            this.updateBarcodes(ctx, entityBosType, recodeList);
            this.updateSeqNos(ctx, entityBosType, recodeList);
        }
    }

    @Override
    protected Object _getRecodesList(Context ctx, String id, Object xml) throws BOSException, EASBizException {
        BarcodeConfigXML xmlInfo = (BarcodeConfigXML)xml;
        List<BarcodeConfigXMLDetail> detailList = xmlInfo.getDetails();
        for (int i = 0; i < detailList.size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = detailList.get(i);
            EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)xmlDetail.getBosType()));
            if (xmlDetail.getParentBosType() != null) continue;
            String bosType = xmlDetail.getBosType();
            List<BarcodeConfigXMLProperty> propertyList = xmlDetail.getProperties();
            IRowSet rowSet = this.getRowSet(ctx, id, propertyList, bosType);
            ArrayList<BarcodeScanningRecodeInfo> recodesList = new ArrayList<BarcodeScanningRecodeInfo>();
            try {
                while (rowSet.next()) {
                    BarcodeScanningRecodeInfo recodeInfo = this.createRecodesInfo(propertyList, rowSet, bosType);
                    recodesList.add(recodeInfo);
                }
                this.setEntryMap(ctx, detailList, bosType, recodesList, bosType);
                this.setBarcodeList(ctx, bosType, recodesList);
                this.setSeqNoList(ctx, bosType, recodesList);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
            return recodesList;
        }
        return null;
    }

    private void deleteRecodesAndSeq(Context ctx, String entityBosType) throws BOSException {
        String sql = "delete from T_ST_" + entityBosType + "_Barcode where fbarcodescanningid = '" + this.barcodeScanningId + "'";
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_ST_" + entityBosType + "_Seqno where fbarcodescanningid = '" + this.barcodeScanningId + "'";
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
    }

    private void updateBarcodes(Context ctx, String entityBosType, List<BarcodeScanningRecodeInfo> recodeList) throws SQLDataException {
        ArrayList<String> listSql = new ArrayList<String>();
        for (int i = 0; i < recodeList.size(); ++i) {
            BarcodeScanningRecodeInfo info = recodeList.get(i);
            List<BarcodeScanningBarcodeInfo> barcodeList = info.getBarcodeList();
            if (barcodeList == null || barcodeList.size() <= 0) continue;
            for (int j = 0; j < barcodeList.size(); ++j) {
                BarcodeScanningBarcodeInfo barcodeInfo = barcodeList.get(j);
                String sql = "insert into T_ST_" + entityBosType + "_Barcode(fparentid,fparentbostype,fbarcode,fbarcoderuleid,fbarcodescanningid) values('" + info.getFid() + "','" + info.getFbosType() + "','" + barcodeInfo.getBarcode() + "','" + barcodeInfo.getBarcodeRuleId() + "','" + this.barcodeScanningId + "')";
                listSql.add(sql);
            }
        }
        if (listSql.size() > 0) {
            DbUtil.executeBatch((Context)ctx, listSql);
        }
    }

    private void updateSeqNos(Context ctx, String entityBosType, List<BarcodeScanningRecodeInfo> recodeList) throws SQLDataException {
        ArrayList<String> listSql = new ArrayList<String>();
        for (int i = 0; i < recodeList.size(); ++i) {
            BarcodeScanningRecodeInfo info = recodeList.get(i);
            List<String> seqNoList = info.getSeqNoList();
            if (seqNoList == null || seqNoList.size() <= 0) continue;
            for (int j = 0; j < seqNoList.size(); ++j) {
                String seqNo = seqNoList.get(j);
                String sql = "insert into T_ST_" + entityBosType + "_Seqno(fparentid,fparentbostype,fsequenceno,fbarcodescanningid) values('" + info.getFid() + "','" + info.getFbosType() + "','" + seqNo + "','" + this.barcodeScanningId + "')";
                listSql.add(sql);
            }
        }
        if (listSql.size() > 0) {
            DbUtil.executeBatch((Context)ctx, listSql);
        }
    }

    private void updateRecodesList(Context ctx, String entityBosType, List<BarcodeScanningRecodeInfo> list) throws BOSException, EASBizException {
        ArrayList<BarcodeScanningRecodeInfo> allChildList = new ArrayList<BarcodeScanningRecodeInfo>();
        for (int i = 0; i < list.size(); ++i) {
            BarcodeScanningRecodeInfo info = list.get(i);
            Map<String, List<BarcodeScanningRecodeInfo>> childMap = info.getEntriesMap();
            if (childMap == null || childMap.size() <= 0) continue;
            Iterator<String> keys = childMap.keySet().iterator();
            while (keys.hasNext()) {
                List<BarcodeScanningRecodeInfo> childList = childMap.get(keys.next());
                allChildList.addAll(childList);
            }
        }
        if (allChildList.size() > 0) {
            this.updateData(ctx, allChildList);
            this.updateBarcodes(ctx, entityBosType, allChildList);
            this.updateSeqNos(ctx, entityBosType, allChildList);
            this.updateRecodesList(ctx, entityBosType, allChildList);
        }
    }

    private void insertRecodes(Context ctx, List<BarcodeScanningRecodeInfo> list) throws SQLDataException {
        if (list.size() > 0) {
            ArrayList<String> listSql = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                BarcodeScanningRecodeInfo info = list.get(i);
                Map<String, BarcodeScanningPropertyInfo> properties = info.getProperties();
                Iterator<String> keys = properties.keySet().iterator();
                String colunms = "(";
                String values = "(";
                if (!keys.hasNext()) continue;
                while (keys.hasNext()) {
                    String key = keys.next();
                    BarcodeScanningPropertyInfo propertyInfo = properties.get(key);
                    if (propertyInfo == null) continue;
                    colunms = colunms + "\"" + key.toUpperCase() + "\",";
                    Object value = propertyInfo.getValue();
                    if (value != null) {
                        if (value.getClass() == java.sql.Date.class || value.getClass() == Timestamp.class) {
                            values = values + "to_date('" + value + "'),";
                            continue;
                        }
                        if (value.getClass() == BigDecimal.class) {
                            values = values + "to_decimal('" + ((BigDecimal)value).toPlainString() + "',21,8),";
                            continue;
                        }
                        values = values + "'" + value + "',";
                        continue;
                    }
                    if ("fdifqty".equalsIgnoreCase(propertyInfo.getKey()) || "fsrcqty".equalsIgnoreCase(propertyInfo.getKey()) || "FDIFSPLITQTY".equalsIgnoreCase(propertyInfo.getKey()) || "FSPLITTEDQTY".equalsIgnoreCase(propertyInfo.getKey()) || "fsplitQty".equalsIgnoreCase(propertyInfo.getKey())) {
                        values = values + "0,";
                        continue;
                    }
                    values = values + value + ",";
                }
                colunms = colunms + "\"FENTITYNAME\",\"FENTITYALIAS\",\"FBOSTYPE\",\"FPARENTBOSTYPE\"";
                colunms = colunms + ")";
                values = values + "'" + info.getFentityName() + "', '" + info.getFentityAlias() + "','" + info.getFbosType() + "','" + info.getFparentBosType() + "'";
                values = values + ")";
                String sql = "insert into T_ST_" + info.getFbosType() + colunms + "values" + values;
                listSql.add(sql);
            }
            if (listSql.size() > 0) {
                DbUtil.executeBatch((Context)ctx, listSql);
            }
        }
    }

    private void updateData(Context ctx, List<BarcodeScanningRecodeInfo> list) throws BOSException, EASBizException {
        Map<String, List<BarcodeScanningRecodeInfo>> map = this.getUpdAndInsRecdList(ctx, list);
        String bosType = list.get(0).getFbosType();
        List<BarcodeScanningRecodeInfo> updateList = map.get("update");
        List<BarcodeScanningRecodeInfo> insertList = map.get("insert");
        String deleteIdStr = (String)((Object)map.get("delete"));
        if (insertList.size() > 0) {
            this.insertRecodes(ctx, insertList);
        }
        if (updateList.size() > 0) {
            this.updateRecodes(ctx, updateList);
        }
        if (deleteIdStr != null) {
            String sql = "delete from T_ST_" + bosType + " where fid in (" + deleteIdStr + ")";
            DbUtil.execute((Context)ctx, (String)sql);
            this.deleteEntryData(ctx, bosType, deleteIdStr);
        }
    }

    private void deleteEntryData(Context ctx, String bosType, String deleteIdStr) throws BOSException, EASBizException {
        for (int i = 0; i < this.xmlDetail.size(); ++i) {
            String parentBosType = this.xmlDetail.get(i).getParentBosType();
            String childBosType = this.xmlDetail.get(i).getBosType();
            if (parentBosType == null || !parentBosType.equals(bosType)) continue;
            String idSql = "select fid from T_ST_" + childBosType + " where fparentid in (" + deleteIdStr + ")";
            IRowSet idSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)idSql);
            String idStr = "";
            try {
                while (idSet.next()) {
                    idStr = idStr + "'" + idSet.getString("fid") + "',";
                }
            }
            catch (SQLException e) {
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
            String childSql = "delete from T_ST_" + childBosType + " where fparentid in (" + deleteIdStr + ")";
            DbUtil.execute((Context)ctx, (String)childSql);
            if (idStr.length() <= 0) continue;
            idStr = idStr.substring(0, idStr.lastIndexOf(","));
            this.deleteEntryData(ctx, childBosType, idStr);
        }
    }

    private void updateRecodes(Context ctx, List<BarcodeScanningRecodeInfo> updateList) throws SQLDataException {
        ArrayList<String> listSql = new ArrayList<String>();
        for (int i = 0; i < updateList.size(); ++i) {
            BarcodeScanningRecodeInfo info = updateList.get(i);
            String sql = "update T_ST_" + info.getFbosType() + "  set ";
            Map<String, BarcodeScanningPropertyInfo> properties = info.getProperties();
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select FEASBILLNUMBER from T_ST_").append(info.getFbosType()).append(" where FEASBILLNUMBER is not null");
            StringBuffer numberStr = new StringBuffer();
            try {
                IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                if (rs.size() > 0) {
                    while (rs.next()) {
                        if (numberStr.length() > 0) {
                            numberStr.append(",").append(rs.getString("FEASBILLNUMBER"));
                            continue;
                        }
                        numberStr.append(rs.getString("FEASBILLNUMBER"));
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Iterator<String> keys = properties.keySet().iterator();
            if (!keys.hasNext()) continue;
            while (keys.hasNext()) {
                String key = keys.next();
                BarcodeScanningPropertyInfo propertyInfo = properties.get(key);
                if (propertyInfo == null) continue;
                sql = sql + "\"" + key.toUpperCase() + "\" = ";
                Object value = propertyInfo.getValue();
                if (value != null) {
                    if (value.getClass() == java.sql.Date.class || value.getClass() == Timestamp.class) {
                        sql = sql + "to_date('" + value + "'),";
                        continue;
                    }
                    if (value.getClass() == BigDecimal.class) {
                        sql = sql + "to_decimal('" + ((BigDecimal)value).toPlainString() + "',21,8),";
                        continue;
                    }
                    if (key.toUpperCase(Locale.ENGLISH).equals("FEASBILLNUMBER") && numberStr.length() > 0) {
                        value = numberStr + "," + value;
                    }
                    sql = sql + "'" + value + "',";
                    continue;
                }
                if ("fdifqty".equalsIgnoreCase(propertyInfo.getKey()) || "fsrcqty".equalsIgnoreCase(propertyInfo.getKey()) || "FDIFSPLITQTY".equalsIgnoreCase(propertyInfo.getKey()) || "FSPLITTEDQTY".equalsIgnoreCase(propertyInfo.getKey()) || "FSPLITQTY".equalsIgnoreCase(propertyInfo.getKey())) {
                    sql = sql + "0,";
                    continue;
                }
                sql = sql + value + ",";
            }
            sql = sql.substring(0, sql.lastIndexOf(","));
            sql = sql + " where \"FID\" = '" + info.getFid() + "'";
            listSql.add(sql);
        }
        if (listSql.size() > 0) {
            DbUtil.executeBatch((Context)ctx, listSql);
        }
    }

    private Map<String, List<BarcodeScanningRecodeInfo>> getUpdAndInsRecdList(Context ctx, List<BarcodeScanningRecodeInfo> list) throws BOSException, EASBizException {
        HashMap<String, List<BarcodeScanningRecodeInfo>> map = new HashMap<String, List<BarcodeScanningRecodeInfo>>();
        ArrayList<BarcodeScanningRecodeInfo> updateList = new ArrayList<BarcodeScanningRecodeInfo>();
        ArrayList<BarcodeScanningRecodeInfo> insertList = new ArrayList<BarcodeScanningRecodeInfo>();
        String deleteIdStr = "";
        String bosType = list.get(0).getFbosType();
        String sql = "select fid,fparentid from T_ST_" + bosType + " where fScanningId = '" + this.barcodeScanningId + "'";
        ArrayList<String> idList = new ArrayList<String>();
        IRowSet set = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
        if (set.size() > 0) {
            int i;
            try {
                while (set.next()) {
                    idList.add(set.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
            block3: for (i = 0; i < idList.size(); ++i) {
                String oldId = (String)idList.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    BarcodeScanningRecodeInfo recodeInfo = list.get(j);
                    String id = recodeInfo.getFid();
                    if (oldId.equals(id)) {
                        updateList.add(recodeInfo);
                        continue block3;
                    }
                    if (oldId.equals(id) || j != list.size() - 1) continue;
                    deleteIdStr = deleteIdStr + "'" + oldId + "',";
                }
            }
            for (i = 0; i < list.size(); ++i) {
                String oldId;
                BarcodeScanningRecodeInfo recodeInfo = list.get(i);
                String id = recodeInfo.getFid();
                for (int j = 0; j < idList.size() && !id.equals(oldId = (String)idList.get(j)); ++j) {
                    if (id.equals(oldId) || j != idList.size() - 1) continue;
                    insertList.add(recodeInfo);
                }
            }
        } else {
            insertList.addAll(list);
        }
        map.put("update", updateList);
        map.put("insert", insertList);
        map.put("delete", (List<BarcodeScanningRecodeInfo>)((Object)(deleteIdStr.equals("") ? null : deleteIdStr.substring(0, deleteIdStr.lastIndexOf(",")))));
        return map;
    }

    private void setSeqNoList(Context ctx, String bosType, List<BarcodeScanningRecodeInfo> recodesList) throws BOSException, SQLException {
        for (int j = 0; j < recodesList.size(); ++j) {
            BarcodeScanningRecodeInfo recodeInfo = recodesList.get(j);
            String sql = "select fsequenceno from T_ST_" + bosType + "_Seqno where fparentid = '" + recodeInfo.getFid() + "'";
            IRowSet set = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> seqList = new ArrayList<String>();
            while (set.next()) {
                seqList.add(set.getString("fsequenceno"));
            }
            recodeInfo.setSeqNoList(seqList);
        }
    }

    private void setBarcodeList(Context ctx, String bosType, List<BarcodeScanningRecodeInfo> recodesList) throws BOSException, SQLException {
        for (int j = 0; j < recodesList.size(); ++j) {
            BarcodeScanningRecodeInfo recodeInfo = recodesList.get(j);
            String sql = "select fbarcode,fbarcoderuleid from T_ST_" + bosType + "_Barcode where fparentid = '" + recodeInfo.getFid() + "'";
            IRowSet set = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<BarcodeScanningBarcodeInfo> barcodeList = new ArrayList<BarcodeScanningBarcodeInfo>();
            while (set.next()) {
                BarcodeScanningBarcodeInfo bsbi = new BarcodeScanningBarcodeInfo();
                bsbi.setBarcode(set.getString("fbarcode"));
                bsbi.setBarcodeRuleId(set.getString("fbarcoderuleid"));
                barcodeList.add(bsbi);
            }
            recodeInfo.setBarcodeList(barcodeList);
        }
    }

    private void setEntryMap(Context ctx, List<BarcodeConfigXMLDetail> detailList, String bosType, List<BarcodeScanningRecodeInfo> recodesList, String billBosType) throws SQLException, BOSException, EASBizException, ParseException {
        for (int j = 0; j < detailList.size(); ++j) {
            BarcodeConfigXMLDetail childDetail = detailList.get(j);
            String parentBosType = childDetail.getParentBosType();
            if (parentBosType == null || !parentBosType.equals(bosType)) continue;
            String currBosType = childDetail.getBosType();
            List<BarcodeConfigXMLProperty> childProList = childDetail.getProperties();
            for (int k = 0; k < recodesList.size(); ++k) {
                ArrayList<BarcodeScanningRecodeInfo> childRecList = new ArrayList<BarcodeScanningRecodeInfo>();
                String id = recodesList.get(k).getFid();
                IRowSet childRowset = this.getRowSet(ctx, id, childProList, currBosType);
                while (childRowset.next()) {
                    BarcodeScanningRecodeInfo childRecodeInfo = this.createRecodesInfo(childProList, childRowset, currBosType);
                    childRecList.add(childRecodeInfo);
                }
                recodesList.get(k).getEntriesMap().put(childDetail.getName(), childRecList);
                this.setBarcodeList(ctx, billBosType, childRecList);
                this.setSeqNoList(ctx, billBosType, childRecList);
                this.setEntryMap(ctx, detailList, currBosType, childRecList, billBosType);
            }
        }
    }

    private IRowSet getRowSet(Context ctx, String id, List<BarcodeConfigXMLProperty> propertyList, String bosType) throws EASBizException {
        String sql = "select ";
        for (int j = 0; j < propertyList.size(); ++j) {
            BarcodeConfigXMLProperty xmlProperty = propertyList.get(j);
            String filed = xmlProperty.getName();
            sql = xmlProperty.isLinkedProperty() ? sql + filed + "_number," + filed + "_name," : sql + filed + ",";
        }
        sql = sql + "fid,fbosType,fparentId,fsrcBillId,fsrcentryid,fentityName,fentityAlias,fparentBosType,fsrcQty,fdifQty,FDIFSPLITQTY,FSPLITQTY,FSPLITTEDQTY,feasbillnumber,fdestbillid,fScanningId,fseq,fsrcScanEntryId from T_ST_" + bosType + " where fparentId = '" + id + "' order by fseq";
        try {
            IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            return rowSet;
        }
        catch (BOSException e1) {
            throw new EASBizException(new NumericExceptionSubItem("", e1.getMessage()));
        }
    }

    private BarcodeScanningRecodeInfo createRecodesInfo(List<BarcodeConfigXMLProperty> propertyList, IRowSet rowSet, String bosType) throws SQLException, ParseException {
        BarcodeScanningPropertyInfo proInfo;
        BarcodeScanningRecodeInfo recodeInfo = new BarcodeScanningRecodeInfo();
        recodeInfo.setFid(rowSet.getString("fid"));
        recodeInfo.setFparentId(rowSet.getString("fparentId"));
        recodeInfo.setFbosType(rowSet.getString("fbosType"));
        recodeInfo.setFparentBosType(rowSet.getString("fparentBosType"));
        recodeInfo.setFsrcBillId(rowSet.getString("fsrcBillId"));
        recodeInfo.setFsrcEntryId(rowSet.getString("fsrcEntryId"));
        recodeInfo.setFentityName(rowSet.getString("fentityName"));
        recodeInfo.setFentityAlias(rowSet.getString("fentityAlias"));
        recodeInfo.setFsrcScanEntryId(rowSet.getString("fsrcScanEntryId"));
        TreeMap<String, BarcodeScanningPropertyInfo> propertyMap = new TreeMap<String, BarcodeScanningPropertyInfo>();
        boolean hasNumberFiled = false;
        for (int j = 0; j < propertyList.size(); ++j) {
            proInfo = new BarcodeScanningPropertyInfo();
            BarcodeConfigXMLProperty xmlPro = propertyList.get(j);
            String key = xmlPro.getName();
            if (xmlPro.isLinkedProperty()) {
                proInfo.setKey(key + "_number");
                proInfo.setValue(rowSet.getString(key + "_number"));
                proInfo.setBcxmlProperty(xmlPro);
                propertyMap.put(key + "_number", proInfo);
                proInfo = new BarcodeScanningPropertyInfo();
                proInfo.setKey(key + "_name");
                proInfo.setValue(rowSet.getString(key + "_name"));
                propertyMap.put(key + "_name", proInfo);
                continue;
            }
            if (key.equals("number")) {
                hasNumberFiled = true;
            }
            Object value = rowSet.getObject(key);
            if (xmlPro.getDataType().equals("Date") && value != null) {
                value = java.sql.Date.valueOf(value.toString().substring(0, 10));
            }
            if (xmlPro.getDataType().equals("Boolean") && value != null) {
                value = !value.equals("false");
            }
            if (xmlPro.getDataType().equals("Integer") && value != null) {
                value = Integer.valueOf(rowSet.getString(key));
            }
            proInfo.setKey(key);
            proInfo.setValue(value);
            proInfo.setBcxmlProperty(xmlPro);
            propertyMap.put(key, proInfo);
        }
        propertyMap.put("fid", this.getCommonProInfo(rowSet, "fid"));
        propertyMap.put("fparentId", this.getCommonProInfo(rowSet, "fparentId"));
        propertyMap.put("fsrcBillId", this.getCommonProInfo(rowSet, "fsrcBillId"));
        propertyMap.put("fsrcEntryId", this.getCommonProInfo(rowSet, "fsrcEntryId"));
        propertyMap.put("fsrcScanEntryId", this.getCommonProInfo(rowSet, "fsrcScanEntryId"));
        propertyMap.put("fsrcQty", this.getCommonProInfo(rowSet, "fsrcQty"));
        propertyMap.put("fdifQty", this.getCommonProInfo(rowSet, "fdifQty"));
        propertyMap.put("fdifSplitQty", this.getCommonProInfo(rowSet, "fdifSplitQty"));
        propertyMap.put("fsplitQty", this.getCommonProInfo(rowSet, "fsplitQty"));
        propertyMap.put("fsplittedQty", this.getCommonProInfo(rowSet, "fsplittedQty"));
        propertyMap.put("fdestBillid", this.getCommonProInfo(rowSet, "fdestBillid"));
        propertyMap.put("fScanningId", this.getCommonProInfo(rowSet, "fScanningId"));
        BarcodeScanningPropertyInfo proSeq = new BarcodeScanningPropertyInfo();
        proSeq.setKey("fseq");
        proSeq.setValue(rowSet.getInt("fseq"));
        propertyMap.put("fseq", proSeq);
        if (hasNumberFiled && rowSet.getString("feasbillnumber") != null) {
            proInfo = new BarcodeScanningPropertyInfo();
            proInfo.setKey("number");
            proInfo.setValue(rowSet.getObject("feasbillnumber"));
            propertyMap.put("number", proInfo);
        }
        recodeInfo.setProperties(propertyMap);
        return recodeInfo;
    }

    private BarcodeScanningPropertyInfo getCommonProInfo(IRowSet rowSet, String key) throws SQLException {
        BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(key);
        proInfo.setValue(rowSet.getObject(key));
        proInfo.setBcxmlProperty(new BarcodeConfigXMLProperty());
        return proInfo;
    }

    private BarcodeScanningPropertyInfo getCommonProInfo(IRowSet rowSet, String key, String srcKey) throws SQLException {
        BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(key);
        BigDecimal value = rowSet.getBigDecimal(key).subtract(rowSet.getBigDecimal(srcKey));
        proInfo.setValue(value);
        return proInfo;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ScanTaskBillInfo info = (ScanTaskBillInfo)this._getValue(ctx, pk);
        ObjectUuidPK orgPK = new ObjectUuidPK(info.getCU().getId());
        if (info.getBillStatus() == BillBaseStatusEnum.AUDITED || !info.getSchedule().equals((Object)ScheduleEnum.Begining) || info.isIssplit()) {
            throw new EASBizException(new NumericExceptionSubItem(null, "\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u6216\u6267\u884c\u8fdb\u5ea6\u4e0d\u4e3a\u672a\u5f00\u59cb\u72b6\u6001\u6216\u5df2\u88ab\u62c6\u5206\u4e0d\u80fd\u5220\u9664\uff01"));
        }
        super._delete(ctx, pk);
        BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(info.getBarcodeConfig().getId()));
        String xmlStr = configInfo.getDetailsXML();
        BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(xmlStr);
        List<BarcodeConfigXMLDetail> xmlDetailList = xmlInfo.getDetails();
        for (int i = 0; i < xmlDetailList.size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = xmlDetailList.get(i);
            DbUtil.execute((Context)ctx, (String)("delete from t_ST_" + xmlDetail.getBosType() + " where fscanningid = '" + pk + "'"));
            if (xmlDetail.getParentBosType() != null && !xmlDetail.getParentBosType().equals("")) continue;
            DbUtil.execute((Context)ctx, (String)("delete from t_ST_" + xmlDetail.getBosType() + "_Barcode where fbarcodescanningid = '" + pk + "'"));
        }
    }

    @Override
    protected Map _exportData(Context ctx, String taskBillId, Map argument) throws BOSException, EASBizException {
        ScanTaskBillCollection scanTaskCol = new ScanTaskBillCollection();
        if (taskBillId == null) {
            scanTaskCol = this.getScanTaskBillCol(ctx);
        } else {
            ScanTaskBillInfo taskBillInfo = (ScanTaskBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(taskBillId), this.getSelectors());
            scanTaskCol.add(taskBillInfo);
        }
        StringBuffer materialId = new StringBuffer();
        StringBuffer bosTypeStr = new StringBuffer();
        int size = scanTaskCol.size();
        for (int i = 0; i < size; ++i) {
            ScanTaskBillInfo taskBillInfo = scanTaskCol.get(i);
            if (bosTypeStr.length() > 0) {
                bosTypeStr.append(",").append(taskBillInfo.getDestBosType());
            } else {
                bosTypeStr.append(taskBillInfo.getDestBosType());
            }
            int m = taskBillInfo.getEntrys().size();
            for (int j = 0; j < m; ++j) {
                ScanTaskBillEntryInfo entryInfo = taskBillInfo.getEntrys().get(j);
                if (entryInfo.getMaterial() == null) continue;
                if (materialId.length() > 0) {
                    materialId.append("','").append(entryInfo.getMaterial().getId().toString());
                    continue;
                }
                materialId.append(entryInfo.getMaterial().getId().toString());
            }
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (materialId.length() > 0) {
            StringBuffer whereSql = new StringBuffer();
            whereSql.append(" CFMaterialID in('").append(materialId).append("')");
            filterMap.put("CT_IND_BarcodeDossier", whereSql.toString());
        }
        SynDataBaseInfo synDataInfo = new SynDataBaseInfo();
        synDataInfo.setId(BOSUuid.read((String)"8r0AAAAJGCJQlody"));
        synDataInfo.setNumber("synBaseData");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"synBaseData"));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("BaseEntry.baseDataName"));
        sic.add(new SelectorItemInfo("BaseEntry.tableName"));
        sic.add(new SelectorItemInfo("BaseEntry.synData"));
        sic.add(new SelectorItemInfo("BaseEntry.resourceID"));
        sic.add(new SelectorItemInfo("BaseEntry.state"));
        sic.add(new SelectorItemInfo("BaseEntry.fieildArg"));
        sic.add(new SelectorItemInfo("isDefault"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        SynDataBaseCollection synBaseCol = SynDataBaseFactory.getLocalInstance(ctx).getSynDataBaseCollection(view);
        ArrayList<SynDataBaseBaseEntryInfo> synBaseEntryList = new ArrayList<SynDataBaseBaseEntryInfo>();
        int size2 = synBaseCol.size();
        for (int i = 0; i < size2; ++i) {
            SynDataBaseInfo synBaseInfo = synBaseCol.get(i);
            int m = synBaseInfo.getBaseEntry().size();
            for (int j = 0; j < m; ++j) {
                SynDataBaseBaseEntryInfo baseEntryInfo = synBaseInfo.getBaseEntry().get(j);
                synBaseEntryList.add(baseEntryInfo);
            }
        }
        HashMap<String, Object> argumentMap = new HashMap<String, Object>();
        argumentMap.put("argument", synBaseEntryList);
        argumentMap.put("filterMap", filterMap);
        argumentMap.put("syndata", synDataInfo);
        argumentMap.put("destBostType", bosTypeStr.toString());
        Map rsMap = null;
        rsMap = SynDataBaseFactory.getLocalInstance(ctx).exportData(argumentMap);
        return rsMap;
    }

    private List<SynDataBaseBaseEntryInfo> getSynEntryInfo(Context ctx, BarcodeConfigInfo configInfo, Map<String, String> tableNameMap) throws EASBizException, BOSException {
        configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(configInfo.getId()), this.getConfigInfoSelectors());
        String detailsXml = configInfo.getDetailsXML();
        BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(detailsXml);
        ArrayList<SynDataBaseBaseEntryInfo> argumentList = new ArrayList<SynDataBaseBaseEntryInfo>();
        for (int i = 0; i < xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail detail = xmlInfo.getDetails().get(i);
            EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)detail.getBosType()));
            StringBuffer fieldStr = new StringBuffer();
            fieldStr.append("FID");
            List<BarcodeConfigXMLProperty> xmlPropertyList = detail.getProperties();
            int m = xmlPropertyList.size();
            for (int j = 0; j < m; ++j) {
                BarcodeConfigXMLProperty xmlProperty = xmlPropertyList.get(j);
                if (xmlProperty.isLinkedProperty()) {
                    EntityObjectInfo linkeEntity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)xmlProperty.getLinkedBosType()));
                    ColumnCollection columnCol = linkeEntity.getTable().getColumns();
                    StringBuffer linkFiledStr = new StringBuffer();
                    int index = 0;
                    for (int k = 0; k < columnCol.size(); ++k) {
                        ColumnInfo columnInfo = columnCol.get(k);
                        String field = columnInfo.getName();
                        if (columnInfo.isMultilingual()) {
                            field = field + "_L2";
                        }
                        if (!field.equalsIgnoreCase("FID") && !field.equalsIgnoreCase("Fnumber") && !field.equalsIgnoreCase("FName_l2")) continue;
                        if (linkFiledStr.length() > 0) {
                            linkFiledStr.append(",").append(field);
                        } else {
                            linkFiledStr.append(field);
                        }
                        ++index;
                    }
                    if (index == 3) {
                        SynDataBaseBaseEntryInfo synBaseInfo = new SynDataBaseBaseEntryInfo();
                        String tableName = linkeEntity.getTable().getName();
                        synBaseInfo.setTableName(tableName);
                        synBaseInfo.setFieildArg(linkFiledStr.toString());
                        if (!tableNameMap.containsKey(tableName)) {
                            argumentList.add(synBaseInfo);
                            tableNameMap.put(tableName, tableName);
                        }
                    }
                }
                ColumnInfo columnInfo = eo.getPropertyByName(xmlProperty.getName()).getMappingField();
                String field = columnInfo.getName();
                if (columnInfo.isMultilingual()) {
                    field = field + "_L2";
                }
                if (fieldStr.length() > 0) {
                    fieldStr.append(",").append(field);
                    continue;
                }
                fieldStr.append(field);
            }
        }
        return argumentList;
    }

    public SelectorItemCollection getConfigInfoSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("isPDA"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("botMapping.*"));
        } else {
            sic.add(new SelectorItemInfo("botMapping.id"));
            sic.add(new SelectorItemInfo("botMapping.name"));
        }
        sic.add(new SelectorItemInfo("srcAlias"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("CU.*"));
        } else {
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("CU.name"));
        }
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    private Map<String, String> insertINDSTableData(Context ctx, String bosType) throws BOSException {
        StringBuffer selectBS = new StringBuffer();
        selectBS.append("select  distinct\u3000fparentid,CFName\u3000from CT_IND_IndBarcodeSetupEntry").append("\t\n");
        selectBS.append("where fparentid=(select top 1 fid from CT_IND_IndBarcodeSetup where").append("\t\n");
        selectBS.append("CFBusinessObjectID='").append(bosType).append("'").append("\t\n");
        selectBS.append(" order by flastUpdateTime desc )and CFName is not null");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)selectBS.toString());
        String parentid = null;
        ArrayList<String> cloKeyList = new ArrayList<String>();
        StringBuffer fieldStr = new StringBuffer();
        fieldStr.append("FNumber,CFIsBarcodeRepeat,CFIsCumsumQty,CFIsSyn");
        try {
            while (rs.next()) {
                if (parentid == null) {
                    parentid = rs.getString("fparentid");
                }
                String name = rs.getString("CFName");
                cloKeyList.add(name);
                if (fieldStr.length() > 0) {
                    fieldStr.append(",").append(name);
                    continue;
                }
                fieldStr.append(name);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (parentid == null) {
            return null;
        }
        String tableName = "T_INDBS_" + bosType;
        StringBuffer barcodeSql = new StringBuffer();
        barcodeSql.append("if  exists(select * from KSQL_USERTABLES where KSQL_TABNAME='").append(tableName).append("')").append("\t\n");
        barcodeSql.append("drop table ").append(tableName).append(";").append("\t\n");
        barcodeSql.append("select FNumber,CFIsBarcodeRepeat,CFIsCumsumQty, CFIsSyn, ").append("\t\n");
        int size = cloKeyList.size();
        for (int i = 0; i < size; ++i) {
            String colKey = (String)cloKeyList.get(i);
            if (i == size - 1) {
                barcodeSql.append(" max(case when  cfname='").append(colKey).append("' THEN cfvalue else '' end ) as '").append(colKey).append("'").append("\t\n");
                continue;
            }
            barcodeSql.append(" max(case when  cfname='").append(colKey).append("' THEN cfvalue else '' end ) as '").append(colKey).append("',").append("\t\n");
        }
        barcodeSql.append(" into  ").append(tableName).append("  from (").append("\t\n");
        barcodeSql.append("select a.FNumber,c.CFIsBarcodeRepeat,c.CFIsCumsumQty,d.CFName, b.CFValue ,0 as  CFIsSyn  ").append("\t\n");
        barcodeSql.append("from CT_IND_BarcodeDossier a").append("\t\n");
        barcodeSql.append("inner join CT_IND_IndBarcodeSetup c on a.cfbarruleid = c.cfmasterid").append("\t\n");
        barcodeSql.append("inner join CT_IND_IndBarcodeSetupEntry d on c.fid = d.fparentid").append("\t\n");
        barcodeSql.append("inner join CT_IND_BarcodeDossierEntry b on a.fid = b.fparentid and b.cfdisplaynameid= d.cfproperty").append("\t\n");
        barcodeSql.append("where c.CFBusinessObjectID='").append(bosType).append("'and d.CFName is not null").append(" and c.fid='").append(parentid).append("'").append("\t\n");
        barcodeSql.append(" and c.CFState=").append(1).append("\t\n");
        barcodeSql.append("union all").append("\t\n");
        barcodeSql.append("select a.FNumber,c.CFIsBarcodeRepeat,c.CFIsCumsumQty,d.CFName, b.CFValue ,0 as  CFIsSyn ").append("\t\n");
        barcodeSql.append("from CT_IND_BarcodeDossier a").append("\t\n");
        barcodeSql.append("inner join CT_IND_IndBarcodeSetup c on a.cfbarruleid = c.cfmasterid").append("\t\n");
        barcodeSql.append("inner join CT_IND_IndBarcodeSetupEntry d on c.fid = d.fparentid ").append("\t\n");
        barcodeSql.append("inner join  CT_SCM_BarcodeDossierTemplate  bdt  on bdt.fid=a.CFTemplateID").append("\t\n");
        barcodeSql.append("inner join CT_SCM_BarcodeDTE  b on bdt.fid=b.fparentid  and b.cfdisplaynameid= d.cfproperty").append("\t\n");
        barcodeSql.append("where c.CFBusinessObjectID='").append(bosType).append("' and d.CFName is not null and  c.fid='").append(parentid).append("'").append("\t\n");
        barcodeSql.append(" and c.CFState=").append(1).append("\t\n");
        barcodeSql.append(") as t_ind_barcodeTable").append("\t\n");
        barcodeSql.append("group by   FNumber,CFIsBarcodeRepeat,CFIsCumsumQty, CFIsSyn").append("\t\n");
        barcodeSql.append(" order by fnumber");
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)barcodeSql.toString());
        HashMap<String, String> colmunMap = new HashMap<String, String>();
        colmunMap.put("tableName", tableName);
        colmunMap.put("fieldStr", fieldStr.toString());
        return colmunMap;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("issplit"));
        sic.add(new SelectorItemInfo("taskName"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("number"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("barcodeConfig.*"));
        } else {
            sic.add(new SelectorItemInfo("barcodeConfig.id"));
            sic.add(new SelectorItemInfo("barcodeConfig.number"));
            sic.add(new SelectorItemInfo("barcodeConfig.name"));
        }
        sic.add(new SelectorItemInfo("srcBosType"));
        sic.add(new SelectorItemInfo("destBosType"));
        sic.add(new SelectorItemInfo("priority"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("chidTask.*"));
        } else {
            sic.add(new SelectorItemInfo("chidTask.id"));
            sic.add(new SelectorItemInfo("chidTask.number"));
            sic.add(new SelectorItemInfo("chidTask.taskName"));
        }
        sic.add(new SelectorItemInfo("billtype"));
        sic.add(new SelectorItemInfo("vldto"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("billStatus"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("transactionType.*"));
        } else {
            sic.add(new SelectorItemInfo("transactionType.id"));
            sic.add(new SelectorItemInfo("transactionType.number"));
            sic.add(new SelectorItemInfo("transactionType.name"));
            sic.add(new SelectorItemInfo("transactionType.scheduled"));
        }
        sic.add(new SelectorItemInfo("taskObject"));
        sic.add(new SelectorItemInfo("schedule"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("auditor.*"));
        } else {
            sic.add(new SelectorItemInfo("auditor.id"));
            sic.add(new SelectorItemInfo("auditor.number"));
            sic.add(new SelectorItemInfo("auditor.name"));
        }
        sic.add(new SelectorItemInfo("auditTime"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("creator.*"));
        } else {
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("creator.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        } else {
            sic.add(new SelectorItemInfo("lastUpdateUser.id"));
            sic.add(new SelectorItemInfo("lastUpdateUser.number"));
            sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        }
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("botpId"));
        sic.add(new SelectorItemInfo("botpNumber"));
        sic.add(new SelectorItemInfo("BdEntrys.seq"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("BdEntrys.*"));
        }
        sic.add(new SelectorItemInfo("BdEntrys.barcode"));
        sic.add(new SelectorItemInfo("BdEntrys.sourceEntryId"));
        sic.add("*");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add(new SelectorItemInfo("entrys.material.id"));
        sic.add(new SelectorItemInfo("entrys.material.number"));
        sic.add(new SelectorItemInfo("entrys.material.name"));
        sic.add(new SelectorItemInfo("entrys.sourceBillEntryId"));
        return sic;
    }

    private ScanTaskBillCollection getScanTaskBillCol(Context ctx) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)4));
        viewInfo.setFilter(filter);
        ScanTaskBillCollection scanTaskCol = ScanTaskBillFactory.getLocalInstance(ctx).getScanTaskBillCollection(viewInfo);
        return scanTaskCol;
    }

    @Override
    protected void _checkScanTask(Context ctx, Map argumentMap) throws BOSException, EASBizException {
        String billIdStr = argumentMap.get("billId").toString();
        billIdStr = billIdStr.replaceAll(",", ",'");
        String bosType = argumentMap.get("destBosType").toString();
        String id = argumentMap.get("id") != null ? argumentMap.get("id").toString() : argumentMap.get("id").toString();
        List entryBosTypeList = (List)argumentMap.get("entryBosTypeList");
        int size = entryBosTypeList.size();
        for (int i = 0; i < size; ++i) {
            String entryBosType = (String)entryBosTypeList.get(i);
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select  fparentid,fsrcBillId  from T_ST_").append(entryBosType).append("\t\n");
            selectSql.append(" where  fparentid<>'").append(id).append("'");
            selectSql.append(" and fsrcBillId in('").append(billIdStr).append("')");
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            try {
                if (!rs.next()) continue;
                throw new EASBizException(new NumericExceptionSubItem("", "\u9009\u62e9\u5bf9\u8c61\u6570\u636e\u5df2\u505a\u4efb\u52a1\u5355"));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void _updateRecodeList(Context ctx, List recodeList, String entityBosType, Object xml) throws BOSException, EASBizException {
        super._updateRecodeList(ctx, recodeList, entityBosType, xml);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit(ctx, pk);
        ScanTaskBillInfo billInfo = (ScanTaskBillInfo)this._getValue(ctx, pk);
        if (billInfo.getChidTask() != null) {
            this.auditAndUnAuditWriteback(ctx, billInfo, true);
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._unAudit(ctx, pk);
        ScanTaskBillInfo billInfo = (ScanTaskBillInfo)this._getValue(ctx, pk);
        if (billInfo.getChidTask() != null) {
            this.auditAndUnAuditWriteback(ctx, billInfo, false);
        }
    }

    protected void auditAndUnAuditWriteback(Context ctx, ScanTaskBillInfo billInfo, boolean isAudit) throws EASBizException, BOSException {
        StringBuffer updateSql = new StringBuffer();
        ArrayList<String> sqlList = new ArrayList<String>();
        IScanTaskBillChirdEntry iScanTaskBillChirdEntry = ScanTaskBillChirdEntryFactory.getLocalInstance(ctx);
        updateSql.append("update CT_SCM_ScanTaskBill set ");
        if (isAudit) {
            updateSql.append("CFIssplit=1 ");
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)billInfo.getChidTask().getId().toString()));
            if (iScanTaskBillChirdEntry.exists(filterInfo)) {
                updateSql.append("CFIssplit=1 ");
            } else {
                updateSql.append("CFIssplit=0 ");
            }
        }
        updateSql.append("where fid='").append(billInfo.getChidTask().getId().toString()).append("'");
        sqlList.add(updateSql.toString());
        String oql = "select id,detailsXML where id ='" + billInfo.getBarcodeConfig().getId() + "'";
        BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo(oql);
        BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(configInfo.getDetailsXML());
        List recodesList = (List)this._getRecodesList(ctx, billInfo.getId().toString(), configXml);
        int size = recodesList.size();
        for (int i = 0; i < size; ++i) {
            BarcodeScanningRecodeInfo info = (BarcodeScanningRecodeInfo)recodesList.get(i);
            Map<String, List<BarcodeScanningRecodeInfo>> childMap = info.getEntriesMap();
            if (childMap == null || childMap.size() <= 0) continue;
            Iterator<String> keys = childMap.keySet().iterator();
            while (keys.hasNext()) {
                List<BarcodeScanningRecodeInfo> childList = childMap.get(keys.next());
                int m = childList.size();
                for (int j = 0; j < m; ++j) {
                    BarcodeScanningPropertyInfo propertyInfo;
                    Map<String, BarcodeScanningPropertyInfo> childProperties;
                    updateSql.setLength(0);
                    BarcodeScanningRecodeInfo childRecodeInfo = childList.get(j);
                    String bosType = childRecodeInfo.getFbosType();
                    if (childRecodeInfo.getFsrcScanEntryId() == null || !(childProperties = childRecodeInfo.getProperties()).containsKey("fsrcQty") || (propertyInfo = childProperties.get("fsrcQty")).getValue() == null) continue;
                    BigDecimal spliQty = (BigDecimal)propertyInfo.getValue();
                    updateSql.append("update t_ST_").append(bosType);
                    if (isAudit) {
                        updateSql.append("  set FSPLITTEDQTY=FSPLITTEDQTY+").append(spliQty);
                        updateSql.append("  , FDIFSPLITQTY=FDIFSPLITQTY-").append(spliQty);
                    } else {
                        updateSql.append("  set FSPLITTEDQTY=FSPLITTEDQTY-").append(spliQty);
                        updateSql.append("  , FDIFSPLITQTY=FDIFSPLITQTY+").append(spliQty);
                    }
                    updateSql.append(" where fid='").append(childRecodeInfo.getFsrcScanEntryId()).append("'");
                    sqlList.add(updateSql.toString());
                }
            }
        }
        if (sqlList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, sqlList);
        }
        if (isAudit) {
            ScanTaskBillChirdEntryInfo childEntryInfo = new ScanTaskBillChirdEntryInfo();
            childEntryInfo.setParent(billInfo.getChidTask());
            childEntryInfo.setTaskBill(billInfo);
            childEntryInfo.setTaskName(billInfo.getTaskName());
            childEntryInfo.setTaskObject(billInfo.getTaskObject());
            childEntryInfo.setTaskOperator(billInfo.getTaskOperator());
            iScanTaskBillChirdEntry.save((CoreBaseInfo)childEntryInfo);
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)billInfo.getChidTask().getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("taskBill.id", (Object)billInfo.getId()));
            iScanTaskBillChirdEntry.delete(filterInfo);
        }
    }

    @Override
    protected IObjectValue _splitTaskBill(Context ctx, Map argument) throws BOSException, EASBizException {
        ScanTaskBillInfo billInfo = (ScanTaskBillInfo)argument.get("mainTaskBill");
        ScanTaskBillInfo clonebillInfo = (ScanTaskBillInfo)billInfo.clone();
        billInfo.setChidTask(clonebillInfo);
        billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        billInfo.setTaskObject(null);
        billInfo.setTaskName(null);
        billInfo.setBizDate(new Date());
        billInfo.setSchedule(ScheduleEnum.Begining);
        billInfo.getEntrys().clear();
        billInfo.getBdEntrys().clear();
        billInfo.getChirdEntry().clear();
        billInfo.setLastUpdateTime(null);
        billInfo.setLastUpdateUser(null);
        billInfo.setCreateTime(null);
        billInfo.setCreator(null);
        billInfo.setBillStatus(BillBaseStatusEnum.ADD);
        billInfo.setIssplit(false);
        billInfo.setTaskObject(null);
        billInfo.setTaskOperator(null);
        boolean havCodeing = false;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)billInfo);
        if (iCodingRuleManager.isExist((IObjectValue)billInfo, strCompanyID)) {
            havCodeing = true;
            billInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyID));
        }
        if (!havCodeing) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            billInfo.setNumber(sdf.format(new Date()));
        }
        return billInfo;
    }
}

