/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.barcode.pda.BarcodePDataInfo;
import com.kingdee.eas.barcode.scm.app.BarcodeBillConfigInfo;
import com.kingdee.eas.barcode.scm.app.CustMappingInfo;
import com.kingdee.eas.barcode.scm.app.TableInfo;
import com.kingdee.eas.barcode.scm.app.UWMathFormulaProcessor;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UWBillUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.uw.app.BillIDUtil");
    public static final String FAIL_ID = "FAIL_ID";
    private static Map typeMap = null;

    public static void loadTypeMapping(Connection conn, boolean fReload) throws EASBizException {
        if (typeMap == null || typeMap.isEmpty() || fReload) {
            ResultSet rs;
            PreparedStatement pstmt;
            block8: {
                if (typeMap == null) {
                    typeMap = new HashMap();
                } else {
                    typeMap.clear();
                }
                pstmt = null;
                rs = null;
                try {
                    pstmt = conn.prepareStatement("select * from t_uw_bpTypeMapping");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int type = rs.getInt("FType");
                        BarcodeBillConfigInfo cInfo = UWBillUtil.createBillConfigInfo(rs);
                        typeMap.put("" + type, cInfo);
                    }
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug((Object)("UW: barcode type mapping, " + typeMap));
                }
                catch (SQLException e) {
                    try {
                        throw new EASBizException(EASBizException.RPCCOMMERR, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        SQLUtils.cleanup((Statement)pstmt);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    private static BarcodeBillConfigInfo createBillConfigInfo(ResultSet rs) throws SQLException {
        BarcodeBillConfigInfo cInfo = new BarcodeBillConfigInfo();
        cInfo.setBindingProperty(rs.getString("FBindingProperty"));
        cInfo.setBindingPropDBCol(rs.getString("FBindingPropDBCol"));
        cInfo.setSrcBosType(rs.getString("FSrcBosType"));
        cInfo.setDestBosType(rs.getString("FDestBosType"));
        cInfo.setSaveType(rs.getInt("FSavaType"));
        return cInfo;
    }

    public static BarcodeBillConfigInfo getBarcodeBillConfigInfo(String type) {
        if (typeMap == null || typeMap.isEmpty()) {
            logger.error((Object)"UW: typeMap is null");
            return null;
        }
        return (BarcodeBillConfigInfo)typeMap.get(type);
    }

    public static String getBillNumber(Context ctx, String type) throws BOSException, EASBizException {
        String numberStr = null;
        logger.debug((Object)"UW: use time in millis as new number suffix, test!");
        numberStr = "BCP_" + System.currentTimeMillis();
        return numberStr;
    }

    public static Map<String, Object> getTargetValue(BarcodePDataInfo pInfo) {
        HashMap<String, Object> tMap = new HashMap<String, Object>();
        Map rawData = pInfo.getBillData();
        if (rawData != null && !rawData.isEmpty()) {
            tMap.putAll(rawData);
            UWBillUtil.calAllFormula(pInfo.getBillTableInfo(), tMap);
        }
        ArrayList entries = new ArrayList();
        List bEntries = pInfo.getEntriesData();
        TableInfo tInfo = null;
        List<TableInfo> entriesTable = pInfo.getEntriesTableInfo();
        if (entriesTable != null && entriesTable.size() > 0) {
            tInfo = entriesTable.get(0);
        }
        if (bEntries != null && bEntries.size() > 0) {
            int n = bEntries.size();
            for (int i = 0; i < n; ++i) {
                HashMap tEMap = new HashMap();
                Map sMap = (Map)bEntries.get(i);
                tEMap.putAll(sMap);
                UWBillUtil.calAllFormula(tInfo, tEMap);
                entries.add(tEMap);
            }
        }
        if (entries.size() > 0) {
            tMap.put("MapFldEntry", entries);
        }
        return tMap;
    }

    public static Map<String, Object> getTargetBillValue(BarcodePDataInfo pInfo) {
        HashMap<String, Object> tMap = new HashMap<String, Object>();
        tMap.putAll(pInfo.getBillData());
        UWBillUtil.calAllFormula(pInfo.getBillTableInfo(), tMap);
        return tMap;
    }

    public static List getTargetEntriesValue(BarcodePDataInfo pInfo) {
        ArrayList entries = new ArrayList();
        List bEntries = pInfo.getEntriesData();
        TableInfo tInfo = null;
        List<TableInfo> entriesTable = pInfo.getEntriesTableInfo();
        if (entriesTable != null && entriesTable.size() > 0) {
            tInfo = entriesTable.get(0);
        }
        int n = bEntries.size();
        for (int i = 0; i < n; ++i) {
            HashMap tEMap = new HashMap();
            Map sMap = (Map)bEntries.get(i);
            tEMap.putAll(sMap);
            UWBillUtil.calAllFormula(tInfo, tEMap);
            entries.add(tEMap);
        }
        return entries;
    }

    private static void calAllFormula(TableInfo tInfo, Map tMap) {
        if (tInfo == null) {
            logger.error((Object)"UW: calAllFormula, no tableInfo! ");
            return;
        }
        UWMathFormulaProcessor fmulaPro = new UWMathFormulaProcessor();
        List mappings = tInfo.getCustMappingInfo();
        int n = mappings.size();
        for (int i = 0; i < n; ++i) {
            CustMappingInfo mInfo = (CustMappingInfo)mappings.get(i);
            String formula = mInfo.getFormula();
            String sourceFld = mInfo.getSourceField();
            String targetFld = mInfo.getTargetField();
            logger.debug((Object)("UW: sourceFld, " + sourceFld + ", targetFld, " + targetFld));
            if (!StringUtils.isEmpty((String)formula)) {
                Object nVal = fmulaPro.calculate(formula, tMap);
                tMap.put(targetFld, nVal);
                continue;
            }
            tMap.put(targetFld, tMap.get(sourceFld));
        }
    }
}

