/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.barcode.scm.util.AttachmentUploadServer;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BizobjectFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.IBizobjectFacade;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentBaseManager;
import com.kingdee.eas.base.attachment.ftp.AttachmentUploadClient;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class AttachmentServerManager
extends AttachmentBaseManager {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.util.AttachmentServerManager");
    private Context ctx;

    public AttachmentServerManager(Context ctx) {
        this.ctx = ctx;
    }

    protected IAttachment getIA() throws BOSException {
        return AttachmentFactory.getLocalInstance((Context)this.ctx);
    }

    protected IBoAttchAsso getIBAA() throws BOSException {
        return BoAttchAssoFactory.getLocalInstance((Context)this.ctx);
    }

    protected IBizobjectFacade getIBF() throws BOSException {
        return BizobjectFacadeFactory.getLocalInstance((Context)this.ctx);
    }

    public void copyBizAttachmentFiles(String sourceboID, String destBoID) throws BOSException, EASBizException {
        this.getIBF().copyBizAttachmentFiles(sourceboID, destBoID);
    }

    public void copyBizRelation(String sourceID, String destID) throws BOSException, EASBizException {
        this.getIBF().copyBizRelation(sourceID, destID);
    }

    protected IAttachmentFtpFacade getIAFF() throws BOSException {
        return AttachmentFtpFacadeFactory.getLocalInstance((Context)this.ctx);
    }

    public String submitAttachment(AttachmentInfo attachmentInfo) throws BOSException, EASBizException {
        String attchID = "";
        byte[] fileInfo = attachmentInfo.getFile();
        String fileUrl = attachmentInfo.getRemotePath();
        attachmentInfo.setRemotePath(null);
        try {
            if (fileInfo != null && fileInfo.length > 0x500000) {
                this.logger.info((Object)" begin mutl part file upload");
                attachmentInfo.setFile(null);
                attchID = this.getIA().addnew(attachmentInfo).toString();
                AttachmentUploadServer fileUpload = new AttachmentUploadServer(this.getIAFF());
                fileUpload.uploadFile(this.ctx, attchID, fileInfo);
            } else if (fileInfo != null && fileInfo.length <= 0x500000) {
                this.logger.info((Object)" begin one part file upload");
                attchID = this.getIA().addnew(attachmentInfo).toString();
            } else if (fileInfo == null && fileUrl != null) {
                this.logger.info((Object)"*****begin large file upload****");
                attachmentInfo.setFile(null);
                attchID = this.getIA().addnew(attachmentInfo).toString();
                AttachmentUploadClient fileUpload = new AttachmentUploadClient(this.getIAFF());
                fileUpload.uploadFile(attchID, fileUrl);
            }
        }
        catch (BOSException e) {
            this.getIA().delete((IObjectPK)new ObjectStringPK(attchID));
            this.logger.info((Object)"upload file fail:", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.getIA().delete((IObjectPK)new ObjectStringPK(attchID));
            this.logger.info((Object)"upload file fail:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.getIA().delete((IObjectPK)new ObjectStringPK(attchID));
            this.logger.info((Object)"upload file fail:", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return attchID;
    }
}

