/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BarcodeDataProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.util.BarcodeDataProvider");
    private List<Map<String, String>> valueList = null;

    public BarcodeDataProvider(List<Map<String, String>> valueList) {
        this.valueList = valueList;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = this.getRowSet();
        return iRowSet;
    }

    private IRowSet getRowSet() {
        if (this.valueList == null) {
            return null;
        }
        DynamicRowSet drs = null;
        List cols = this.getCols();
        int colsLen = cols.size();
        try {
            int i;
            drs = new DynamicRowSet(colsLen);
            for (i = 0; i < colsLen; ++i) {
                drs.setColInfo(i + 1, (ColInfo)cols.get(i));
            }
            drs.beforeFirst();
            int n = this.valueList.size();
            for (i = 0; i < n; ++i) {
                drs.moveToInsertRow();
                BarcodeDataProvider.clearRow((IRowSet)drs);
                Map<String, String> valueMap = this.valueList.get(i);
                this.convertValueRowSet((IRowSet)drs, valueMap);
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)"exception while convert the info to rowset", (Throwable)e);
        }
        return drs;
    }

    private static void clearRow(IRowSet rs) throws SQLException {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private void convertValueRowSet(IRowSet rs, Map<String, String> valueMap) throws SQLException {
        for (String key : valueMap.keySet()) {
            String value = valueMap.get(key);
            if (key == null || "".equals(key)) continue;
            rs.updateString(key, value);
        }
    }

    private List getCols() {
        if (this.valueList.size() < -1) {
            return null;
        }
        ArrayList<ColInfo> newCols = new ArrayList<ColInfo>();
        for (String colName : this.valueList.get(0).keySet()) {
            if (colName == null || "".equals(colName)) continue;
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = colName;
            ci.nullable = 1;
            newCols.add(ci);
        }
        return newCols;
    }
}

