/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class BarcodePrintListener
implements IPrintActionListener {
    private KDNoteHelper appHlp = null;
    private Logger logger = Logger.getLogger(BarcodePrintListener.class);
    protected BOSObjectType bosType = null;
    protected String tdPath = "";
    protected String billNum = "";
    protected boolean isEditUI = true;
    protected Map<String, String> barcodeMap = null;
    private boolean isPrint = false;

    public boolean isPrint() {
        return this.isPrint;
    }

    public void setPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    public Map<String, String> getBarcodeMap() {
        return this.barcodeMap;
    }

    public void setBarcodeMap(Map<String, String> barcodeMap) {
        this.barcodeMap = barcodeMap;
    }

    public BarcodePrintListener(KDNoteHelper appHlp, BOSObjectType bosType, Map<String, String> barcodeMap, String tdPath) {
        this.appHlp = appHlp;
        this.bosType = bosType;
        this.tdPath = tdPath;
        this.barcodeMap = barcodeMap;
    }

    public void beforePrint() {
        try {
            BarcodeDossierFactory.getRemoteInstance().updateBatchPrinted(this.barcodeMap);
            this.setBarcodeMap(this.barcodeMap);
            this.setPrint(true);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public String findControlPath(String path) throws KDRSException {
        this.logger.info((Object)("Current Find Path:>" + path));
        if (KDNoteHelper.isPrintTimesControllable((String)path) || "".equals(path)) {
            this.logger.info((Object)"Find Complent!");
            return path;
        }
        String tph = "";
        try {
            tph = path.substring(0, path.lastIndexOf("/"));
            this.logger.info((Object)("Parent Path:" + tph));
        }
        catch (Exception e) {
            this.logger.info((Object)"Find root path,no control path!!");
            tph = "";
        }
        return this.findControlPath(tph);
    }

    public boolean isPrintable(int pnum, String billID) throws KDRSException, BOSException {
        boolean isok = true;
        String tdPath = this.findControlPath(this.getTDFileName());
        this.logger.info((Object)("current print control path:>>" + tdPath));
        if (tdPath != null && tdPath.trim().length() > 0) {
            this.logger.info((Object)"start the print control!");
            KDNoteHelper noteHelper = new KDNoteHelper();
            int maxNum = noteHelper.getMaxPrintTimes2(tdPath);
            int curNum = this.appHlp.getCopies();
            this.logger.info((Object)("Max print number:>>" + maxNum));
            this.logger.info((Object)("Alreadey print number:>>" + pnum));
            this.logger.info((Object)("current print number:>>" + curNum));
            if (pnum >= maxNum) {
                IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
                String billNumber = pinfo.getBillNumberByBosType(this.getBosType(), billID);
                String msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo1");
                Object[] objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                MsgBox.showWarning((String)MessageFormat.format(msgInfo, objs));
                isok = false;
            } else if (curNum + pnum > maxNum) {
                IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
                String billNumber = pinfo.getBillNumberByBosType(this.getBosType(), billID);
                String msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo2");
                Object[] objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                MsgBox.showWarning((String)MessageFormat.format(msgInfo, objs));
                isok = false;
            }
        }
        return isok;
    }

    public String getTDFileName() {
        return this.tdPath;
    }

    public String getBosType() {
        return this.bosType.toString();
    }

    public void beforePrintOrPreview() {
    }

    public void beforePreview() {
    }

    public void closePreview() {
    }
}

