/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import com.kingdee.eas.barcode.scm.app.MoveBillCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MoveBarcodeCacheManager {
    private static HashMap cacheMap = new HashMap();

    private MoveBarcodeCacheManager() {
    }

    public static boolean getSimpleFlag(String key) {
        try {
            return (Boolean)cacheMap.get(key);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static long getServerStartdt(String key) {
        try {
            return (Long)cacheMap.get(key);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static synchronized boolean setSimpleFlag(String key, boolean flag) {
        if (flag && MoveBarcodeCacheManager.getSimpleFlag(key)) {
            return false;
        }
        cacheMap.put(key, flag);
        return true;
    }

    public static synchronized boolean setSimpleFlag(String key, long serverbegrundt) {
        if (cacheMap.get(key) == null) {
            cacheMap.put(key, serverbegrundt);
            return true;
        }
        return false;
    }

    private static synchronized MoveBillCache getCache(String key) {
        return (MoveBillCache)cacheMap.get(key);
    }

    private static synchronized boolean hasCache(String key) {
        return cacheMap.containsKey(key);
    }

    public static synchronized void clearAll() {
        cacheMap.clear();
    }

    public static synchronized void clearAll(String type) {
        Iterator i = cacheMap.entrySet().iterator();
        ArrayList<String> arr = new ArrayList<String>();
        try {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(type)) continue;
                arr.add(key);
            }
            for (int k = 0; k < arr.size(); ++k) {
                MoveBarcodeCacheManager.clearOnly((String)arr.get(k));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized void clearOnly(String key) {
        cacheMap.remove(key);
    }

    public static synchronized void putCache(String key, MoveBillCache obj) {
        cacheMap.put(key, obj);
    }

    public static synchronized MoveBillCache getCacheInfo(String key) {
        if (MoveBarcodeCacheManager.hasCache(key)) {
            MoveBillCache cache = MoveBarcodeCacheManager.getCache(key);
            if (MoveBarcodeCacheManager.cacheExpired(cache)) {
                cache.setExpired(true);
                MoveBarcodeCacheManager.clearOnly(key);
            }
            return cache;
        }
        return null;
    }

    public static void putCacheInfo(String key, Object obj, long dt, boolean expired) {
        MoveBillCache cache = new MoveBillCache();
        cache.setKey(key);
        cache.setTimeOut(dt + System.currentTimeMillis());
        cache.setValue(obj);
        cache.setExpired(expired);
        cacheMap.put(key, cache);
    }

    public static void putCacheInfo(String key, Object obj, long dt) {
        MoveBillCache cache = new MoveBillCache();
        cache.setKey(key);
        cache.setTimeOut(dt + System.currentTimeMillis());
        cache.setValue(obj);
        cache.setExpired(false);
        cacheMap.put(key, cache);
    }

    public static boolean cacheExpired(MoveBillCache cache) {
        if (null == cache) {
            return false;
        }
        long nowDt = System.currentTimeMillis();
        long cacheDt = cache.getTimeOut();
        return cacheDt > 0L && cacheDt <= nowDt;
    }

    public static int getCacheSize() {
        return cacheMap.size();
    }

    public static int getCacheSize(String type) {
        int k = 0;
        Iterator i = cacheMap.entrySet().iterator();
        try {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                if (key.indexOf(type) == -1) continue;
                ++k;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return k;
    }

    public static ArrayList<String> getCacheAllkey() {
        ArrayList<String> a = new ArrayList<String>();
        try {
            for (Map.Entry entry : cacheMap.entrySet()) {
                a.add((String)entry.getKey());
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getCacheListkey(String type) {
        ArrayList<String> a = new ArrayList<String>();
        try {
            for (Map.Entry entry : cacheMap.entrySet()) {
                String key = (String)entry.getKey();
                if (key.indexOf(type) == -1) continue;
                a.add(key);
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return a;
    }
}

