/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class PropertiesUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.util.PropertiesUtil");
    private static final byte[] raw = new byte[]{117, 78, 105, 111, 110, 119, 65, 114, 101, 64, 55, 54, 49, 51, 49, 52};

    public static String readPropertiesFile() {
        ResourceBundle resource = ResourceBundle.getBundle("com/kingdee/eas/barcode/scm/util/config");
        String eventsName = resource.getString("EventsName");
        return eventsName;
    }

    public static Map<String, String> readBarcodeVersionFile() {
        HashMap<String, String> barcodeVersionMap = new HashMap<String, String>();
        try {
            ResourceBundle resource = ResourceBundle.getBundle("com/kingdee/eas/barcode/barcodeVersion");
            String machineCode = resource.getString("machineCode");
            machineCode = PropertiesUtil.Decrypt(machineCode);
            logger.info((Object)("machineCode:" + machineCode));
            barcodeVersionMap.put("machineCode", machineCode);
            String licmax = resource.getString("licmax");
            licmax = PropertiesUtil.Decrypt(licmax);
            logger.info((Object)("licmax:" + licmax));
            barcodeVersionMap.put("licmax", licmax);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return barcodeVersionMap;
    }

    public static void writeFile(String content, String file) {
        try {
            FileWriter fw = new FileWriter(file, true);
            PrintWriter out = new PrintWriter(fw);
            out.println(content);
            out.close();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("Uh oh, got an IOException error!");
            e.printStackTrace();
        }
    }

    private static String Decrypt(String sSrc) throws Exception {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            byte[] encrypted1 = new Base64().decode(sSrc);
            try {
                byte[] original = cipher.doFinal(encrypted1);
                String originalString = new String(original, "utf-8");
                return originalString;
            }
            catch (Exception e) {
                System.out.println(e.toString());
                return null;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            return null;
        }
    }
}

