/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.BizCLOSEACCOUNTException;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class AbstractCloseAccountStrategy {
    protected static final String tempTalbeNameKEY = "tempTalbeNameKEY";
    protected static final String tempRecSendTableNameKEY = "tempRecSendTableNameKEY";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.closeAccount.app.AbstractCloseAccountStrategy");

    protected abstract void closeAccount(Context var1, HashMap var2) throws BizCLOSEACCOUNTException, EASBizException, BOSException;

    protected void calPeriodRSData(Context ctx, HashMap paramMap, int accountType) throws EASBizException, BOSException {
        String tempTableName = paramMap.get(tempTalbeNameKEY).toString();
        String tempRecSendTableName = paramMap.get(tempRecSendTableNameKEY).toString();
        this.insertTempTable(ctx, paramMap, accountType, tempTableName, tempRecSendTableName);
    }

    private void insertTempTable(Context ctx, HashMap paramMap, int accountType, String tempTableName, String tempRecSendTableName) throws BOSException, EASBizException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt.addBatch(this.getShareInsertSQL(tempRecSendTableName) + this.getShareSumSQL(paramMap, accountType, true));
            stmt.addBatch(this.getShareInsertSQL(tempRecSendTableName) + this.getAllotAdjCostSQL(paramMap, (PeriodInfo)paramMap.get("period"), accountType, true));
            stmt.addBatch(this.getShareInsertSQL(tempRecSendTableName) + this.getShareSumSQL(paramMap, accountType, false));
            String calType = (String)paramMap.get("calType");
            if (!"2".equals(calType)) {
                stmt.addBatch(this.updateCostMoveIsCalcalate(tempRecSendTableName, calType));
            }
            stmt.addBatch(this.getShareInsertSQL(tempRecSendTableName) + this.getAllotAdjCostSQL(paramMap, (PeriodInfo)paramMap.get("period"), accountType, false));
            stmt.addBatch(this.getInsertInvBalanceSQL(tempTableName, tempRecSendTableName, paramMap));
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String getAllotAdjCostSQL(HashMap paramMap, PeriodInfo period, int accountType, boolean isReceived) {
        StringBuffer stringBuffer = new StringBuffer();
        String companyOrgUnitID = paramMap.get("companyOrgUnitID").toString();
        stringBuffer.append("SELECT ");
        stringBuffer.append("NEWBOSID('8FA62986'),");
        stringBuffer.append("A.FCompanyOrgUnitID,");
        stringBuffer.append("A.FStorageOrgUnitID,");
        stringBuffer.append("A.FMaterialID,");
        stringBuffer.append("A.FLot,");
        stringBuffer.append("0,");
        stringBuffer.append("A.FWarehouseID,");
        stringBuffer.append("NULL,");
        stringBuffer.append("NULL,");
        stringBuffer.append("FAssistPropertyID as FAssistPropertyID,");
        stringBuffer.append("1,");
        if (isReceived) {
            stringBuffer.append(" 1,");
        } else {
            stringBuffer.append(" 2,");
        }
        stringBuffer.append("null AS FBIZTYPEID,");
        stringBuffer.append("0 AS FPeriodQty,");
        stringBuffer.append("0 AS FPeriodAssistQty,");
        if (accountType != 2) {
            stringBuffer.append("ISNULL(SUM(A.FAmount),0) AS FTotalAmount,");
            stringBuffer.append("0 AS FPeriodCostDiff ");
        } else {
            stringBuffer.append("0 AS FTotalAmount, ");
            stringBuffer.append("ISNULL(SUM(A.FAmount),0) AS FPeriodCostDiff ");
        }
        stringBuffer.append("FROM T_CL_CostAdjustBillEntry A INNER JOIN T_CL_CostAdjustBill B ");
        stringBuffer.append("ON A.FParentID = B.FID ");
        stringBuffer.append("INNER JOIN T_BD_MaterialCompanyInfo C ");
        stringBuffer.append("ON A.FMaterialID = C.FMaterialID ");
        stringBuffer.append(" WHERE B.FPeriod = " + period.getPeriodNumber());
        stringBuffer.append(" AND B.FYear = " + period.getPeriodYear());
        stringBuffer.append(" AND B.FBaseStatus = 4");
        stringBuffer.append(" AND c.FAccountType = " + accountType);
        stringBuffer.append(" AND A.FCompanyOrgUnitID = '" + companyOrgUnitID + "'");
        stringBuffer.append(" AND C.FCompanyID = '" + companyOrgUnitID + "'");
        if (isReceived) {
            stringBuffer.append(" AND B.FCalculateKind = 0");
        } else {
            stringBuffer.append(" AND B.FCalculateKind = 1");
        }
        stringBuffer.append(" GROUP BY A.FCompanyOrgUnitID,A.FStorageOrgUnitID,A.FAssistPropertyID, ");
        stringBuffer.append(" A.FMaterialID,A.FLot,A.FWarehouseID,B.FCalculateKind");
        return stringBuffer.toString();
    }

    private String getShareInsertSQL(String tempTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + " (FID,FCompanyOrgUnitID,FStorageOrgUnitID,");
        sb.append("FMaterialID,FLot,FSeqNum,FWarehouseID,FLocationID,FStoreStatusID,FAssistPropertyID,FISCALCULATE,FRSTYPE,FBIZTYPEID,");
        sb.append("FPeriodQty,FPeriodAssistQty,FPeriodAmount,FPeriodCostDiff) ");
        return sb.toString();
    }

    private String getShareSumSQL(HashMap paramMap, int accountType, boolean isRecieve) {
        int endNumber;
        int beginNumber;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList listTableNames = (ArrayList)paramMap.get("listTableNames");
        ArrayList listEntryTableNames = (ArrayList)paramMap.get("listEntryTableNames");
        stringBuffer.append("SELECT NEWBOSID('" + paramMap.get("InvBalBosType").toString() + "'),A.FCompanyOrgUnitID,A.FStorageOrgUnitID,A.FMaterialID,A.FLot,A.FSeqNum, ");
        stringBuffer.append("A.FWarehouseID,A.FLocationID,A.FStoreStatusID,A.FAssistPropertyID,A.FISCALCULATE,");
        if (isRecieve) {
            stringBuffer.append("1 AS FRSTYPE,");
        } else {
            stringBuffer.append("2 AS FRSTYPE,");
        }
        stringBuffer.append("A.FBIZTYPEID,");
        stringBuffer.append("sum(A.FPeriodQty),sum(A.FPeriodAssistQty),sum(A.FPeriodReceiptAmount),sum(A.FPeriodCostDiff)  ");
        stringBuffer.append("FROM ( ");
        int moveLoactionIndex = 9;
        if (isRecieve) {
            beginNumber = 4;
            endNumber = 7;
        } else {
            beginNumber = 0;
            endNumber = 3;
        }
        String companyOrgUnitID = paramMap.get("companyOrgUnitID").toString();
        stringBuffer.append(this.getShareSelectSQL(paramMap, companyOrgUnitID, accountType, listTableNames.get(moveLoactionIndex).toString(), listEntryTableNames.get(moveLoactionIndex).toString(), isRecieve, true));
        stringBuffer.append(" UNION ALL ");
        for (int i = beginNumber; i <= endNumber; ++i) {
            stringBuffer.append(this.getShareSelectSQL(paramMap, companyOrgUnitID, accountType, listTableNames.get(i).toString(), listEntryTableNames.get(i).toString(), isRecieve, false));
            if (i >= endNumber) continue;
            stringBuffer.append(" UNION ALL ");
        }
        if (isRecieve && accountType == 2) {
            stringBuffer.append(" UNION ALL ").append("\n");
            stringBuffer.append(this.getStandardCostAdjBillSql(paramMap, companyOrgUnitID));
        }
        stringBuffer.append(") A ");
        stringBuffer.append("GROUP BY FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FLot,FSeqNum,");
        stringBuffer.append("FWarehouseID,FLocationID,FStoreStatusID,FAssistPropertyID,FIsCalculate,FBIZTYPEID");
        logger.debug((Object)("getShareSumSQL=\n " + stringBuffer.toString()));
        return stringBuffer.toString();
    }

    private String getShareSelectSQL(HashMap paramMap, String companyOrgUnitID, int accountType, String headTableName, String entryTableName, boolean isRecieve, boolean isMoveLocBill) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer groupBuffer = new StringBuffer(" GROUP BY A.FCompanyOrgUnitID,A.FStorageOrgUnitID,A.FMaterialID,A.FLot,A.FWarehouseID,C.FIsCalculate,C.FBizTypeID ");
        PeriodInfo period = (PeriodInfo)paramMap.get("period");
        ArrayList al = (ArrayList)paramMap.get("listTableNames");
        stringBuffer.append("SELECT ");
        stringBuffer.append("A.FCompanyOrgUnitID AS FCompanyOrgUnitID, ");
        stringBuffer.append("A.FStorageOrgUnitID AS FStorageOrgUnitID, ");
        stringBuffer.append("A.FMaterialID AS FMaterialID, ");
        stringBuffer.append("A.FLot AS FLot, ");
        stringBuffer.append("0 AS FSeqNum, ");
        stringBuffer.append("A.FWarehouseID AS FWarehouseID, ");
        if (isMoveLocBill && isRecieve) {
            stringBuffer.append("A.FReceiptLocationID AS FLocationID, ");
            groupBuffer.append(",A.FReceiptLocationID");
        } else {
            stringBuffer.append("A.FLocationID AS FLocationID, ");
            groupBuffer.append(",A.FLocationID");
        }
        if (isMoveLocBill || headTableName.equalsIgnoreCase(al.get(2).toString()) || headTableName.equalsIgnoreCase(al.get(6).toString())) {
            stringBuffer.append("A.FStoreStatusID AS FStoreStatusID, ");
            groupBuffer.append(",A.FStoreStatusID");
        } else {
            stringBuffer.append("CASE WHEN (C.FExistingQty = 1 OR C.FExistingQty = -1) THEN C.FStoreStateID WHEN (C.FExistingQtyPre = -1 OR C.FExistingQtyPre = 1) THEN C.FStoreStatePreID END AS FStoreStatusID, ");
            groupBuffer.append(",C.FStoreStateID,C.FExistingQty,C.FStoreStatePreID,C.FExistingQtyPre");
        }
        stringBuffer.append("A.FAssistPropertyID AS FAssistPropertyID, ");
        stringBuffer.append("C.FIsCalculate AS FIsCalculate, ");
        stringBuffer.append("C.FBizTypeID AS FBizTypeID, ");
        groupBuffer.append(",A.FAssistPropertyID ");
        stringBuffer.append("ISNULL(SUM(A.FBaseQty),0) AS FPeriodQty, ");
        stringBuffer.append("ISNULL(SUM(A.FAssistQty),0) AS FPeriodAssistQty, ");
        if (accountType == 2) {
            stringBuffer.append("ISNULL(SUM(A.FStandardCost),0) AS FPeriodReceiptAmount, ");
            stringBuffer.append("(ISNULL(SUM(A.FActualCost),0) - ISNULL(SUM(A.FStandardCost),0)) AS FPeriodCostDiff ");
        } else {
            stringBuffer.append("ISNULL(SUM(A.FActualCost),0) AS FPeriodReceiptAmount, ");
            stringBuffer.append("0 AS FPeriodCostDiff ");
        }
        stringBuffer.append("FROM " + entryTableName + " A ");
        stringBuffer.append("INNER JOIN " + headTableName + " B ");
        stringBuffer.append("ON A.FParentID = B.FID ");
        if (!isMoveLocBill) {
            stringBuffer.append("INNER JOIN T_SCM_TransactionType C ");
            stringBuffer.append("ON B.FTransactionTypeID = C.FID ");
        } else {
            stringBuffer.append("LEFT JOIN T_SCM_TransactionType C ");
            stringBuffer.append("ON B.FTransactionTypeID = C.FID ");
        }
        stringBuffer.append("INNER JOIN T_BD_MaterialCompanyInfo D ");
        stringBuffer.append("ON A.FMaterialID = D.FMaterialID ");
        stringBuffer.append(" WHERE B.FPeriod = " + period.getPeriodNumber());
        stringBuffer.append(" AND B.FYear = " + period.getPeriodYear());
        stringBuffer.append(" AND A.FCompanyOrgUnitID = '" + companyOrgUnitID + "'");
        stringBuffer.append(" AND D.FCompanyID = '" + companyOrgUnitID + "'");
        stringBuffer.append(" AND (B.FIsInitBill = 0 OR B.FIsInitBill IS NULL)");
        stringBuffer.append(" AND B.FBaseStatus = 4");
        stringBuffer.append(" AND D.FAccountType = " + accountType);
        stringBuffer.append(" AND A.FCompanyOrgUnitID = D.FCompanyID ");
        stringBuffer.append(groupBuffer.toString());
        logger.debug((Object)("getShareSelectSQL==\n" + stringBuffer.toString()));
        return stringBuffer.toString();
    }

    private String getInsertInvBalanceSQL(String tableName, String tempRecSendTableName, HashMap paramMap) {
        StringBuffer stringBuffer = new StringBuffer();
        PeriodInfo period = (PeriodInfo)paramMap.get("period");
        stringBuffer.append(" INSERT INTO " + tableName + "(");
        stringBuffer.append(" FID, ");
        stringBuffer.append(" FCompanyOrgUnitID,");
        stringBuffer.append(" FPeriod,");
        stringBuffer.append(" FYear,");
        stringBuffer.append(" FMaterialID,");
        stringBuffer.append(" FLot,");
        stringBuffer.append(" FSeqNum,");
        stringBuffer.append(" FStorageOrgUnitID,");
        stringBuffer.append(" FStoreStatusID,");
        stringBuffer.append(" FAssistPropertyID,");
        stringBuffer.append(" FWarehouseID,");
        stringBuffer.append(" FLocationID,");
        stringBuffer.append(" FISCALCULATE,");
        stringBuffer.append(" FPeriodBeginQty,");
        stringBuffer.append(" FPeriodReceiptQty, ");
        stringBuffer.append(" FPeriodIssueQty, ");
        stringBuffer.append(" FPeriodBeginAssistQty, ");
        stringBuffer.append(" FPeriodReceiptAssistQty, ");
        stringBuffer.append(" FPeriodIssueAssistQty, ");
        stringBuffer.append(" FPeriodBeginBalance, ");
        stringBuffer.append(" FPeriodReceiptAmount, ");
        stringBuffer.append(" FPeriodIssueAmount, ");
        stringBuffer.append(" FPeriodBeginCostDiff, ");
        stringBuffer.append(" FPeriodReceiptCostDiff, ");
        stringBuffer.append(" FPeriodIssueCostDiff");
        stringBuffer.append(" )\n SELECT");
        stringBuffer.append(" NEWBOSID('" + paramMap.get("InvBalBosType").toString() + "'), ");
        stringBuffer.append(" FCompanyOrgUnitID,");
        stringBuffer.append(" " + period.getPeriodNumber() + " ,");
        stringBuffer.append(" " + period.getPeriodYear() + " ,");
        stringBuffer.append(" FMaterialID,");
        stringBuffer.append(" FLot,");
        stringBuffer.append(" 0,");
        stringBuffer.append(" FStorageOrgUnitID,");
        stringBuffer.append(" FStoreStatusID,");
        stringBuffer.append(" FAssistPropertyID,");
        stringBuffer.append(" FWarehouseID,");
        stringBuffer.append(" FLocationID,");
        stringBuffer.append(" FISCALCULATE,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=0 THEN FPeriodQty ELSE 0 END) AS FPERIODBEGINQTY,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=1 THEN FPeriodQty ELSE 0 END) AS FPeriodReceiptQty,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=2 THEN FPeriodQty ELSE 0 END) AS FPeriodIssueAssistQty,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=0 THEN FPeriodAssistQty ELSE 0 END) AS FPeriodBeginAssistQty,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=1 THEN FPeriodAssistQty ELSE 0 END) AS FPeriodReceiptAssistQty,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=2 THEN FPeriodAssistQty ELSE 0 END) AS FPeriodIssueAssistQty,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=0 THEN FPeriodAmount ELSE 0 END) AS FPeriodBeginBalance,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=1 THEN FPeriodAmount ELSE 0 END) AS FPeriodReceiptAmount,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=2 THEN FPeriodAmount ELSE 0 END) AS FPeriodIssueAmount,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=0 THEN FPeriodCostDiff ELSE 0 END) AS FPeriodBeginCostDiff,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=1 THEN FPeriodCostDiff ELSE 0 END) AS FPeriodReceiptCostDiff,");
        stringBuffer.append("\n SUM(CASE WHEN FRSTYPE=2 THEN FPeriodCostDiff ELSE 0 END) AS FPeriodIssueCostDiff");
        stringBuffer.append("\n FROM " + tempRecSendTableName);
        stringBuffer.append("\n GROUP BY FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FMaterialID,FAssistPropertyID,FLot,FLocationID,");
        stringBuffer.append("FStoreStatusID,FISCALCULATE");
        logger.debug((Object)("\u63d2\u5165\u8ba1\u7b97\u6536\u4e0e\u53d1\u51fa\u7684\u6570\u636e:\n" + stringBuffer.toString()));
        return stringBuffer.toString();
    }

    private String updateCostMoveIsCalcalate(String tempReceiveSendTable, String calType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(tempReceiveSendTable);
        buffer.append(" SET FISCALCULATE = 0 ");
        buffer.append("\n WHERE FISCALCULATE =1");
        if ("0".equals(calType)) {
            buffer.append("\n AND FBIZTYPEID IN ('").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
            buffer.append(" ,'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("')");
        } else if ("1".equals(calType)) {
            buffer.append("\n AND FBIZTYPEID IN ('").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("')");
        }
        return buffer.toString();
    }

    private String getStandardCostAdjBillSql(HashMap paramMap, String companyOrgUnitId) {
        int precision = (Integer)paramMap.get("precision");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer groupBuffer = new StringBuffer("\n GROUP BY A.FCompanyOrgUnitID,A.FStorageOrgUnitID,A.FMaterialID,A.FLot,A.FWarehouseID");
        groupBuffer.append(",A.FLocationID");
        PeriodInfo period = (PeriodInfo)paramMap.get("period");
        stringBuffer.append("SELECT ");
        stringBuffer.append("A.FCompanyOrgUnitID AS FCompanyOrgUnitID, ");
        stringBuffer.append("A.FStorageOrgUnitID AS FStorageOrgUnitID, ");
        stringBuffer.append("A.FMaterialID AS FMaterialID, ");
        stringBuffer.append("\n A.FLot AS FLot, ");
        stringBuffer.append("0 AS FSeqNum, ");
        stringBuffer.append("A.FWarehouseID AS FWarehouseID, ");
        stringBuffer.append("A.FLocationID AS FLocationID, ");
        stringBuffer.append("NULL AS FStoreStatusID, ");
        stringBuffer.append("A.FAssistPropertyID AS FAssistPropertyID, ");
        stringBuffer.append("1 AS FIsCalculate, ");
        stringBuffer.append("NULL AS FBizTypeID,");
        groupBuffer.append(",A.FAssistPropertyID");
        stringBuffer.append("0 AS FPeriodQty, ");
        stringBuffer.append("0 AS FPeriodAssistQty, ");
        stringBuffer.append("SUM(ROUND(" + CalculateUtil.TO_DECIMAL_AMT("T1.PriceDiff*A.FPERIODBEGINQTY") + "," + precision + ")) AS FPeriodReceiptAmount, ");
        stringBuffer.append("SUM(ROUND(" + CalculateUtil.TO_DECIMAL_AMT("T1.PriceDiff*A.FPERIODBEGINQTY") + "," + precision + ")*(-1)) AS FPeriodCostDiff ");
        stringBuffer.append("\n FROM (");
        stringBuffer.append(this.getSumStandardCostAdjBillPriceSql(period, companyOrgUnitId));
        stringBuffer.append(") AS T1");
        stringBuffer.append("\n INNER JOIN  T_IM_INVENTORYBALANCE A ");
        stringBuffer.append(" ON (A.FCompanyOrgUnitID = T1.FCompanyOrgUnitID AND A.FMATERIALID = T1.FMATERIALID )");
        stringBuffer.append("\n INNER JOIN T_BD_MaterialCompanyInfo D ");
        stringBuffer.append("ON (A.FMaterialID = D.FMaterialID ");
        stringBuffer.append(" AND A.FCompanyOrgUnitID = D.FCompanyID) ");
        stringBuffer.append("\n WHERE A.FPeriod = " + period.getPeriodNumber());
        stringBuffer.append(" AND A.FYear = " + period.getPeriodYear());
        stringBuffer.append(" AND A.FCompanyOrgUnitID = '" + companyOrgUnitId + "'");
        stringBuffer.append(" AND A.FIsCalculate = 1 ");
        stringBuffer.append(groupBuffer.toString());
        return stringBuffer.toString();
    }

    private String getSumStandardCostAdjBillPriceSql(PeriodInfo period, String companyOrgUnitid) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT B.FMaterialID AS FMaterialID,A.FCompanyOrgUnitID AS FCompanyOrgUnitID");
        buffer.append(",SUM(B.FNewStandardPrice -B.FOldStandardPrice) AS PriceDiff");
        buffer.append("\n FROM  T_CL_StandardCostAdjBill A INNER JOIN T_CL_StandardCostAdjEntry B ON A.FID = B.FParentID");
        buffer.append("\n WHERE A.FBaseStatus = 4 ");
        buffer.append("\n AND A.FYEAR = ").append(period.getPeriodYear());
        buffer.append("\n AND A.FPERIOD = ").append(period.getPeriodNumber());
        buffer.append("\n AND A.FCompanyOrgUnitID = '").append(companyOrgUnitid).append("'");
        buffer.append("\n GROUP BY A.FCompanyOrgUnitID,B.FMaterialID");
        return buffer.toString();
    }
}

