/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.app.AbstractBillAccountViewQueryFacadeControllerBean;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.app.thread.QueryDataSyncLock;
import com.kingdee.eas.scm.framework.app.thread.QueryDataTask;
import com.kingdee.eas.scm.framework.app.thread.ThreadPool;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillAccountViewQueryFacadeControllerBean
extends AbstractBillAccountViewQueryFacadeControllerBean {
    private static final long serialVersionUID = -6367471131934397757L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.BillAccountViewQueryFacadeControllerBean");
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";
    private static final String LINE = "\n";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
        params.setInt("amtPrecision", amtPrecision);
        String tempTableName = DBUtil.createTempTable(ctx, this.getCreateTempTableSQL(ctx, "BillAccountViewQuery"));
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)aCompanyOrgUnitInfo.getId().toString(), (String)"billAccountView_view");
        if (checkPermission) {
            LowTimer t = new LowTimer();
            this.insertBillData(ctx, tempTableName, params);
            logger.debug((Object)("\u51c6\u5907\u6570\u636e\u5171\u8017\u65f6(ms):" + t.msValue()));
        }
        RptParams result = new RptParams();
        result.setObject("header", (Object)this.createTableHeader(ctx));
        result.setString("tempTable", tempTableName);
        String countSql = "select count(1) cc from " + tempTableName;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        result.setInt("RecordCount", count);
        return result;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTableName = params.getString("tempTable");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT '' AS SELECTED,T1.FBillTypeName,T1.FTransactionName,T1.FBillNumber,T1.FBizDate,T1.FFIVOUCHERED,T1.FMaterialNumber,");
        sqlBuffer.append("T1.FMaterialName,T1.FModel,");
        sqlBuffer.append("T1.FStoreTypeID,T1.FStoreTypeName,T1.FAccountViewInID,T1.FAccountViewInName, ");
        sqlBuffer.append("T1.FStoreTypePreID,T1.FStoreTypePreName,T1.FAccountViewOutID,T1.FAccountViewOutName, ");
        sqlBuffer.append("T1.FStorageOrgName,T1.FWarehouseName,T1.FUnitName,T1.FQty,T1.FBaseUnitName,T1.FBaseQty,");
        sqlBuffer.append("T1.FMaterialId,T1.FUnitId,T1.FQtyPrecision,T1.FBaseQtyPrecision,T1.FBillTypeId,T1.FBillId, ");
        sqlBuffer.append("T1.FCompanyOrgUnitID,T1.FBaseUnitId,T1.FBillEntryID ");
        sqlBuffer.append("\n FROM ").append(tempTableName).append(" AS T1 ");
        sqlBuffer.append("\n ORDER BY T1.FBILLTYPENAME,T1.FTransactionName,T1.FBillNumber,T1.FBizDate,T1.FBillEntryID");
        LowTimer t = new LowTimer();
        RptRowSet rs = this.executeQuery(sqlBuffer.toString(), null, from, len, ctx);
        logger.debug((Object)("\u5f02\u5e38\u6570\u636e\u67e5\u8be2\u5171\u8017\u65f6(ms):" + t.msValue()));
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String getCreateTempTableSQL(Context ctx, String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tempTable + " (");
        sql.append("\n FID VARCHAR(44),");
        sql.append("\n FBilltypeName NVARCHAR(255),");
        sql.append("\n FTRANSACTIONNAME NVARCHAR(255),");
        sql.append("\n FBillNumber NVARCHAR(80),");
        sql.append("\n FBizDate DATETIME,");
        sql.append("\n FFIVOUCHERED int default 0,");
        sql.append("\n FMaterialID VARCHAR(44),");
        sql.append("\n FMATERIALNUMBER NVARCHAR(80),");
        sql.append("\n FMATERIALNAME NVARCHAR(255),");
        sql.append("\n FMODEL NVARCHAR(255),");
        sql.append("\n FUnitId VARCHAR(44),");
        sql.append("\n FunitName NVARCHAR(80),");
        sql.append("\n FQty NUMERIC(21,8) default 0,");
        sql.append("\n FBaseUnitName NVARCHAR(80),");
        sql.append("\n FBaseQty NUMERIC(21,8) default 0,");
        sql.append("\n FQtyPrecision INT default 2,");
        sql.append("\n FBaseQtyPrecision INT default 2,");
        sql.append("\n FBILLTYPEID VARCHAR(44),");
        sql.append("\n FBILLID VARCHAR(44),");
        sql.append("\n FCompanyOrgUnitID VARCHAR(44),");
        sql.append("\n FBaseUnitId VARCHAR(44),");
        sql.append("\n FBillEntryID VARCHAR(44),");
        sql.append("\n FStoreTypeID VARCHAR(44),");
        sql.append("\n FStoreTypeName NVARCHAR(255),");
        sql.append("\n FAccountViewInID VARCHAR(44),");
        sql.append("\n FAccountViewInName NVARCHAR(255),");
        sql.append("\n FStoreTypePreID VARCHAR(44),");
        sql.append("\n FStoreTypePreName NVARCHAR(255),");
        sql.append("\n FAccountViewOutID VARCHAR(44),");
        sql.append("\n FAccountViewOutName NVARCHAR(255),");
        sql.append("\n FStorageOrgName NVARCHAR(255),");
        sql.append("\n FWarehouseName NVARCHAR(255),");
        sql.append("\n FSeq int default 0");
        sql.append(")");
        return sql.toString();
    }

    private RptTableHeader createTableHeader(Context ctx) throws BOSException {
        RptTableHeader header = new RptTableHeader();
        try {
            RptTableColumn col = null;
            col = new RptTableColumn("selected");
            col.setWidth(50);
            header.addColumn(col);
            col = new RptTableColumn("FBillTypeName");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FTransactionName");
            col.setWidth(120);
            header.addColumn(col);
            col = new RptTableColumn("FBillNumber");
            col.setWidth(120);
            header.addColumn(col);
            col = new RptTableColumn("FBizDate");
            col.setWidth(80);
            col.setFormatPattern("yyyy-MM-dd");
            header.addColumn(col);
            col = new RptTableColumn("FFIVOUCHERED");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FMaterialNumber");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FMaterialName");
            col.setWidth(150);
            header.addColumn(col);
            col = new RptTableColumn("FModel");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FStoreTypeID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FStoreTypeName");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FAccountViewInID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FAccountViewInName");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FStoreTypePreID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FStoreTypePreName");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FAccountViewOutID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FAccountViewOutName");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FStorageOrgName");
            col.setWidth(100);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FWarehouseName");
            col.setWidth(100);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FUnitName");
            col.setWidth(80);
            header.addColumn(col);
            col = new RptTableColumn("FQty");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("FBaseUnitName");
            col.setWidth(80);
            header.addColumn(col);
            col = new RptTableColumn("FBaseQty");
            col.setWidth(120);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("FMaterialId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FUnitId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FQtyPrecision");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBaseQtyPrecision");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBillTypeId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBillId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FCompanyOrgUnitID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBaseUnitId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBillEntryID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            this.setHeadLabes(ctx, header);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return header;
    }

    private void setHeadLabes(Context ctx, RptTableHeader header) {
        header.setLabels((Object[][])new Object[][]{{SCMUtils.getResource((String)this.res, (String)"selected", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), "FFivouchered", SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx), "FStoreTypeID", SCMUtils.getResource((String)this.res, (String)"STORETYPENAME", (Context)ctx), "FAccountViewInID", SCMUtils.getResource((String)this.res, (String)"ACCOUNTVIEWINNAME", (Context)ctx), "FStoreTypePreID", SCMUtils.getResource((String)this.res, (String)"STORETYPEPRENAME", (Context)ctx), "FAccountViewOutID", SCMUtils.getResource((String)this.res, (String)"ACCOUNTVIEWOUTNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FStorageOrgUnitName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FWarehouseName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BASEUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BASEQTY", (Context)ctx), "FMaterialID", "FUnitID", "FQtyPrecision", "FBaseQtyPrecision", "FBILLTYPEID", "FbillID", "FCompanyOrgUnitID", "FBaseUnitId", "FBillEntryID"}, {SCMUtils.getResource((String)this.res, (String)"selected", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), "FFivouchered", SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx), "FStoreTypeID", SCMUtils.getResource((String)this.res, (String)"STORETYPENAME", (Context)ctx), "FAccountViewInID", SCMUtils.getResource((String)this.res, (String)"ACCOUNTVIEWINNAME", (Context)ctx), "FStoreTypePreID", SCMUtils.getResource((String)this.res, (String)"STORETYPEPRENAME", (Context)ctx), "FAccountViewOutID", SCMUtils.getResource((String)this.res, (String)"ACCOUNTVIEWOUTNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FStorageOrgUnitName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FWarehouseName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BASEUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BASEQTY", (Context)ctx), "FMaterialID", "FUnitID", "FQtyPrecision", "FBaseQtyPrecision", "FBILLTYPEID", "FbillID", "FCompanyOrgUnitID", "FBaseUnitId", "FBillEntryID"}}, true);
    }

    private void insertBillData(Context ctx, String tempTableName, RptParams params) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            List<String> billelectSQLList = null;
            billelectSQLList = params.getObject("billType") != null ? this.getExceptionBills(ctx, params.getObject("billType"), params) : this.getSelectAllBillSQLList(ctx, params);
            this.takeBillData(ctx, tempTableName, billelectSQLList, this.getBillQueryLock());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private List<String> getExceptionBills(Context ctx, Object obj, RptParams params) throws BOSException, EASBizException {
        if (obj == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        BillTypeInfo billTypeInfo = null;
        if (obj instanceof BillTypeInfo) {
            billTypeInfo = (BillTypeInfo)obj;
            if (billTypeInfo.getId() != null) {
                list.add(billTypeInfo.getId().toString());
            }
        } else if (obj instanceof Object[]) {
            Object[] billTypes = (Object[])obj;
            int size = billTypes.length;
            for (int j = 0; j < size; ++j) {
                billTypeInfo = (BillTypeInfo)billTypes[j];
                if (billTypeInfo == null || billTypeInfo.getId() == null) continue;
                list.add(billTypeInfo.getId().toString());
            }
        }
        String billTypeID = null;
        ArrayList<String> billelectSQLList = new ArrayList<String>(9);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            billTypeID = (String)list.get(i);
            if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL(ctx, "T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry", this.getExtendFields(ctx), false, -1, params));
                continue;
            }
            if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL(ctx, "T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry", this.getExtendFields(ctx), false, -1, params));
                continue;
            }
            if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL(ctx, "T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry", this.getExtendFields(ctx), false, -1, params));
                continue;
            }
            if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL(ctx, "T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", this.getExtendFields(ctx), false, -1, params));
                continue;
            }
            if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL(ctx, "T_IM_SaleIssueBill", "T_IM_SaleIssueEntry", this.getExtendFields(ctx), false, -1, params));
                continue;
            }
            if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL(ctx, "T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry", this.getExtendFields(ctx), false, -1, params));
                continue;
            }
            if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL(ctx, "T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry", this.getExtendFields(ctx), false, -1, params));
                continue;
            }
            if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL(ctx, "T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry", this.getExtendFields(ctx), false, -1, params));
                continue;
            }
            if (!"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(billTypeID)) continue;
            billelectSQLList.add(this.getShareBillSelectSQL(ctx, "T_CL_CostAdjustBill", "T_CL_CostAdjustBillEntry", this.getExtendFields(ctx), false, -1, params));
        }
        return billelectSQLList;
    }

    private String getShareBillSelectSQL(Context ctx, String headTableName, String entryTableName, String extendFields, boolean isCostAdjustBill, int costAdjBillType, RptParams params) throws BOSException, EASBizException {
        StringBuffer ids;
        Set storageSet = null;
        Set warehouseSet = null;
        if (params.getObject("storageIds") != null) {
            storageSet = (Set)params.getObject("storageIds");
        }
        if (params.getObject("warehouseIds") != null) {
            warehouseSet = (Set)params.getObject("warehouseIds");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append("newbosid('086F1FBA') as FID,");
        stringBuffer.append("BILLTYPE.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FBILLTYPENAME,");
        stringBuffer.append("TransactionType.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FTRANSACTIONNAME,");
        stringBuffer.append("BILL.FNumber AS FBillNumber,");
        stringBuffer.append("BILL.FBIZDATE AS FBizDate,");
        stringBuffer.append("BILL.FFIVOUCHERED AS FFIVOUCHERED,");
        stringBuffer.append("ENTRY.FMaterialID AS FMaterialID, ");
        stringBuffer.append("MATERIAL.FNumber AS FMATERIALNUMBER,");
        stringBuffer.append("MATERIAL.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FMATERIALNAME,");
        stringBuffer.append("MATERIAL.FModel AS FMODEL,");
        stringBuffer.append("ENTRY.FUnitID AS FUnitId,");
        stringBuffer.append("MeasureUnit.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FunitName,");
        stringBuffer.append("ENTRY.FQty AS FQty,");
        stringBuffer.append("BaseUnit.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FBaseUnitName,");
        stringBuffer.append("ENTRY.FBASEQTY AS FBaseQty,");
        stringBuffer.append("multiunit.FQtyPrecision AS FQtyPrecision,");
        stringBuffer.append("BaseUnit.FQtyPrecision AS FBaseQtyPrecision,");
        stringBuffer.append("BILL.FBILLTYPEID AS FBILLTYPEID,");
        stringBuffer.append("BILL.FID AS FBILLID,");
        stringBuffer.append("ENTRY.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        stringBuffer.append("ENTRY.FBASEUNITID AS FBaseUnitId, ");
        stringBuffer.append("ENTRY.FID AS FBillEntryID,");
        if (!"T_CL_CostAdjustBill".equals(headTableName)) {
            stringBuffer.append("STORETYPE.FID AS FStoreTypeID,");
            stringBuffer.append("STORETYPE.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FStoreTypeName,");
        } else {
            stringBuffer.append("case when BILL.FISSUETYPE <> -1 then null else STORETYPE.FID end AS FStoreTypeID   ,");
            stringBuffer.append("case when BILL.FISSUETYPE <> -1 then null  else STORETYPE.FName_").append(CalculateUtil.getLoc(ctx)).append(" end AS FStoreTypeName ,");
        }
        stringBuffer.append("ENTRY.FAccountViewInId AS FAccountViewInID,");
        stringBuffer.append("ACCOUNTVIEWIN.FLongName_").append(CalculateUtil.getLoc(ctx)).append(" AS FAccountViewInName,");
        if (!"T_CL_CostAdjustBill".equals(headTableName)) {
            stringBuffer.append("STORETYPEPRE.FID AS FStoreTypePreID,");
            stringBuffer.append("STORETYPEPRE.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FStoreTypePreName,");
        } else {
            stringBuffer.append("case when BILL.FISSUETYPE = -1 then null  else STORETYPEPRE.FID end AS FStoreTypeID   ,");
            stringBuffer.append("case when BILL.FISSUETYPE = -1 then null  else STORETYPEPRE.FName_").append(CalculateUtil.getLoc(ctx)).append(" end AS FStoreTypeName ,");
        }
        stringBuffer.append("ENTRY.FAccountViewOutId AS FAccountViewOutID,");
        stringBuffer.append("ACCOUNTVIEWOUT.FLongName_").append(CalculateUtil.getLoc(ctx)).append(" AS FAccountViewOutName,");
        stringBuffer.append("STORAGE.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FSTORAGEORGNAME,");
        stringBuffer.append("WAREHOUSE.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FWAREHOUSENAME");
        stringBuffer.append("\n FROM " + entryTableName + " ENTRY ");
        stringBuffer.append("\n INNER JOIN " + headTableName + " BILL ON ENTRY.FParentID = BILL.FID ");
        stringBuffer.append("\n LEFT JOIN T_SCM_TransactionType TransactionType ON TransactionType.FID = BILL.FTransactionTypeID ");
        stringBuffer.append("\n INNER JOIN T_BD_Material MATERIAL ON MATERIAL.FID = ENTRY.FMATERIALID ");
        stringBuffer.append("\n INNER JOIN T_ORG_Storage STORAGE ON STORAGE.FID = ENTRY.FSTORAGEORGUNITID ");
        stringBuffer.append("\n INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON WAREHOUSE.FID = ENTRY.FWAREHOUSEID ");
        if (!"T_CL_CostAdjustBill".equals(headTableName)) {
            stringBuffer.append("\n LEFT JOIN T_IM_InvUpdateType INVUPDATETYPE ON INVUPDATETYPE.FID = ENTRY.FInvUpdateTypeID ");
            stringBuffer.append("\n LEFT JOIN T_IM_STORETYPE STORETYPE ON STORETYPE.FID = INVUPDATETYPE.FStoreTypeID ");
            stringBuffer.append("\n LEFT JOIN T_IM_STORETYPE STORETYPEPRE ON STORETYPEPRE.FID = INVUPDATETYPE.FStoreTypePreID ");
        } else {
            stringBuffer.append("\n LEFT JOIN T_IM_STORETYPE STORETYPE ON STORETYPE.FID = ENTRY.FStoreTypeID ");
            stringBuffer.append("\n LEFT JOIN T_IM_STORETYPE STORETYPEPRE ON STORETYPEPRE.FID = ENTRY.FStoreTypeID ");
        }
        stringBuffer.append("\n LEFT JOIN T_BD_AccountView ACCOUNTVIEWIN ON ACCOUNTVIEWIN.FID = ENTRY.FAccountViewInId ");
        stringBuffer.append("\n LEFT JOIN T_BD_AccountView ACCOUNTVIEWOUT ON ACCOUNTVIEWOUT.FID = ENTRY.FAccountViewOutId ");
        stringBuffer.append("\n INNER JOIN T_SCM_BILLTYPE BILLTYPE ON BILL.FBILLTYPEID = BILLTYPE.FID");
        stringBuffer.append("\n INNER JOIN T_BD_MeasureUnit MeasureUnit ON ENTRY.FUNITID = MeasureUnit.FID");
        stringBuffer.append("\n INNER JOIN T_BD_MeasureUnit BaseUnit ON ENTRY.FBASEUNITID = baseUnit.FID");
        stringBuffer.append("\n  LEFT JOIN T_BD_MultiMeasureUnit multiunit ON ENTRY.fmaterialid = multiunit.fmaterialId and ENTRY.funitid = multiunit.FMeasureUnitID ");
        stringBuffer.append("\n WHERE (BILL.FIsInitBill = 0 OR BILL.FIsInitBill IS NULL)");
        if (!"T_CL_CostAdjustBill".equals(headTableName)) {
            stringBuffer.append("\n and TransactionType.FIsManuCheckAccount=1");
        }
        if (params.getObject("company") != null) {
            stringBuffer.append("\n AND ENTRY.FCompanyOrgUnitID = '" + ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString() + "'");
        }
        if (params.getObject("startMaterial") != null) {
            if (params.getObject("startMaterial") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("startMaterial");
                if (materials.length == 1) {
                    stringBuffer.append("\n AND MATERIAL.FNUMBER >='").append(((MaterialInfo)materials[0]).getNumber()).append("'");
                } else {
                    stringBuffer.append("\n AND MATERIAL.FNUMBER in (").append(CalculateUtil.getObjArrayNumberWithQuote(materials)).append(")");
                }
            } else {
                stringBuffer.append("\n AND MATERIAL.FNUMBER >='").append(((MaterialInfo)params.getObject("startMaterial")).getNumber()).append("'");
            }
        }
        if (params.getObject("endMaterial") != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER <='").append(((MaterialInfo)params.getObject("endMaterial")).getNumber()).append("'");
        }
        if (params.getObject("materialIds") != null) {
            ids = new StringBuffer();
            Set materialSet = (Set)params.getObject("materialIds");
            for (String s : materialSet) {
                ids.append("'").append(s).append("',");
            }
            stringBuffer.append(" AND MATERIAL.FID in (").append(ids.substring(0, ids.length() - 1)).append(")");
        }
        if (params.getObject("startTransacionType") != null) {
            if (params.getObject("startTransacionType") instanceof Object[]) {
                Object[] trans = (Object[])params.getObject("startTransacionType");
                if (trans.length == 1) {
                    stringBuffer.append("\n AND TransactionType.FNUMBER >= '").append(((TransactionTypeInfo)trans[0]).getNumber()).append("'");
                } else {
                    stringBuffer.append("\n AND TransactionType.FNUMBER in (").append(CalculateUtil.getObjArrayNumberWithQuote(trans)).append(")");
                }
            } else {
                stringBuffer.append("\n AND TransactionType.FNUMBER >= '" + ((TransactionTypeInfo)params.getObject("startTransacionType")).getNumber()).append("'");
            }
        }
        if (params.getObject("endTransactionType") != null) {
            stringBuffer.append(" AND TransactionType.FNUMBER <= '" + ((TransactionTypeInfo)params.getObject("endTransactionType")).getNumber()).append("'");
        }
        if (params.getObject("transacionTypeIds") != null) {
            ids = new StringBuffer();
            Set transacionTypeSet = (Set)params.getObject("transacionTypeIds");
            for (String s : transacionTypeSet) {
                ids.append("'").append(s).append("',");
            }
            stringBuffer.append(" AND TransactionType.FID in (").append(ids.substring(0, ids.length() - 1)).append(")");
        }
        if (params.getObject("billStatus") != null) {
            BillBaseStatusEnum billStatus = (BillBaseStatusEnum)params.getObject("billStatus");
            if (billStatus.getValue() != -1) {
                stringBuffer.append("\n AND BILL.fbaseStatus = ").append(billStatus.getValue());
            } else {
                stringBuffer.append("\n AND BILL.fbaseStatus in (1,2,4)");
            }
        }
        if (params.getObject("vouchered") != null) {
            if ("T_IM_SaleIssueBill".equals(headTableName)) {
                if (((VoucheredEnum)((Object)params.getObject("vouchered"))).getValue() == 1) {
                    stringBuffer.append("\n AND (BILL.FFIVOUCHERED = 1 OR BILL.FisWriteOffVouched = 1) ");
                } else if (((VoucheredEnum)((Object)params.getObject("vouchered"))).getValue() == 0) {
                    stringBuffer.append("\n AND (BILL.FFIVOUCHERED = 0 AND BILL.FisWriteOffVouched = 0) ");
                }
            } else if (((VoucheredEnum)((Object)params.getObject("vouchered"))).getValue() == 1) {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 1");
            } else if (((VoucheredEnum)((Object)params.getObject("vouchered"))).getValue() == 0) {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 0");
            }
        }
        stringBuffer.append("\n AND " + this.getPeriodFilter(ctx, params));
        if (params.getBoolean("isOnlyShowNull")) {
            if (!"T_CL_CostAdjustBill".equals(headTableName)) {
                stringBuffer.append("\n  and (");
                stringBuffer.append("\n ( STORETYPE.FID is not null and ENTRY.FAccountViewInId IS NULL )");
                stringBuffer.append("\n  or ( STORETYPEPRE.FID is not null and  ENTRY.FAccountViewOutId IS NULL)) ");
            } else {
                stringBuffer.append("\n  and (");
                stringBuffer.append("\n ( BILL.FISSUETYPE = -1 and ENTRY.FAccountViewInId IS NULL )");
                stringBuffer.append("\n  or ( BILL.FISSUETYPE <> -1 and  ENTRY.FAccountViewOutId IS NULL)) ");
            }
        }
        if (storageSet != null) {
            ids = new StringBuffer();
            for (String s : storageSet) {
                ids.append("'").append(s).append("',");
            }
            stringBuffer.append("\n AND ENTRY.FSTORAGEORGUNITID IN (").append(ids.substring(0, ids.length() - 1)).append(")");
        }
        if (warehouseSet != null) {
            ids = new StringBuffer();
            for (String s : warehouseSet) {
                ids.append("'").append(s).append("',");
            }
            stringBuffer.append("\n AND ENTRY.FWAREHOUSEID IN (").append(ids.substring(0, ids.length() - 1)).append(")");
        }
        if (params.getObject("startBillNumber") != null && !StringUtil.isEmpty((String)params.getString("startBillNumber"))) {
            stringBuffer.append("\n AND BILL.FNUMBER >='").append(params.getString("startBillNumber")).append("'");
        }
        if (params.getObject("endBillNumber") != null && !StringUtil.isEmpty((String)params.getString("endBillNumber"))) {
            stringBuffer.append("\n AND BILL.FNUMBER <='").append(params.getString("endBillNumber")).append("'");
        }
        if (params.getObject("accountViewIds") != null) {
            stringBuffer.append("\n AND (ACCOUNTVIEWIN.fid in(" + params.getObject("accountViewIds") + ")");
            stringBuffer.append("\n OR ACCOUNTVIEWOUT.fid in(" + params.getObject("accountViewIds") + "))");
        }
        return stringBuffer.toString();
    }

    private List<String> getSelectAllBillSQLList(Context ctx, RptParams params) throws BOSException, EASBizException {
        ArrayList<String> allSelectSQLList = new ArrayList<String>(9);
        int count = this.getBillHeadTableName().size();
        for (int i = 0; i < count; ++i) {
            allSelectSQLList.add(this.getShareBillSelectSQL(ctx, this.getBillHeadTableName().get(i), this.getBillEntryTableName().get(i), this.getExtendFields(ctx), false, -1, params));
        }
        return allSelectSQLList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void takeBillData(Context ctx, String tempTable, List<String> sqlList, List<String> lockList) throws BOSException {
        Connection conn = null;
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        int size = sqlList.size();
        try {
            String insertSQL = this.getInsertSql(tempTable);
            StringBuffer sSQL = new StringBuffer();
            conn = EJBFactory.getConnection((Context)ctx);
            for (int i = 0; i < size; ++i) {
                String selectSQL = sqlList.get(i);
                if (StringUtil.isEmpty((String)selectSQL)) continue;
                sSQL.setLength(0);
                sSQL.append(insertSQL).append(LINE).append(selectSQL);
                QueryDataTask thread = new QueryDataTask(lock, lockList.get(i), conn, sSQL.toString());
                lock.addLock(lockList.get(i));
                threadPool.addTask((Runnable)thread);
            }
            lock.waitFinish();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (BOSException bose) {
                    throw bose;
                }
            }
            catch (Throwable throwable) {
                KsqlUtil.cleanup(conn);
                throw throwable;
            }
        }
        KsqlUtil.cleanup((Connection)conn);
    }

    private List<String> getBillQueryLock() {
        ArrayList<String> billQueryLock = new ArrayList<String>();
        billQueryLock.add(0, "SALEISSUE_LOCK");
        billQueryLock.add(1, "MATERIALREQ_LOCK");
        billQueryLock.add(2, "OTHERISSUE_LOCK");
        billQueryLock.add(3, "MOVEISSUE_LOCK");
        billQueryLock.add(4, "PURINWAREHS_LOCK");
        billQueryLock.add(5, "MANUFACTUREREC_LOCK");
        billQueryLock.add(6, "OTHERINWAREHS_LOCK");
        billQueryLock.add(7, "MOVEINWAREHS_LOCK");
        billQueryLock.add(8, "COSTADJ_LOCK");
        return billQueryLock;
    }

    private String getExtendFields(Context ctx) {
        StringBuffer fields = new StringBuffer();
        fields.append(",BILL.FBILLTYPEID AS FBILLTYPEID,BILL.FTRANSACTIONTYPEID AS FTRANSACTIONTYPEID,BILL.FNUMBER AS FBILLNUMBER");
        fields.append("\n ,ENTRY.FUNITID AS FUNITID,ENTRY.FUNITActualCost AS FActualBaseUnitCost ,ENTRY.FActualCost AS FACTCOST");
        fields.append("\n ,ENTRY.FUnitStandardCost AS FUnitStandardCost,ENTRY.FSTANDARDCOST AS FSTANDARDCOST2");
        fields.append("\n ,MATERIAL.FModel AS MODEL");
        fields.append("\n ,MATERIAL.FPricePrecision AS pricePrecsion");
        fields.append("\n ,BILL.FBIZDATE AS FBizDate,MATERIAL.Fnumber AS FMaterialNumber");
        try {
            fields.append("\n,MATERIAL.Fname_").append(CalculateUtil.getLoc(ctx)).append(" AS FmaterialName");
            fields.append("\n,TransactionType.Fname_").append(CalculateUtil.getLoc(ctx)).append(" AS FTransactionTypeName");
            fields.append(", BILL.FID AS FBILLID, ENTRY.FID AS FEntryID ");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return fields.toString();
    }

    private List<String> getBillHeadTableName() {
        ArrayList<String> billHeadTableNameList = new ArrayList<String>();
        billHeadTableNameList.add(0, "T_IM_SaleIssueBill");
        billHeadTableNameList.add(1, "T_IM_MaterialReqBill");
        billHeadTableNameList.add(2, "T_IM_OtherIssueBill");
        billHeadTableNameList.add(3, "T_IM_MoveIssueBill");
        billHeadTableNameList.add(4, "T_IM_PurInWarehsBill");
        billHeadTableNameList.add(5, "T_IM_ManufactureRecBill");
        billHeadTableNameList.add(6, "T_IM_OtherInWarehsBill");
        billHeadTableNameList.add(7, "T_IM_MoveInWarehsBill");
        billHeadTableNameList.add(8, "T_CL_CostAdjustBill");
        return billHeadTableNameList;
    }

    private List<String> getBillEntryTableName() {
        ArrayList<String> billEntryTableNameList = new ArrayList<String>();
        billEntryTableNameList.add(0, "T_IM_SaleIssueEntry");
        billEntryTableNameList.add(1, "T_IM_MaterialReqBillEntry");
        billEntryTableNameList.add(2, "T_IM_OtherIssueBillEntry");
        billEntryTableNameList.add(3, "T_IM_MoveIssueBillEntry");
        billEntryTableNameList.add(4, "T_IM_PurInWarehsEntry");
        billEntryTableNameList.add(5, "T_IM_ManufactureRecBillEntry");
        billEntryTableNameList.add(6, "T_IM_OtherInWarehsBillEntry");
        billEntryTableNameList.add(7, "T_IM_MoveInWarehsBillEntry");
        billEntryTableNameList.add(8, "T_CL_CostAdjustBillEntry");
        return billEntryTableNameList;
    }

    private String getPeriodFilter(Context ctx, RptParams params) throws EASBizException, BOSException {
        int beginYear = params.getInt("startYear");
        int beginPeriod = params.getInt("startPeriod");
        int endYear = params.getInt("endYear");
        int endPeriod = params.getInt("endPeriod");
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        PeriodInfo beginPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)beginYear, (int)beginPeriod, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        PeriodInfo endPeriodInfo = null;
        endPeriodInfo = beginYear == endYear && beginPeriod == endPeriod ? beginPeriodInfo : PeriodUtils.getPeriodInfo((Context)ctx, (int)endYear, (int)endPeriod, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        StringBuffer extendWhere = new StringBuffer();
        extendWhere.append("(BILL.FBizDate >= {ts'").append(IMRptUtils.getFilterBeginDate((Date)beginPeriodInfo.getBeginDate())).append("'}");
        extendWhere.append(" AND BILL.FBizDate <= {ts'").append(IMRptUtils.getFilterEndDate((Date)endPeriodInfo.getEndDate())).append("'})");
        extendWhere.append("\n AND (ENTRY.FBizDate >= {ts'").append(IMRptUtils.getFilterBeginDate((Date)beginPeriodInfo.getBeginDate())).append("'}");
        extendWhere.append(" AND ENTRY.FBizDate <= {ts'").append(IMRptUtils.getFilterEndDate((Date)endPeriodInfo.getEndDate())).append("'})");
        return extendWhere.toString();
    }

    private String getInsertSql(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tempTable);
        sql.append("(FID");
        sql.append(",FBILLTYPENAME");
        sql.append(",FTRANSACTIONNAME");
        sql.append(",FBillNumber");
        sql.append(",FBizDate");
        sql.append(",FFIVOUCHERED");
        sql.append(",FMaterialID");
        sql.append(",FMATERIALNUMBER");
        sql.append(",FMATERIALNAME");
        sql.append(",FMODEL");
        sql.append(",FUnitId");
        sql.append(",FunitName");
        sql.append(",FQty");
        sql.append(",FBaseUnitName");
        sql.append(",FBaseQty");
        sql.append(",FQtyPrecision");
        sql.append(",FBaseQtyPrecision");
        sql.append(",FBILLTYPEID");
        sql.append(",FBILLID");
        sql.append(",FCompanyOrgUnitID ");
        sql.append(",FBaseUnitId ");
        sql.append(",FBillEntryID");
        sql.append(",FStoreTypeID");
        sql.append(",FStoreTypeName");
        sql.append(",FAccountViewInID");
        sql.append(",FAccountViewInName");
        sql.append(",FStoreTypePreID");
        sql.append(",FStoreTypePreName");
        sql.append(",FAccountViewOutID");
        sql.append(",FAccountViewOutName");
        sql.append(",FStorageOrgName");
        sql.append(",FWarehouseName");
        sql.append(")");
        sql.append(LINE);
        return sql.toString();
    }

    @Override
    protected void _updateBill4AcountView(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList paramList = (ArrayList)param.get("ENTRYCOLL");
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.getConnection(ctx);
            statement = conn.createStatement();
            for (int i = 0; i < paramList.size(); ++i) {
                Map map = (Map)paramList.get(i);
                statement.addBatch(this.getUpdateSql(map));
            }
            statement.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    private String getUpdateSql(Map<String, String> map) throws BOSException, EASBizException {
        StringBuilder sb = new StringBuilder();
        String entryId = map.get("entryId");
        String AccountViewInId = map.get("AccountViewInId");
        String AccountViewOutId = map.get("AccountViewOutId");
        String billTypeId = map.get("billTypeId");
        String entryTableName = this.getEntryTableName(billTypeId);
        if (entryTableName == null) {
            return null;
        }
        sb.append("update ").append(entryTableName).append(" Set").append(LINE);
        if (AccountViewInId != null) {
            sb.append(" FAccountViewInId = '").append(AccountViewInId).append("'").append(LINE);
        } else {
            sb.append(" FAccountViewInId = null").append(LINE);
        }
        if (AccountViewOutId != null) {
            sb.append(",FAccountViewOutId = '").append(AccountViewOutId).append("'").append(LINE);
        } else {
            sb.append(",FAccountViewOutId = null").append(LINE);
        }
        sb.append(" where FID = '").append(entryId).append("'").append(LINE);
        return sb.toString();
    }

    private String getEntryTableName(String billTypeID) throws BOSException, EASBizException {
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
            return "T_IM_PurInWarehsEntry";
        }
        if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID)) {
            return "T_IM_ManufactureRecBillEntry";
        }
        if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID)) {
            return "T_IM_MoveInWarehsBillEntry";
        }
        if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
            return "T_IM_OtherInWarehsBillEntry";
        }
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
            return "T_IM_SaleIssueEntry";
        }
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
            return "T_IM_MaterialReqBillEntry";
        }
        if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
            return "T_IM_OtherIssueBillEntry";
        }
        if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID)) {
            return "T_IM_MoveIssueBillEntry";
        }
        if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(billTypeID)) {
            return "T_CL_CostAdjustBillEntry";
        }
        return null;
    }
}

