/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.IJobInstStatusFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.CostComputeRportHeaderFactory;
import com.kingdee.eas.scm.cal.CostComputeRportHeaderInfo;
import com.kingdee.eas.scm.cal.MaterialCalTypeEnum;
import com.kingdee.eas.scm.cal.app.AbstractCalculateFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.calculate.CalculateFactory;
import com.kingdee.eas.scm.cal.app.calculate.ExceptionBillCalculate;
import com.kingdee.eas.scm.cal.app.calculate.ExceptionDataAdjZero;
import com.kingdee.eas.scm.cal.app.calculate.FIFOCalculate;
import com.kingdee.eas.scm.cal.app.calculate.FIFOCalculateNew;
import com.kingdee.eas.scm.cal.app.calculate.InpWarehsSumCalculate;
import com.kingdee.eas.scm.cal.app.calculate.IssueCostAdjustCalculate;
import com.kingdee.eas.scm.cal.app.calculate.MoveAverageReCalculateNew;
import com.kingdee.eas.scm.cal.app.calculate.MoveWeightedAverageReCalculate;
import com.kingdee.eas.scm.cal.app.calculate.MoveingWeightedAverageCalculate;
import com.kingdee.eas.scm.cal.app.calculate.StandardCostDiffCalculate;
import com.kingdee.eas.scm.cal.app.calculate.WeightedAverageCalculateNew;
import com.kingdee.eas.scm.cal.app.calculate.interfaces.ICalculate;
import com.kingdee.eas.scm.cal.app.help.CostAdjustHelp;
import com.kingdee.eas.scm.cal.app.help.InventoryBillHelp;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalculateFacadeControllerBean
extends AbstractCalculateFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CalculateFacadeControllerBean.class);
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.CALAutoGenerateResource";

    @Override
    protected void _calculate(Context ctx, CoreBillBaseInfo calbill) throws BOSException, EASBizException {
        logger.debug((Object)"\u6838\u7b97\u5f00\u59cb");
        CalculateFactory cf = new CalculateFactory();
        ICalculate ic = cf.create(calbill);
        String name = "";
        if (ic != null) {
            name = ic.getClass().getName().replaceAll("com.kingdee.eas.scm.cal.app.", "");
        }
        logger.debug((Object)("\u521b\u5efa\u6838\u7b97\u7b97\u6cd5\u7c7b:" + name));
        logger.debug((Object)("\u5f00\u59cb\u6838\u7b97\u8fd0\u7b97:" + calbill.getNumber()));
        if (ic != null) {
            ic.calculate(ctx, calbill);
        }
        logger.debug((Object)("\u6838\u7b97\u7ed3\u675f:" + calbill.getNumber()));
    }

    @Override
    protected void _calculate(Context ctx, CoreBillBaseInfo calbill, BizActionEnum bizAction) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _apportionDiff(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(ctx, null);
        try {
            boolean success;
            StandardCostDiffCalculate sc = new StandardCostDiffCalculate();
            boolean bl = success = sc.calculateCost(ctx, params, sysTempTableHelper);
            return bl;
        }
        finally {
            sysTempTableHelper.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CalculateParams _updateInpWarehsCost(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(ctx, null);
        try {
            InpWarehsSumCalculate iiwsc = new InpWarehsSumCalculate();
            params.setString("ErrorMsgList", null);
            boolean success = iiwsc.calculateCost(ctx, params, sysTempTableHelper);
            CalculateParams cps = new CalculateParams();
            cps.setBoolean("isSuccess", success);
            cps.setString("ErrorMsgList", params.getString("ErrorMsgList"));
            CalculateParams calculateParams = cps;
            return calculateParams;
        }
        finally {
            sysTempTableHelper.releaseConnection();
        }
    }

    @Override
    protected boolean _isOnlyUseAddAverage(Context ctx, String companyid) throws BOSException, CalculateException {
        return CalculateUtil.isOnlyUseAddAverage(ctx, companyid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CalculateParams _costCalculate(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        logger.info((Object)"--------\u6210\u672c\u6838\u7b97\u5f00\u59cb---------");
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(ctx, null);
        try {
            if (StringUtils.isEmpty((String)params.getString("headerid"))) {
                String parentId = this.writeCostComputePriceSourceRptHeader(ctx, sysTempTableHelper, params);
                params.setString("headerid", parentId);
            }
            this.initParams(ctx, params);
            LowTimer st = new LowTimer();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\u3010\u521d\u59cb\u53c2\u6570,\u82b1\u8d39\u65f6\u95f4  ms\u3011\uff1a" + st.msValue()));
            }
            st.reset();
            if (params.getBoolean("ISSUE_COST_ADJUST")) {
                String temTableName = null;
                params.setString("T_Temp_PeriodCostAdjustAssistTable", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getCostAdjustAssistTableFields()));
                params.setString("T_Temp_PeriodEndCostAdjustAssistTable", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getCostAdjustAssistTableFields()));
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getCostAdjustTableFields());
                sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
                params.setString("T_Temp_CostAdjusTable", temTableName);
                IssueCostAdjustCalculate isa = new IssueCostAdjustCalculate();
                isa.calculateCost(ctx, params, sysTempTableHelper);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("\u3010\u51fa\u5e93\u6210\u672c\u8c03\u6574,\u82b1\u8d39\u65f6\u95f4  ms\u3011\uff1a" + st.msValue()));
                }
                st.reset();
                CalculateParams cps = new CalculateParams();
                cps.setBoolean("boolean", true);
                CalculateParams calculateParams = cps;
                return calculateParams;
            }
            if ((PeriodInfo)params.getObject("PERIOD_OBJ") != null && params.getString("COMPANY_ID") != null) {
                CostAdjustHelp.deleteCostAdjustBill(ctx, params, CostAdjuestCreateTypeEnum.ExcepAdjZero, sysTempTableHelper);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("\u3010\u5220\u9664\u6210\u672c\u8c03\u6574\u5355,\u82b1\u8d39\u65f6\u95f4  ms\u3011\uff1a" + st.msValue()));
                }
                st.reset();
            }
            if (params.getBoolean("ExceptionDataAdjZero")) {
                this.handleExpDataAdjZero(ctx, params, sysTempTableHelper);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("\u3010\u5904\u7406\u5f02\u5e38\u6570\u636e\u8c030,\u82b1\u8d39\u65f6\u95f4  ms\u3011\uff1a" + st.msValue()));
                }
                st.reset();
                CalculateParams cps = new CalculateParams();
                cps.setBoolean("boolean", true);
                CalculateParams isa = cps;
                return isa;
            }
            String costCalculate = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"costCalculate", (Context)ctx);
            IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"costCalculate", (BOSObjectType)this.getBOSType(), null, (String)"", (String)"calculate", (String)params.getString("COMPANY_ID"), (String)costCalculate);
            CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
            try {
                companyOrgUnitInfo.setId(BOSUuid.read((String)params.getString("COMPANY_ID")));
                if (companyOrgUnitInfo == null || companyOrgUnitInfo.getId() == null) {
                    throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
                }
            }
            catch (Exception e) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            params.setInt("Local_Currency_Presision", CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo));
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            params.setObject("PERIOD_OBJ", (Object)periodInfo);
            this.createCostCalculteTmpTable(ctx, params, sysTempTableHelper);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\u3010\u521b\u5efa\u6210\u672c\u8ba1\u7b97\u6240\u9700\u8981\u7684\u4e34\u65f6\u8868,\u82b1\u8d39\u65f6\u95f4  ms\u3011\uff1a" + st.msValue()));
            }
            st.reset();
            CalculateParams cps = this.costSubCalculate(ctx, params, sysTempTableHelper);
            st.reset();
            String[] calculateTables = InventoryBillHelp.getCalculateTables();
            for (int i = 0; i < calculateTables.length; ++i) {
                if (null == params.getString(calculateTables[i])) continue;
                if (params.getBoolean("IsReleaseTmpTable")) {
                    sysTempTableHelper.releaseTempTable(params.getString(calculateTables[i]));
                    continue;
                }
                sysTempTableHelper.execute("TRUNCATE TABLE " + params.getString(calculateTables[i]));
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\u3010\u91ca\u653e\u6216\u8005\u6e05\u7a7a\u4e34\u65f6\u8868,\u4e00\u5171\u82b1\u8d39\u65f6\u95f4  ms\u3011\uff1a" + st.msValue()));
            }
            st.reset();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\u3010\u91ca\u653e\u6570\u636e\u5e93\u8fde\u63a5,\u82b1\u8d39\u65f6\u95f4  ms\u3011\uff1a" + st.msValue()));
            }
            st.reset();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"--------\u6210\u672c\u6838\u7b97\u7ed3\u675f----------");
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
            params.setString("headerid", null);
            CalculateParams calculateParams = cps;
            return calculateParams;
        }
        finally {
            sysTempTableHelper.releaseConnection();
        }
    }

    private String writeCostComputePriceSourceRptHeader(Context ctx, SysTempTableHelper sysTempTableHelper, CalculateParams params) throws BOSException, EASBizException {
        CostComputeRportHeaderInfo info = new CostComputeRportHeaderInfo();
        String companyID = params.getString("COMPANY_ID");
        PeriodInfo curPeriod = (PeriodInfo)params.getObject("PERIOD_OBJ");
        int accountType = params.getInt("ACCOUNT_TYPE");
        String calType = params.getString("CALTYPE");
        HashSet storageOrgUnitNameSet = (HashSet)params.getObject("STORAGEORGUNITID");
        HashSet warehouseNameSet = (HashSet)params.getObject("WAREHOUSEID");
        String materialNumFrom = params.getString("MATERIAL_FROM");
        String materialNumTo = params.getString("MATERIAL_TO");
        String startTime = params.getString("startTime");
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)companyID));
        if (curPeriod == null) {
            curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        }
        info.setCompany(companyInfo);
        info.setPeriod(curPeriod);
        info.setAccountType(AccountType.getEnum((int)accountType));
        info.setMatCalType(MaterialCalTypeEnum.getEnum(calType));
        StringBuffer storageUnitNameSb = new StringBuffer();
        if (storageOrgUnitNameSet != null) {
            for (StorageOrgUnitInfo storageOrgUnitName : storageOrgUnitNameSet) {
                storageUnitNameSb.append(storageOrgUnitName.getName()).append(";");
            }
            String storageUnitNames = "";
            storageUnitNames = storageUnitNameSb.length() > 255 ? storageUnitNameSb.substring(0, 254) : storageUnitNameSb.toString();
            info.setStorageOrgNames(storageUnitNames);
        }
        StringBuffer warehouseNameSb = new StringBuffer();
        if (warehouseNameSet != null) {
            for (WarehouseInfo warehouseName : warehouseNameSet) {
                warehouseNameSb.append(warehouseName.getName()).append(";");
            }
            String warehouseNames = "";
            warehouseNames = warehouseNameSb.length() > 255 ? warehouseNameSb.substring(0, 254) : warehouseNameSb.toString();
            info.setWarehouseNames(warehouseNames);
        }
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)materialNumFrom)) {
            info.setMaterialNumberFrom(materialNumFrom);
        }
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)materialNumTo)) {
            info.setMaterialNumberTo(materialNumTo);
        }
        Timestamp time = new Timestamp(new Date().getTime());
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)startTime)) {
            time = Timestamp.valueOf(startTime);
        }
        info.setStartTime(time);
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(fcount)  maxCount from T_CL_CostComputeRportHeader ");
        sql.append(" where FCompanyID = '");
        sql.append(companyID).append("'");
        sql.append(" and FPeriodID = '");
        sql.append(curPeriod.getId().toString()).append("'");
        IRowSet rs = sysTempTableHelper.executeQuery(sql.toString());
        int count = 1;
        try {
            if (rs.next()) {
                count = rs.getInt("maxCount") + 1;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        info.setCount(count);
        IObjectPK pk = CostComputeRportHeaderFactory.getLocalInstance(ctx).addnew(info);
        return pk.toString();
    }

    protected int _getCurrentTaskNum(Context ctx, CalculateParams params) throws BOSException {
        int currentTaskNum = 0;
        String taskID = params.getString("taskID");
        if (taskID != null) {
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)this.getMaxTaskInfoSql(params));
            try {
                if (rowSet.next()) {
                    currentTaskNum = rowSet.getInt("currentTaskNum");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return currentTaskNum;
    }

    private String getMaxTaskInfoSql(CalculateParams params) {
        String taskID = params.getString("taskID");
        String progressTable = params.getString("t_cl_progressTableName");
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT maxTaskNum,currentTaskNum FROM " + progressTable);
        buffer.append("\n WHERE FID = '" + taskID + "'");
        return buffer.toString();
    }

    @Override
    protected int _getLastCalculateKind(Context ctx, String companyOrgUnitID, int calculKind) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer();
        int calcuakind = -1;
        buffer.append("SELECT CALCULKIND FROM  T_CL_DEFUALTCALKIND WHERE COMPANYUNITORGID ='" + companyOrgUnitID + "'");
        Object defaultCalculate = DBUtil.takeValue(ctx, buffer.toString());
        if (defaultCalculate != null) {
            calcuakind = defaultCalculate instanceof BigDecimal ? ((BigDecimal)defaultCalculate).intValue() : ((Integer)defaultCalculate).intValue();
        } else {
            buffer.setLength(0);
            buffer.append("INSERT INTO T_CL_DEFUALTCALKIND(COMPANYUNITORGID,CALCULKIND)");
            buffer.append("VALUES(?,?)");
            Object[] params = new Object[]{companyOrgUnitID, new Integer(3)};
            DBUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])params);
        }
        return calcuakind;
    }

    @Override
    protected void _updateLastCalculateKind(Context ctx, String companyOrgUnitid, int calculKind) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE T_CL_DEFUALTCALKIND SET  CALCULKIND =? WHERE COMPANYUNITORGID =?");
        Object[] params = new Object[]{new Integer(calculKind), companyOrgUnitid};
        DBUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])params);
    }

    private void handleExpDataAdjZero(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws EASBizException, BOSException {
        if (params != null) {
            new ExceptionDataAdjZero().handleExpDataAdjZero(ctx, params, sysTempTableHelper);
        }
    }

    private void initParams(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        String strCalType;
        String companyOrgID = params.getString("COMPANY_ID");
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        try {
            companyOrgUnitInfo.setId(BOSUuid.read((String)params.getString("COMPANY_ID")));
            if (companyOrgUnitInfo == null || companyOrgUnitInfo.getId() == null) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        int presision = 2;
        try {
            presision = params.getInt("Local_Currency_Presision");
            if (presision < 0) {
                presision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo);
            }
        }
        catch (Exception e) {
            presision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo);
        }
        PeriodInfo periodInfo = null;
        if (params.getObject("PERIOD_OBJ") == null) {
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            if (periodInfo == null) {
                companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId().toString()));
                throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(companyOrgUnitInfo.getName(), companyOrgUnitInfo.getNumber())});
            }
        } else {
            periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        }
        if ((strCalType = params.getString("CALTYPE")) == null) {
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            strCalType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyOrgID), "SCM_CAL_002");
        }
        params.setObject("COMPANY_OBJ", (Object)companyOrgUnitInfo);
        params.setInt("Local_Currency_Presision", presision);
        params.setObject("PERIOD_OBJ", (Object)periodInfo);
        params.setString("CALTYPE", strCalType);
    }

    private void createCostCalculteTmpTable(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws BOSException {
        if (!params.getBoolean("IsOtherInvkCostCalculate")) {
            params.setBoolean("IsCreateTmpTable", true);
            params.setBoolean("IsReleaseTmpTable", true);
        }
        if (!params.getBoolean("IsCreateTmpTable")) {
            return;
        }
        String temTableName = null;
        String[] calculateTables = InventoryBillHelp.getCalculateTables();
        for (int i = 0; i < calculateTables.length; ++i) {
            if ("T_Temp_WeightedAverageMaterialList".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getWeightedTableFields());
                sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
                params.setString("T_Temp_WeightedAverageMaterialList", temTableName);
                sysTempTableHelper.createTempTableIndex(temTableName, "FMaterialID,FCompanyOrgUnitID", false, false);
            }
            if ("T_Temp_FIFOBills".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getFIFOTableFields());
                sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
                params.setString("T_Temp_FIFOBills", temTableName);
                sysTempTableHelper.createTempTableIndex(temTableName, "FENTRYTABLEMAME,FFIVOUCHERED", false, false);
                sysTempTableHelper.createTempTableIndex(temTableName, "FBillEntryId,FBillId,FSOURCEBILLENTRYID", false, false);
                sysTempTableHelper.createTempTableIndex(temTableName, "FMaterialID,FCompanyOrgUnitID", false, false);
            }
            if ("T_Temp_MiddleFIFOBills".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getMiddleFIFOTableFields());
                sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
                params.setString("T_Temp_MiddleFIFOBills", temTableName);
                sysTempTableHelper.createTempTableIndex(temTableName, "FMaterialID,FBaseUnit", false, false);
            }
            if ("T_Temp_FIFOMaterialListNew".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getFIFOMaterialTableFieldsNew());
                params.setString("T_Temp_FIFOMaterialListNew", temTableName);
                sysTempTableHelper.createTempTableIndex(temTableName, "KSQL_SEQ", false, false);
            }
            if ("T_Temp_FIFOMaterialList".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getFIFOMaterialTableFields());
                params.setString("T_Temp_FIFOMaterialList", temTableName);
            }
            if ("T_Temp_ReverseBills".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getReverseBillsTableFields());
                params.setString("T_Temp_ReverseBills", temTableName);
                sysTempTableHelper.createTempTableIndex(temTableName, "FSourceBillEntryId,FSourceBillId", false, false);
            }
            if ("T_Temp_FullReverseBills".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getFullReverseBillsTableFields());
                params.setString("T_Temp_FullReverseBills", temTableName);
                sysTempTableHelper.createTempTableIndex(temTableName, "fbillentryid,fbillid", false, false);
            }
            if ("T_Temp_FullReverseMaxTimeBills".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getFullReverseMaxTimeBillsTableFields());
                params.setString("T_Temp_FullReverseMaxTimeBills", temTableName);
                sysTempTableHelper.createTempTableIndex(temTableName, "fsourcebillentryid,fsourcebillid", false, false);
            }
            if ("T_Temp_FullReverseMaxIdBills".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getFullReverseMaxIdBillsTableFields());
                params.setString("T_Temp_FullReverseMaxIdBills", temTableName);
                sysTempTableHelper.createTempTableIndex(temTableName, "fentryid", false, false);
                sysTempTableHelper.createTempTableIndex(temTableName, "fsourcebillentryid,fsourcebillid", false, false);
            }
            if ("T_Temp_CostStockTranMaxTimeBills".equals(calculateTables[i])) {
                params.setString("T_Temp_CostStockTranMaxTimeBills", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getCostStockTranMaxTimeBillsTableFields()));
                sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_CostStockTranMaxTimeBills"), "FStockTransBillEntryID,FStockTransferBillID", false, false);
            }
            if ("T_Temp_CostStockTranMaxIdBills".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getCostStockTranMaxIDBillsTableFields());
                sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
                params.setString("T_Temp_CostStockTranMaxIdBills", temTableName);
            }
            if ("T_Temp_TotalCostStockTranOutBills".equals(calculateTables[i])) {
                params.setString("T_Temp_TotalCostStockTranOutBills", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getTotalCostStockTranOutWarehsTableFields()));
                sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_TotalCostStockTranOutBills"), "FStockTransBillEntryID,FStockTransferBillID", false, false);
            }
            if ("T_Temp_TotalCostStockTranInpBills".equals(calculateTables[i])) {
                params.setString("T_Temp_TotalCostStockTranInpBills", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getTotalCostStockTranInpWarehsTableFields()));
                sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_TotalCostStockTranInpBills"), "FStockTransBillEntryID,FStockTransferBillID", false, false);
            }
            if ("T_Temp_MoveWeightedAverageMaterialList".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getMoveWeightedTableFields());
                params.setString("T_Temp_MoveWeightedAverageMaterialList", temTableName);
            }
            if ("T_Temp_WeightedAverageGroupbyList".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getWeightedAssistTableFields());
                sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
                params.setString("T_Temp_WeightedAverageGroupbyList", temTableName);
            }
            if ("T_Temp_MaterialAssistTable".equals(calculateTables[i])) {
                params.setString("T_Temp_MaterialAssistTable", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getMaterialAssistTableFields()));
                sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_MaterialAssistTable"), "FMaterialID,FCompanyOrgUnitID", false, false);
            }
            if ("T_Temp_MaterialAssistTable2".equals(calculateTables[i])) {
                params.setString("T_Temp_MaterialAssistTable2", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getMaterialAssistTableFields2()));
                sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_MaterialAssistTable2"), "FMaterialID,FCompanyOrgUnitID", false, false);
            }
            if ("T_Temp_ASSISTTABLE".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getAssistTableFields());
                sysTempTableHelper.createTempTableIndex(temTableName, "FID", false, false);
                params.setString("T_Temp_ASSISTTABLE", temTableName);
            }
            if ("T_Temp_WriteOffTable".equals(calculateTables[i])) {
                temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getWriteOffTableFields());
                sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
                params.setString("T_Temp_WriteOffTable", temTableName);
                sysTempTableHelper.createTempTableIndex(temTableName, "FBillEntryID,FBillID", false, false);
            }
            if ("T_Temp_ENTRYINFO".equals(calculateTables[i])) {
                params.setString("T_Temp_ENTRYINFO", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getEntryInfoTableFields()));
                sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_ENTRYINFO"), "FParentID", false, false);
            }
            if ("T_Temp_ReturnBillAssistTableField".equals(calculateTables[i])) {
                params.setString("T_Temp_ReturnBillAssistTableField", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getReturnBillAssistTableFields()));
                sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_ReturnBillAssistTableField"), "FMaterialID,FCompanyOrgUnitID", false, false);
                sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_ReturnBillAssistTableField"), "FEntryId", true, false);
            }
            if ("T_Temp_StockTransBillEntryID".equals(calculateTables[i])) {
                params.setString("T_Temp_StockTransBillEntryID", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getStockTransEntryID()));
            }
            logger.debug((Object)("\u521b\u5efa\u4e34\u65f6\u8868: " + calculateTables[i]));
        }
    }

    private CalculateParams costSubCalculate(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws EASBizException, BOSException {
        boolean isCostCalAllAcctType = params.getBoolean("IsCostAllAccountType");
        if (isCostCalAllAcctType) {
            int progress = 5;
            String jobId = (String)ctx.remove((Object)"SCM_JOB_INST_ID");
            IJobInstStatusFacade iJobInstStatusFacade = JobInstStatusFacadeFactory.getLocalInstance((Context)ctx);
            ArrayList accoutYpes = params.getObject("accountTypeList") != null ? (ArrayList)params.getObject("accountTypeList") : this.getCurrentAccountTypes(ctx, params, sysTempTableHelper);
            for (int i = 0; i < accoutYpes.size(); ++i) {
                String[] progressDetail;
                int acctp = (Integer)accoutYpes.get(i);
                if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)jobId) && null != (progressDetail = this.getProgressDetailByAccounType(ctx, acctp)) && progressDetail.length == 3) {
                    iJobInstStatusFacade.updateProgress(jobId, progress, progressDetail[0], progressDetail[1], progressDetail[2]);
                    progress += 25;
                }
                if (3 == acctp) {
                    params.setInt("ACCOUNT_TYPE", 3);
                    this.weightAvgeCalcalate(ctx, params, sysTempTableHelper);
                    this.clearTmpTableData(ctx, params, sysTempTableHelper);
                    continue;
                }
                if (5 == acctp) {
                    params.setInt("ACCOUNT_TYPE", 5);
                    this.weightAvgeCalcalate(ctx, params, sysTempTableHelper);
                    this.clearTmpTableData(ctx, params, sysTempTableHelper);
                    continue;
                }
                if (4 == acctp) {
                    params.setInt("ACCOUNT_TYPE", 4);
                    this.fifoCostCalcualte(ctx, params, sysTempTableHelper);
                    this.clearTmpTableData(ctx, params, sysTempTableHelper);
                    continue;
                }
                if (2 == acctp) {
                    params.setInt("ACCOUNT_TYPE", 2);
                    this.standCostCalculate(ctx, params, sysTempTableHelper);
                    this.clearTmpTableData(ctx, params, sysTempTableHelper);
                    continue;
                }
                if (6 != acctp) continue;
                params.setInt("ACCOUNT_TYPE", 6);
                this.moveingWeightAvgeCalcalate(ctx, params, sysTempTableHelper);
                this.clearTmpTableData(ctx, params, sysTempTableHelper);
            }
        } else if (2 == params.getInt("ACCOUNT_TYPE")) {
            this.standCostCalculate(ctx, params, sysTempTableHelper);
        } else if (1 == params.getInt("ACCOUNT_TYPE")) {
            if (params.getBoolean("ISMOVEAVGRECALCUALTEBILLCOST")) {
                this.moveAddAvageRelCostCalculate(ctx, params, sysTempTableHelper);
            } else {
                this.moveAddAvageReCalculate(ctx, params, sysTempTableHelper);
            }
        } else if (3 == params.getInt("ACCOUNT_TYPE") || 5 == params.getInt("ACCOUNT_TYPE")) {
            this.weightAvgeCalcalate(ctx, params, sysTempTableHelper);
        } else if (4 == params.getInt("ACCOUNT_TYPE")) {
            this.fifoCostCalcualte(ctx, params, sysTempTableHelper);
        } else if (6 == params.getInt("ACCOUNT_TYPE")) {
            this.moveingWeightAvgeCalcalate(ctx, params, sysTempTableHelper);
        }
        CalculateParams resultParam = new CalculateParams();
        resultParam.setBoolean("boolean", true);
        return resultParam;
    }

    private String[] getProgressDetailByAccounType(Context ctx, int accountType) {
        Locale l2 = LocaleUtils.locale_l2;
        Locale l3 = LocaleUtils.locale_l3;
        if (3 == accountType) {
            return new String[]{"", ResourceBase.getString((String)RESOURCE, (String)"242_CostCalculating_ADD_AVERAGE", (Locale)l2), ResourceBase.getString((String)RESOURCE, (String)"242_CostCalculating_ADD_AVERAGE", (Locale)l3)};
        }
        if (5 == accountType) {
            return new String[]{"", ResourceBase.getString((String)RESOURCE, (String)"243_CostCalculating_SPECIAL_ACCT", (Locale)l2), ResourceBase.getString((String)RESOURCE, (String)"243_CostCalculating_SPECIAL_ACCT", (Locale)l3)};
        }
        if (4 == accountType) {
            return new String[]{"", ResourceBase.getString((String)RESOURCE, (String)"244_CostCalculating_FIN_FOUT", (Locale)l2), ResourceBase.getString((String)RESOURCE, (String)"244_CostCalculating_FIN_FOUT", (Locale)l3)};
        }
        if (2 == accountType) {
            return new String[]{"", ResourceBase.getString((String)RESOURCE, (String)"245_CostCalculating_STANDARDCOST", (Locale)l2), ResourceBase.getString((String)RESOURCE, (String)"245_CostCalculating_STANDARDCOST", (Locale)l3)};
        }
        return null;
    }

    private void standCostCalculate(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws EASBizException, BOSException {
        StandardCostDiffCalculate sc = new StandardCostDiffCalculate();
        sc.calculateCost(ctx, params, sysTempTableHelper);
    }

    private void moveAddAvageReCalculate(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws EASBizException, BOSException {
        logger.info((Object)("---------\u5b9e\u65f6\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6838\u7b97\u5f00\u59cb:" + MoveWeightedAverageReCalculate.class.getName()));
        LowTimer t = new LowTimer();
        MoveWeightedAverageReCalculate ical = new MoveWeightedAverageReCalculate();
        try {
            ical.calculateCost(ctx, (CalculateParams)params.clone(), sysTempTableHelper);
            logger.info((Object)("---------\u5b9e\u65f6\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6838\u7b97\u7ed3\u675f\u5171\u7528\u65f6(ms): " + t.msValue()));
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void weightAvgeCalcalate(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws EASBizException, BOSException {
        logger.info((Object)("---------\u52a0\u6743\u5e73\u5747\uff0c\u4e2a\u522b\u8ba1\u4ef7\u6cd5\u6838\u7b97\u5f00\u59cb:" + WeightedAverageCalculateNew.class.getName()));
        LowTimer t = new LowTimer();
        try {
            WeightedAverageCalculateNew ical = new WeightedAverageCalculateNew();
            ical.calculateCost(ctx, (CalculateParams)params.clone(), sysTempTableHelper);
            logger.info((Object)("---------\u52a0\u6743\u5e73\u5747\uff0c\u4e2a\u522b\u8ba1\u4ef7\u6cd5\u6838\u7b97\u7ed3\u675f\u5171\u7528\u65f6(ms): " + t.msValue()));
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void fifoCostCalcualte(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws EASBizException, BOSException {
        logger.info((Object)("---------\u5148\u8fdb\u5148\u51fa\u6838\u7b97\u5f00\u59cb:" + FIFOCalculate.class.getName()));
        LowTimer t = new LowTimer();
        try {
            FIFOCalculateNew ical = new FIFOCalculateNew();
            ical.calculateCost(ctx, (CalculateParams)params.clone(), sysTempTableHelper);
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("---------\u5148\u8fdb\u5148\u51fa\u6838\u7b97\u7ed3\u675f\u5171\u7528\u65f6(ms): " + t.msValue()));
    }

    private void clearTmpTableData(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws EASBizException, BOSException {
        String[] calculateTables = InventoryBillHelp.getCalculateTables();
        for (int i = 0; i < calculateTables.length; ++i) {
            if (null != params.getString(calculateTables[i])) {
                sysTempTableHelper.execute("TRUNCATE TABLE " + params.getString(calculateTables[i]));
            }
            logger.debug((Object)("\u91ca\u653e\u6216\u8005\u6e05\u7a7a\u4e34\u65f6\u8868: " + calculateTables[i]));
        }
    }

    private ArrayList getCurrentAccountTypes(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tmpTable = params.getString("ThirdPartyMaterialTableName");
        sql.append("SELECT  distinct FACCOUNTTYPE FROM T_BD_MATERIALCOMPANYINFO T1 INNER JOIN ").append(tmpTable).append(" as tmp");
        sql.append("\n ON T1.FMATERIALID = TMP.FMATERIALID");
        sql.append("\n WHERE T1.FCOMPANYID='").append(params.getString("COMPANY_ID")).append("'");
        IRowSet row = sysTempTableHelper.executeQuery(sql.toString());
        ArrayList<Integer> arr = new ArrayList<Integer>();
        try {
            while (row.next()) {
                arr.add(new Integer(row.getInt("FACCOUNTTYPE")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return arr;
    }

    private void moveAddAvageRelCostCalculate(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws EASBizException, BOSException {
        logger.info((Object)("---------\u5b9e\u65f6\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6838\u7b97\u7ed3\u675f\u5f00\u59cb:" + MoveWeightedAverageReCalculate.class.getName()));
        LowTimer t = new LowTimer();
        MoveAverageReCalculateNew ical = new MoveAverageReCalculateNew();
        try {
            ical.calculateCost(ctx, (CalculateParams)params.clone(), sysTempTableHelper);
            logger.info((Object)("---------\u5b9e\u65f6\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6838\u7b97\u7ed3\u675f\u5171\u7528\u65f6(ms): " + t.msValue()));
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void moveingWeightAvgeCalcalate(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws EASBizException, BOSException {
        logger.info((Object)("---------\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6838\u7b97\u7ed3\u675f\u5f00\u59cb:" + MoveingWeightedAverageCalculate.class.getName()));
        LowTimer t = new LowTimer();
        MoveingWeightedAverageCalculate ical = new MoveingWeightedAverageCalculate();
        try {
            ical.calculateCost(ctx, (CalculateParams)params.clone(), sysTempTableHelper);
            logger.info((Object)("---------\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6838\u7b97\u7ed3\u675f\u5171\u7528\u65f6(ms): " + t.msValue()));
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CalculateParams _expDataAdjZero(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        logger.info((Object)"--------\u5f02\u5e38\u6570\u636e\u8c030---------");
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(ctx, null);
        try {
            this.initParams(ctx, params);
            if ((PeriodInfo)params.getObject("PERIOD_OBJ") != null && params.getString("COMPANY_ID") != null) {
                CostAdjustHelp.isExistExpAdjZeroCostAdjBill(ctx, params, CostAdjuestCreateTypeEnum.ExcepAdjZero, sysTempTableHelper);
                CostAdjustHelp.deleteCostAdjustBill(ctx, params, CostAdjuestCreateTypeEnum.ExcepAdjZero, sysTempTableHelper);
            }
            this.handleExpDataAdjZero(ctx, params, sysTempTableHelper);
            CalculateParams cps = new CalculateParams();
            cps.setBoolean("boolean", true);
            CalculateParams calculateParams = cps;
            return calculateParams;
        }
        finally {
            sysTempTableHelper.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CalculateParams _outInvAdjust(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(ctx, null);
        try {
            this.initParams(ctx, params);
            params.setString("T_Temp_PeriodCostAdjustAssistTable", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getCostAdjustAssistTableFields()));
            params.setString("T_Temp_PeriodEndCostAdjustAssistTable", sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getCostAdjustAssistTableFields()));
            String temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getCostAdjustTableFields());
            sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
            params.setString("T_Temp_CostAdjusTable", temTableName);
            IssueCostAdjustCalculate isa = new IssueCostAdjustCalculate();
            isa.calculateCost(ctx, params, sysTempTableHelper);
            CalculateParams cps = new CalculateParams();
            cps.setBoolean("boolean", true);
            CalculateParams calculateParams = cps;
            return calculateParams;
        }
        finally {
            sysTempTableHelper.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CalculateParams _updateExceptionBillCost(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(ctx, null);
        try {
            ExceptionBillCalculate iiwsc = new ExceptionBillCalculate();
            params.setString("ErrorMsgList", null);
            boolean success = iiwsc.calculateCost(ctx, params, sysTempTableHelper);
            CalculateParams cps = new CalculateParams();
            cps.setBoolean("isSuccess", success);
            cps.setString("ErrorMsgList", params.getString("ErrorMsgList"));
            CalculateParams calculateParams = cps;
            return calculateParams;
        }
        finally {
            sysTempTableHelper.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _autoCalculate(Context ctx, String companyNumber, String storageNumber, String warehouseNumber, String materialFromNumber, String materialToNumber, String checkItems, int accountType, int costAdjustType, String isMaterialOrProduct, String userNumber) throws BOSException, EASBizException {
        FilterInfo filter;
        FilterItemInfo filteritem;
        EntityViewInfo view;
        HashSet<StorageOrgUnitInfo> storageOrgSet = new HashSet<StorageOrgUnitInfo>();
        HashSet<WarehouseInfo> warehousSet = new HashSet<WarehouseInfo>();
        UserInfo user = new UserInfo();
        Object[] warehouseNumbers = null;
        Object[] storageNumbers = null;
        CalculateParams params = new CalculateParams();
        String[] checks = checkItems.split(";");
        boolean isCheckUnAuditBill = checks[0].equals("1");
        boolean isCheckprice0AuditInBill = checks[1].equals("1");
        boolean writeCostRpt = checks[2].equals("1");
        boolean writeOnlyErrCostRpt = checks[3].equals("1");
        boolean ismaterialCal = isMaterialOrProduct.equals("0");
        MaterialInfo materialFrom = null;
        MaterialInfo materialTo = null;
        CompanyOrgUnitInfo companyInfo = null;
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)storageNumber)) {
            storageNumbers = storageNumber.split(";");
            HashSet storageNumberSet = new HashSet(Arrays.asList((Object[])storageNumbers));
            view = new EntityViewInfo();
            filteritem = new FilterItemInfo("number", storageNumberSet, CompareType.INCLUDE);
            filter = new FilterInfo();
            filter.getFilterItems().add(filteritem);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setFilter(filter);
            StorageOrgUnitCollection storages = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
            for (int i = 0; i < storages.size(); ++i) {
                storageOrgSet.add(storages.get(i));
            }
        }
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)warehouseNumber)) {
            warehouseNumbers = warehouseNumber.split(";");
            HashSet warehouseNumberSet = new HashSet(Arrays.asList((Object[])warehouseNumbers));
            view = new EntityViewInfo();
            filteritem = new FilterItemInfo("number", warehouseNumberSet, CompareType.INCLUDE);
            filter = new FilterInfo();
            filter.getFilterItems().add(filteritem);
            view.setFilter(filter);
            WarehouseCollection warehouses = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(view);
            for (int i = 0; i < warehouses.size(); ++i) {
                warehousSet.add(warehouses.get(i));
            }
        }
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)companyNumber)) {
            throw new BOSException(CalculateUtil.getCalServerResource(ctx, "SELECTCOMPANY"));
        }
        EntityViewInfo view2 = new EntityViewInfo();
        FilterItemInfo filteritem2 = new FilterItemInfo("number", (Object)companyNumber, CompareType.EQUALS);
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(filteritem2);
        view2.setFilter(filter2);
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view2).get(0);
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)materialFromNumber)) {
            view2 = new EntityViewInfo();
            filteritem2 = new FilterItemInfo("number", (Object)materialFromNumber, CompareType.EQUALS);
            filter2 = new FilterInfo();
            filter2.getFilterItems().add(filteritem2);
            view2.setFilter(filter2);
            materialFrom = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view2).get(0);
        }
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)materialToNumber)) {
            view2 = new EntityViewInfo();
            filteritem2 = new FilterItemInfo("number", (Object)materialToNumber, CompareType.EQUALS);
            filter2 = new FilterInfo();
            filter2.getFilterItems().add(filteritem2);
            view2.setFilter(filter2);
            materialTo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view2).get(0);
        }
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)userNumber)) {
            return;
        }
        view2 = new EntityViewInfo();
        filteritem2 = new FilterItemInfo("number", (Object)userNumber, CompareType.EQUALS);
        filter2 = new FilterInfo();
        filter2.getFilterItems().add(filteritem2);
        view2.setFilter(filter2);
        user = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view2).get(0);
        params.setBoolean("isPerf", true);
        params.setBoolean("ISWRITECOSTCOMPUTEREPORT", writeCostRpt);
        params.setBoolean("ISWRITEDEXPCOSTRPT", writeOnlyErrCostRpt);
        params.setInt("COST_ADJUST_ISSUE_TYPE", costAdjustType);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String calType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), "SCM_CAL_002");
        params.setString("CALTYPE", calType);
        params.setString("COMPANY_ID", companyInfo.getId().toString());
        params.setInt("ACCOUNT_TYPE", accountType);
        params.setString("COMPANY_NAME", companyInfo.getName());
        params.setString("COMPANY_NUMBER", companyNumber);
        params.setObject("STORAGEORGUNIT_NUMBER", (Object)storageNumbers);
        params.setObject("WAREHOUSE_NUMBER", (Object)warehouseNumbers);
        params.setObject("STORAGEORGUNITID", storageOrgSet);
        params.setObject("WAREHOUSEID", warehousSet);
        params.setString("MATERIAL_FROM", materialFrom == null ? null : materialFrom.getNumber());
        params.setString("MATERIAL_TO", materialTo == null ? null : materialTo.getNumber());
        params.setInt("CALCULATE_CREATE_ITEM", 0);
        PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        params.setObject("PERIOD_OBJ", (Object)curPeriodInfo);
        params.setString("taskID", String.valueOf(System.currentTimeMillis()));
        params.setString("t_cl_progressTableName", "t_cl_progress");
        if (ismaterialCal) {
            params.setString("title", "(" + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"materialCal", (Context)ctx) + ")");
            params.setString("OprtState", "rawMaterailCostCal");
            params.setString("CALCULATEMATERIALRANGE", "rawMaterailCostCal");
        } else {
            params.setString("title", "(" + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"materialCal2", (Context)ctx) + ")");
            params.setString("OprtState", "fishedGoodsCostCal");
            params.setString("CALCULATEMATERIALRANGE", "fishedGoodsCostCal");
        }
        params.setObject("CURRENT_USER", (Object)user);
        params.setObject("CURRENT_COMPANY", (Object)companyInfo);
        params.setObject("CURRENT_CU", (Object)companyInfo.getCU());
        params.setObject("languageLocale", (Object)ctx.getLocale());
        params.setBoolean("isCheckBillIsAudited", isCheckUnAuditBill);
        params.setBoolean("isCheckPriceIsZero", isCheckprice0AuditInBill);
        JobConfig jobCfg = this.createJobCfg(params);
        HashMap<String, Object> con = new HashMap<String, Object>();
        con.put("CalculateParams", params);
        con.put("isCheckBillIsAudited", isCheckUnAuditBill);
        con.put("isCheckPriceIsZero", isCheckprice0AuditInBill);
        String notCalculate = params.getString("COMPANY_NUMBER") + "SCM_CAL_0002";
        con.put("CloseMutexCalculate", notCalculate);
        con.put("CALCULATE_ROWMATEIAL_WAITE", jobCfg.getTaskType());
        Map rs = CostCalculateFacadeFactory.getLocalInstance(ctx).fetchData(con);
        if (((Boolean)rs.get("CloseMutexCalculate")).booleanValue()) {
            throw new BOSException(CalculateUtil.getCalServerResource(ctx, "CloseMutexCalculate_Msg"));
        }
        if (((Boolean)rs.get("CALCULATE_ROWMATEIAL_WAITE")).booleanValue()) {
            if (!params.getString("OprtState").equalsIgnoreCase("rawMaterailCostCal")) throw new BOSException(CalculateUtil.getCalServerResource(ctx, "CALCULATE_FINSHGOOD_WAITE_MSG"));
            throw new BOSException(CalculateUtil.getCalServerResource(ctx, "CALCULATE_ROWMATEIAL_WAITE_MSG"));
        }
        try {
            String jobInstExtId;
            Map result = CreateJobFacadeFactory.getLocalInstance((Context)ctx).executeJob(new JobParam((Object)params), jobCfg);
            if (null != result && null == (jobInstExtId = (String)result.get("jobInstExtId"))) return;
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private JobConfig createJobCfg(CalculateParams params) {
        String title = "\u3010" + params.getString("COMPANY_NAME") + "(" + params.getString("COMPANY_NUMBER") + ")\u3011" + params.getString("title");
        JobConfig jobCfg = new JobConfig();
        if (params.getString("OprtState").equalsIgnoreCase("rawMaterailCostCal")) {
            jobCfg.setNumber("SCM_CAL_0001");
            jobCfg.setTaskType(params.getString("COMPANY_NUMBER") + "SCM_CAL_0001");
        } else {
            jobCfg.setNumber("SCM_CAL_0003");
            jobCfg.setTaskType(params.getString("COMPANY_NUMBER") + "SCM_CAL_0003");
        }
        jobCfg.setTitle(title);
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(false);
        return jobCfg;
    }
}

