/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalcuateRefactorFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindRefactorBillFactory;
import com.kingdee.eas.scm.cal.CalculateKindRefactorBillInfo;
import com.kingdee.eas.scm.cal.CalculateKindRefactorEntryCollection;
import com.kingdee.eas.scm.cal.ICalcuateRefactorFacade;
import com.kingdee.eas.scm.cal.app.AbstractCalculateKindRefactorBillControllerBean;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class CalculateKindRefactorBillControllerBean
extends AbstractCalculateKindRefactorBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.CalculateKindRefactorBillControllerBean");

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CalculateKindRefactorBillInfo info = (CalculateKindRefactorBillInfo)model;
        CompanyOrgUnitInfo cou = info.getCompanyOrgUnit();
        return cou;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("year"));
        selector.add(new SelectorItemInfo("period"));
        selector.add(new SelectorItemInfo("companyOrgUnit.id"));
        selector.add(new SelectorItemInfo("companyOrgUnit.number"));
        selector.add(new SelectorItemInfo("companyOrgUnit.name"));
        CalculateKindRefactorBillInfo info = this.getCalculateKindRefactorBillInfo(ctx, pk, selector);
        CompanyOrgUnitInfo cou = info.getCompanyOrgUnit();
        return cou;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CalculateKindRefactorBillInfo info = (CalculateKindRefactorBillInfo)model;
        if (info != null && info.getCompanyOrgUnit() != null) {
            return info.getCompanyOrgUnit().getId().toString();
        }
        return null;
    }

    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CalculateKindRefactorBillInfo info = (CalculateKindRefactorBillInfo)model;
        if (info != null && info.getSoureAccountType() != null && info.getSoureAccountType().getValue() == 2 && this.checkDifferAmountIsZero(info)) {
            throw new CalculateException(CalculateException.EXPNOTALLOWZERO);
        }
        int year = info.getYear();
        int period = info.getPeriod();
        this._checkBizDate(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        info.setYear(year);
        info.setPeriod(period);
        if (info.getBillType() != null) {
            String billTypeId = info.getBillType().getId().toString();
            String companyid = info.getCompanyOrgUnit().getId().toString();
            boolean isAutoAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 1, companyid, billTypeId);
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equalsIgnoreCase("1")) {
                isAutoAudit = true;
            }
            if (isAutoAudit) {
                this._passAudit(ctx, pk, (IObjectValue)info);
            }
        }
        return pk;
    }

    protected boolean isCloseAccount(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        boolean isShuted;
        CalculateKindRefactorBillInfo info = (CalculateKindRefactorBillInfo)model;
        CompanyOrgUnitInfo cou = info.getCompanyOrgUnit();
        if (cou != null && (isShuted = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou)) && this.isCheckCloseAccount()) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            if (info.getYear() == curPeriodInfo.getPeriodYear() && info.getPeriod() == curPeriodInfo.getPeriodNumber()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isCloseAccount(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean isShuted;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("year"));
        selector.add(new SelectorItemInfo("period"));
        selector.add(new SelectorItemInfo("companyOrgUnit.id"));
        selector.add(new SelectorItemInfo("companyOrgUnit.number"));
        selector.add(new SelectorItemInfo("companyOrgUnit.name"));
        CalculateKindRefactorBillInfo info = this.getCalculateKindRefactorBillInfo(ctx, pk, selector);
        CompanyOrgUnitInfo cou = info.getCompanyOrgUnit();
        if (cou != null && (isShuted = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou)) && this.isCheckCloseAccount()) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            if (info.getYear() == curPeriodInfo.getPeriodYear() && info.getPeriod() == curPeriodInfo.getPeriodNumber()) {
                return true;
            }
        }
        return false;
    }

    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getCalculateKindRefactorBillSelector();
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (pk == null && model == null) {
            return;
        }
        super.audit(ctx, pk);
        CalculateKindRefactorBillInfo billInfo = (CalculateKindRefactorBillInfo)model;
        if (billInfo == null) {
            billInfo = CalculateKindRefactorBillFactory.getLocalInstance(ctx).getCalculateKindRefactorBillInfo(pk, this.getSelector());
        }
        if (billInfo != null && billInfo.getSoureAccountType() != null && billInfo.getSoureAccountType().getValue() == 2 && this.checkDifferAmountIsZero(billInfo)) {
            throw new CalculateException(CalculateException.EXPNOTALLOWZERO);
        }
        this._checkBillExist(ctx, (IObjectValue)billInfo);
        CalculateKindRefactorBillInfo checkInfo = (CalculateKindRefactorBillInfo)this.getDataNewStatus(ctx, (IObjectValue)billInfo);
        this._checkAudit(ctx, (IObjectValue)checkInfo, true);
        this._checkSubmit(ctx, (IObjectValue)checkInfo, false);
        try {
            AccountType newAccountType = billInfo.getNewAccountType();
            AccountType oldAccountType = billInfo.getSoureAccountType();
            if (5 == newAccountType.getValue() || 5 == oldAccountType.getValue()) {
                Class<?> ncmCommonFacadeFactory = Class.forName("com.kingdee.eas.ncm.common.NCMCommonFacadeFactory");
                Method m = ncmCommonFacadeFactory.getMethod("getLocalInstance", Context.class);
                Object o = m.invoke(null, ctx);
                Class<?> iNCMCommonFacade = Class.forName("com.kingdee.eas.ncm.common.INCMCommonFacade");
                Method m1 = iNCMCommonFacade.getMethod("isUsedCostObjectOfMateiral", CoreBillBaseInfo.class);
                m1.invoke(o, billInfo);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        ICalcuateRefactorFacade refRemote = CalcuateRefactorFacadeFactory.getLocalInstance(ctx);
        refRemote.auditCalculateRef(billInfo);
        if (super._isExistPropertyName(ctx, (CoreBaseInfo)billInfo, "baseStatus")) {
            this.updateAuditStatus(ctx, (IObjectValue)billInfo);
        }
        this.setMaterialAccountType(ctx, billInfo);
        super._passAudit(ctx, pk, (IObjectValue)billInfo);
    }

    private void setMaterialAccountType(Context ctx, CalculateKindRefactorBillInfo info) throws EASBizException, BOSException {
        StringBuffer ids = new StringBuffer();
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            ids.append("'" + info.getEntry().get(i).getMaterial().getId().toString() + "',");
        }
        ids.append("' '");
        String companyID = info.getCompanyOrgUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BD_MaterialCompanyInfo set FAccountType = ?, FIsLot = ?, FIsAssistProperty = ?, FIsProject = ?, FIsTrackNumber = ? ");
        sql.append("where FMaterialID in (").append(ids.toString()).append(") and FCompanyID = '").append(companyID).append("'");
        int lot = info.isIsLot() ? 1 : 0;
        int assistProperty = info.isIsAssistProperty() ? 1 : 0;
        int projectNum = info.isIsProjectNum() ? 1 : 0;
        int trackNum = info.isIsTrackNum() ? 1 : 0;
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getNewAccountType().getValue(), lot, assistProperty, projectNum, trackNum});
    }

    public void updateAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            Date now = new Date();
            preStmt.setTimestamp(1, new Timestamp(now.getTime()));
            UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            preStmt.setString(2, aUserInfo.getId().toString());
            preStmt.setInt(3, 4);
            preStmt.setString(4, aSCMBillBaseInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, conn);
                SQLUtils.cleanup(sm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
    }

    private boolean checkDifferAmountIsZero(CalculateKindRefactorBillInfo info) {
        CalculateKindRefactorEntryCollection entries = info.getEntry();
        BigDecimal zero = new BigDecimal(String.valueOf("0.0"));
        for (int i = 0; entries != null && i < entries.size(); ++i) {
            if (entries.get(i).getPeriodBeginDiffer() == null || entries.get(i).getPeriodBeginDiffer().compareTo(zero) == 0) continue;
            return true;
        }
        return false;
    }

    public String getParamCon4Audit() {
        return "SCM_CAL_A02";
    }

    public String getParamCon4UnAudit() {
        return "SCM_CAL_A01";
    }
}

