/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.INewParamAfterDeal;
import com.kingdee.eas.base.param.INewParamCheck;
import com.kingdee.eas.base.param.IParamCheck;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;

public class CalculateModeParamCheckImpl
implements IParamCheck,
INewParamCheck,
INewParamAfterDeal {
    private static final String STORESYSTEMID = "e45c1988-00fd-1000-e000-36b8c0a8500d02A5514C";
    public static final int CALKIND_COMPANY = 0;
    public static final int CALKIND_STORAGE = 1;
    public static final int CALKIND_WAREHOUSE = 2;

    public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
        if (model.getOrgUnitID() != null && model.getOrgUnitID().getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(model.getOrgUnitID().getId().toString());
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            if (company != null) {
                if ("SCM_CAL_002".equalsIgnoreCase(model.getKeyID().getNumber())) {
                    boolean bln = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
                    String strCalType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_002");
                    int oldCalculKind = Integer.parseInt(strCalType);
                    this.checkSCMParam2(ctx, pk.toString(), bln, Integer.parseInt(model.getValue()), oldCalculKind);
                } else if ("SCM_CAL_008".equalsIgnoreCase(model.getKeyID().getNumber())) {
                    String voucherType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_008");
                    if ("1".equals(voucherType)) {
                        throw new CalculateException(CalculateException.PARAM_SCM008_MODIFI);
                    }
                    if ("0".equals(voucherType)) {
                        iParamControl.updateParamItemByNumberAndOrg("SCM_CAL_011", company.getId().toString(), "false");
                    }
                } else if ("SCM_CAL_011".equalsIgnoreCase(model.getKeyID().getNumber())) {
                    String value;
                    String voucherType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_008");
                    if ("1".equals(voucherType) && "false".equalsIgnoreCase(value = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_011"))) {
                        throw new CalculateException(CalculateException.PARAM_SCM011_MODIFI);
                    }
                } else if ("SCM_CAL_001".equals(model.getKeyID().getNumber())) {
                    String dischargeType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_001");
                    int oldValue = Integer.parseInt(dischargeType);
                    int newValue = Integer.parseInt(model.getValue());
                    this.dischargeParamChanged(ctx, pk.toString(), oldValue, newValue);
                }
            }
        }
    }

    public void check(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
        ParamItemInfo model = null;
        CompanyOrgUnitInfo company = null;
        IParamControl iParamControl = null;
        int size = modelCol.size();
        for (int i = 0; i < size; ++i) {
            model = modelCol.get(i);
            if (model.getOrgUnitID() == null || model.getOrgUnitID().getId() == null) continue;
            ObjectUuidPK pk = new ObjectUuidPK(model.getOrgUnitID().getId().toString());
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
            iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            if (company == null) continue;
            if ("SCM_CAL_002".equalsIgnoreCase(model.getKeyID().getNumber())) {
                boolean bln = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
                String strCalType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_002");
                int oldCalculKind = Integer.parseInt(strCalType);
                this.checkSCMParam2(ctx, pk.toString(), bln, Integer.parseInt(model.getValue()), oldCalculKind);
                continue;
            }
            if ("SCM_CAL_008".equalsIgnoreCase(model.getKeyID().getNumber())) {
                String voucherType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_008");
                if ("1".equals(voucherType)) {
                    throw new CalculateException(CalculateException.PARAM_SCM008_MODIFI);
                }
                if (!"0".equals(voucherType)) continue;
                iParamControl.updateParamItemByNumberAndOrg("SCM_CAL_011", company.getId().toString(), "false");
                continue;
            }
            if ("SCM_CAL_011".equalsIgnoreCase(model.getKeyID().getNumber())) {
                String value;
                String voucherType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_008");
                if (!"1".equals(voucherType) || !"false".equalsIgnoreCase(value = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_011"))) continue;
                throw new CalculateException(CalculateException.PARAM_SCM011_MODIFI);
            }
            if (!"SCM_CAL_001".equals(model.getKeyID().getNumber())) continue;
            String dischargeType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "SCM_CAL_001");
            int oldValue = Integer.parseInt(dischargeType);
            int newValue = Integer.parseInt(model.getValue());
            this.dischargeParamChanged(ctx, pk.toString(), oldValue, newValue);
        }
    }

    public void afterDeal(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
    }

    private void checkSCMParam2(Context ctx, String orgUnitID, boolean bln, int calculKind, int oldCalculKind) throws BOSException, EASBizException {
        this.clearRecentCost(ctx, orgUnitID, oldCalculKind);
        this.inertRecentCost(ctx, calculKind, orgUnitID);
    }

    private void clearRecentCost(Context ctx, String orgUnitID, int oldCalculKind) throws BOSException {
        String clearSql = this.getRecentCostSql(orgUnitID, oldCalculKind);
        DBUtil.execute((Context)ctx, (String)clearSql);
    }

    private String getRecentCostSql(String orgUnitID, int oldCalculKind) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM T_CL_RECENTCOST ");
        buffer.append("\n WHERE FCOMPANYORGUNITID ='" + orgUnitID + "'");
        return buffer.toString();
    }

    private void inertRecentCost(Context ctx, int calculKind, String companyOrgUnitID) throws BOSException {
        String sql = this.getInsertRecentCostSql(calculKind, companyOrgUnitID);
        DBUtil.execute((Context)ctx, (String)sql);
    }

    private String getInsertRecentCostSql(int calculKind, String companyOrgUnitID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO T_CL_RECENTCOST(FID,FCOMPANYORGUNITID,");
        if (calculKind == 1) {
            buffer.append("FSTORAGEORGUNITID,");
        } else if (calculKind == 2) {
            buffer.append("FSTORAGEORGUNITID,");
            buffer.append("FWAREHOUSEID,");
        }
        buffer.append("FMATERIALID,FRECENTQTY,FRECENTCOST,FPRICE)");
        buffer.append("\n SELECT NEWBOSID('88888888') AS FID,T1.FCOMPANYORGUNITID,");
        if (calculKind == 1) {
            buffer.append("T1.FSTORAGEORGUNITID,");
        } else if (calculKind == 2) {
            buffer.append("T1.FSTORAGEORGUNITID,");
            buffer.append("T1.FWAREHOUSEID,");
        }
        buffer.append("T1.FMATERIALID,");
        buffer.append("\n SUM(T1.FPERIODBEGINQTY) AS QTY ,SUM(T1.FPERIODBEGINBALANCE) AS AMOUNT,");
        buffer.append("\n CASE  WHEN DECIMAL(SUM(T1.FPERIODBEGINQTY),17,1)=0 THEN 0 ");
        buffer.append("\n ELSE ABS(DECIMAL(SUM(T1.FPERIODBEGINBALANCE),17,1)/DECIMAL(SUM(T1.FPERIODBEGINQTY),17,4))");
        buffer.append("\n END  AS FPRICE");
        buffer.append("\n FROM T_IM_INVENTORYBALANCE T1 INNER JOIN T_BD_MATERIALCOMPANYINFO T2 ");
        buffer.append("\n ON T1.FMATERIALID = T2.FMATERIALID AND T1.FCOMPANYORGUNITID = T2.FCOMPANYID");
        buffer.append("\n AND T2.FACCOUNTTYPE = 1");
        buffer.append("\n WHERE T1.FYEAR = (SELECT FPERIODYEAR FROM T_BD_PERIOD");
        buffer.append("\n WHERE FID =(");
        buffer.append(this.getCurrentPeriodSql(companyOrgUnitID));
        buffer.append("))");
        buffer.append("\n AND T1.FPERIOD = (SELECT FPERIODNUMBER FROM T_BD_PERIOD");
        buffer.append("\n WHERE FID =(");
        buffer.append(this.getCurrentPeriodSql(companyOrgUnitID));
        buffer.append("))");
        buffer.append(" AND T1.FCOMPANYORGUNITID='").append(companyOrgUnitID).append("'");
        buffer.append("\n GROUP BY T1.FCOMPANYORGUNITID,");
        if (calculKind == 1) {
            buffer.append("T1.FSTORAGEORGUNITID,");
        } else if (calculKind == 2) {
            buffer.append("T1.FSTORAGEORGUNITID,");
            buffer.append("T1.FWAREHOUSEID,");
        }
        buffer.append("T1.FMATERIALID");
        return buffer.toString();
    }

    private String getCurrentPeriodSql(String companyOrgUnitID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FCURRENTPERIODID FROM t_bd_systemstatusctrol");
        buffer.append("\n where fcompanyid ='" + companyOrgUnitID + "'");
        buffer.append("\n and fsystemstatusid = 'e45c1988-00fd-1000-e000-36b8c0a8500d02A5514C'");
        return buffer.toString();
    }

    private void dischargeParamChanged(Context ctx, String companyId, int OldValue, int newValue) throws BOSException, EASBizException {
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyId));
        if (curPeriod == null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(companyId));
            throw new CalculateException(CalculateException.COMPANY_PERIOD_NULL, new String[]{company.getName()});
        }
        try {
            if (OldValue == 0) {
                this.isCanChangeUnClear(ctx, companyId, curPeriod);
                this.updateDischargeType(ctx, companyId, newValue);
            } else if (OldValue == 2) {
                this.isVoucheredWriteOffRecord(ctx, companyId, curPeriod);
                if (newValue == 0) {
                    this.isVoucheredPurBill(ctx, companyId, curPeriod);
                }
                this.updateDischargeType(ctx, companyId, newValue);
            } else if (OldValue == 1) {
                this.isVoucheredWriteOffRecord(ctx, companyId, curPeriod);
                if (newValue == 0) {
                    this.isVoucheredPurBill(ctx, companyId, curPeriod);
                }
                this.updateDischargeType(ctx, companyId, newValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void isCanChangeUnClear(Context ctx, String companyId, PeriodInfo curPeriod) throws BOSException, EASBizException, SQLException {
        String IS_EXIST_FUTHER_WRITEOFFRECORD = "select fid from T_CL_WriteOffGroup where (FWriteOffYear * 100 + FWriteOffPeriod) > {0} and FCreateType <= 5 and FCompanyOrgUnitID = ''{1}''";
        String IS_VOUCHERED_PURINWAREHSBILL = "select bill.fid from T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on entry.FParentId = bill.FID where bill.FFiVouchered = 1 and bill.FYear = {0} and bill.FPeriod = {1} and entry.FCompanyOrgUnitID = ''{2}''";
        String IS_VOUCHERED_OTHERBILL = "select fid from T_AP_OtherBill where FFiVouchered = 1 and FBillType = {3} and FSourceBillType != {4} and FYear = {0} and FPeriod = {1} and FCompanyID = ''{2}''";
        String IS_VOUCHERED_COSTADJBILL = "select bill.fid from T_CL_CostAdjustBill bill inner join T_CL_CostAdjustBillEntry entry on entry.FParentId = bill.FID where bill.FCreateType = 0 and bill.FFiVouchered = 1 and bill.FYear = {0} and bill.FPeriod = {1} and entry.FCompanyOrgUnitID = ''{2}''";
        String IS_EXIST_MOREONEPURBILL = "select t.FParentId from (select entry.FParentid as FParentid,entry.FBillId as FBillId from T_CL_WriteOffGroup bill inner join T_CL_WriteOffRecord entry on bill.FID = entry.FParentId where entry.FBillTypeNumber = ''103'' and bill.FWriteOffYear = {0} and bill.FWriteOffPeriod = {1} and bill.FCompanyOrgUnitID = ''{2}'' group by entry.FParentid,entry.FBillId) as t group by t.FParentid having count(*) > 1";
        String IS_EXIST_NOTALL_WRITEOFFBILL = "select bill.fid from T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on bill.FID = entry.FParentid where (bill.FYear * 100 + bill.FPeriod) < {0} and entry.FUnWriteOffQty != 0 and entry.FWrittenOffQty != 0 and entry.FCompanyOrgUnitID = ''{1}''";
        String sSQL = "";
        IRowSet rs = null;
        sSQL = MessageFormat.format(IS_EXIST_FUTHER_WRITEOFFRECORD, String.valueOf(curPeriod.getNumber()), companyId);
        rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        if (rs.next()) {
            throw new CalculateException(CalculateException.EXIST_FUTHER_RECORD);
        }
        sSQL = MessageFormat.format(IS_VOUCHERED_PURINWAREHSBILL, String.valueOf(curPeriod.getPeriodYear()), String.valueOf(curPeriod.getPeriodNumber()), companyId);
        rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        if (rs.next()) {
            throw new CalculateException(CalculateException.PURBILL_ISVOUCHERED);
        }
        sSQL = MessageFormat.format(IS_VOUCHERED_OTHERBILL, String.valueOf(curPeriod.getPeriodYear()), String.valueOf(curPeriod.getPeriodNumber()), companyId, String.valueOf(202), String.valueOf(14));
        rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        if (rs.next()) {
            throw new CalculateException(CalculateException.OTHERBILL_ISVOUCHERED);
        }
        sSQL = MessageFormat.format(IS_VOUCHERED_COSTADJBILL, String.valueOf(curPeriod.getPeriodYear()), String.valueOf(curPeriod.getPeriodNumber()), companyId);
        rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        if (rs.next()) {
            throw new CalculateException(CalculateException.COSTADJBILL_ISVOUCHERED);
        }
        sSQL = MessageFormat.format(IS_EXIST_MOREONEPURBILL, String.valueOf(curPeriod.getPeriodYear()), String.valueOf(curPeriod.getPeriodNumber()), companyId);
        rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        if (rs.next()) {
            throw new CalculateException(CalculateException.MOREONE_PURBILL);
        }
        sSQL = MessageFormat.format(IS_EXIST_NOTALL_WRITEOFFBILL, String.valueOf(curPeriod.getNumber()), companyId);
        rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        if (rs.next()) {
            throw new CalculateException(CalculateException.EXIST_PART_WRITEOFF);
        }
    }

    private void isVoucheredWriteOffRecord(Context ctx, String companyId, PeriodInfo curPeriod) throws BOSException, EASBizException, SQLException {
        String IS_VOUCHERED_RECORD = "select fid from T_CL_WriteOffGroup where FFivouchered = 1 and FWriteOffYear = {0} and FWriteOffPeriod = {1} and FCreateType <= 5 and FCompanyOrgUnitID = ''{2}''";
        String sSQL = MessageFormat.format(IS_VOUCHERED_RECORD, String.valueOf(curPeriod.getPeriodYear()), String.valueOf(curPeriod.getPeriodNumber()), companyId);
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        if (rs.next()) {
            throw new CalculateException(CalculateException.RECORD_ISVOUCHERED);
        }
    }

    private void isVoucheredPurBill(Context ctx, String companyId, PeriodInfo curPeriod) throws BOSException, EASBizException, SQLException {
        String IS_VOUCHERED_PURBILL = "select bill.fid from T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on entry.FParentId = bill.FID where bill.FFiVouchered = 1 and bill.FYear = {0} and bill.FPeriod = {1} and entry.FCompanyOrgUnitID = ''{2}''";
        String sSQL = MessageFormat.format(IS_VOUCHERED_PURBILL, String.valueOf(curPeriod.getPeriodYear()), String.valueOf(curPeriod.getPeriodNumber()), companyId);
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        if (rs.next()) {
            throw new CalculateException(CalculateException.PURBILL_ISVOUCHERED);
        }
    }

    private void updateDischargeType(Context ctx, String companyId, int newDischargeType) throws BOSException {
        String UPDATE_PURBILL_SQL = "update T_IM_PurInWarehsBill set FDischargeType = {0} where FID in (select bill.FId from T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on bill.FID = entry.FParentId  and bill.FBaseStatus = 4 and entry.FUnWriteOffQty != 0 and entry.FCompanyOrgUnitID = ''{1}'' and ISNULL(bill.FIsInitBill, 0) = 0)";
        String UPDATE_RECORD_SQL = "update T_CL_WriteOffGroup set FDischargeType = {0} where FID in (select record.FParentId from T_CL_WriteOffRecord record inner join T_IM_PurInWarehsEntry entry on record.FBillEntryID = entry.FId  where entry.FUnWriteOffQty != 0 and entry.FCompanyOrgUnitID = ''{1}'')";
        String sSQL = MessageFormat.format(UPDATE_PURBILL_SQL, String.valueOf(newDischargeType), companyId);
        DBUtil.execute((Context)ctx, (String)sSQL);
        sSQL = MessageFormat.format(UPDATE_RECORD_SQL, String.valueOf(newDischargeType), companyId);
        DBUtil.execute((Context)ctx, (String)sSQL);
    }
}

