/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.PriceEnum;
import com.kingdee.eas.scm.cal.app.AbstractCalculateReportFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.calculate.InpWarehsSumCalculate;
import com.kingdee.eas.scm.cal.app.calculate.InvBillPriceCalculate;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CalculateReportFacadeControllerBean
extends AbstractCalculateReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected void _inWarehouseSumCal(Context ctx) throws BOSException {
    }

    private String getDetailTempTable() {
        StringBuffer sb = new StringBuffer();
        sb.append("Create Table TempReportTable(");
        sb.append(" FID varchar(44)  not null PRIMARY KEY ,");
        sb.append(" FGatherID varchar(44), ");
        sb.append(" FCompanyOrgUnitID varchar(44),");
        sb.append(" FStorageOrgUnitID varchar(44),");
        sb.append(" FStorageOrgNumber nvarchar(300),");
        sb.append(" FWarehouseID varchar(44),");
        sb.append(" FWarehouseNumber nvarchar(300),");
        sb.append(" FActualBaseUnitCost Decimal(28,10) not null default 0,");
        sb.append(" FPeriodBeginBalance Decimal(28,10) not null default 0,");
        sb.append(" FPeriodBeginCostDiff Decimal(28,10) not null default 0,");
        sb.append(" FIncomeCostAdjustAmt Decimal(28,10) not null default 0,");
        sb.append(" FStandardCost Decimal(28,10) not null default 0,");
        sb.append(" FActualCost Decimal(28,10) not null default 0, ");
        sb.append(" FGatherActualCost Decimal(28,10) not null default 0, ");
        sb.append(" FBaseQty Decimal(28,10) not null default 0,");
        sb.append(" FBaseUnitActualCost Decimal(28,10) not null default 0,");
        sb.append(" FPeriodBeginQty Decimal(28,10) not null default 0,");
        sb.append(" FBillTypeID varchar(44),");
        sb.append(" FNumber nvarchar(300),");
        sb.append(" FBizDate datetime,");
        sb.append(" FIsReversed  int,");
        sb.append(" FTransactionTypeNumber nvarchar(300),");
        sb.append(" FAdminOrgUnitID varchar(44),");
        sb.append(" FCostCenterOrgUnitID varchar(44),");
        sb.append(" FWrittenOffQty Decimal(28,10) not null default 0, ");
        sb.append(" FReverseQty Decimal(28,10) not null default 0, ");
        sb.append(" FMantissaAmt Decimal(17,4) not null default 0, ");
        sb.append(" FLocalCurrencyPrecision  int DEFAULT 0 ,");
        sb.append(" FMaterialID varchar(44),");
        sb.append(" FMaterialNumber nvarchar(300),");
        sb.append(" FMaterialName nvarchar(300),");
        sb.append(" FMaterialModel nvarchar(300),");
        sb.append(" FMaterialBaseUnitID  varchar(44),");
        sb.append(" FPricePrecision int,");
        sb.append(" FAccountType int,");
        sb.append(" FParentID varchar(44),");
        sb.append(" FEntryID varchar(44),");
        sb.append(" FLot nvarchar(300),");
        sb.append(" FAssistPropertyID varchar(44),");
        sb.append(" FProjectID varchar(44),");
        sb.append(" FTrackNumberID varchar(44),");
        sb.append(" FSourceBillID varchar(44),");
        sb.append(" FSourceBillEntryID varchar(44),");
        sb.append(" FSourceBillEntrySeq int,");
        sb.append(" FOutwarehouseType int,");
        sb.append(" FEntryTableName nvarchar(300),");
        sb.append(" FLastBillEntryID varchar(44),");
        sb.append(" FStoreTypeId varchar(44),");
        sb.append(" FStoreTypePreId varchar(44)");
        sb.append(" );");
        return sb.toString();
    }

    protected String[][] getTempTableFields() {
        String[][] fields = new String[][]{{"KSQL_SEQ", "INT IDENTITY(1,1)"}, {"FID", "VARCHAR(44) NOT NULL PRIMARY KEY"}, {"FCreatorID", "VARCHAR(80) NOT NULL"}, {"FCreateTime", "DateTime"}, {"FLastUpdateUserID", "VARCHAR(80) NOT NULL"}, {"FLastUpdateTime", "DateTime"}, {"FControlUnitID", "VARCHAR(80) NOT NULL"}, {"FBASEQTY", "NUMERIC(28,16) DEFAULT 0 NOT NULL"}, {"FActualBaseUnitCost", "NUMERIC(28,16) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(19,4) DEFAULT 0 NOT NULL"}, {"FQtyPrecision", "INT DEFAULT 0 NOT NULL"}, {"FPricePrecision", "INT DEFAULT 0 NOT NULL"}, {"FLocalCurrencyPrecision", "INT DEFAULT 0 "}, {"FStorageOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FWarehouseID", "VARCHAR(44) NOT NULL"}, {"FAdminOrgUnitID", "VARCHAR(44)"}, {"FCostCenterOrgUnitID", "VARCHAR(44)"}, {"FMaterialID", "VARCHAR(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FMantissaAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FLastBillEntryID", "VARCHAR(44) NULL"}, {"FLot", "VARCHAR(255)"}, {"FAccountType", "INT DEFAULT 0 NOT NULL"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}};
        return fields;
    }

    private PeriodInfo getPeriod(Context ctx, RptParams params, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        PeriodInfo periodInfo = null;
        periodInfo = params.getObject("PERIOD_OBJ") != null ? (PeriodInfo)params.getObject("PERIOD_OBJ") : SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        if (periodInfo == null) {
            companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId().toString()));
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(companyOrgUnitInfo.getName(), companyOrgUnitInfo.getNumber())});
        }
        return periodInfo;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnit(RptParams params) throws CalculateException {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        try {
            companyOrgUnitInfo.setId(BOSUuid.read((String)params.getString("COMPANY_ID")));
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        return companyOrgUnitInfo;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String gatherTableName = params.getString("TEMPTABLE");
        String detailTableName = params.getString("DETAILTEMPTABLE");
        String finalTableName = params.getString("FINALTABLE");
        InpWarehsSumCalculate wac = new InpWarehsSumCalculate();
        if (!"file".equals(params.getObject("file"))) {
            this.dropTempTable(detailTableName, ctx);
            this.dropTempTable(gatherTableName, ctx);
            this.dropTempTable(finalTableName, ctx);
            detailTableName = DBUtil.createTempTable(ctx, this.getDetailTempTable());
            DBUtil.createTempTableIndex(ctx, detailTableName, "FEntryID", false);
            DBUtil.createTempTableIndex(ctx, detailTableName, "FGatherID", false);
            DBUtil.createTempTableIndex(ctx, detailTableName, "FMaterialID", false);
            gatherTableName = wac.createTempTable(ctx, this.getTempTableFields());
            DBUtil.createTempTableIndex(ctx, gatherTableName, "KSQL_SEQ", false);
        }
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnit(params);
        PeriodInfo periodInfo = this.getPeriod(ctx, params, companyInfo);
        CalculateParams cp = new CalculateParams(params.toMap());
        int localCurrencyPresision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyInfo);
        cp.setInt("Local_Currency_Presision", localCurrencyPresision);
        params.setInt("Local_Currency_Presision", localCurrencyPresision);
        String detailsql = wac.getBillDetailRecordSQLNew(ctx, periodInfo, cp);
        this.insertDetailData(ctx, detailsql, detailTableName, cp);
        String gathersql = wac.getInpWarehsSumBillNew(ctx, periodInfo, cp, detailTableName);
        this.insertGatherTable(ctx, gathersql, gatherTableName);
        this.updateGatherID(ctx, params, detailTableName, gatherTableName);
        finalTableName = this.insertFinalTable(ctx, params, gatherTableName);
        this.getRecordCount(ctx, finalTableName, params);
        this.updateFinalTableSumData(ctx, finalTableName, params);
        params.setString("TEMPTABLE", gatherTableName);
        params.setString("FINALTABLE", finalTableName);
        params.setString("DETAILTEMPTABLE", detailTableName);
        return params;
    }

    private void updateGatherID(Context ctx, RptParams params, String detailTableName, String gatherTableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" update " + detailTableName + " t10 set (fgatherid) = ( ");
        sb.append(" select t2.fid from " + detailTableName + "  t1 left join  " + gatherTableName + " t2 on ");
        sb.append(" t1.FCompanyOrgUnitID  = t2.FCompanyOrgUnitID and t1.FMaterialID = t2.FMaterialID ");
        sb.append(" and t1.FAccountType = t2.FAccountType and isnull(t1.FAssistPropertyID,'XXXX') =isnull(t2.FAssistPropertyID,'XXXX')  ");
        sb.append(" and isnull(t1.FLot,'XXXX') =  isnull(t2.FLot,'XXXX') and isnull(t1.FProjectID,'XXXX') =  isnull(t2.FProjectID,'XXXX') ");
        sb.append(" and isnull(t1.FTrackNumberID,'XXXX') =  isnull(t2.FTrackNumberID,'XXXX') ");
        if (params != null && params.getInt("SUMCONDITION") == 1) {
            sb.append("and t1.FSTORAGEORGUNITID = t2.FSTORAGEORGUNITID ");
        }
        if (params != null && params.getInt("SUMCONDITION") == 2) {
            sb.append("and t1.FSTORAGEORGUNITID = t2.FSTORAGEORGUNITID ");
            sb.append("and isnull(t1.FWarehouseID,'XXXX') = isnull(t2.FWarehouseID,'XXXX') ");
        }
        if (params != null && params.getInt("SUMCONDITION") == 3) {
            sb.append("and isnull(t1.fAdminOrgUnitID,'XXXX') = isnull(t2.fAdminOrgUnitID,'XXXX') ");
        }
        if (params != null && params.getInt("SUMCONDITION") == 4) {
            sb.append("and isnull(t1.FCostCenterOrgUnitID,'XXXX') = isnull(t2.FCostCenterOrgUnitID,'XXXX') ");
        }
        sb.append(" where t10.fid = t1.fid )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void insertGatherTable(Context ctx, String sql, String tableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(tableName);
        sb.append("( KSQL_SEQ, FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID,");
        sb.append(" FBASEQTY, FActualBaseUnitCost, FActualCost, FQtyPrecision, FPricePrecision, FLocalCurrencyPrecision,");
        sb.append(" FStorageOrgUnitID, FWarehouseID, FAdminOrgUnitID, FCostCenterOrgUnitID, FMaterialID, FCompanyOrgUnitID,");
        sb.append(" FMantissaAmt, FLastBillEntryID, FLot, FAccountType, FAssistPropertyID, FProjectID, FTrackNumberID)");
        sb.append(sql);
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void insertDetailData(Context ctx, String sql, String tableName, CalculateParams params) throws BOSException {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        StringBuffer sb = new StringBuffer();
        sb.append(" insert into  ").append(tableName);
        sb.append(" ( FID,FGatherID,FCompanyOrgUnitID,FStorageOrgUnitID,FStorageOrgNumber,FWarehouseID,FCostCenterOrgUnitID,");
        sb.append("  FWarehouseNumber,FPeriodBeginBalance,FPeriodBeginCostDiff,FIncomeCostAdjustAmt,FStandardCost,FActualCost,");
        sb.append("  FBaseQty,FBaseUnitActualCost,FPeriodBeginQty,FBillTypeID,FNumber,FBizDate,FIsReversed,FTransactionTypeNumber,");
        sb.append("  FAdminOrgUnitID,FWrittenOffQty,FReverseQty,FMaterialID,FMaterialNumber,FMaterialName,FMaterialModel,FMaterialBaseUnitID,");
        sb.append("  FPricePrecision,FAccountType,FParentID,FEntryID,FLot,FAssistPropertyID,FProjectID,FTrackNumberID,");
        sb.append("  FOutwarehouseType,FEntryTableName,FLocalCurrencyPrecision )");
        sb.append("  select newbosid('clreport'),'',FCompanyOrgUnitID,FStorageOrgUnitID,FStorageOrg,FWarehouseID,FCostCenterOrgUnitID, ");
        sb.append("  FWarehouse,FPeriodBeginBalance,FPeriodBeginCostDiff,FIncomeCostAdjustAmt,FStandardCost,ROUND(FActualCost," + Local_Currency_Presision + "), ");
        sb.append("  FBaseQty,FBaseUnitActualCost,FPeriodBeginQty,FBillTypeID,FNumber,FBizDate,FIsReversed,TRANSACTIONTYPEFNUMBER, ");
        sb.append("  FAdminOrgUnitID,FWrittenOffQty,FReverseQty,FMaterialID,MATERIALFNUMBER,MATERIALFNAME,MATERIALFMODEL,MATERIALFBASEUNIT,");
        sb.append("  FPricePrecision,FAccountType,FParentID,FID,FLot,FAssistPropertyID,FProjectID,FTrackNumberID, ");
        sb.append("  FOutwarehouseType,FEntryTableMame," + Local_Currency_Presision + " from ");
        sb.append("  (").append(sql).append(" ) t ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return super._init(ctx, params);
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String finalTableName = params.getString("FINALTABLE");
        StringBuffer sql = new StringBuffer();
        sql.append("select FSTORAGEORG, FSTORAGEORGName, FWarehouseName,FDeptNumber, FAdminOrgUnitName, ");
        sql.append("FCostCenterNumber, FCostCenterOrgUnitName, MaterialNumber, MATERIALFName, ");
        sql.append("SHORTNAME, MATERIALFModel, FLot, AssistPropertyName, ProjectNumber, ");
        sql.append("TrackNumberNumber, MEASUREUNITFName, FBASEQTY, FActualBaseUnitCost, ");
        sql.append("FActualCost, FQtyPrecision, FPricePrecision, FLocalCurrencyPrecision, ");
        sql.append("FSTORAGEORGUNITID, FWAREHOUSEID, FMATERIALID, FCOMPANYORGUNITID, FID, FAccountType");
        sql.append(" from ").append(finalTableName);
        sql.append(" WHERE SEQ >= ").append(from + 1).append(" AND SEQ <= ").append(from + len);
        sql.append(" ORDER BY SEQ ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        params.setObject("rowset", (Object)rs);
        return params;
    }

    private String processInpWarehsSumTempTable(Context ctx, String tempTableName, RptParams params) throws EASBizException, BOSException {
        String materialGroupStandardID = params.getString("MATERIALGROUPSTANDARD_ID");
        String materialGroupIDS = params.getString("MATERIALGROUP_IDS");
        InpWarehsSumCalculate wac = new InpWarehsSumCalculate();
        String tempTableName2 = wac.createTempTable(ctx, this.getTempTableFields());
        StringBuffer bf = new StringBuffer();
        bf.append("insert into ").append(tempTableName2);
        bf.append(" select TempT.* from ").append(tempTableName).append(" TempT");
        bf.append(" inner join T_BD_MaterialGroupDetial T on TempT.FMaterialId = T.FMaterialId");
        bf.append(" inner join T_BD_MaterialGroup T2 on T.FMaterialGroupId = T2.FID");
        bf.append(" where 1=1 ");
        if (null != materialGroupStandardID) {
            bf.append(" and T2.fgroupstandard = '").append(materialGroupStandardID).append("'");
        }
        if (null != materialGroupIDS) {
            bf.append(" and T.FMaterialGroupID in ").append(materialGroupIDS);
        }
        DbUtil.execute((Context)ctx, (String)bf.toString());
        return tempTableName2;
    }

    private void updateZeroCost(Context ctx, RptParams params, String tempTableName) {
    }

    private void getRecordCount(Context ctx, String sqltemp, RptParams params) throws BOSException {
        StringBuffer countSql = new StringBuffer();
        countSql.append("select count(1) from ").append(sqltemp);
        RptRowSet rsCount = this.executeQuery(countSql.toString(), null, ctx);
        rsCount.next();
        int count = rsCount.getInt(0) == 0 ? 0 : rsCount.getInt(0) + 1;
        params.setInt("TOTAL_COUNT", count);
    }

    private void verdictIsGetDaulPrice(Context ctx, RptParams params, String tempTableName) throws BOSException, EASBizException {
        if (params.getObject("PRICE_ENUM") != null) {
            PriceEnum price = (PriceEnum)((Object)params.getObject("PRICE_ENUM"));
            PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
            CalculateParams calparams = new CalculateParams();
            calparams.setString("COMPANY_ID", params.getString("COMPANY_ID"));
            CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
            companyOrgUnitInfo.setId(BOSUuid.read((String)params.getString("COMPANY_ID")));
            if (periodInfo == null) {
                periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            }
            if (periodInfo == null) {
                throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{""});
            }
            InvBillPriceCalculate iiwc = new InvBillPriceCalculate();
            int calType = 0;
            if (params.getObject("SUMCONDITION") != null) {
                calType = params.getInt("SUMCONDITION");
            }
            iiwc.setCalType(calType);
            String devInWarehsTempTable = DBUtil.createTempTable(ctx, "BEGINAVGPRICE", this.getBeginDataTableField());
            if (price.compareTo((Object)PriceEnum.BEGIN_WEIGHTED_AVERAGE_PRICE) == 0) {
                DbUtil.execute((Context)ctx, (String)iiwc.getBeginDataSQL(periodInfo, tempTableName, devInWarehsTempTable));
                DbUtil.execute((Context)ctx, (String)iiwc.updateBeginWeightedAveragePrice(periodInfo, tempTableName, devInWarehsTempTable));
            }
            if (price.compareTo((Object)PriceEnum.UNIT_STANDARD_PRICE) == 0) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateUnitStandardPrice(periodInfo, tempTableName));
            }
            if (price.compareTo((Object)PriceEnum.LAST_TIME_NEW_PAYOUT_PRICE) == 0) {
                iiwc.updateLastTimeNewPayoutPrice(ctx, periodInfo, tempTableName, calparams);
            }
            if (price.compareTo((Object)PriceEnum.NEW_INPOUR_PRICE) == 0) {
                iiwc.updateNewInpourPrice(ctx, periodInfo, tempTableName, calparams);
            }
            if (price.compareTo((Object)PriceEnum.NEW_PAYOUT_PRICE) == 0) {
                iiwc.updateNewPayoutPrice(ctx, periodInfo, tempTableName, calparams);
            }
            if (price.compareTo((Object)PriceEnum.THIS_PERIOD_AVERAGE_INPOUR_PRICE) == 0) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateThisPeriodAverageInpourPrice(periodInfo, tempTableName, null, calparams));
            }
            if (price.compareTo((Object)PriceEnum.THIS_PERIOD_AVERAGE_PAYOUT_PRICE) == 0) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateThisPeriodAveragePayoutPrice(periodInfo, tempTableName, null, calparams));
            }
            if (price.compareTo((Object)PriceEnum.THIS_PERIOD_AVERAGE_INPOUR_PLUS_PRICE) == 0) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateThisPeriodAverageInpourPrice(periodInfo, tempTableName, ">0", calparams));
            }
            if (price.compareTo((Object)PriceEnum.THIS_PERIOD_AVERAGE_PAYOUT_PLUS_PRICE) == 0) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateThisPeriodAveragePayoutPrice(periodInfo, tempTableName, ">0", calparams));
            }
            if (price.compareTo((Object)PriceEnum.THIS_PERIOD_AVERAGE_INPOUR_MINUS_PRICE) == 0) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateThisPeriodAverageInpourPrice(periodInfo, tempTableName, "<0", calparams));
            }
            if (price.compareTo((Object)PriceEnum.THIS_PERIOD_AVERAGE_PAYOUT_MINUS_PRICE) == 0) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateThisPeriodAveragePayoutPrice(periodInfo, tempTableName, "<0", calparams));
            }
        }
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        return this._query(ctx, params, 0, -1);
    }

    protected String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private String[][] getBeginDataTableField() {
        String[][] fields = new String[][]{{"FMaterialId", "varchar(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FStorageOrgUnitID", "VARCHAR(44)"}, {"FWarehouseID", "VARCHAR(44)"}, {"FPeriodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodBeginBalance", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FLot", "NVARCHAR(80)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}};
        return fields;
    }

    @Override
    protected Map _getCustomConditionData(Context ctx, RptParams params) throws BOSException, EASBizException {
        HashMap<String, Object> rs = new HashMap<String, Object>();
        if (params.getString("COMPANY_ID") != null && params.getString("COMPANY_ID").length() != 0) {
            CompanyOrgUnitInfo cinfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(params.getString("COMPANY_ID")));
            rs.put("COMPANY_ID", cinfo);
        }
        if (params.getString("MATERIAL_ID_FROM") != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)params.getString("MATERIAL_ID_FROM"), CompareType.INCLUDE));
            view.setFilter(filterInfo);
            MaterialCollection mtoinfos = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
            rs.put("MATERIAL_ID_FROM", mtoinfos.toArray());
        }
        if (params.getString("MATERIAL_ID_TO") != null && params.getString("MATERIAL_ID_TO").length() != 0) {
            MaterialInfo mtoinfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(params.getString("MATERIAL_ID_TO")));
            rs.put("MATERIAL_ID_TO", mtoinfo);
        }
        if (params.getString("BILLTYPE_ID") != null && params.getString("BILLTYPE_ID").length() != 0) {
            BillTypeInfo btinfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(params.getString("BILLTYPE_ID")));
            rs.put("BILLTYPE_ID", btinfo);
        }
        return rs;
    }

    @Override
    protected Map _fetchDataByCou(Context ctx, CompanyOrgUnitInfo cou) throws BOSException, EASBizException {
        HashMap<String, Object> rs = new HashMap<String, Object>();
        if (cou == null) {
            return rs;
        }
        OrgUnitCollection orgCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(cou.getId().toString(), 1, 4);
        rs.put("FromUnit", orgCol);
        rs.put(cou.getId().toString() + "curPeriod", SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou));
        rs.put("companyAddInfo", CalRptUtilFacadeFactory.getLocalInstance(ctx).fetchInitFilterData(cou.getId().toString()));
        return rs;
    }

    @Override
    protected void _verdictGetDaulPrice(Context ctx, RptParams params, String tempTableName) throws BOSException, EASBizException {
        try {
            this.verdictIsGetDaulPrice(ctx, params, tempTableName);
        }
        catch (CalculateException e) {
            this.updateZeroCost(ctx, params, tempTableName);
            params.setObject("EXCEPTION", (Object)e);
        }
    }

    private void updateFinalTableSumData(Context ctx, String finalTable, RptParams params) throws BOSException {
        int count = params.getInt("TOTAL_COUNT");
        int calSumCondition = params.getInt("SUMCONDITION");
        if (count == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        String total1 = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.TOTALTITLE");
        sql.append(" update ").append(finalTable).append(" set SEQ = KSQL_SEQ; ");
        sql.append(" insert into  ").append(finalTable);
        sql.append(" ( FSTORAGEORG, MaterialNumber, FCostCenterNumber, FDeptNumber, FBASEQTY, FActualCost)");
        sql.append(" select '").append(calSumCondition == 1 || calSumCondition == 2 ? total1 : "").append("' AS FSTORAGEORG,");
        sql.append("'").append(calSumCondition == 0 ? total1 : "").append("' AS MaterialNumber, ");
        sql.append("'").append(calSumCondition == 4 ? total1 : "").append("' AS FCostCenterNumber,");
        sql.append("'").append(calSumCondition == 3 ? total1 : "").append("' AS FDeptNumber,");
        sql.append("sum(isnull(FBASEQTY, 0)) sumQty, sum(isnull(FActualCost,0)) sumCost from ").append(finalTable).append(";");
        sql.append(" update ").append(finalTable).append(" set SEQ = ").append(count).append(" where SEQ is null;");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String insertFinalTable(Context ctx, RptParams params, String gatherTableName) throws BOSException, EASBizException {
        String materialGroupStandardID = params.getString("MATERIALGROUPSTANDARD_ID");
        try {
            this.verdictIsGetDaulPrice(ctx, params, gatherTableName);
        }
        catch (CalculateException e) {
            this.updateZeroCost(ctx, params, gatherTableName);
            params.setObject("EXCEPTION", (Object)e);
        }
        String finalTableName = DBUtil.createTempTable(ctx, this.getFinalTempTable());
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        StringBuffer sql = new StringBuffer("select ");
        if (params != null && params.getInt("SUMCONDITION") == 1) {
            sql.append(" Org.FNumber AS FSTORAGEORG,Org.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS FSTORAGEORGName");
        } else if (params != null && params.getInt("SUMCONDITION") != 2) {
            sql.append(" '' AS FSTORAGEORG,'' AS FSTORAGEORGName");
        }
        if (params != null && params.getInt("SUMCONDITION") == 2) {
            sql.append(" Org.FNumber AS FSTORAGEORG,Org.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS FSTORAGEORGName");
            sql.append(" ,Warehouse.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS FWarehouseName");
        } else {
            sql.append(" ,'' AS FWarehouseName");
        }
        if (params != null && params.getInt("SUMCONDITION") == 3) {
            sql.append(" ,DEPT.FNumber AS FDeptNumber,DEPT.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS FAdminOrgUnitName");
        } else {
            sql.append(" ,'' AS FDeptNumber, '' AS FAdminOrgUnitName");
        }
        if (params != null && params.getInt("SUMCONDITION") == 4) {
            sql.append(" ,COSTCENTER.FNumber AS FCostCenterNumber, COSTCENTER.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS FCostCenterOrgUnitName");
        } else {
            sql.append(" ,'' AS FCostCenterNumber, '' AS FCostCenterOrgUnitName");
        }
        sql.append(" ,MATERIAL.FNumber AS MaterialNumber").append("\t\n");
        sql.append(" ,MATERIAL.FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()) + " AS MATERIALFName");
        sql.append(", MATERIAL.FSHORTNAME AS SHORTNAME");
        sql.append(" ,MATERIAL.FModel AS MATERIALFModel").append("\t\n");
        sql.append(" ,ENTRY.FLot");
        sql.append(",AssAttr.FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()) + " as AssistPropertyName");
        sql.append(",PJ.FNumber as ProjectNumber");
        sql.append(",TN.FNumber as TrackNumberNumber");
        sql.append(" ,MEASUREUNIT.FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()) + " AS MEASUREUNITFName").append("\t\n");
        sql.append(" ,Entry.FBASEQTY ");
        sql.append(" ,Entry.FActualBaseUnitCost");
        sql.append(" ,Entry.FActualCost").append("\t\n");
        sql.append(" ,Entry.FQtyPrecision");
        sql.append(" ,Entry.FPricePrecision");
        sql.append(" ,Entry.FLocalCurrencyPrecision").append("\t\n");
        sql.append(" ,Entry.FSTORAGEORGUNITID");
        sql.append(" ,Entry.FWAREHOUSEID");
        sql.append(" ,Entry.FMATERIALID");
        sql.append(" ,Entry.FCOMPANYORGUNITID");
        sql.append(" ,Entry.FID");
        sql.append(" ,Entry.FAccountType");
        sql.append(" FROM ");
        sql.append(gatherTableName).append(" Entry");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON Entry.FMaterialID = MATERIAL.FId").append("\t\n");
        sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT");
        sql.append(" ON MATERIAL.FBaseUnit = MEASUREUNIT.FID").append("\t\n");
        sql.append(" LEFT OUTER JOIN t_org_baseunit Org").append("\t\n");
        sql.append(" ON Entry.FSTORAGEORGUNITID = Org.Fid");
        sql.append(" LEFT OUTER JOIN T_DB_WAREHOUSE Warehouse").append("\t\n");
        sql.append(" ON Entry.FWarehouseID = Warehouse.Fid");
        sql.append(" INNER JOIN T_BD_MaterialGroupDetial T").append("\t\n");
        sql.append(" ON Entry.FMaterialID = T.FMaterialID AND T.FMaterialGroupStandardID = ");
        sql.append("'").append(materialGroupStandardID).append("'");
        sql.append(" INNER JOIN T_BD_MaterialGroup T2").append("\t\n");
        sql.append(" ON T.FMaterialGroupId = T2.FID");
        sql.append(" LEFT JOIN T_ORG_Admin DEPT ON DEPT.FID = Entry.FAdminOrgUnitID ");
        sql.append(" left join T_BD_AsstAttrValue AssAttr on AssAttr.FID = Entry.FAssistPropertyID ");
        sql.append(" left join T_MM_Project PJ on PJ.FID = Entry.FProjectID ");
        sql.append(" left join T_MM_TrackNumber TN on TN.FID = Entry.FTrackNumberID ");
        if (params.getInt("SUMCONDITION") == 4) {
            sql.append("LEFT JOIN T_ORG_CostCenter COSTCENTER ON COSTCENTER.FID = Entry.FCostCenterOrgUnitID");
        }
        if (params.getBoolean("ckBxMShortName") && (params.getString("txtMShortNameFrom").length() > 0 || params.getString("txtMShortNameTo").length() > 0)) {
            if (params.getString("txtMShortNameFrom").length() > 0 && params.getString("txtMShortNameTo").length() > 0) {
                sql.append(" WHERE MATERIAL.FSHORTNAME >='").append(params.getString("txtMShortNameFrom").trim() + "'").append(" AND MATERIAL.FSHORTNAME<= '").append(params.getString("txtMShortNameTo").trim()).append("'");
            } else if (params.getString("txtMShortNameFrom").length() > 0 && params.getString("txtMShortNameTo").length() <= 0) {
                sql.append(" WHERE MATERIAL.FSHORTNAME >= '").append(params.getString("txtMShortNameFrom").trim()).append("'");
            } else if (params.getString("txtMShortNameFrom").length() <= 0 && params.getString("txtMShortNameTo").length() > 0) {
                sql.append(" WHERE ").append(" MATERIAL.FSHORTNAME<= '").append(params.getString("txtMShortNameTo").trim()).append("'");
            }
        }
        sql.append(" order by FSTORAGEORG,FWarehouseName,MaterialNumber,SHORTNAME");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into  ").append(finalTableName);
        insertSql.append(" (KSQL_SEQ, FSTORAGEORG, FSTORAGEORGName, FWarehouseName, FDeptNumber, FAdminOrgUnitName, FCostCenterNumber, FCostCenterOrgUnitName, ");
        insertSql.append(" MaterialNumber, MATERIALFName, SHORTNAME, MATERIALFModel, FLot, AssistPropertyName, ProjectNumber, TrackNumberNumber, MEASUREUNITFName,");
        insertSql.append(" FBASEQTY, FActualBaseUnitCost, FActualCost, FQtyPrecision, FPricePrecision, FLocalCurrencyPrecision, ");
        insertSql.append(" FSTORAGEORGUNITID, FWAREHOUSEID, FMATERIALID, FCOMPANYORGUNITID, FID, FAccountType)");
        insertSql.append(sql);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return finalTableName;
    }

    private String getFinalTempTable() {
        StringBuffer sb = new StringBuffer();
        sb.append("Create Table TempReportTable(");
        sb.append(" KSQL_SEQ INT IDENTITY(1,1) ,");
        sb.append(" SEQ INT ,");
        sb.append(" FSTORAGEORG varchar(44),");
        sb.append(" FSTORAGEORGName nvarchar(300),");
        sb.append(" FWarehouseName nvarchar(300),");
        sb.append(" FDeptNumber nvarchar(44), ");
        sb.append(" FAdminOrgUnitName nvarchar(300),");
        sb.append(" FCostCenterNumber nvarchar(300),");
        sb.append(" FCostCenterOrgUnitName nvarchar(300),");
        sb.append(" MaterialNumber nvarchar(300),");
        sb.append(" MATERIALFName nvarchar(300),");
        sb.append(" SHORTNAME nvarchar(300),");
        sb.append(" MATERIALFModel nvarchar(300),");
        sb.append(" FLot nvarchar(300),");
        sb.append(" AssistPropertyName nvarchar(300),");
        sb.append(" ProjectNumber nvarchar(300),");
        sb.append(" TrackNumberNumber nvarchar(300),");
        sb.append(" MEASUREUNITFName  nvarchar(300),");
        sb.append(" FBASEQTY Decimal(28,10) not null default 0,");
        sb.append(" FActualBaseUnitCost Decimal(28,10) not null default 0,");
        sb.append(" FActualCost Decimal(28,10) not null default 0,");
        sb.append(" FQtyPrecision int,");
        sb.append(" FPricePrecision int,");
        sb.append(" FLocalCurrencyPrecision int,");
        sb.append(" FSTORAGEORGUNITID varchar(44),");
        sb.append(" FWAREHOUSEID varchar(44),");
        sb.append(" FMATERIALID varchar(44),");
        sb.append(" FCOMPANYORGUNITID varchar(44),");
        sb.append(" FID varchar(44),");
        sb.append(" FAccountType varchar(44)");
        sb.append(" );");
        return sb.toString();
    }

    @Override
    protected void _updateImportPrice(Context ctx, RptParams params) throws BOSException {
        String tempTableName = params.getString("TEMPTABLE");
        String finalTempTableName = params.getString("FINALTABLE");
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(finalTempTableName).append(" A set (FActualBaseUnitCost,FActualCost) = (");
        sql.append(" select FActualBaseUnitCost,FActualCost from ").append(tempTableName).append(" B where A.fid = B.fid );");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

