/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.app.AbstractCostCalChkFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.calculate.InvBillShareSqlGenerator;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

public class CostCalChkFacadeControllerBean
extends AbstractCostCalChkFacadeControllerBean {
    private static final long serialVersionUID = 1L;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _isExistUnAuditBill(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        String costMaterialRange;
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(ctx, null);
        InvBillShareSqlGenerator sqlGenertor = this.getSqlGengateForCondition(params);
        if (params != null) {
            costMaterialRange = params.getString("CALCULATEMATERIALRANGE");
            sqlGenertor.setCostMaterialRange(costMaterialRange);
        }
        sqlGenertor.setExtendWhereCondition(false);
        sqlGenertor.setFilterBillstatus(true);
        sqlGenertor.setBillStatus(2);
        if (params != null && params.getString("CALCULATEMATERIALRANGE") != null) {
            costMaterialRange = params.getString("CALCULATEMATERIALRANGE");
            sqlGenertor.setCostMaterialRange(costMaterialRange);
        }
        StringBuffer bf = new StringBuffer();
        bf.append(sqlGenertor.getInBillSql());
        bf.append("\n UNION ALL ");
        bf.append(sqlGenertor.getStandArdAdjBillSql());
        IRowSet rowSet = null;
        try {
            rowSet = sysTempTableHelper.executeQuery(bf.toString());
            if (rowSet.next()) {
                throw new CalculateException(CalculateException.BILLUNAUDIT);
            }
            String billSQL = sqlGenertor.getOutBillSql();
            rowSet = sysTempTableHelper.executeQuery(billSQL);
            if (rowSet.next()) {
                throw new CalculateException(CalculateException.BILLUNAUDIT);
            }
            billSQL = sqlGenertor.getCostAdjustBillSql(-1);
            rowSet = sysTempTableHelper.executeQuery(billSQL);
            if (rowSet.next()) {
                throw new CalculateException(CalculateException.BILLUNAUDIT);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (CalculateException e2) {
                    throw new CalculateException(CalculateException.BILLUNAUDIT);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowSet);
                sysTempTableHelper.releaseConnection();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowSet);
        sysTempTableHelper.releaseConnection();
        return false;
    }

    @Override
    protected boolean _isExistInBillPriceIsZero(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        Set storageOrgBegs = null;
        Object wareHouseIds = null;
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(ctx, null);
        InvBillShareSqlGenerator sqlGenertor = this.getSqlGengateForCondition(params);
        storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
        if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
            String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
            sqlGenertor.setQueryStorageIds(orgIds);
            sqlGenertor.setIsFilterStorage(true);
            sqlGenertor.setIsFromCostChk(true);
        }
        if (params != null && params.getString("CALCULATEMATERIALRANGE") != null) {
            String costMaterialRange = params.getString("CALCULATEMATERIALRANGE");
            sqlGenertor.setCostMaterialRange(costMaterialRange);
        }
        sqlGenertor.setExtendWhereCondition(true);
        sqlGenertor.setFilterBillstatus(true);
        sqlGenertor.setFilterCostMove(true);
        sqlGenertor.setFilterMatChange(true);
        sqlGenertor.setExtendWhereCondition(" Entry.FunitActualcost <= 0 AND ENTRY.FISPRESENT =0 ");
        String billSQL = sqlGenertor.getInBillSqlForMoveInWarehsbill();
        billSQL = "SELECT TOP 1 T.FCompanyOrgUnitID FROM (" + billSQL + ") AS T";
        IRowSet rowSet = null;
        try {
            rowSet = sysTempTableHelper.executeQuery(billSQL);
            if (rowSet.next()) {
                throw new CalculateException(CalculateException.INBILLPRICEZERO);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
            sysTempTableHelper.releaseConnection();
        }
        return false;
    }

    private InvBillShareSqlGenerator getSqlGengateForCondition(CalculateParams params) {
        Set storageOrgBegs = null;
        Set wareHouseIds = null;
        PeriodInfo period = (PeriodInfo)params.getObject("PERIOD_OBJ");
        String companyOrgID = params.getString("COMPANY_ID");
        String calType = params.getString("CALTYPE");
        InvBillShareSqlGenerator sqlGenertor = new InvBillShareSqlGenerator();
        sqlGenertor.setPeriod(period);
        sqlGenertor.setCompanyOrgUnitId(companyOrgID);
        sqlGenertor.setFilterIsCalculate(true);
        sqlGenertor.setCalcualte(true);
        if ("1".equals(calType)) {
            storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sqlGenertor.setQueryStorageIds(orgIds);
                sqlGenertor.setIsFilterStorage(true);
                sqlGenertor.setIsFromCostChk(true);
            }
        } else if ("2".equals(calType)) {
            storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sqlGenertor.setQueryStorageIds(orgIds);
                sqlGenertor.setIsFilterStorage(true);
                sqlGenertor.setIsFromCostChk(true);
            }
            if ((wareHouseIds = (Set)params.getObject("WAREHOUSEID")) != null && wareHouseIds.size() > 0) {
                String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
                sqlGenertor.setQueryWarehsoueNumbers(warehouseIds);
                sqlGenertor.setIsFilterWarehouse(true);
                sqlGenertor.setIsFromCostChk(true);
            }
        }
        if (!StringUtil.isEmpty((String)params.getString("MATERIAL_FROM"))) {
            sqlGenertor.setIsFilterMaterial(true);
            sqlGenertor.setQueryStartMaterialNumber(params.getString("MATERIAL_FROM"));
        }
        if (!StringUtil.isEmpty((String)params.getString("MATERIAL_TO"))) {
            sqlGenertor.setIsFilterMaterial(true);
            sqlGenertor.setQueryEndMaterialNumber(params.getString("MATERIAL_TO"));
        }
        return sqlGenertor;
    }
}

