/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.app.AbstractCostComputeReportPriceSourceControllerBean;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CostComputeReportPriceSourceControllerBean
extends AbstractCostComputeReportPriceSourceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.CostComputeReportPriceSourceControllerBean");

    @Override
    protected RptRowSet _getMaterialList(Context ctx, EntityViewInfo entityViewInfo) throws BOSException {
        RptRowSet rs = null;
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT DISTINCT");
            sql.append("  MATERIAL.FNumber AS MATERIALNUMBER");
            sql.append(", Material.FID AS MATERIALID");
            sql.append(", Material.FName_").append(ctx.getLocale()).append(" AS MATERIALNAME");
            sql.append(", Material.FSHORTNAME AS MATERIALSHORTNAME");
            sql.append(", MATERIALCOMPANY.FACCOUNTTYPE AS MATERIALCOMPANYACCOUNTTYPE");
            sql.append(", MATERIALCOMPANY.FIsLot AS isLot");
            sql.append(", MATERIALCOMPANY.FIsAssistProperty AS isAssistProperty");
            sql.append(", MATERIALCOMPANY.FIsProject AS isProject");
            sql.append(", MATERIALCOMPANY.FIsTrackNumber AS isTrackNumber");
            sql.append(" FROM");
            sql.append(" T_CL_CostComputePriceReport COSTCOMPUTEREPORT");
            sql.append(" LEFT OUTER  JOIN T_DB_WAREHOUSE WAREHOUSE ON COSTCOMPUTEREPORT.FWarehouseID = WAREHOUSE.FID");
            sql.append(" LEFT OUTER JOIN T_ORG_Storage STORAGEORG ON COSTCOMPUTEREPORT.FStorageOrgUnitID = STORAGEORG.FID");
            sql.append(" INNER JOIN T_BD_Material MATERIAL ON COSTCOMPUTEREPORT.FMaterialID = MATERIAL.FID");
            sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ON (");
            sql.append(" COSTCOMPUTEREPORT.FMaterialID = MATERIALCOMPANY.FMaterialID");
            sql.append(" AND COSTCOMPUTEREPORT.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID");
            sql.append(" )");
            sql.append("\n LEFT OUTER JOIN T_BD_AsstAttrValue ASS ON ASS.FID = COSTCOMPUTEREPORT.FAssistPropertyID");
            sql.append("\n LEFT OUTER JOIN T_MM_PROJECT PRO ON PRO.FID = COSTCOMPUTEREPORT.FProjectID");
            sql.append("\n LEFT OUTER JOIN T_MM_TrackNumber TRA ON TRA.FID = COSTCOMPUTEREPORT.FTrackNumberID");
            sql.append(" WHERE ");
            sql.append(" MATERIAL.FSTATUS = ").append(1);
            sql.append(" AND MATERIALCOMPANY.FSTATUS =").append(1);
            if (entityViewInfo != null && entityViewInfo.getFilter() != null) {
                String wheresql = entityViewInfo.getFilter().toString();
                wheresql = wheresql.replaceAll("FINANCEORG.ID", "FCompanyOrgUnitID");
                wheresql = wheresql.replaceAll("WAREHOUSE.NUMBER", "WAREHOUSE.FNumber");
                wheresql = wheresql.replaceAll("STORAGEORG.NUMBER", "STORAGEORG.FNumber");
                wheresql = wheresql.replaceAll("MATERIAL.NUMBER", "MATERIAL.FNUMBER");
                wheresql = wheresql.replaceAll("MATERIAL.ID", "MATERIAL.FID");
                wheresql = wheresql.replaceAll("MATERIAL.SHORTNAME", "MATERIAL.FSHORTNAME");
                wheresql = wheresql.replaceAll("PERIOD", "COSTCOMPUTEREPORT.FPERIOD");
                wheresql = wheresql.replaceAll("YEAR", "COSTCOMPUTEREPORT.FYEAR");
                wheresql = wheresql.replaceAll("MATERIALCOMPANY.ACCOUNTTYPE", "MATERIALCOMPANY.FACCOUNTTYPE");
                wheresql = wheresql.replaceAll("Lot", "COSTCOMPUTEREPORT.FLot");
                wheresql = wheresql.replaceAll("AssistProperty.number", "ASS.FNumber");
                wheresql = wheresql.replaceAll("Project.number", "PRO.FNumber");
                wheresql = wheresql.replaceAll("trackNumber.number", "TRA.FNumber");
                wheresql = wheresql.replaceAll("PARENT.ID", "COSTCOMPUTEREPORT.FPARENTID");
                sql.append(" AND ").append(wheresql);
            }
            sql.append(" ORDER BY");
            sql.append(" MATERIAL.FNumber ASC");
            rs = DBUtil.executeQuery((String)sql.toString(), (Connection)conn);
        }
        catch (SQLException e) {
            logger.info((Object)e);
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)conn);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _deleteComputeReport(Context ctx, HashMap params) throws BOSException {
        String tempTable = "";
        try {
            int periodNumFrom = (Integer)params.get("periodNumFrom");
            int periodNumTo = (Integer)params.get("periodNumTo");
            String companyId = (String)params.get("companyId");
            boolean isRemain = (Boolean)params.get("isRemain");
            int remainCount = (Integer)params.get("remainCount");
            StringBuffer sql = new StringBuffer();
            sql.append(" create table temp (fid varchar(44),fperiodid varchar(44),fcount int,FAccountType int )");
            tempTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" insert into ").append(tempTable);
            sql.append(" (fid,fperiodid,fcount,FAccountType) ");
            sql.append(" select T1.fid,T1.fperiodid,T1.fcount,T1.FAccountType from T_CL_CostComputeRportHeader T1 ");
            sql.append(" inner join T_bd_period T2 on T1.fperiodid = T2.fid ");
            sql.append(" where T1.fcompanyid =  ? and T2.fnumber >= ? and T2.fnumber <= ?");
            KsqlUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodNumFrom, periodNumTo});
            IRowSet rs = null;
            sql.setLength(0);
            if (isRemain) {
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < remainCount; ++i) {
                    sql.append(" select  top 1 max(fcount) fcount ,fperiodid from ");
                    sql.append(tempTable).append(" group by fperiodid,FAccountType order by fcount desc ");
                    rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        while (rs.next()) {
                            paramList.add(new Object[]{rs.getInt("fcount"), rs.getString("fperiodid")});
                        }
                        sql.setLength(0);
                        sql.append(" delete from ").append(tempTable);
                        sql.append(" where fcount = ? and fperiodid = ? ");
                        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramList);
                        sql.setLength(0);
                        paramList.clear();
                        continue;
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            sql.setLength(0);
            sql.append(" delete from T_CL_CostComputeRportHeader where fid in (select  fid from ");
            sql.append(tempTable).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" delete from T_CL_CostComputePriceReport where fparentid in (select  fid from ");
            sql.append(tempTable).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
        }
    }

    @Override
    protected HashSet _getPeriodMaxCountID(Context ctx, String companyId, String periodId, int accountType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid  from T_CL_CostComputeRportHeader where fcount in (");
        sql.append(" select max(fcount) maxCount  from ");
        sql.append(" T_CL_CostComputeRportHeader where fcompanyid = ? and fperiodid = ?  ");
        if (accountType != 0) {
            sql.append(" and FAccountType = ?  ");
        }
        sql.append(" group by FAccountType )");
        sql.append(" and fcompanyid = ? and fperiodid = ?  ");
        IRowSet rs = accountType != 0 ? KsqlUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodId, accountType, companyId, periodId}) : KsqlUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId, periodId, companyId, periodId});
        HashSet<String> maxIDSet = new HashSet<String>();
        try {
            while (rs.next()) {
                maxIDSet.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return maxIDSet;
    }
}

