/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class CostComputeSumRptServer
extends ReportServerBase {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.CostComputeSumRptServer");
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";
    private String calType = null;

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        return null;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        StringBuffer buffer = new StringBuffer();
        buffer.append(SCMUtils.getResource((String)this.res, (String)"FCOMPANYNUMBER", (Context)this.getContext()));
        buffer.append(":");
        buffer.append(filter.getString("companyNumber") == null ? "" : filter.getString("companyNumber"));
        titles.AddTitle(0, buffer.toString());
        buffer.setLength(0);
        buffer.append(SCMUtils.getResource((String)this.res, (String)"STORAGEORG", (Context)this.getContext()));
        buffer.append(":");
        buffer.append(filter.getString("stroageNumber") == null ? "" : filter.getString("stroageNumber"));
        titles.AddTitle(1, buffer.toString());
        buffer.setLength(0);
        buffer.append(SCMUtils.getResource((String)this.res, (String)"WAREHOUSENUM", (Context)this.getContext()));
        buffer.append(":");
        buffer.append(filter.getString("warehouseNumber") == null ? "" : filter.getString("warehouseNumber"));
        titles.AddTitle(2, buffer.toString());
        buffer.setLength(0);
        buffer.append(SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)this.getContext()));
        buffer.append(":");
        if (filter.getObject("materialnumberfrom") != null) {
            if (filter.getObject("materialnumberfrom") instanceof Object[]) {
                Object[] materialnumberfrom = (Object[])filter.getObject("materialnumberfrom");
                for (int i = 0; i < materialnumberfrom.length; ++i) {
                    if (i != 0) {
                        buffer.append("; ");
                    }
                    buffer.append(((MaterialInfo)materialnumberfrom[i]).getNumber());
                }
            } else {
                buffer.append(filter.getString("materialnumberfrom"));
            }
        }
        if (filter.getString("materialnumberto") != null) {
            buffer.append("---");
            buffer.append(filter.getString("materialnumberto"));
        }
        titles.AddTitle(3, buffer.toString());
        return titles;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String tmpeTableName = DBUtil.createTempTable(ctx, "temp", this.getcretateTmpeTableSql());
        String couNumber = filter.getString("companyNumber");
        CompanyOrgUnitInfo cou = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo("where number = '" + couNumber + "'");
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)cou.getId().toString(), (String)"invOutSumRpt_View");
        if (checkPermission) {
            String CostComputeSumRptTempName = DBUtil.createTempTable(this.getContext(), "CostComputeSumRptTemp", this.getcretateTmpeTableSqlForReport());
            DBUtil.execute((Context)this.getContext(), (String)(this.getInsertSqlForReport(filter, CostComputeSumRptTempName) + this.getSqlForReport(filter)));
            DBUtil.createTempTableIndex(this.getContext(), tmpeTableName, "fwarehouseNumber,FMaterialNumber", false);
            DBUtil.execute((Context)this.getContext(), (String)this.getInsertSql(filter, tmpeTableName, CostComputeSumRptTempName));
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)this.getContext());
                DBUtil.AnalyseTable(this.getContext(), conn, tmpeTableName);
                String sql = this.getUpdateSql(filter, tmpeTableName);
                if (sql.length() > 0) {
                    DBUtil.execute((Context)this.getContext(), (String)sql);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        return tmpeTableName;
    }

    private String getSqlForReport(RptParams filter) throws BOSException, EASBizException {
        String strCalType = this.getCalType(filter, true);
        String oprtState = filter.getString("oprtState");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" a.FMATERIALID AS FMATERIALID,a.FLot AS FLot,FAssistPropertyID AS FAssistPropertyID,");
        sql.append(" a.FProjectID AS FProjectID,a.FTrackNumberID AS FTrackNumberID,");
        sql.append(" a.FCOMPANYORGUNITID AS FCOMPANYORGUNITID,a.FYEAR AS FYEAR,a.FPERIOD AS FPERIOD,");
        sql.append("\n CASE WHEN MAX(FIsSusccessed)>1 THEN MAX(FIsSusccessed)");
        sql.append("\n WHEN MIN(FIsSusccessed)<1 THEN MIN(FIsSusccessed)");
        sql.append("\n ELSE  1 END as FIsSusccessed ,");
        sql.append(" MAX(a.FTIMESERIALNUMBER) AS FTIMESERIALNUMBER ");
        if ("2".equals(strCalType)) {
            sql.append(",a.fstorageorgunitid,a.fwarehouseid");
        } else if ("1".equals(strCalType)) {
            sql.append(",a.fstorageorgunitid");
        }
        sql.append(" FROM T_CL_COSTCOMPUTEREPORT a");
        sql.append("\n INNER JOIN T_ORG_COMPANY b on a.FCompanyOrgUnitID = b.FID");
        sql.append("\n INNER JOIN T_BD_MaterialCompanyInfo AS MATERIALCOMPANY ");
        sql.append("\n ON a.FMaterialID = MATERIALCOMPANY.FMaterialID ");
        sql.append("\n AND a.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID");
        sql.append("\n AND a.FAccountType = MATERIALCOMPANY.FAccountType");
        sql.append("\n WHERE ").append("b.FNumber = '").append(filter.getString("companyNumber")).append("'");
        if ("rawMaterailCostCal".equals(oprtState)) {
            sql.append("\n AND MATERIALCOMPANY.FCalculateType = ").append(0);
        } else if ("fishedGoodsCostCal".equals(oprtState)) {
            sql.append("\n AND MATERIALCOMPANY.FCalculateType <> ").append(0);
        }
        sql.append("\n GROUP BY a.FMATERIALID,a.FLot,FAssistPropertyID,a.FProjectID,a.FTrackNumberID ");
        sql.append("\n ,a.FCOMPANYORGUNITID,a.FYEAR,a.FPERIOD");
        if ("2".equals(strCalType)) {
            sql.append(",a.fstorageorgunitid,a.fwarehouseid");
        } else if ("1".equals(strCalType)) {
            sql.append(",a.fstorageorgunitid");
        }
        return sql.toString();
    }

    private String getInsertSqlForReport(RptParams filter, String tmpTableName) throws BOSException, EASBizException {
        String strCalType = this.getCalType(filter, true);
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(tmpTableName).append("(");
        buffer.append("FMaterialid,FLot,FAssistPropertyID,FProjectID,FTrackNumberID,FCompanyOrgUnitID,FYear,FPERIOD,FIsSusccessed,FTIMESERIALNUMBER");
        if ("2".equals(strCalType)) {
            buffer.append(",fstorageorgunitid,fwarehouseid");
        } else if ("1".equals(strCalType)) {
            buffer.append(",fstorageorgunitid");
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String[][] getcretateTmpeTableSqlForReport() {
        String[][] fields = new String[][]{{"FMaterialid", "VARCHAR(44)"}, {"FLot", "NVARCHAR(80)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}, {"FCompanyOrgUnitID", "VARCHAR(44) "}, {"FYear", "int DEFAULT 0 "}, {"FPERIOD", "int DEFAULT 0  "}, {"FTIMESERIALNUMBER", "VARCHAR(44)"}, {"fwarehouseid", "VARCHAR(44)"}, {"fstorageorgunitid", "VARCHAR(44)"}, {"FIsSusccessed", "int DEFAULT 1"}};
        return fields;
    }

    private String getUpdateSql(RptParams filter, String tmpeTableName) throws EASBizException, BOSException {
        StringBuffer buffer = new StringBuffer();
        String strCalType = this.getCalType(filter, true);
        buffer.append("UPDATE ").append(tmpeTableName).append(" AS T1 ");
        buffer.append(" SET (FStatus,FStatusName)=(");
        buffer.append("\n SELECT 0,N'").append(SCMUtils.getResource((String)this.res, (String)"COMPUTEFAIL", (Context)this.getContext())).append("' FROM (");
        buffer.append("\n SELECT T2.FCOMPANYORGUNITID,T2.FMATERIALID ,T2.Fstatus,T2.Fstatusname");
        buffer.append(this.getFieldByCalType(strCalType));
        buffer.append("\n FROM ");
        buffer.append(tmpeTableName).append(" T2 ");
        buffer.append("\n WHERE (Fstatus = 0 OR Fstatus=2) ");
        buffer.append("\n GROUP BY T2.FCOMPANYORGUNITID,T2.FMATERIALID,T2.Fstatus,T2.Fstatusname");
        buffer.append(this.getFieldByCalType(strCalType));
        buffer.append(") temp ");
        buffer.append("\n WHERE T1.FCOMPANYORGUNITID= temp.FCOMPANYORGUNITID AND T1.FMATERIALID = temp.FMATERIALID ");
        if ("2".equals(strCalType)) {
            buffer.append("AND T1.fstorageorgunitid=temp.fstorageorgunitid AND T1.fwarehouseid =temp.fwarehouseid");
        } else if ("1".equals(strCalType)) {
            buffer.append("AND T1.fstorageorgunitid=temp.fstorageorgunitid ");
        }
        buffer.append(" AND (T1.Fstatus = 0 OR T1.Fstatus=2)");
        buffer.append(")");
        DBUtil.execute((Context)this.getContext(), (String)buffer.toString());
        StringBuffer sql = new StringBuffer();
        buffer = new StringBuffer();
        buffer.append("\n SELECT T2.FCOMPANYORGUNITID,T2.FMATERIALID ,T2.Fstatus,T2.Fstatusname,T2.FAccountType ");
        buffer.append(this.getFieldByCalType(strCalType));
        buffer.append("\n FROM ");
        buffer.append(tmpeTableName).append(" T2 ");
        buffer.append("\n WHERE (T2.Fstatus = 0) ");
        buffer.append("\n GROUP BY T2.FCOMPANYORGUNITID,T2.FMATERIALID,T2.Fstatus,T2.Fstatusname,T2.FAccountType ");
        buffer.append(this.getFieldByCalType(strCalType));
        IRowSet rs = DBUtil.executeQuery((Context)this.getContext(), (String)buffer.toString());
        try {
            if (rs != null && rs.next()) {
                sql.append("UPDATE ").append(tmpeTableName).append(" AS T1 ");
                sql.append(" SET (FStatus,FStatusName)=(");
                sql.append("\n SELECT 0,N'").append(SCMUtils.getResource((String)this.res, (String)"COMPUTEFAIL", (Context)this.getContext())).append("' FROM (");
                sql.append("\n SELECT T2.FCOMPANYORGUNITID,T2.FMATERIALID ,T2.Fstatus,T2.Fstatusname,T2.FLot,T2.FAssistProperty,T2.FProjectNUmber,T2.FTrackNumber");
                sql.append(this.getFieldByCalType(strCalType));
                sql.append("\n FROM ");
                sql.append(tmpeTableName).append(" T2 ");
                sql.append("\n WHERE T2.Fstatus = 0 ");
                sql.append("\n GROUP BY T2.FCOMPANYORGUNITID,T2.FMATERIALID,T2.Fstatus,T2.Fstatusname,T2.FLot,T2.FAssistProperty,T2.FProjectNUmber,T2.FTrackNumber");
                sql.append(this.getFieldByCalType(strCalType));
                sql.append(") temp ");
                sql.append("\n WHERE T1.FCOMPANYORGUNITID= temp.FCOMPANYORGUNITID AND T1.FMATERIALID = temp.FMATERIALID ");
                if ("2".equals(strCalType)) {
                    sql.append("AND T1.fstorageorgunitid=temp.fstorageorgunitid AND T1.fwarehouseid =temp.fwarehouseid");
                } else if ("1".equals(strCalType)) {
                    sql.append("AND T1.fstorageorgunitid=temp.fstorageorgunitid ");
                }
                sql.append("\n  and isnull(T1.FLot,'NULLID') = isnull(temp.FLot,'NULLID')");
                sql.append("\n and isnull(T1.FAssistProperty,'NULLID') = isnull(temp.FAssistProperty,'NULLID')");
                sql.append("\n and isnull(T1.FProjectNUmber,'NULLID') = isnull(temp.FProjectNUmber,'NULLID')");
                sql.append("\n and isnull(T1.ftracknumber,'NULLID') = isnull(temp.ftracknumber,'NULLID')");
                sql.append(")");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sql.toString();
    }

    private String getFieldByCalType(String strCalType) {
        StringBuffer buffer = new StringBuffer();
        if ("2".equals(strCalType)) {
            buffer.append(",T2.fstorageorgunitid,T2.fwarehouseid");
        } else if ("1".equals(strCalType)) {
            buffer.append(",T2.fstorageorgunitid");
        }
        return buffer.toString();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FYear,FPERIOD,");
        buffer.append(this.getFieldForCalType(filter));
        buffer.append("\n,FMaterialNumber,FMaterialName,FMaterialModel,FLot,FAssistProperty,FProjectNumber,FTrackNumber");
        buffer.append("\n,FStatus,FStatusName,FCompanyOrgUnitID");
        buffer.append("\n FROM ").append(tableName);
        buffer.append("\n GROUP BY FYear,FPERIOD,");
        buffer.append(this.getFieldForCalType(filter));
        buffer.append("\n,FMaterialNumber,FMaterialName,FMaterialModel,FLot,FAssistProperty,FProjectNumber,FTrackNumber");
        buffer.append("\n,FStatus,FStatusName,FCompanyOrgUnitID");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)buffer.toString(), (int)start, (int)rows);
        return rs;
    }

    private String getFieldForCalType(RptParams filter) {
        StringBuffer buffer = new StringBuffer();
        try {
            String strCalType = this.getCalType(filter, false);
            buffer.append(" FCompanyNumber,FCompanyName");
            if ("2".equals(strCalType)) {
                buffer.append(",fstorageNumber,fstorageName,fwarehouseNumber,fwarehouseName");
            } else if ("1".equals(strCalType)) {
                buffer.append(",fstorageNumber,fstorageName ");
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return buffer.toString();
    }

    private String getInsertSql(RptParams filter, String tmpTableName, String CostComputeSumRptTempName) throws BOSException, EASBizException {
        String strCalType = this.getCalType(filter, true);
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(tmpTableName).append("(");
        buffer.append("FID,FYear,FPERIOD,FCompanyOrgUnitID,FCompanyNumber,FCompanyName");
        if ("2".equals(strCalType)) {
            buffer.append("\n,fstorageorgunitid,fstorageNumber,fstorageName");
            buffer.append("\n,fwarehouseid,fwarehouseNumber,fwarehouseName");
        } else if ("1".equals(strCalType)) {
            buffer.append("\n,fstorageorgunitid,fstorageNumber,fstorageName");
        }
        buffer.append("\n,FMaterialid,FMaterialNumber,FMaterialName");
        buffer.append("\n,FMaterialModel,FMatertialShortName,FLot,FAssistProperty,FProjectNumber,FTrackNumber");
        buffer.append("\n,FAccountType,FAccountTypeName,FStatus,FStatusName");
        buffer.append(")");
        buffer.append(this.getSelectDataSql(filter, CostComputeSumRptTempName));
        return buffer.toString();
    }

    private String getSelectDataSql(RptParams filter, String CostComputeSumRptTempName) throws BOSException, EASBizException {
        String strCalType = this.getCalType(filter, true);
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT newbosid('2F1F9D8E') AS CostComputerRptFID,COSTCOMPUTEREPORT.FYear AS FYEAR, COSTCOMPUTEREPORT.FPeriod AS FPERIOD, ");
        buffer.append("\n FINANCEORG.fid AS fcompanyOrgUnitid,FINANCEORG.FNumber AS FcompanyNumber,FINANCEORG.FName_l2 AS FcompanyName,");
        if ("2".equals(strCalType)) {
            buffer.append("\n STORAGEORG.FID AS FSTORAGEORGUnitid,STORAGEORG.FNumber AS FStorageOrgNumber,STORAGEORG.FName_l2 AS FstorageName,");
            buffer.append("\n WAREHOUSE.FID AS FwarehouseId,WAREHOUSE.FNumber AS FwarehouseNumber,WAREHOUSE.FName_l2 AS FWarehouseName,");
        } else if ("1".equals(strCalType)) {
            buffer.append("\n STORAGEORG.FID AS FSTORAGEORGUnitid,STORAGEORG.FNumber AS FStorageOrgNumber,STORAGEORG.FName_l2 AS FstorageName,");
        }
        buffer.append("\n MATERIAL.FID AS FMaterialId,");
        buffer.append("\n MATERIAL.FNumber AS FMaterialNumber,MATERIAL.FName_l2 AS FMaterialName,");
        buffer.append("\n MATERIAL.Fmodel AS FmaterialModel,MATERIAL.fshortname AS FMaterialShortName,temp.FLot AS FLot,");
        buffer.append("\n ASS.FNumber AS FAssistProperty,PRO.FNumber AS FProjectNumber,TRA.FNumber AS FTrackNumber,");
        buffer.append("\n MATERIALCOMPANY.FAccountType as FAccountType,");
        buffer.append("\n CASE WHEN MATERIALCOMPANY.FAccountType=1 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"MOVEAVERAGEKIND", (Context)this.getContext())).append("'");
        buffer.append("\n WHEN MATERIALCOMPANY.FAccountType=2 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"STANDARDKIND", (Context)this.getContext())).append("'");
        buffer.append("\n WHEN MATERIALCOMPANY.FAccountType=3 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"AVERAGEKIND", (Context)this.getContext())).append("'");
        buffer.append("\n WHEN MATERIALCOMPANY.FAccountType=4 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"FIFOKIND", (Context)this.getContext())).append("'");
        buffer.append("\n ELSE  N'").append(SCMUtils.getResource((String)this.res, (String)"LOTAVERAGEKIND", (Context)this.getContext())).append("' END AS accountName,");
        buffer.append("\n temp.FIsSusccessed as FIsSusccessed,");
        buffer.append("\n CASE WHEN temp.FIsSusccessed=0 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"COMPUTEFAIL", (Context)this.getContext())).append("'");
        buffer.append("\n WHEN temp.FIsSusccessed=1 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"COMPUTESUCESS", (Context)this.getContext())).append("'");
        buffer.append("\n ELSE  N'").append(SCMUtils.getResource((String)this.res, (String)"COMPUTEEXCEPTION", (Context)this.getContext())).append("' END AS statusName");
        buffer.append("\n FROM " + CostComputeSumRptTempName + " AS temp");
        buffer.append("\n INNER JOIN T_CL_COSTCOMPUTEREPORT AS COSTCOMPUTEREPORT ");
        buffer.append("\n on COSTCOMPUTEREPORT.FTIMESERIALNUMBER = temp.FTIMESERIALNUMBER");
        buffer.append("\n and COSTCOMPUTEREPORT.FMaterialid = temp.FMaterialid");
        buffer.append("\n and COSTCOMPUTEREPORT.FCompanyOrgUnitID = temp.FCompanyOrgUnitID");
        buffer.append("\n and COSTCOMPUTEREPORT.FYear = temp.FYear");
        buffer.append("\n and COSTCOMPUTEREPORT.FPERIOD = temp.FPERIOD");
        buffer.append("\n and isnull(COSTCOMPUTEREPORT.FLot,'NULLID') = isnull(temp.FLot,'NULLID')");
        buffer.append("\n and isnull(COSTCOMPUTEREPORT.FAssistPropertyID,'NULLID') = isnull(temp.FAssistPropertyID,'NULLID')");
        buffer.append("\n and isnull(COSTCOMPUTEREPORT.FProjectID,'NULLID') = isnull(temp.FProjectID,'NULLID')");
        buffer.append("\n and isnull(COSTCOMPUTEREPORT.FTrackNumberID,'NULLID') = isnull(temp.FTrackNumberID,'NULLID')");
        if ("2".equals(strCalType)) {
            buffer.append("\n and COSTCOMPUTEREPORT.fstorageorgunitid = temp.fstorageorgunitid");
            buffer.append("\n and COSTCOMPUTEREPORT.fwarehouseid = temp.fwarehouseid");
        } else if ("1".equals(strCalType)) {
            buffer.append("\n and COSTCOMPUTEREPORT.fstorageorgunitid = temp.fstorageorgunitid");
        }
        if ("2".equals(strCalType)) {
            buffer.append("\n LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON COSTCOMPUTEREPORT.FWarehouseID = WAREHOUSE.FID");
            buffer.append("\n LEFT OUTER JOIN T_ORG_Storage AS STORAGEORG ON COSTCOMPUTEREPORT.FStorageOrgUnitID = STORAGEORG.FID");
        } else if ("1".equals(strCalType)) {
            buffer.append("\n LEFT OUTER JOIN T_ORG_Storage AS STORAGEORG ON COSTCOMPUTEREPORT.FStorageOrgUnitID = STORAGEORG.FID");
        }
        buffer.append("\n LEFT OUTER JOIN T_BD_Material AS MATERIAL ON COSTCOMPUTEREPORT.FMaterialID = MATERIAL.FID");
        buffer.append("\n LEFT OUTER JOIN T_ORG_Company AS FINANCEORG ON COSTCOMPUTEREPORT.FCompanyOrgUnitID = FINANCEORG.FID");
        buffer.append("\n INNER JOIN T_BD_MaterialCompanyInfo AS MATERIALCOMPANY ");
        buffer.append("\n ON COSTCOMPUTEREPORT.FMaterialID = MATERIALCOMPANY.FMaterialID ");
        buffer.append("\n AND COSTCOMPUTEREPORT.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID");
        buffer.append("\n AND COSTCOMPUTEREPORT.FAccountType = MATERIALCOMPANY.FAccountType");
        buffer.append("\n LEFT OUTER JOIN T_BD_AsstAttrValue ASS ON ASS.FID = COSTCOMPUTEREPORT.FAssistPropertyID");
        buffer.append("\n LEFT OUTER JOIN T_MM_PROJECT PRO ON PRO.FID = COSTCOMPUTEREPORT.FProjectID");
        buffer.append("\n LEFT OUTER JOIN T_MM_TrackNumber TRA ON TRA.FID = COSTCOMPUTEREPORT.FTrackNumberID");
        buffer.append("\n WHERE ").append("FINANCEORG.FNUMBER='").append(filter.getString("companyNumber")).append("'");
        if (filter.getBoolean("chk_OnlyVisibleErrorRpt")) {
            buffer.append("\n AND (temp.FISSUSCCESSED=0 OR temp.FISSUSCCESSED=2)");
        }
        if ("2".equals(strCalType)) {
            if (!StringUtil.isEmpty((String)filter.getString("stroageNumber"))) {
                buffer.append("\n AND STORAGEORG.FNUMBER='").append(filter.getString("stroageNumber")).append("'");
            }
            if (!StringUtil.isEmpty((String)filter.getString("warehouseNumber"))) {
                buffer.append("\n AND WAREHOUSE.FNUMBER='").append(filter.getString("warehouseNumber")).append("'");
            }
        }
        if ("1".equals(strCalType) && !StringUtil.isEmpty((String)filter.getString("stroageNumber"))) {
            buffer.append("\n AND STORAGEORG.FNUMBER='").append(filter.getString("stroageNumber")).append("'");
        }
        if (filter.getObject("materialnumberfrom") instanceof String && !StringUtil.isEmpty((String)filter.getString("materialnumberfrom"))) {
            buffer.append("\n AND MATERIAL.FNumber>='").append(filter.getString("materialnumberfrom")).append("'");
        } else if (filter.getObject("materialnumberfrom") instanceof Object[] && filter.getObject("materialnumberfrom") != null) {
            Object[] materialInfos = (Object[])filter.getObject("materialnumberfrom");
            if (materialInfos.length == 1) {
                buffer.append("\n AND MATERIAL.FNumber>='").append(((MaterialInfo)materialInfos[0]).getNumber()).append("'");
            } else {
                buffer.append("\n AND MATERIAL.FNumber in ('");
                for (int i = 0; i < materialInfos.length; ++i) {
                    if (i != 0) {
                        buffer.append("','");
                    }
                    buffer.append(((MaterialInfo)materialInfos[i]).getNumber());
                }
                buffer.append("')");
            }
        }
        if (!StringUtil.isEmpty((String)filter.getString("materialnumberto"))) {
            buffer.append("\n AND MATERIAL.FNumber<='").append(filter.getString("materialnumberto")).append("'");
        }
        if (!StringUtil.isEmpty((String)filter.getString("materialnumbers"))) {
            buffer.append("\n AND MATERIAL.FNumber IN (").append(filter.getString("materialnumbers")).append(")");
        }
        if (!StringUtil.isEmpty((String)filter.getString("shortName"))) {
            buffer.append("\n AND MATERIAL.fshortname LIKE '%").append(filter.getString("shortName").trim()).append("%'");
        }
        return buffer.toString();
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        Hashtable<String, ReportHeader> dctHeader = new Hashtable<String, ReportHeader>();
        dctHeader.put("root", header);
        this.getCalType(filter, true);
        ReportHeader hd = header.addChild();
        hd.setFieldName("FYear");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)this.getContext()));
        hd.setWidth(60);
        hd.setIndex(1);
        hd = header.addChild();
        hd.setFieldName("FPERIOD");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)this.getContext()));
        hd.setWidth(50);
        hd.setIndex(2);
        hd = header.addChild();
        hd.setFieldName("FCompanyNumber");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"FCOMPANYNUMBER", (Context)this.getContext()));
        hd.setWidth(100);
        hd.setIndex(3);
        hd = header.addChild();
        hd.setFieldName("FCompanyName");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"FICU", (Context)this.getContext()));
        hd.setWidth(200);
        hd.setIndex(4);
        if (this.isCreateColFromCalType(this.calType, 1)) {
            hd = header.addChild();
            hd.setFieldName("fstorageNumber");
            hd.setCaption(SCMUtils.getResource((String)this.res, (String)"STORAGEORG", (Context)this.getContext()));
            hd.setWidth(100);
            hd.setIndex(5);
            hd = header.addChild();
            hd.setFieldName("fstorageName");
            hd.setCaption(SCMUtils.getResource((String)this.res, (String)"StorageName", (Context)this.getContext()));
            hd.setWidth(200);
            hd.setIndex(6);
        }
        if (this.isCreateColFromCalType(this.calType, 2)) {
            hd = header.addChild();
            hd.setFieldName("fwarehouseNumber");
            hd.setCaption(SCMUtils.getResource((String)this.res, (String)"WAREHOUSENUM", (Context)this.getContext()));
            hd.setWidth(100);
            hd.setIndex(7);
            hd = header.addChild();
            hd.setFieldName("fwarehouseName");
            hd.setCaption(SCMUtils.getResource((String)this.res, (String)"WAREHOUSENAME", (Context)this.getContext()));
            hd.setWidth(200);
            hd.setIndex(9);
        }
        hd = header.addChild();
        hd.setFieldName("FMaterialNumber");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)this.getContext()));
        hd.setWidth(200);
        hd.setIndex(9);
        hd = header.addChild();
        hd.setFieldName("FMaterialName");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)this.getContext()));
        hd.setWidth(200);
        hd.setIndex(10);
        hd = header.addChild();
        hd.setFieldName("FMaterialModel");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)this.getContext()));
        hd.setWidth(150);
        hd.setIndex(11);
        hd = header.addChild();
        hd.setFieldName("FLot");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"LOT", (Context)this.getContext()));
        hd.setWidth(100);
        hd.setIndex(12);
        hd = header.addChild();
        hd.setFieldName("FAssistProperty");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"ACCESSORIAL", (Context)this.getContext()));
        hd.setWidth(100);
        hd.setIndex(13);
        hd.setVisible(false);
        hd = header.addChild();
        hd.setFieldName("FProjectNumber");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"projectNumber", (Context)this.getContext()));
        hd.setWidth(100);
        hd.setIndex(14);
        hd.setVisible(false);
        hd = header.addChild();
        hd.setFieldName("FTrackNumber");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"trackNumber", (Context)this.getContext()));
        hd.setWidth(100);
        hd.setIndex(15);
        hd.setVisible(false);
        hd = header.addChild();
        hd.setFieldName("FStatusName");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"FISCUCCESSED", (Context)this.getContext()));
        hd.setWidth(100);
        hd.setIndex(16);
        hd = header.addChild();
        hd.setFieldName("FStatus");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"FISCUCCESSED", (Context)this.getContext()));
        hd.setWidth(0);
        hd.setIndex(17);
        hd.setVisible(false);
        hd = header.addChild();
        hd.setFieldName("FCompanyOrgUnitID");
        hd.setWidth(0);
        hd.setIndex(18);
        hd.setVisible(false);
        return header;
    }

    private boolean isCreateColFromCalType(String calType, int colIndex) {
        boolean ret = false;
        if ("0".equals(calType)) {
            ret = false;
        } else if ("1".equals(calType)) {
            ret = colIndex == 1;
        }
        if ("2".equals(calType)) {
            ret = true;
        }
        return ret;
    }

    private String[][] getcretateTmpeTableSql() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL PRIMARY KEY"}, {"FYear", "int DEFAULT 0 "}, {"FPERIOD", "int DEFAULT 0  "}, {"FCompanyOrgUnitID", "VARCHAR(44) "}, {"FCompanyNumber", "NVARCHAR(80) "}, {"FCompanyName", "NVARCHAR(255) "}, {"fstorageorgunitid", "VARCHAR(44)"}, {"fstorageNumber", "NVARCHAR(80)"}, {"fstorageName", "NVARCHAR(255)"}, {"fwarehouseid", "VARCHAR(44)"}, {"fwarehouseNumber", "NVARCHAR(80)"}, {"fwarehouseName", "NVARCHAR(255)"}, {"FMaterialid", "VARCHAR(44)"}, {"FMaterialNumber", "NVARCHAR(255)"}, {"FMaterialName", "NVARCHAR(255)"}, {"FMaterialModel", "NVARCHAR(255)"}, {"FMatertialShortName", "NVARCHAR(255)"}, {"FLot", "NVARCHAR(80)"}, {"FAssistProperty", "NVARCHAR(80)"}, {"FProjectNumber", "NVARCHAR(80)"}, {"FTrackNumber", "NVARCHAR(80)"}, {"FAccountType", "int"}, {"FAccountTypeName", "NVARCHAR(255)"}, {"FStatus", "int default 0 "}, {"FStatusName", "VARCHAR(255)"}};
        return fields;
    }

    private String getCalType(RptParams filter, boolean isRefresh) throws BOSException, EASBizException {
        String companyNumber;
        if ((isRefresh || this.calType == null) && !StringUtil.isEmpty((String)(companyNumber = filter.getString("companyNumber"))) && companyNumber != null) {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext());
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(viewInfo);
            if (companyColl != null && companyColl.size() > 0) {
                IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)this.getContext());
                this.calType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyColl.get(0).getId()), "SCM_CAL_002");
            }
        }
        return this.calType;
    }

    public Integer getRowCount(String tableName, RptParams filter) throws BOSException, SQLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT COUNT(*) AS COUNT FROM(").append(" SELECT FYear").append(" FROM ").append(tableName).append(" GROUP BY FYear,FPERIOD,").append(this.getFieldForCalType(filter)).append(",FMaterialNumber,FMaterialName,FMaterialModel,FLot,FAssistProperty,FProjectNumber,FTrackNumber").append(",FStatus,FStatusName,FCompanyOrgUnitID").append(") as temp");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)buffer.toString());
        if (rs.next()) {
            return rs.getInt("COUNT");
        }
        return 0;
    }
}

