/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.app.AbstractCostDiffDetailReportFacadeControllerBean;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CostDiffDetailReportFacadeControllerBean
extends AbstractCostDiffDetailReportFacadeControllerBean {
    private static final long serialVersionUID = -7854720937871865289L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.CostDiffDetailReportFacadeControllerBean");
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";
    private static final String TEMP_TABLE_NAME = "T_CL_COSTDIFFREPORT";
    private static final String PERIODTEMP_TABLE_NAME = "T_CL_COSTDIFFPERIOD";

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String sql = "";
        int beginYear = params.getInt("accPeriodYearFrom");
        int beginPeriod = params.getInt("accPeriodMonthFrom");
        int beginOldYear = beginYear;
        int beginOldPeriod = beginPeriod;
        int endYear = params.getInt("accPeriodYearTo");
        int endPeriod = params.getInt("accPeriodMonthTo");
        int toPeriod = endYear * 100 + endPeriod;
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)params.getObject("company");
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        int currentPeriod = currentPeriodInfo.getPeriodYear() * 100 + currentPeriodInfo.getPeriodNumber();
        PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
        if (100 * beginYear + beginPeriod > currentPeriod) {
            beginYear = currentPeriodInfo.getPeriodYear();
            beginPeriod = currentPeriodInfo.getPeriodNumber();
            params.setInt("accPeriodYearFrom", beginYear);
            params.setInt("accPeriodMonthFrom", beginPeriod);
        }
        sql = this.getCreateTempTab(ctx, TEMP_TABLE_NAME);
        String tempTable = this.createTempTable(ctx, sql);
        String amtFormat = "#,##0";
        String prcFormat = "#,##0";
        String qtyFormat = "#,##0";
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)cou.getId().toString(), (String)"costdiffdetailreport_view");
        if (checkPermission) {
            this.getPeriodHappen(ctx, tempTable, params);
            sql = this.getPeriodSql(PERIODTEMP_TABLE_NAME);
            String tmpPeriodTable = this.createTempTable(ctx, sql);
            String fiOrgUnitID = null;
            if (cou != null) {
                fiOrgUnitID = cou.getId().toString();
            }
            sql = "Insert Into " + tmpPeriodTable + " Select '" + fiOrgUnitID + "',FMaterialID,FYear,FPeriod From " + tempTable + " where FPeriod != 0  GROUP BY FMaterialID, FYear, FPeriod";
            this.executeSQL(ctx, sql);
            sql = this.getPeriodBegin(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            if (toPeriod > currentPeriod) {
                this.insertNextPeriodBegin(ctx, tempTable, currentPeriodInfo, nextPeriodInfo, params);
            }
            int nextPeriod = -1;
            if (nextPeriodInfo != null) {
                nextPeriod = nextPeriodInfo.getPeriodYear() * 100 + nextPeriodInfo.getPeriodNumber();
            }
            if (toPeriod > nextPeriod && nextPeriod != -1) {
                PeriodInfo next2PeriodInfo = null;
                try {
                    next2PeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo);
                }
                catch (BOSException be) {
                    logger.info((Object)"next 2 period is null");
                }
                catch (EASBizException ee) {
                    logger.info((Object)"next 2 period is null");
                }
                if (next2PeriodInfo != null) {
                    this.insertNextPeriodBegin(ctx, tempTable, nextPeriodInfo, next2PeriodInfo, params);
                }
            }
            sql = this.getPeriodTotal(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            this.getDealNextPeriod(ctx, tempTable, params);
            sql = this.getPeriodYearTotal(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getDealPrice(ctx, tempTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getDropTmpPeriodTab(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            IMaterial aIMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)params.getObject("CurrentMaterialID").toString()));
            MaterialInfo aMaterialInfo = aIMaterial.getMaterialInfo((IObjectPK)pk);
            int prcPrecision = aMaterialInfo.getPricePrecision();
            sql = "Update " + tempTable + " Set FYear=null Where FYear=0 ";
            this.executeSQL(ctx, sql);
            sql = "Update " + tempTable + " Set FPeriod=null Where FPeriod=0 ";
            this.executeSQL(ctx, sql);
            if (100 * beginOldYear + beginOldPeriod > currentPeriod) {
                sql = "delete from " + tempTable + " where 100*fyear + fperiod < " + (100 * beginOldYear + beginOldPeriod);
                this.executeSQL(ctx, sql);
            }
            params.setInt("accPeriodYearFrom", beginOldYear);
            params.setInt("accPeriodMonthTo", beginOldPeriod);
            String formaStr = RptCellFormatter.getTrimZeroFormat();
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
            int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
            amtFormat = CalculateUtil.getFormatPattern(amtPrecision);
            prcFormat = CalculateUtil.getFormatPattern(prcPrecision);
            qtyFormat = null;
            MeasureUnitInfo aMeasureUnitInfo = aMaterialInfo.getBaseUnit();
            String sSQL = "select FQtyPrecision from T_BD_MultiMeasureUnit where FMaterialID='" + aMaterialInfo.getId().toString() + "' and FMeasureUnitID='" + aMeasureUnitInfo.getId().toString() + "'";
            RptRowSet rs = this.executeQuery(sSQL, null, ctx);
            if (rs.first()) {
                int qtyPrecision = rs.getInt(0);
                qtyFormat = CalculateUtil.getFormatPattern(qtyPrecision);
            } else {
                qtyFormat = formaStr;
            }
        }
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        int count = 0;
        if (rs.getRowCount() > 0) {
            rs.next();
            count = rs.getInt(0);
        }
        RptTableHeader header = this.getRptTableHeader(ctx, amtFormat, prcFormat, qtyFormat);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        return result;
    }

    private RptTableHeader getRptTableHeader(Context ctx, String amtFormat, String prcFormat, String qtyFormat) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FYear");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FPeriod");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FVoucherNumber");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FBizDate");
        col.setWidth(90);
        col.setFormatPattern("yyyy-MM-dd");
        header.addColumn(col);
        col = new RptTableColumn("FBillNumber");
        col.setFormatPattern("@");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FBizType");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FTransactionType");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FAssistAttr");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FInQty");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInUnitPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInDiffAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutQty");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutUnitPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutDiffAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainQty");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainUnitPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainDiffAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FIndex");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FBillType");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        header.addColumn(col);
        header.setLabels((Object[][])new Object[][]{{SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"VOUCHERNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BIZTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ACCESSORIAL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), "FIndex", "FID", "materielID", SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx)}, {SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"VOUCHERNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BIZTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ACCESSORIAL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"DIFFERENCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"DIFFERENCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"DIFFERENCE", (Context)ctx), "FIndex", "FID", "materielID", SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx)}}, true);
        return header;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
        IMaterial aIMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)params.getObject("CurrentMaterialID").toString()));
        MaterialInfo aMaterialInfo = aIMaterial.getMaterialInfo((IObjectPK)pk);
        int prcPrecision = aMaterialInfo.getPricePrecision();
        MeasureUnitInfo aMeasureUnitInfo = aMaterialInfo.getBaseUnit();
        String sSQL = "select FQtyPrecision from T_BD_MultiMeasureUnit where FMaterialID='" + aMaterialInfo.getId().toString() + "' and FMeasureUnitID='" + aMeasureUnitInfo.getId().toString() + "'";
        RptRowSet rs0 = this.executeQuery(sSQL, null, ctx);
        int qtyPrecision = 6;
        if (rs0.first()) {
            qtyPrecision = rs0.getInt(0);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FYear,FPeriod,FVoucherNumber,");
        sql.append("FBizDate,FBillNumber,");
        sql.append("trim(FBizTypeName),");
        sql.append("trim(FTransactionTypeName),");
        sql.append("trim(FAssistantAttrName),");
        sql.append("round(FInQty,").append(qtyPrecision).append("),round(FInUnitPrice,").append(prcPrecision).append("),");
        sql.append("round(FInAmount,").append(amtPrecision).append("),round(FInDiffAmount,").append(amtPrecision).append("),");
        sql.append("round(FOutQty,").append(qtyPrecision).append("),round(FOutUnitPrice,").append(prcPrecision).append("),");
        sql.append("round(FOutAmount,").append(amtPrecision).append("),round(FOutDiffAmount,").append(amtPrecision).append("),");
        sql.append("round(FRemainQty, ").append(qtyPrecision).append("),");
        sql.append("round(FRemainUnitPrice,").append(prcPrecision).append("),round(FRemainAmount,").append(amtPrecision).append("),");
        sql.append("round(FRemainDiffAmount,").append(amtPrecision).append("), FIndex,FID,FMaterialID,FBillType ");
        sql.append(" FROM " + params.getString("tempTable"));
        sql.append(" Order By FYear,FPeriod,FIndex,FBizDate ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String getCreateTempTab(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tempTable + " (");
        sql.append("FIndex INT DEFAULT 0,");
        sql.append("FID VARCHAR(44),");
        sql.append("FMaterialID VARCHAR(44), ");
        sql.append("FSHORTNAME NVARCHAR(255), ");
        sql.append("FBillType INT NOT NULL,");
        sql.append("FYear INT,");
        sql.append("FPeriod INT,");
        sql.append("FVoucherNumber NVARCHAR(44),");
        sql.append("FBizDate DATETIME,");
        sql.append("FBillNumber VARCHAR(80),");
        sql.append("FBizTypeName NVARCHAR(255),");
        sql.append("FTransactionTypeName NVARCHAR(255),");
        sql.append("FAssistantAttrName NVARCHAR(1000),");
        sql.append("FInQty NUMERIC(21,8),");
        sql.append("FInUnitPrice NUMERIC(21,8) null,");
        sql.append("FInAmount NUMERIC(17,4),");
        sql.append("FInDiffAmount NUMERIC(17,4),");
        sql.append("FOutQty NUMERIC(21,8),");
        sql.append("FOutUnitPrice NUMERIC(21,8) null,");
        sql.append("FOutAmount NUMERIC(17,4),");
        sql.append("FOutDiffAmount NUMERIC(17,4),");
        sql.append("FRemainQty NUMERIC(21,8),");
        sql.append("FRemainUnitPrice NUMERIC(21,8) null,");
        sql.append("FRemainAmount NUMERIC(17,4),");
        sql.append("FRemainDiffAmount NUMERIC(17,4),");
        sql.append("FInQty_1 NUMERIC(21,8),");
        sql.append("FInUnitPrice_1 NUMERIC(21,8) null,");
        sql.append("FOutQty_1 NUMERIC(21,8),");
        sql.append("FOutUnitPrice_1 NUMERIC(21,8) null");
        sql.append(")");
        return sql.toString();
    }

    private void getPeriodHappen(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        boolean isJoinQuery;
        int i;
        StringBuffer sql = new StringBuffer();
        String fiOrgUnitID = null;
        String CurrentMaterial = null;
        String txtMShortNameFrom = null;
        String txtMShortNameTo = null;
        String warehouseFrom = null;
        String warehouseTo = null;
        String warehouseIn = null;
        String warehouse = null;
        String storageOrgUnitID = null;
        boolean ckShowNoCalculate = false;
        boolean noSelectStorageMoveBill = false;
        boolean noSelectWarehouseMoveBill = false;
        int voucher = -1;
        int calType = -1;
        int status = -1;
        StringBuffer bizTypeStr = new StringBuffer();
        StringBuffer transTypeStr = new StringBuffer();
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        if (params.getObject("calType") != null) {
            calType = ((CalculateTypeEnum)params.getObject("calType")).getValue();
        }
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        if (params.getObject("bizType") != null) {
            Object[] bizTypeArray = (Object[])params.getObject("bizType");
            for (i = 0; i < bizTypeArray.length; ++i) {
                if (bizTypeArray[i] == null) continue;
                if (i > 0) {
                    bizTypeStr.append(",");
                }
                bizTypeStr.append("'").append(((BizTypeInfo)bizTypeArray[i]).getId().toString()).append("'");
            }
        }
        if (params.getObject("transactionType") != null) {
            Object[] transTypeArray = (Object[])params.getObject("transactionType");
            for (i = 0; i < transTypeArray.length; ++i) {
                if (transTypeArray[i] == null) continue;
                if (i > 0) {
                    transTypeStr.append(",");
                }
                transTypeStr.append("'").append(((TransactionTypeInfo)transTypeArray[i]).getId().toString()).append("'");
            }
        }
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        if (params.getObject("calType") != null) {
            calType = ((CalculateTypeEnum)params.getObject("calType")).getValue();
        }
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        if (isJoinQuery = params.getBoolean("IsJoinQuery")) {
            warehouse = params.getString("warehouse");
        } else {
            if (params.getObject("warehouseFrom") != null) {
                if (params.getObject("warehouseFrom") instanceof Object[]) {
                    Object[] warehouses = (Object[])params.getObject("warehouseFrom");
                    if (warehouses.length == 1) {
                        warehouseFrom = ((WarehouseInfo)warehouses[0]).getNumber();
                    } else {
                        warehouseIn = CalculateUtil.getObjArrayNumberWithQuote(warehouses);
                    }
                } else {
                    warehouseFrom = ((WarehouseInfo)params.getObject("warehouseFrom")).getNumber();
                }
            }
            if (params.getObject("warehouseTo") != null) {
                warehouseTo = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            }
        }
        if (params.getObject("FStorageOrgUnitID") != null) {
            storageOrgUnitID = params.getObject("FStorageOrgUnitID").toString();
        }
        ckShowNoCalculate = params.getBoolean("ckShowNoCalculate");
        voucher = ((VoucheredEnum)((Object)params.getObject("voucher"))).getValue();
        noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        int periodYFrom = params.getInt("accPeriodYearFrom");
        int periodYTo = params.getInt("accPeriodYearTo");
        int periodMFrom = params.getInt("accPeriodMonthFrom");
        int periodMTo = params.getInt("accPeriodMonthTo");
        StringBuffer sqlWhere = new StringBuffer();
        StringBuffer sqlWhere1 = new StringBuffer();
        sqlWhere.append(" And (h.FIsInitBill = 0 or h.FIsInitBill is null ) ");
        String sql1 = "And d.FCompanyOrgUnitID = '" + fiOrgUnitID + "'";
        sqlWhere.append(sql1);
        sql1 = "And h.FCompanyOrgUnitID = '" + fiOrgUnitID + "'";
        sqlWhere1.append(sql1);
        sql1 = " AND (h.FYear*100+h.FPeriod >= " + String.valueOf(periodYFrom * 100 + periodMFrom) + " And h.FYear*100+h.FPeriod <= " + String.valueOf(periodYTo * 100 + periodMTo) + ") ";
        sqlWhere.append(sql1);
        sqlWhere1.append(sql1);
        if (CurrentMaterial != null) {
            sql1 = " AND d.FMaterialID = '" + CurrentMaterial + "' ";
            sqlWhere.append(sql1);
            sqlWhere1.append(sql1);
        }
        txtMShortNameFrom = params.getString("txtMShortNameFrom").trim();
        txtMShortNameTo = params.getString("txtMShortNameTo").trim();
        if (txtMShortNameFrom.length() > 0) {
            sqlWhere.append(" AND MATERIAL.FSHORTNAME >= '" + txtMShortNameFrom + "' ");
        }
        if (txtMShortNameTo.length() > 0 && txtMShortNameFrom.length() > 0) {
            sqlWhere.append(" AND MATERIAL.FSHORTNAME <= '" + txtMShortNameTo + "' ");
        }
        if (txtMShortNameTo.length() > 0 && txtMShortNameFrom.length() <= 0) {
            sqlWhere.append(" AND ( MATERIAL.FSHORTNAME <= '" + txtMShortNameTo + "' OR MATERIAL.FSHORTNAME IS NULL ) ");
        }
        if (isJoinQuery && warehouse != null) {
            sqlWhere.append(" AND wh.FID in('" + warehouse + "')").append("\r\n");
        } else {
            if (warehouseFrom != null) {
                sqlWhere.append(" AND wh.FNumber >= '" + warehouseFrom + "' ");
            }
            if (warehouseTo != null) {
                sqlWhere.append(" AND wh.FNumber <= '" + warehouseTo + "' ");
            }
            if (warehouseIn != null) {
                sqlWhere.append(" AND wh.FNumber in (" + warehouseIn + ") ");
            }
        }
        if (storageOrgUnitID != null) {
            sqlWhere.append(" AND h.FStorageOrgUnitID = '" + storageOrgUnitID + "' ");
        }
        if (voucher != -1) {
            sqlWhere.append("And h.ffiVouchered = ").append(voucher);
            sqlWhere1.append("And h.ffiVouchered = ").append(voucher);
        }
        if (calType >= 0) {
            sql1 = " AND mcom.FCalculateType = " + String.valueOf(calType);
            sqlWhere.append(sql1);
            sqlWhere1.append(sql1);
        }
        if (status == 2) {
            sql1 = " AND h.FBaseStatus = " + String.valueOf(status);
            sqlWhere.append(sql1);
            sqlWhere1.append(sql1);
        } else if (status == 4) {
            sql1 = " AND h.FBaseStatus = " + String.valueOf(status);
            sqlWhere.append(sql1);
            sqlWhere1.append(sql1);
        }
        sqlWhere.append(" and mcom.FAccountType = 2 ");
        sqlWhere1.append(" and mcom.FAccountType = 2 ");
        sqlWhere.append(" and stype.FIsForwardAmt = 1 ");
        String sqlWhereCostAdj = sqlWhere.toString();
        if (!ckShowNoCalculate) {
            sqlWhere.append("And tr.FIsCalculate = 1 ");
        }
        if (bizTypeStr.length() > 0) {
            sqlWhere.append(" And bt.FID IN (").append(bizTypeStr.toString()).append(") \r\n");
        }
        if (transTypeStr.length() > 0) {
            sqlWhere.append(" And tr.FID IN (").append(transTypeStr.toString()).append(") \r\n");
        }
        String insertSQL = "INSERT INTO " + tempTable + " \r\n";
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("MATERIAL.FSHORTNAME as FSHORTNAME,");
        sql.append("1 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName,");
        sql.append("SUM(d.FBaseQty) as FInQty,");
        sql.append("0 as  FInUnitPrice,");
        sql.append("SUM(d.FStandardCost) as FInAmount,");
        sql.append("SUM(d.FActualCost)-SUM(d.FStandardCost) as FInDiffAmount,");
        sql.append("0 as  FOutQty,");
        sql.append("0 as  FOutUnitPrice,");
        sql.append("0 as  FOutAmount,");
        sql.append("0 as  FOutDiffAmount,");
        sql.append("0 as  FRemainQty,");
        sql.append("0 as  FRemainUnitPrice,");
        sql.append("0 as  FRemainAmount,");
        sql.append("0 as  FRemainDiffAmount,");
        sql.append("SUM(d.FQty) as FInQty_1,");
        sql.append("avg(d.FUnitStandardCost) as FInUnitPrice_1,");
        sql.append("0 as  FOutQty_1,");
        sql.append("0 as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_IM_PurInWarehsBill h ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_IM_PurInWarehsEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialId AND mcom.FCompanyID = d.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID  ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.finvupdatetypeid = invupdatetype.fid ");
        sql.append("INNER JOIN T_IM_STORETYPE stype ON invupdatetype.FSTORETYPEID = stype.FID ");
        sql.append("Left Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialID ");
        sql.append("WHERE 1 = 1 ");
        sql.append(sqlWhere.toString() + " \r\n");
        sql.append("GROUP BY  ");
        sql.append("h.FID,d.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + ",");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("a.FName_" + this.getLoc(ctx) + ",");
        sql.append("h.FBaseStatus,mcom.FCalculateType  ");
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("Material.FSHORTNAME as FSHORTNAME,");
        sql.append("2 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName,");
        sql.append("SUM(d.FBaseQty) as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("SUM(d.FStandardCost) as FInAmount,");
        sql.append("SUM(d.FActualCost)-SUM(d.FStandardCost) as FInDiffAmount,");
        sql.append("0 as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("0 as FOutAmount,");
        sql.append("0 as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainUnitPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,");
        sql.append("SUM(d.FQty) as FInQty_1,");
        sql.append("avg(d.FUnitStandardCost) as FInUnitPrice_1,");
        sql.append("0 as  FOutQty_1,");
        sql.append("0 as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_IM_ManufactureRecBill h   ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_IM_ManufactureRecBillEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialId AND mcom.FCompanyID = d.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID  ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.finvupdatetypeid = invupdatetype.fid ");
        sql.append("INNER JOIN T_IM_STORETYPE stype ON invupdatetype.FSTORETYPEID = stype.FID ");
        sql.append("Left Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialId ");
        sql.append("WHERE 1 = 1 ");
        sql.append(sqlWhere.toString() + " \r\n");
        sql.append("GROUP BY  ");
        sql.append("h.FID,d.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + ",");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("a.FName_" + this.getLoc(ctx) + ",");
        sql.append("h.FBaseStatus,");
        sql.append("mcom.FCalculateType  ");
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("Material.FSHORTNAME as FSHORTNAME,");
        sql.append("3 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName,");
        sql.append("SUM(d.FBaseQty) as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("SUM(d.FStandardCost) as FInAmount,");
        sql.append("SUM(d.FActualCost)-SUM(d.FStandardCost) as FInDiffAmount,");
        sql.append("0 as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("0 as FOutAmount,");
        sql.append("0 as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainUnitPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,");
        sql.append("SUM(d.FQty) as FInQty_1,");
        sql.append("avg(d.FUnitStandardCost) as FInUnitPrice_1,");
        sql.append("0 as  FOutQty_1,");
        sql.append("0 as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_IM_MoveInWarehsBill h   ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_IM_MoveInWarehsBillEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialId AND mcom.FCompanyID = d.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID  ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.finvupdatetypeid = invupdatetype.fid ");
        sql.append("INNER JOIN T_IM_STORETYPE stype ON invupdatetype.FSTORETYPEID = stype.FID ");
        sql.append("Left Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialID ");
        sql.append("WHERE 1 = 1 ");
        sql.append(sqlWhere.toString() + " \r\n");
        if (noSelectStorageMoveBill) {
            sql.append(" and bt.fid <>'d8e80652-011a-1000-e000-04c5c0a812202407435C' ");
        }
        if (noSelectWarehouseMoveBill) {
            sql.append(" and bt.fid <>'d8e80652-011b-1000-e000-04c5c0a812202407435C' ");
        }
        sql.append("GROUP BY  \r\n");
        sql.append("h.FID,d.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + ",");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("a.FName_" + this.getLoc(ctx) + ",");
        sql.append("h.FBaseStatus,");
        sql.append("mcom.FCalculateType  ");
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("Material.FSHORTNAME as FSHORTNAME,");
        sql.append("4 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName,");
        sql.append("SUM(d.FBaseQty) as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("SUM(d.FStandardCost) as FInAmount,");
        sql.append("SUM(d.FActualCost)-SUM(d.FStandardCost) as FInDiffAmount,");
        sql.append("0 as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("0 as FOutAmount,");
        sql.append("0 as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainUnitPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,");
        sql.append("SUM(d.FQty) as FInQty_1,");
        sql.append("avg(d.FUnitStandardCost) as FInUnitPrice_1,");
        sql.append("0 as  FOutQty_1,");
        sql.append("0 as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_IM_OtherInWarehsBill h   ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_IM_OtherInWarehsBillEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialId AND mcom.FCompanyID = d.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID  ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.finvupdatetypeid = invupdatetype.fid ");
        sql.append("INNER JOIN T_IM_STORETYPE stype ON invupdatetype.FSTORETYPEID = stype.FID ");
        sql.append("Left Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialId ");
        sql.append("WHERE 1 = 1 ");
        sql.append(sqlWhere.toString() + " \r\n");
        sql.append("GROUP BY  \r\n");
        sql.append("h.FID,d.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + ",");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("a.FName_" + this.getLoc(ctx) + ",");
        sql.append("h.FBaseStatus,");
        sql.append("mcom.FCalculateType  ");
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("Material.FSHORTNAME as FSHORTNAME,");
        sql.append("5 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName,");
        sql.append("0 as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("0 as FInAmount,");
        sql.append("0 as FInDiffAmount,");
        sql.append("SUM(d.FBaseQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("SUM(d.FStandardCost) as FOutAmount,");
        sql.append("SUM(d.FActualCost)-SUM(d.FStandardCost) as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainUnitPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,");
        sql.append("0 as FInQty_1,");
        sql.append("0 as FInUnitPrice_1,");
        sql.append("SUM(d.FQty) as  FOutQty_1,");
        sql.append("avg(d.FUnitStandardCost) as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_IM_SaleIssueBill h   ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_IM_SaleIssueEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID  ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.finvupdatetypeid = invupdatetype.fid ");
        sql.append("INNER JOIN T_IM_STORETYPE stype ON invupdatetype.FSTORETYPEPREID = stype.FID ");
        sql.append("Left Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialId ");
        sql.append("WHERE  1 = 1");
        sql.append(sqlWhere.toString() + " \r\n");
        sql.append("GROUP BY  \r\n");
        sql.append("h.FID,d.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + ",");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("a.FName_" + this.getLoc(ctx) + ",");
        sql.append("h.FBaseStatus,");
        sql.append("mcom.FCalculateType  ");
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("Material.FSHORTNAME as FSHORTNAME,");
        sql.append("6 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName,");
        sql.append("0 as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("0 as FInAmount,");
        sql.append("0 as FInDiffAmount,");
        sql.append("SUM(d.FBaseQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("SUM(d.FStandardCost) as FOutAmount,");
        sql.append("SUM(d.FActualCost)-Sum(d.FStandardCost) as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainUnitPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,");
        sql.append("0 as FInQty_1,");
        sql.append("0 as FInUnitPrice_1,");
        sql.append("SUM(d.FQty) as  FOutQty_1,");
        sql.append("avg(d.FUnitStandardCost) as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_IM_MaterialReqBill h   ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_IM_MaterialReqBillEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID  ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.finvupdatetypeid = invupdatetype.fid ");
        sql.append("INNER JOIN T_IM_STORETYPE stype ON invupdatetype.FSTORETYPEPREID = stype.FID ");
        sql.append("Left Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialId ");
        sql.append("WHERE 1 = 1 ");
        sql.append(sqlWhere.toString() + " \r\n");
        sql.append("GROUP BY  \r\n");
        sql.append("h.FID,d.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + ",");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("a.FName_" + this.getLoc(ctx) + ",");
        sql.append("h.FBaseStatus,");
        sql.append("mcom.FCalculateType  ");
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("Material.FSHORTNAME as FSHORTNAME,");
        sql.append("7 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName,");
        sql.append("0 as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("0 as FInAmount,");
        sql.append("0 as FInDiffAmount,");
        sql.append("SUM(d.FBaseQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("SUM(d.FStandardCost) as FOutAmount,");
        sql.append("SUM(d.FActualCost)-Sum(d.FStandardCost) as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainUnitPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,");
        sql.append("0 as FInQty_1,");
        sql.append("0 as FInUnitPrice_1,");
        sql.append("SUM(d.FQty) as  FOutQty_1,");
        sql.append("avg(d.FUnitStandardCost) as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_IM_MoveIssueBill h   ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_IM_MoveIssueBillEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID  ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.finvupdatetypeid = invupdatetype.fid ");
        sql.append("INNER JOIN T_IM_STORETYPE stype ON invupdatetype.FSTORETYPEPREID = stype.FID ");
        sql.append("Left Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialId ");
        sql.append("WHERE 1 = 1 ");
        sql.append(sqlWhere.toString() + " \r\n");
        if (noSelectStorageMoveBill) {
            sql.append(" and bt.fid <>'d8e80652-011a-1000-e000-04c5c0a812202407435C' ");
        }
        if (noSelectWarehouseMoveBill) {
            sql.append(" and bt.fid <>'d8e80652-011b-1000-e000-04c5c0a812202407435C' ");
        }
        sql.append("GROUP BY  \r\n");
        sql.append("h.FID,d.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + ",");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("a.FName_" + this.getLoc(ctx) + ",");
        sql.append("h.FBaseStatus,");
        sql.append("mcom.FCalculateType  ");
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("Material.FSHORTNAME as FSHORTNAME,");
        sql.append("8 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName,");
        sql.append("0 as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("0 as FInAmount,");
        sql.append("0 as FInDiffAmount,");
        sql.append("SUM(d.FBaseQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("SUM(d.FStandardCost) as FOutAmount,");
        sql.append("SUM(d.FActualCost)-SUM(d.FStandardCost) as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainUnitPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,");
        sql.append("0 as FInQty_1,");
        sql.append("0 as FInUnitPrice_1,");
        sql.append("SUM(d.FQty) as  FOutQty_1,");
        sql.append("avg(d.FUnitStandardCost) as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_IM_OtherIssueBill h   ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_IM_OtherIssueBillEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID  ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.finvupdatetypeid = invupdatetype.fid ");
        sql.append("INNER JOIN T_IM_STORETYPE stype ON invupdatetype.FSTORETYPEPREID = stype.FID ");
        sql.append("Left Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialId ");
        sql.append("WHERE 1 = 1");
        sql.append(sqlWhere.toString() + " \r\n");
        sql.append("GROUP BY  \r\n");
        sql.append("h.FID,d.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("bt.FName_" + this.getLoc(ctx) + ",");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("a.FName_" + this.getLoc(ctx) + ",");
        sql.append("h.FBaseStatus,");
        sql.append("mcom.FCalculateType  ");
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("Material.FSHORTNAME as FSHORTNAME,");
        sql.append("9 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("NULL as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName,");
        sql.append("0 as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("0 as FInAmount,");
        sql.append("SUM((CASE h.FCalculateKind WHEN 0 THEN d.FActualCost ELSE 0 END)) as FInDiffAmount,");
        sql.append("0 as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("0 as FOutAmount,");
        sql.append("SUM((CASE h.FCalculateKind WHEN 1 THEN d.FActualCost ELSE 0 END)) as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainUnitPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,");
        sql.append("0 as FInQty_1,");
        sql.append("0 as FInUnitPrice_1,");
        sql.append("0 as  FOutQty_1,");
        sql.append("0 as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_CL_CostAdjustBill h   ");
        sql.append("INNER JOIN T_SCM_BillType tr ON h.FBillTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_CL_CostAdjustBillEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID  ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_STORETYPE stype ON d.FSTORETYPEID = stype.FID ");
        sql.append("Left Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialId ");
        sql.append("WHERE 1 = 1 ");
        sql.append(sqlWhereCostAdj.toString() + " \r\n");
        sql.append("GROUP BY  \r\n");
        sql.append("h.FID,d.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("h.FCalculateKind,");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("a.FName_" + this.getLoc(ctx) + ",");
        sql.append("h.FBaseStatus,mcom.FCalculateType  ");
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("SELECT 0 AS FIndex,");
        sql.append("h.FID,");
        sql.append("d.FMaterialID as FMaterialID,");
        sql.append("Material.FSHORTNAME as FSHORTNAME,");
        sql.append("10 as FBillType,");
        sql.append("h.FYear as FYear,");
        sql.append("h.FPeriod as FPeriod,");
        sql.append("g.FNumber as FVoucherNumber,");
        sql.append("h.FBizDate as FBizDate,");
        sql.append("h.FNumber as FBillNumber,");
        sql.append("null as FBizTypeName,");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName,");
        sql.append("null as FAssistantAttrName,");
        sql.append("0 as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("Sum(FDiffAmount) as FInAmount,");
        sql.append("Sum((FDiffAmount)) as FDiffAmount,");
        sql.append("0 as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("0 as FOutAmount,");
        sql.append("0 as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainUnitPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,");
        sql.append("0 as FInQty_1,");
        sql.append("0 as FInUnitPrice_1,");
        sql.append("0 as  FOutQty_1,");
        sql.append("0 as  FOutUnitPrice_1 \r\n");
        sql.append("FROM T_CL_StandardCostAdjBill h  ");
        sql.append("INNER JOIN T_SCM_BillType tr ON h.FBillTypeID = tr.FID  ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID  ");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry d ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = h.FCompanyOrgUnitID  ");
        sql.append("INNER JOIN T_ORG_Company fi ON h.FCompanyOrgUnitID = fi.FID  ");
        sql.append("Left Join T_BD_MATERIAL MATERIAL on MATERIAL.FID = d.FMaterialID AND MATERIAL.FID = mcom.FMaterialId ");
        sql.append("WHERE 1 = 1 ");
        sql.append("AND h.FBaseStatus =" + String.valueOf(4) + " ");
        sql.append(sqlWhere1.toString() + " \r\n");
        sql.append("GROUP BY  \r\n");
        sql.append("h.FID,h.FCompanyOrgUnitID,h.FYear,h.FPeriod,");
        sql.append("fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("g.FNumber,");
        sql.append("h.FBizDate,");
        sql.append("h.FNumber,");
        sql.append("tr.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FMaterialID,");
        sql.append("Material.FSHORTNAME,");
        sql.append("h.FBaseStatus,mcom.FCalculateType");
        this.executeSQL(ctx, insertSQL + sql.toString());
    }

    private String getPeriodSql(String tmpPeriodTable) {
        String sql = "CREATE TABLE " + tmpPeriodTable + " (FCompanyOrgUnitID nvarchar (44) ,FMaterialID nvarchar (44) , FYear int NULL ,FPeriod int NULL)";
        return sql;
    }

    private String getPeriodBegin(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        boolean isJoinQuery;
        String fiOrgUnitID = null;
        String warehouseFrom = null;
        String warehouseTo = null;
        String warehouseIn = null;
        String warehouse = null;
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        if (isJoinQuery = params.getBoolean("IsJoinQuery")) {
            warehouse = params.getString("warehouse");
        } else {
            if (params.getObject("warehouseFrom") != null) {
                if (params.getObject("warehouseFrom") instanceof Object[]) {
                    Object[] warehouses = (Object[])params.getObject("warehouseFrom");
                    if (warehouses.length == 1) {
                        warehouseFrom = ((WarehouseInfo)warehouses[0]).getNumber();
                    } else {
                        warehouseIn = CalculateUtil.getObjArrayNumberWithQuote(warehouses);
                    }
                } else {
                    warehouseFrom = ((WarehouseInfo)params.getObject("warehouseFrom")).getNumber();
                }
            }
            if (params.getObject("warehouseTo") != null) {
                warehouseTo = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            }
        }
        String CurrentMaterial = null;
        String storageOrgUnitID = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(CurrentMaterial));
        String shortName = null;
        if (materialInfo != null) {
            shortName = materialInfo.getShortName();
        }
        int periodYFrom = params.getInt("accPeriodYearFrom");
        int periodMFrom = params.getInt("accPeriodMonthFrom");
        int periodYTo = params.getInt("accPeriodYearTo");
        int periodMTo = params.getInt("accPeriodMonthTo");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTable + " ");
        sql.append(" (FIndex, FID, FMaterialID, FSHORTNAME, FBillType, FYear, FPeriod, FVoucherNumber,");
        sql.append(" FBillNumber, FBizTypeName, FTransactionTypeName, FAssistantAttrName, FInQty,");
        sql.append(" FInUnitPrice, FInAmount, FInDiffAmount, FOutQty,FOutUnitPrice, FOutAmount, FOutDiffAmount, FRemainQty,");
        sql.append(" FRemainUnitPrice, FRemainAmount, FRemainDiffAmount, FInQty_1, FInUnitPrice_1, FOutQty_1, FOutUnitPrice_1)");
        sql.append(" Select j.FIndex, j.FID, j.FMaterialID, j.FShortName, j.FBillType, j.FYear, j.FPeriod,");
        sql.append(" j.FVoucherNumber, j.FNumber, j.FBizTypeName, j.FTransactionType, j.FAssistantAttr, j.FInQty, j.FInUnitPrice,");
        sql.append(" j.FInAmount, j.FInDiffAount, j.FOutQty, j.FOutUnitPrice, j.FOutAmount, j.FOutDiffAmout, j.FRemainQty,");
        sql.append(" j.FRemainPrice, j.FRemainAmount, j.FRemainDiffAmount, j.FInQty_1, j.FInUnitPrice_1, j.FOutQty_1, j.FOutUnitPrice_1 From (");
        sql.append(" Select -1 as FIndex,' ' AS FID,'" + CurrentMaterial + "' as FMaterialID,'" + shortName + "' as FShortName, -1 as FBillType,\r\n");
        sql.append(" (case when p.FYear is null then i.FYear else p.FYear END) as FYear,\r\n");
        sql.append(" (case when p.FPeriod is null then i.FPeriod else p.FPeriod END) as FPeriod,");
        sql.append(" ' ' as FVoucherNumber,' ' as FNumber,null as FBizTypeName,'" + SCMUtils.getResource((String)this.res, (String)"BEGINBALANCE", (Context)ctx) + "' as FTransactionType,\r\n");
        sql.append(" ' ' as FAssistantAttr,0 as FInQty,0 as FInUnitPrice,\r\n");
        sql.append(" 0 as FInAmount,0 as FInDiffAount,0 as FOutQty,0 as FOutUnitPrice,\r\n");
        sql.append(" 0 as FOutAmount,0 as FOutDiffAmout,sum(i.FPeriodBeginQty) as FRemainQty,\r\n");
        sql.append(" 0 as FRemainPrice,sum(i.FPeriodBeginBalance) as FRemainAmount,sum(i.FPeriodBeginCostDiff) as FRemainDiffAmount,\r\n");
        sql.append(" 0 as FInQty_1, 0 as FInUnitPrice_1, 0 as FOutQty_1,0 as FOutUnitPrice_1 ");
        sql.append(" from (Select j.FMaterialID,j.fid,j.fyear,j.FPERIOD,j.FPERIODBEGINQTY,j.FPERIODBEGINBALANCE,j.FPERIODBEGINCOSTDIFF,j.FCompanyOrgUnitID From T_IM_InventoryBalance j \r\n");
        sql.append(" inner join t_db_warehouse wh on j.fwarehouseid = wh.fid \r\n");
        sql.append(" inner join t_im_STORETYPE stype on j.FStoreTypeID = stype.fid \r\n");
        sql.append(" Where j.FCompanyOrgUnitID='" + fiOrgUnitID + "' and j.FMaterialID='" + CurrentMaterial + "' \r\n");
        if (isJoinQuery && warehouse != null) {
            sql.append(" AND wh.FID in('" + warehouse + "')").append("\r\n");
        } else {
            if (warehouseFrom != null) {
                sql.append(" AND wh.FNumber >= '" + warehouseFrom + "' ");
            }
            if (warehouseTo != null) {
                sql.append(" AND wh.FNumber <= '" + warehouseTo + "' ");
            }
            if (warehouseIn != null) {
                sql.append(" AND wh.FNumber in (" + warehouseIn + ") ");
            }
        }
        if (params.getObject("FStorageOrgUnitID") != null) {
            storageOrgUnitID = params.getObject("FStorageOrgUnitID").toString();
            sql.append(" AND j.FStorageOrgUnitID = '" + storageOrgUnitID + "' ");
        }
        if (!params.getBoolean("ckShowNoCalculate")) {
            sql.append("AND j.FIsCalculate = 1 ");
        }
        boolean noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        boolean noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        if (noSelectStorageMoveBill) {
            sql.append("AND j.FMoveType <> 1 ");
        }
        if (noSelectWarehouseMoveBill) {
            sql.append("AND j.FMoveType <> 2 ");
        }
        sql.append("  and stype.FIsForwardAmt = 1 ");
        sql.append(") i Full outer Join " + tmpPeriodTable + " p \r\n");
        sql.append(" On i.FCompanyOrgUnitID=p.FCompanyOrgUnitID and i.fMaterialid = p.FMaterialID and i.FYear=p.FYear and i.FPeriod=p.FPeriod \r\n");
        sql.append(" Where i.FmaterialID ='" + CurrentMaterial + "'  \r\n");
        sql.append(" or p.fmaterialid = '" + CurrentMaterial + "' \r\n");
        sql.append(" Group By i.FCompanyOrgUnitID,i.FYear,p.FYear,i.FPeriod,p.FPeriod \r\n");
        sql.append(") j \r\n");
        sql.append("Where ");
        sql.append(" (j.FYear*100+j.FPeriod>=" + (periodYFrom * 100 + periodMFrom) + " and j.FYear*100+j.FPeriod<=" + (periodYTo * 100 + periodMTo) + ") \r\n");
        return sql.toString();
    }

    private void insertNextPeriodBegin(Context ctx, String tempTable, PeriodInfo currentPeriodInfo, PeriodInfo nextPeriodInfo, RptParams params) throws BOSException, EASBizException {
        if (nextPeriodInfo.isIsAdjustPeriod()) {
            StringBuffer sql = new StringBuffer();
            StringBuffer sqlIn = new StringBuffer();
            String currentMaterial = "";
            if (params.getObject("CurrentMaterialID") != null) {
                currentMaterial = params.getObject("CurrentMaterialID").toString();
            }
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            MaterialInfo materialInfo = null;
            materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(currentMaterial));
            String shortName = null;
            if (materialInfo != null) {
                shortName = materialInfo.getShortName();
            }
            sql.append("select count(*) as cnt from ").append(tempTable).append(" ").append("where ").append("fyear = ").append(nextPeriodInfo.getPeriodYear()).append(" ").append("and fperiod = ").append(nextPeriodInfo.getPeriodNumber()).append(" ").append("and fIndex = -1");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                int cnt;
                if (rs.next() && (cnt = rs.getInt("cnt")) == 0) {
                    sqlIn.append("insert into ").append(tempTable).append("(").append("FIndex,FMaterialID,FSHORTNAME,FBilltype,FTransactionTypeName,FYear,FPeriod) ").append("values(-1,'").append(currentMaterial).append("','" + shortName + "',-1,").append("'").append(SCMUtils.getResource((String)this.res, (String)"BEGINBALANCE", (Context)ctx)).append("',").append(nextPeriodInfo.getPeriodYear()).append(",").append(nextPeriodInfo.getPeriodNumber()).append("").append(")");
                    this.executeSQL(ctx, sqlIn.toString());
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String getPeriodTotal(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        String CurrentMaterial = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo materialInfo = null;
        materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(CurrentMaterial));
        String shortName = null;
        if (materialInfo != null) {
            shortName = materialInfo.getShortName();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTable + "\r\n");
        sql.append("Select 1 as FIndex,");
        sql.append("null AS FID,");
        sql.append("'" + CurrentMaterial + "' as FMaterialID,");
        sql.append("'" + shortName + "' as FSHORTNAME,");
        sql.append("-1 as FBillType,");
        sql.append("p.FYear as FYear,\r\n");
        sql.append("p.FPeriod as FPeriod,");
        sql.append("' ' as FVoucherNumber,");
        sql.append("null as FBizDate,");
        sql.append("' ' as FNumber,");
        sql.append("' ' as FBizTypeName,");
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"PERIODTOTAL", (Context)ctx) + "' as FTransactionType,");
        sql.append("' ' as FAssistantAttr,");
        sql.append("sum(p.FInQty) as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("sum(p.FInAmount) as FInAmount,");
        sql.append("sum(p.FInDiffAmount) as FInDiffAount,");
        sql.append("sum(p.FOutQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("sum(p.FOutAmount) as FOutAmount,");
        sql.append("sum(p.FOutDiffAmount) as FOutDiffAmout,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount \r\n");
        sql.append(", 0 as FInQty_1, 0 as FInUnitPrice_1, 0 as FOutQty_1,0 as FOutUnitPrice_1 ");
        sql.append(" From " + tempTable + " p \r\n");
        sql.append(" Where p.FIndex=0 or p.Findex = -1 \r\n");
        sql.append(" Group By p.FYear,p.FPeriod\r\n");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " As t2  Set(FRemainQty,FRemainAmount,FRemainDiffAmount)=\r\n");
        sql.append("(Select isNull(t1.FRemainQty,0)+isNull(t3.FInQty,0)-isNull(t3.FOutQty,0),");
        sql.append("isNull(t1.FRemainAmount,0)+isNull(t3.FInAmount,0)-isNull(t3.FOutAmount,0),");
        sql.append("isNull(t1.FRemainDiffAmount,0)+isNull(t3.FInDiffAmount,0)-isNull(t3.FOutDiffAmount,0) ");
        sql.append("From " + tempTable + " t3," + tempTable + " t1 \r\n");
        sql.append("Where t3.FIndex=1 And t1.FIndex=-1 And t3.FYear=t1.FYear And t3.FPeriod=t1.FPeriod ");
        sql.append("And t3.FIndex =t2.FIndex And t3.FYear=t2.FYear And t3.FPeriod=t2.FPeriod )");
        return sql.toString();
    }

    private String getPeriodYearTotal(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        String CurrentMaterial = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo materialInfo = null;
        materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(CurrentMaterial));
        String shortName = null;
        if (materialInfo != null) {
            shortName = materialInfo.getShortName();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTable + " \r\n");
        sql.append("Select 2 as FIndex,");
        sql.append("null AS FID,");
        sql.append("'" + CurrentMaterial + "' as FMaterialID,");
        sql.append("'" + shortName + "' AS FSHORTNAME, -1 as FBillType,");
        sql.append("p.FYear,");
        sql.append("0 as FPeriod,");
        sql.append("null as FVoucherNumber,");
        sql.append("null as FBizDate,");
        sql.append("null as FNumber,");
        sql.append("null as FBizTypeName,");
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"YEARTOTAL", (Context)ctx) + "' as FTransactionType,");
        sql.append("null as FAssistantAttr,");
        sql.append("sum(p.FInQty) as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("sum(p.FInAmount) as FInAmount,");
        sql.append("sum(p.FInDiffAmount) as FInDiffAmount,");
        sql.append("sum(p.FOutQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("sum(p.FOutAmount) as FOutAmount,");
        sql.append("sum(p.FOutDiffAmount) as FOutDiffAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("0 as FRemainDiffAmount,\r\n");
        sql.append("0 as FInQty_1, 0 as FInUnitPrice_1, 0 as FOutQty_1,0 as FOutUnitPrice_1 ");
        sql.append(" From " + tempTable + " p \r\n");
        sql.append(" Where p.FIndex=1\r\n");
        sql.append(" Group By p.FYear\r\n");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " as t3 \r\n");
        sql.append("Set (FRemainQty,FRemainAmount,FRemainDiffAmount)=( \r\n");
        sql.append("Select t2.FRemainQty,t2.FRemainAmount,t2.FRemainDiffAmount From  " + tempTable + " t1 \r\n");
        sql.append("Left Join ( \r\n");
        sql.append("\tSelect t2.FYear,t2.FPeriod,t1.FRemainQty,t1.FRemainAmount,t1.FRemainDiffAmount  \r\n");
        sql.append("\tFrom " + tempTable + " t1  \r\n");
        sql.append("\tInner Join(  \r\n");
        sql.append("\tselect FYear,Max(FPeriod) FPeriod  From " + tempTable + " t1 group by FYear \r\n");
        sql.append("\t) t2  \r\n");
        sql.append("\tOn  t1.FYear=t2.FYear and t1.FPeriod=t2.FPeriod where  t1.Findex=1 \r\n");
        sql.append(" ) t2  \r\n");
        sql.append("On t1.FYear=t2.FYear \r\n");
        sql.append("Where t1.FIndex=2 And t1.FIndex=t3.FIndex And t1.FYear=t3.FYear)");
        return sql.toString();
    }

    private String getDropTmpPeriodTab(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Drop Table " + tmpPeriodTable + "\r\n");
        return sql.toString();
    }

    private void getDealNextPeriod(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        PeriodInfo currentPeriodInfo;
        PeriodInfo nextPeriodInfo;
        int nextPeriod;
        int periodMTo;
        int periodYTo = params.getInt("accPeriodYearTo");
        int toPeriod = periodYTo * 100 + (periodMTo = params.getInt("accPeriodMonthTo"));
        if (toPeriod >= (nextPeriod = (nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)(currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")))))).getPeriodYear() * 100 + nextPeriodInfo.getPeriodNumber())) {
            this.UpdatePeriodFirst(ctx, tempTable, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber(), nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
            this.UpdatePeriodLast(ctx, tempTable, nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
        }
    }

    private String getDealPrice(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set \r\n");
        sql.append("FInUnitPrice=(case when FInQty=FInQty_1 then FInUnitPrice_1 else (CASE WHEN (isnull(FInQty,0)=0) THEN Null ELSE round(decimal(FInAmount,17,4)/decimal(FInQty,21,8),6) END) end),");
        sql.append("FOutUnitPrice=(case when FOutQty=FOutQty_1 then FOutUnitPrice_1 else (CASE WHEN (isnull(FOutQty,0)=0) THEN Null ELSE round(decimal(FOutAmount,17,4)/decimal(FOutQty,21,8),6) END) end),");
        sql.append("FRemainUnitPrice=(CASE WHEN (isnull(FRemainQty,0)=0) THEN Null ELSE round(decimal(FRemainAmount,17,4)/decimal(FRemainQty,21,8),6) END) ");
        return sql.toString();
    }

    private void UpdatePeriodFirst(Context ctx, String tempTable, int prePeriodY, int prePeriodM, int nextPeriodY, int nextPeriodM) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " as t3 Set(FRemainQty,FRemainAmount,FRemainDiffAmount)=\r\n");
        sql.append("(Select t1.FRemainQty,t1.FRemainAmount,t1.FRemainDiffAmount \r\n");
        sql.append("From " + tempTable + " t2 ," + tempTable + " t1 ");
        sql.append("Where t1.FYear=" + prePeriodY + " And t1.FPeriod=" + prePeriodM + " And t1.FIndex=1 ");
        sql.append("And t2.FYear=" + nextPeriodY + " And t2.FPeriod=" + nextPeriodM + " And t2.FIndex=-1  ");
        sql.append("And t3.FIndex=t2.FIndex and t3.FYear=t2.FYear and t3.FPeriod=t2.FPeriod )");
        this.executeSQL(ctx, sql.toString());
    }

    private void UpdatePeriodLast(Context ctx, String tempTable, int pYear, int pMonth) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " As t2  Set(FRemainQty,FRemainAmount,FRemainDiffAmount)=\r\n");
        sql.append("(Select isNull(t1.FRemainQty,0)+isNull(t3.FInQty,0)-isNull(t3.FOutQty,0),");
        sql.append("isNull(t1.FRemainAmount,0)+isNull(t3.FInAmount,0)-isNull(t3.FOutAmount,0),");
        sql.append("isNull(t1.FRemainDiffAmount,0)+isNull(t3.FInDiffAmount,0)-isNull(t3.FOutDiffAmount,0) ");
        sql.append("From " + tempTable + " t3," + tempTable + " t1 \r\n");
        sql.append("Where t3.FIndex=1 And t1.FIndex=-1 And t3.FYear=t1.FYear And t3.FPeriod=t1.FPeriod ");
        sql.append("And t3.FIndex =t2.FIndex And t3.FYear=t2.FYear And t3.FPeriod=t2.FPeriod )");
        this.executeSQL(ctx, sql.toString());
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    @Override
    protected Object[] _getMaterialPKArray(Context ctx, RptParams params) throws BOSException {
        PeriodInfo periodInfoFrom = null;
        PeriodInfo periodInfoTo = null;
        boolean noSelectNoneInOut = params.getBoolean("noSelectNoneInOut");
        PeriodInfo currentPeriodInfo = null;
        try {
            currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
            periodInfoFrom = PeriodUtils.getPeriodInfo((Context)ctx, (int)params.getInt("accPeriodYearFrom"), (int)params.getInt("accPeriodMonthFrom"), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
            periodInfoTo = PeriodUtils.getPeriodInfo((Context)ctx, (int)params.getInt("accPeriodYearTo"), (int)params.getInt("accPeriodMonthTo"), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (100 * periodInfoFrom.getPeriodYear() + periodInfoFrom.getPeriodNumber() > 100 * currentPeriodInfo.getPeriodYear() + currentPeriodInfo.getPeriodNumber()) {
            periodInfoFrom = currentPeriodInfo;
        }
        String fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        Vector<String> materialIDVct = new Vector<String>();
        StringBuffer sqlBuff = new StringBuffer();
        StringBuffer billBuff = new StringBuffer();
        String[][] tableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}, {"T_CL_CostAdjustBill", "T_CL_CostAdjustBillEntry"}, {"T_CL_StandardCostAdjBill", "T_CL_StandardCostAdjEntry"}};
        billBuff.append("select T.fmaterialid as fmaterialid from (");
        for (int i = 0; i < tableName.length; ++i) {
            if (i != 0) {
                billBuff.append(" union all ");
            }
            billBuff.append("select b.fmaterialid as fmaterialid from ").append(tableName[i][0]).append(" a,").append(tableName[i][1]).append(" b ").append("where a.fid = b.fparentid ");
            if (tableName[i][0].equals("T_CL_StandardCostAdjBill")) {
                billBuff.append("and a.fcompanyorgunitid = '").append(fiOrgUnitID).append("' ");
            } else {
                billBuff.append("and b.fcompanyorgunitid = '").append(fiOrgUnitID).append("' ");
            }
            if (periodInfoFrom != null) {
                billBuff.append("and a.fbizdate >= to_date('").append(IMRptUtils.getFilterBeginDate((Date)periodInfoFrom.getBeginDate())).append("') ");
            }
            if (periodInfoTo == null) continue;
            billBuff.append("and a.fbizdate <= to_date('").append(IMRptUtils.getFilterEndDate((Date)periodInfoTo.getEndDate())).append("') ");
        }
        if (!noSelectNoneInOut) {
            billBuff.append("union all ");
            billBuff.append("select fmaterialid as fmaterialid from t_im_inventorybalance ");
            billBuff.append("where fcompanyorgunitid ='").append(fiOrgUnitID).append("' ");
            if (periodInfoFrom != null) {
                billBuff.append(" and 100*fyear+fperiod >=").append(100 * periodInfoFrom.getPeriodYear() + periodInfoFrom.getPeriodNumber());
            }
            if (periodInfoTo != null) {
                billBuff.append(" and 100*fyear+fperiod <=").append(100 * periodInfoTo.getPeriodYear() + periodInfoTo.getPeriodNumber());
            }
        }
        billBuff.append(") T group by T.fmaterialid");
        sqlBuff.append("SELECT TOP " + (Integer)params.getObject("MaxCount") + " B.FID ");
        sqlBuff.append("FROM T_BD_MaterialCompanyInfo A ");
        sqlBuff.append("INNER JOIN T_BD_Material B ON A.FMaterialID = B.FID ");
        sqlBuff.append("INNER JOIN (").append(billBuff).append(") C ON C.FMaterialID = B.FID ");
        sqlBuff.append("WHERE A.FCompanyID = '" + ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString() + "' ");
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof MaterialInfo) {
                sqlBuff.append(" AND B.FNumber >= '" + ((MaterialInfo)params.getObject("materialFrom")).getNumber() + "'");
            } else if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    sqlBuff.append(" AND B.FNumber >= '" + ((MaterialInfo)materials[0]).getNumber() + "'");
                } else {
                    sqlBuff.append(" AND B.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(materials)).append(")");
                }
            } else {
                sqlBuff.append(" AND B.FNumber >= '" + params.getObject("materialFrom") + "'");
            }
        }
        if (params.getObject("materialTo") != null) {
            if (params.getObject("materialTo") instanceof MaterialInfo) {
                sqlBuff.append(" AND B.FNumber <= '" + ((MaterialInfo)params.getObject("materialTo")).getNumber() + "'");
            } else {
                sqlBuff.append(" AND B.FNumber <= '" + params.getObject("materialTo") + "'");
            }
        }
        if (params.getObject("ckBxMShortName") != null && params.getBoolean("ckBxMShortName")) {
            if (params.getString("txtMShortNameFrom").trim().length() > 0) {
                sqlBuff.append(" AND B.FSHORTNAME >= '" + params.getString("txtMShortNameFrom").trim() + "'");
            }
            if (params.getString("txtMShortNameFrom").trim().length() > 0 && params.getString("txtMShortNameTo").trim().length() > 0) {
                sqlBuff.append(" AND B.FSHORTNAME <= '" + params.getString("txtMShortNameTo").trim() + "'");
            }
            if (params.getString("txtMShortNameTo").trim().length() > 0 && params.getString("txtMShortNameFrom").trim().length() <= 0) {
                sqlBuff.append(" AND ( B.FSHORTNAME <= '" + params.getString("txtMShortNameTo").trim() + "' OR B.FSHORTNAME IS NULL ) ");
            }
        }
        sqlBuff.append("AND A.FAccountType =").append(2).append(" ");
        int calType = -1;
        if (params.getObject("calType") != null) {
            calType = ((CalculateTypeEnum)params.getObject("calType")).getValue();
        }
        if (calType >= 0) {
            sqlBuff.append(" AND A.FCalculateType = " + String.valueOf(calType));
        }
        if (params.getString("CurrentMaterialID") != null && !"".equals(params.getString("CurrentMaterialID"))) {
            sqlBuff.append(" AND A.FMaterialID = '" + params.getString("CurrentMaterialID") + "'");
        }
        sqlBuff.append(" ORDER BY B.FNumber");
        RptRowSet rs = this.executeQuery(sqlBuff.toString(), null, ctx);
        while (rs.next()) {
            materialIDVct.add(rs.getString(0));
        }
        rs = null;
        return materialIDVct.toArray();
    }
}

